/*
 * Decompiled with CFR 0.152.
 */
package com.Nxer.TwistSpaceTechnology.common.modularizedMachine.ModularizedMachineLogic;

import com.Nxer.TwistSpaceTechnology.TwistSpaceTechnology;
import com.Nxer.TwistSpaceTechnology.common.misc.CheckRecipeResults.CheckRecipeResults;
import com.Nxer.TwistSpaceTechnology.common.misc.OverclockType;
import com.Nxer.TwistSpaceTechnology.common.modularizedMachine.ModularizedMachineLogic.IModularizedMachine;
import com.Nxer.TwistSpaceTechnology.common.modularizedMachine.ModularizedMachineLogic.ModularHatchTypes;
import com.Nxer.TwistSpaceTechnology.common.modularizedMachine.ModularizedMachineLogic.ModularizedMachineBase;
import com.Nxer.TwistSpaceTechnology.common.modularizedMachine.ModularizedMachineLogic.MultiExecutionProcessingLogic;
import com.Nxer.TwistSpaceTechnology.common.modularizedMachine.modularHatches.ExecutionCores.AdvExecutionCore;
import com.Nxer.TwistSpaceTechnology.common.modularizedMachine.modularHatches.ExecutionCores.ExecutionCore;
import com.Nxer.TwistSpaceTechnology.common.modularizedMachine.modularHatches.ExecutionCores.IExecutionCore;
import com.Nxer.TwistSpaceTechnology.common.modularizedMachine.modularHatches.ExecutionCores.PerfectExecutionCore;
import com.Nxer.TwistSpaceTechnology.common.modularizedMachine.modularHatches.IModularHatch;
import com.Nxer.TwistSpaceTechnology.util.NBTUtils;
import com.Nxer.TwistSpaceTechnology.util.TextEnums;
import com.Nxer.TwistSpaceTechnology.util.TstUtils;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.interfaces.tileentity.IRecipeLockable;
import gregtech.api.interfaces.tileentity.IVoidable;
import gregtech.api.logic.ProcessingLogic;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.MTEHatchInputBus;
import gregtech.api.metatileentity.implementations.MTEMultiBlockBase;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.CheckRecipeResultRegistry;
import gregtech.api.util.GTRecipe;
import gregtech.api.util.GTUtility;
import gregtech.api.util.OverclockCalculator;
import gregtech.api.util.shutdown.ShutDownReason;
import gregtech.api.util.shutdown.ShutDownReasonRegistry;
import gregtech.common.tileentities.machines.IRecipeProcessingAwareHatch;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.ArrayUtils;
import org.jetbrains.annotations.NotNull;

public abstract class MultiExecutionCoreMachineBase<T extends MultiExecutionCoreMachineBase<T>>
extends ModularizedMachineBase<T>
implements IModularizedMachine.ISupportExecutionCore,
IExecutionCore {
    protected final Collection<PerfectExecutionCore> perfectExecutionCores = new ArrayList<PerfectExecutionCore>();
    protected final Collection<AdvExecutionCore> advExecutionCores = new ArrayList<AdvExecutionCore>();
    protected final Collection<ExecutionCore> executionCores = new ArrayList<ExecutionCore>();
    protected final Collection<IRecipeProcessingAwareHatch> MEInputHatches = new ArrayList<IRecipeProcessingAwareHatch>();
    protected ItemStack[] eOutputItems;
    protected FluidStack[] eOutputFluids;
    protected int eMaxProgressingTime;
    protected int eProgressedTime;
    protected int eBoostedTime;
    protected long eEut;
    protected static final int[] progressingTick = new int[]{1, 5, 10, 20, 32, 64, 128, 192, 256, 512};
    protected byte progressingTickIndex = (byte)5;
    protected boolean startedRecipeProcessing = false;
    protected boolean needToCheckRecipe = true;
    protected long maxEutCanUse = 0L;
    protected long eutForBoostLastTick = 0L;
    protected boolean isNoOverclockCalculator = false;
    protected CheckRecipeResult lastCheck = CheckRecipeResultRegistry.NO_RECIPE;

    public MultiExecutionCoreMachineBase(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public MultiExecutionCoreMachineBase(String aName) {
        super(aName);
    }

    private static <T extends Collection<?>> T filterValidMTE(T metaTileEntities) {
        metaTileEntities.removeIf(o -> {
            if (o == null) {
                return true;
            }
            if (o instanceof MetaTileEntity) {
                MetaTileEntity mte = (MetaTileEntity)o;
                return !mte.isValid();
            }
            return false;
        });
        return metaTileEntities;
    }

    @Override
    public void resetModularHatchCollections() {
        super.resetModularHatchCollections();
        this.perfectExecutionCores.clear();
        this.advExecutionCores.clear();
        this.executionCores.clear();
        this.MEInputHatches.clear();
    }

    public void startRecipeProcessing() {
        this.startedRecipeProcessing = true;
        if (this.MEInputHatches.isEmpty()) {
            return;
        }
        for (IRecipeProcessingAwareHatch hatch : MultiExecutionCoreMachineBase.filterValidMTE(this.MEInputHatches)) {
            hatch.startRecipeProcessing();
        }
    }

    public void endRecipeProcessing() {
        this.startedRecipeProcessing = false;
        if (this.MEInputHatches.isEmpty()) {
            return;
        }
        for (IRecipeProcessingAwareHatch hatch : MultiExecutionCoreMachineBase.filterValidMTE(this.MEInputHatches)) {
            this.setResultIfFailure(hatch.endRecipeProcessing((MTEMultiBlockBase)this));
        }
    }

    @Override
    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        IRecipeProcessingAwareHatch aware;
        if (!super.checkMachine(aBaseMetaTileEntity, aStack)) {
            return false;
        }
        this.maxEutCanUse = (long)(0.975 * (double)this.getMaxInputEu());
        for (MTEHatchInputBus hatch : (ArrayList)GTUtility.filterValidMTEs((Collection)this.mInputBusses)) {
            if (!(hatch instanceof IRecipeProcessingAwareHatch)) continue;
            aware = (IRecipeProcessingAwareHatch)hatch;
            this.MEInputHatches.add(aware);
        }
        for (MTEHatchInputBus hatch : (ArrayList)GTUtility.filterValidMTEs((Collection)this.mInputHatches)) {
            if (!(hatch instanceof IRecipeProcessingAwareHatch)) continue;
            aware = (IRecipeProcessingAwareHatch)hatch;
            this.MEInputHatches.add(aware);
        }
        Collection allExecutionCores = (Collection)this.modularHatches.get((Object)ModularHatchTypes.EXECUTION_CORE);
        if (allExecutionCores != null && !allExecutionCores.isEmpty()) {
            for (IModularHatch hatch : allExecutionCores) {
                if (hatch == null) continue;
                if (hatch instanceof PerfectExecutionCore) {
                    PerfectExecutionCore perfectExecutionCore = (PerfectExecutionCore)hatch;
                    this.perfectExecutionCores.add(perfectExecutionCore);
                    perfectExecutionCore.setup(this);
                    continue;
                }
                if (hatch instanceof AdvExecutionCore) {
                    AdvExecutionCore advExecutionCore = (AdvExecutionCore)hatch;
                    this.advExecutionCores.add(advExecutionCore);
                    advExecutionCore.setup(this);
                    continue;
                }
                if (!(hatch instanceof ExecutionCore)) continue;
                ExecutionCore executionCore = (ExecutionCore)hatch;
                this.executionCores.add(executionCore);
                executionCore.setup(this);
            }
        }
        return true;
    }

    @Override
    public Collection<IExecutionCore> getIdleNormalExecutionCores() {
        ArrayList<IExecutionCore> cores = new ArrayList<IExecutionCore>();
        for (ExecutionCore executionCore : this.executionCores) {
            if (executionCore == null || !executionCore.isIdle()) continue;
            cores.add(executionCore);
        }
        return cores;
    }

    @Override
    public Collection<IExecutionCore> getIdleAdvancedExecutionCores() {
        ArrayList<IExecutionCore> cores = new ArrayList<IExecutionCore>();
        for (AdvExecutionCore executionCore : this.advExecutionCores) {
            if (executionCore == null || !executionCore.isIdle()) continue;
            cores.add(executionCore);
        }
        return cores;
    }

    @Override
    public Collection<IExecutionCore> getIdlePerfectExecutionCores() {
        ArrayList<IExecutionCore> cores = new ArrayList<IExecutionCore>();
        for (PerfectExecutionCore executionCore : this.perfectExecutionCores) {
            if (executionCore == null || !executionCore.isIdle()) continue;
            cores.add(executionCore);
        }
        return cores;
    }

    @Override
    public Collection<IExecutionCore> getAllWorkingExecutionCoresToBoost() {
        ArrayList<IExecutionCore> cores = new ArrayList<IExecutionCore>();
        if (this.isWorking()) {
            cores.add(this);
        }
        for (ExecutionCore executionCore : this.executionCores) {
            if (!executionCore.isWorking()) continue;
            cores.add(executionCore);
        }
        for (AdvExecutionCore advExecutionCore : this.advExecutionCores) {
            if (!advExecutionCore.isWorking()) continue;
            cores.add(advExecutionCore);
        }
        return cores;
    }

    @Override
    public int getParallelOfEveryNormalExecutionCore() {
        int totalParallel;
        if (this.executionCores.isEmpty()) {
            return this.getMaxParallelRecipes();
        }
        int coreAmount = this.executionCores.size() + 1;
        if (coreAmount >= (totalParallel = this.getMaxParallelRecipes())) {
            return 1;
        }
        return 1 + totalParallel / coreAmount;
    }

    @Override
    public IModularizedMachine.ISupportExecutionCore getMainMachine() {
        return this;
    }

    @Override
    public boolean setProcessing(ProcessingLogic processingLogic) {
        this.setOutputItems(processingLogic.getOutputItems());
        this.setOutputFluids(processingLogic.getOutputFluids());
        this.setMaxProgressingTime(processingLogic.getDuration());
        this.setEut(processingLogic.getCalculatedEut());
        return this.done();
    }

    @Override
    public long getEut() {
        return this.eEut;
    }

    public void onPreTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.onPreTick(aBaseMetaTileEntity, aTick);
        if (aBaseMetaTileEntity.isServerSide()) {
            this.runExecutionCoreTick(aBaseMetaTileEntity, aTick);
            if (aBaseMetaTileEntity.isAllowedToWork() && this.needToCheckRecipe) {
                this.doCheckRecipeForExecutionCores();
            }
        }
    }

    @Override
    public void runExecutionCoreTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        if (!aBaseMetaTileEntity.isServerSide()) {
            return;
        }
        if (this.eMaxProgressingTime > 0) {
            if (this.eProgressedTime < this.eMaxProgressingTime) {
                ++this.eProgressedTime;
            } else {
                if (this.eOutputItems != null && this.eOutputItems.length > 0) {
                    this.mergeOutputItems(this.eOutputItems);
                    this.eOutputItems = null;
                }
                if (this.eOutputFluids != null && this.eOutputFluids.length > 0) {
                    this.mergeOutputFluids(this.eOutputFluids);
                    this.eOutputFluids = null;
                }
                if (this.useMainMachinePower() && !this.tryDecreaseUsedEut(this.eEut)) {
                    TwistSpaceTechnology.LOG.info("ERROR: Execution core try decrease used EU/t failed at x" + aBaseMetaTileEntity.getXCoord() + " y" + aBaseMetaTileEntity.getYCoord() + " z" + aBaseMetaTileEntity.getZCoord());
                }
                this.eMaxProgressingTime = 0;
                this.eProgressedTime = 0;
                this.eBoostedTime = 0;
                this.eEut = 0L;
                this.forceCheckProcessing();
            }
        }
    }

    @Override
    public IExecutionCore boostTick(int tick) {
        this.eProgressedTime += tick;
        this.eBoostedTime += tick;
        return this;
    }

    @Override
    public int getNeedProgressingTime() {
        return this.eMaxProgressingTime - this.eProgressedTime;
    }

    @Override
    public boolean done() {
        return true;
    }

    @Override
    public boolean useMainMachinePower() {
        return true;
    }

    public void processWailaBody(ItemStack itemStack, List<String> currentTip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        int maxProgressingTime;
        NBTTagCompound tag = accessor.getNBTData();
        if (tag.func_74767_n("isActive")) {
            currentTip.add(EnumChatFormatting.AQUA + TextEnums.tr("Waila.ExecutionCore.5") + EnumChatFormatting.GRAY + " : " + tag.func_74763_f("eutForBoostLastTick") + " EU/t");
        }
        if ((maxProgressingTime = tag.func_74762_e("maxProgressingTime")) > 0) {
            currentTip.add(TextEnums.tr("Waila.ExecutionCore.1") + " : " + maxProgressingTime + " tick (" + maxProgressingTime / 20 + "s)");
            int progressedTime = tag.func_74762_e("progressedTime");
            currentTip.add(TextEnums.tr("Waila.ExecutionCore.2") + " : " + progressedTime + " tick (" + progressedTime / 20 + "s)");
            int boostedTime = tag.func_74762_e("boostedTime");
            currentTip.add(TextEnums.tr("Waila.ExecutionCore.4") + " : " + boostedTime + " tick (" + boostedTime / 20 + "s)");
            currentTip.add(TextEnums.tr("Waila.ExecutionCore.3") + " : " + tag.func_74763_f("usingEut") + " EU/t");
        } else {
            currentTip.add(TextEnums.tr("Waila.ExecutionCore.IsIdle"));
        }
    }

    @Override
    public void getWailaBody(ItemStack itemStack, List<String> currentTip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        super.getWailaBody(itemStack, currentTip, accessor, config);
        this.processWailaBody(itemStack, currentTip, accessor, config);
    }

    @Override
    public void getWailaNBTData(EntityPlayerMP player, TileEntity tile, NBTTagCompound tag, World world, int x, int y, int z) {
        super.getWailaNBTData(player, tile, tag, world, x, y, z);
        IGregTechTileEntity tileEntity = this.getBaseMetaTileEntity();
        if (tileEntity != null) {
            tag.func_74768_a("maxProgressingTime", this.eMaxProgressingTime);
            if (this.eMaxProgressingTime > 0) {
                int outputItemStackAmount = this.eOutputItems == null ? 0 : this.eOutputItems.length;
                tag.func_74768_a("outputItemStackAmount", outputItemStackAmount);
                int outputFluidStackAmount = this.eOutputFluids == null ? 0 : this.eOutputFluids.length;
                tag.func_74768_a("outputFluidStackAmount", outputFluidStackAmount);
                tag.func_74768_a("progressedTime", this.eProgressedTime);
                tag.func_74768_a("boostedTime", this.eBoostedTime);
                tag.func_74772_a("usingEut", this.eEut);
                tag.func_74772_a("eutForBoostLastTick", this.eutForBoostLastTick);
            }
        }
    }

    protected void saveNBTDataItemStacks(NBTTagCompound aNBT) {
        if (this.eOutputItems != null && this.eOutputItems.length > 0) {
            aNBT.func_74768_a("eOutputItemsLength", this.eOutputItems.length);
            for (int i = 0; i < this.eOutputItems.length; ++i) {
                NBTUtils.saveItem(aNBT, "eOutputItems" + i, this.eOutputItems[i]);
            }
        }
    }

    protected void saveNBTDataFluidStacks(NBTTagCompound aNBT) {
        if (this.eOutputFluids != null && this.eOutputFluids.length > 0) {
            aNBT.func_74768_a("eOutputFluidsLength", this.eOutputFluids.length);
            for (int i = 0; i < this.eOutputFluids.length; ++i) {
                NBTUtils.saveFluid(aNBT, "eOutputFluids" + i, this.eOutputFluids[i]);
            }
        }
    }

    protected void loadNBTDataItemStacks(NBTTagCompound aNBT) {
        int length = aNBT.func_74762_e("eOutputItemsLength");
        if (length > 0) {
            this.eOutputItems = new ItemStack[length];
            for (int i = 0; i < length; ++i) {
                this.eOutputItems[i] = NBTUtils.loadItem(aNBT, "eOutputItems" + i);
            }
        }
    }

    protected void loadNBTDataFluidStacks(NBTTagCompound aNBT) {
        int length = aNBT.func_74762_e("eOutputFluidsLength");
        if (length > 0) {
            this.eOutputFluids = new FluidStack[length];
            for (int i = 0; i < length; ++i) {
                this.eOutputFluids[i] = NBTUtils.loadFluid(aNBT, "eOutputFluids" + i);
            }
        }
    }

    @Override
    public boolean setup(IModularizedMachine.ISupportExecutionCore mainMachine) {
        return true;
    }

    @Override
    public void reset() {
        this.eOutputItems = null;
        this.eOutputFluids = null;
        this.eMaxProgressingTime = 0;
        this.eProgressedTime = 0;
        this.eBoostedTime = 0;
        this.eEut = 0L;
    }

    @Override
    public void shutDown() {
        this.eOutputItems = null;
        this.eOutputFluids = null;
        this.eMaxProgressingTime = 0;
        this.eProgressedTime = 0;
        this.eBoostedTime = 0;
        this.eEut = 0L;
    }

    @Override
    public boolean isIdle() {
        return this.eMaxProgressingTime < 1;
    }

    @Override
    public boolean isWorking() {
        return this.eMaxProgressingTime > 0;
    }

    @Override
    public IExecutionCore setOutputItems(ItemStack[] outputItems) {
        this.eOutputItems = outputItems;
        return this;
    }

    @Override
    public IExecutionCore setOutputFluids(FluidStack[] outputFluids) {
        this.eOutputFluids = outputFluids;
        return this;
    }

    @Override
    public IExecutionCore setMaxProgressingTime(int maxProgressingTime) {
        this.eMaxProgressingTime = maxProgressingTime;
        return this;
    }

    @Override
    public IExecutionCore setEut(long eut) {
        this.eEut = eut;
        return this;
    }

    protected abstract OverclockType getOverclockType();

    protected int getBaseProgressingTick() {
        return progressingTick[this.progressingTickIndex];
    }

    public boolean onWireCutterRightClick(ForgeDirection side, ForgeDirection wrenchingSide, EntityPlayer aPlayer, float aX, float aY, float aZ, ItemStack aTool) {
        if (this.getBaseMetaTileEntity().isServerSide()) {
            this.progressingTickIndex = (byte)((this.progressingTickIndex + 1) % 10);
            GTUtility.sendChatToPlayer((EntityPlayer)aPlayer, (String)(StatCollector.func_74838_a((String)"MultiExecutionCoreMachineBase.progressingTickIndex") + this.getBaseProgressingTick() + " tick"));
            return true;
        }
        return false;
    }

    @Override
    public String[] getInfoData() {
        String[] origin = super.getInfoData();
        String[] ret = new String[origin.length + 1];
        System.arraycopy(origin, 0, ret, 0, origin.length);
        ret[origin.length] = this.getOverclockType().getDescription();
        return ret;
    }

    @Override
    public void mergeOutputItems(ItemStack ... outputs) {
        this.mOutputItems = (ItemStack[])ArrayUtils.addAll((Object[])this.mOutputItems, (Object[])outputs);
    }

    @Override
    public void mergeOutputFluids(FluidStack ... outputs) {
        this.mOutputFluids = (FluidStack[])ArrayUtils.addAll((Object[])this.mOutputFluids, (Object[])outputs);
    }

    @Override
    public boolean tryUseEut(long eut) {
        long canUse = this.getEutCanUse();
        if (canUse >= eut) {
            this.lEUt -= eut;
            return true;
        }
        return false;
    }

    @Override
    public boolean tryDecreaseUsedEut(long eut) {
        if (-this.lEUt >= eut) {
            this.lEUt += eut;
            return true;
        }
        return false;
    }

    public boolean onRunningTick(ItemStack aStack) {
        long eutForBoostLastTick = this.boostExecutionCoreProcessing();
        if (this.lEUt < 0L && !this.drainEnergyInput(this.getActualEnergyUsage())) {
            this.shutDownAllExecutionCore();
            this.stopMachine(ShutDownReasonRegistry.POWER_LOSS);
            return false;
        }
        this.tryDecreaseUsedEut(eutForBoostLastTick);
        return true;
    }

    public void stopMachine(@NotNull ShutDownReason reason) {
        this.eutForBoostLastTick = 0L;
        super.stopMachine(reason);
    }

    protected long boostExecutionCoreProcessing() {
        this.eutForBoostLastTick = 0L;
        Collection<IExecutionCore> workingCores = this.getAllWorkingExecutionCoresToBoost();
        if (workingCores.isEmpty()) {
            return 0L;
        }
        int workingCoreWaitBoostAmount = workingCores.size();
        long maxEUtCanUse = this.getEutCanUse();
        if (maxEUtCanUse < (long)workingCoreWaitBoostAmount) {
            return 0L;
        }
        boolean perfectOverclock = this.getOverclockType().isPerfectOverclock();
        for (IExecutionCore executionCore : workingCores) {
            int boostedTick;
            long maxAverageEUtCanUse = maxEUtCanUse / (long)workingCoreWaitBoostAmount;
            --workingCoreWaitBoostAmount;
            int maxTickCanBoost = executionCore.getNeedProgressingTime();
            if (maxTickCanBoost < 1) continue;
            long thisCoreEUt = executionCore.getEut();
            long thisCoreUsed = 0L;
            long eutExtraMultiplier = maxAverageEUtCanUse / thisCoreEUt;
            if (perfectOverclock) {
                boostedTick = eutExtraMultiplier > (long)maxTickCanBoost ? maxTickCanBoost : (int)eutExtraMultiplier;
                thisCoreUsed = (long)boostedTick * thisCoreEUt;
            } else {
                long eutMultiplier = eutExtraMultiplier + 1L;
                int canOverclockTimes = (int)Math.min(Math.log(eutMultiplier) / TstUtils.LOG4, Math.log(maxTickCanBoost) / TstUtils.LOG2);
                boostedTick = (int)Math.pow(2.0, canOverclockTimes) - 1;
                thisCoreUsed = (long)((Math.pow(4.0, canOverclockTimes) - 1.0) * (double)thisCoreEUt);
            }
            maxEUtCanUse -= thisCoreUsed;
            this.eutForBoostLastTick += thisCoreUsed;
            this.tryUseEut(thisCoreUsed);
            executionCore.boostTick(boostedTick);
        }
        return this.eutForBoostLastTick;
    }

    protected void shutDownAllExecutionCore() {
        this.shutDown();
        for (IExecutionCore iExecutionCore : this.executionCores) {
            iExecutionCore.shutDown();
        }
        for (IExecutionCore iExecutionCore : this.advExecutionCores) {
            iExecutionCore.shutDown();
        }
    }

    protected void resetAllExecutionCore() {
        this.reset();
        for (IExecutionCore iExecutionCore : this.executionCores) {
            iExecutionCore.reset();
        }
        for (IExecutionCore iExecutionCore : this.advExecutionCores) {
            iExecutionCore.reset();
        }
        for (IExecutionCore iExecutionCore : this.perfectExecutionCores) {
            iExecutionCore.reset();
        }
        this.resetModularHatchCollections();
    }

    public void onBlockDestroyed() {
        this.resetAllExecutionCore();
        super.onBlockDestroyed();
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74774_a("progressingTickIndex", this.progressingTickIndex);
        aNBT.func_74757_a("startedRecipeProcessing", this.startedRecipeProcessing);
        aNBT.func_74772_a("maxEutCanUse", this.maxEutCanUse);
        aNBT.func_74772_a("eutForBoostLastTick", this.eutForBoostLastTick);
        aNBT.func_74757_a("isNoOverclockCalculator", this.isNoOverclockCalculator);
        aNBT.func_74768_a("eMaxProgressingTime", this.eMaxProgressingTime);
        aNBT.func_74768_a("eProgressedTime", this.eProgressedTime);
        aNBT.func_74768_a("eBoostedTime", this.eBoostedTime);
        aNBT.func_74772_a("eEut", this.eEut);
        this.saveNBTDataItemStacks(aNBT);
        this.saveNBTDataFluidStacks(aNBT);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.progressingTickIndex = aNBT.func_74771_c("progressingTickIndex");
        this.startedRecipeProcessing = aNBT.func_74767_n("startedRecipeProcessing");
        this.maxEutCanUse = aNBT.func_74763_f("maxEutCanUse");
        this.eutForBoostLastTick = aNBT.func_74763_f("eutForBoostLastTick");
        this.isNoOverclockCalculator = aNBT.func_74767_n("isNoOverclockCalculator");
        this.eMaxProgressingTime = aNBT.func_74762_e("eMaxProgressingTime");
        this.eProgressedTime = aNBT.func_74762_e("eProgressedTime");
        this.eBoostedTime = aNBT.func_74762_e("eBoostedTime");
        this.eEut = aNBT.func_74763_f("eEut");
        this.loadNBTDataItemStacks(aNBT);
        this.loadNBTDataFluidStacks(aNBT);
    }

    public long getEutCanUse() {
        return this.maxEutCanUse + this.lEUt;
    }

    public long getEutCanUse(int coreAmount) {
        return (this.maxEutCanUse + this.lEUt) / (long)coreAmount;
    }

    @Override
    protected ProcessingLogic createProcessingLogic() {
        return new MultiExecutionProcessingLogic(){

            @NotNull
            public CheckRecipeResult process() {
                this.setEuModifier(MultiExecutionCoreMachineBase.this.getEuModifier());
                this.setSpeedBonus(MultiExecutionCoreMachineBase.this.getSpeedBonus());
                this.setOverclock(MultiExecutionCoreMachineBase.this.getOverclockType().timeReduction, MultiExecutionCoreMachineBase.this.getOverclockType().powerIncrease);
                return super.process();
            }

            @Nonnull
            protected OverclockCalculator createOverclockCalculator(@Nonnull GTRecipe recipe) {
                if (MultiExecutionCoreMachineBase.this.isNoOverclockCalculator) {
                    return OverclockCalculator.ofNoOverclock((GTRecipe)recipe);
                }
                return super.createOverclockCalculator(recipe);
            }
        };
    }

    @Override
    protected void setupProcessingLogic(ProcessingLogic logic) {
        logic.clear();
        logic.setMachine((IVoidable)this);
        logic.setRecipeMapSupplier(() -> ((MultiExecutionCoreMachineBase)this).getRecipeMap());
        logic.setVoidProtection(false, false);
        logic.setBatchSize(this.isBatchModeEnabled() ? this.getMaxBatchSize() : 1);
        logic.setRecipeLocking((IRecipeLockable)this, false);
        logic.setAvailableVoltage(this.getEutCanUse());
        logic.setAvailableAmperage(1L);
        logic.setMaxParallel(this.getParallelOfEveryNormalExecutionCore());
    }

    protected void setupProcessingLogicWirelessEU(ProcessingLogic logic) {
        logic.clear();
        logic.setMachine((IVoidable)this);
        logic.setRecipeMapSupplier(() -> ((MultiExecutionCoreMachineBase)this).getRecipeMap());
        logic.setVoidProtection(false, false);
        logic.setBatchSize(this.isBatchModeEnabled() ? this.getMaxBatchSize() : 1);
        logic.setRecipeLocking((IRecipeLockable)this, false);
        logic.setAvailableVoltage(this.getEutCanUse());
        logic.setAvailableAmperage(1L);
        logic.setMaxParallel(Integer.MAX_VALUE);
    }

    @Nonnull
    protected CheckRecipeResult doCheckRecipe() {
        return super.doCheckRecipe();
    }

    @Override
    @NotNull
    public CheckRecipeResult checkProcessingMM() {
        this.doCheckRecipeForExecutionCores();
        this.mMaxProgresstime = this.getBaseProgressingTick();
        this.mEfficiency = 10000;
        this.mEfficiencyIncrease = 10000;
        this.updateSlots();
        return CheckRecipeResultRegistry.SUCCESSFUL;
    }

    @Override
    public void forceCheckProcessing() {
        this.needToCheckRecipe = true;
    }

    public void doCheckRecipeForExecutionCores() {
        this.needToCheckRecipe = false;
        if (this.checkProcessingForPerfectExecutionCore() == CheckRecipeResults.SetProcessingFailed) {
            this.disableWorking();
            this.setResultIfFailure(CheckRecipeResults.SetProcessingFailed);
            return;
        }
        if (this.checkProcessingForAdvancedExecutionCore() == CheckRecipeResults.SetProcessingFailed) {
            this.disableWorking();
            this.setResultIfFailure(CheckRecipeResults.SetProcessingFailed);
            return;
        }
        this.lastCheck = this.checkProcessingForNormalExecutionCore();
    }

    @NotNull
    public CheckRecipeResult checkProcessingForNormalExecutionCore() {
        Collection<IExecutionCore> idleExecutionCores = this.getIdleNormalExecutionCores();
        if (this.isIdle()) {
            idleExecutionCores.add(this);
        }
        if (idleExecutionCores.isEmpty()) {
            return CheckRecipeResults.NoIdleExecutionCore;
        }
        this.isNoOverclockCalculator = false;
        this.setupProcessingLogic(this.processingLogic);
        int idleAmount = idleExecutionCores.size();
        boolean flag = false;
        for (IExecutionCore executionCore : idleExecutionCores) {
            this.processingLogic.setAvailableVoltage(this.getEutCanUse(idleAmount));
            --idleAmount;
            CheckRecipeResult result = this.checkExecutionCoreProcessing(executionCore);
            if (result == CheckRecipeResults.SetProcessingFailed) {
                return result;
            }
            if (!result.wasSuccessful()) break;
            flag = true;
        }
        return flag ? CheckRecipeResultRegistry.SUCCESSFUL : CheckRecipeResultRegistry.NO_RECIPE;
    }

    @NotNull
    public CheckRecipeResult checkProcessingForAdvancedExecutionCore() {
        Collection<IExecutionCore> idleExecutionCores = this.getIdleAdvancedExecutionCores();
        if (idleExecutionCores.isEmpty()) {
            return CheckRecipeResults.NoIdleExecutionCore;
        }
        this.isNoOverclockCalculator = false;
        this.setupProcessingLogic(this.processingLogic);
        boolean flag = false;
        for (IExecutionCore executionCore : idleExecutionCores) {
            CheckRecipeResult result = this.checkExecutionCoreProcessing(executionCore);
            if (result == CheckRecipeResults.SetProcessingFailed) {
                return result;
            }
            if (!result.wasSuccessful()) break;
            flag = true;
        }
        return flag ? CheckRecipeResultRegistry.SUCCESSFUL : CheckRecipeResultRegistry.NO_RECIPE;
    }

    public CheckRecipeResult checkProcessingForPerfectExecutionCore() {
        Collection<IExecutionCore> idleExecutionCores = this.getIdlePerfectExecutionCores();
        if (idleExecutionCores.isEmpty()) {
            return CheckRecipeResults.NoIdleExecutionCore;
        }
        this.isNoOverclockCalculator = true;
        this.setupProcessingLogicWirelessEU(this.processingLogic);
        this.processingLogic.setAvailableVoltage(Long.MAX_VALUE);
        boolean flag = false;
        for (IExecutionCore executionCore : idleExecutionCores) {
            CheckRecipeResult result = this.checkExecutionCoreProcessing(executionCore);
            if (result == CheckRecipeResults.SetProcessingFailed) {
                return result;
            }
            if (!result.wasSuccessful()) break;
            flag = true;
        }
        return flag ? CheckRecipeResultRegistry.SUCCESSFUL : CheckRecipeResultRegistry.NO_RECIPE;
    }

    protected CheckRecipeResult checkExecutionCoreProcessing(IExecutionCore executionCore) {
        CheckRecipeResult result;
        if (!this.startedRecipeProcessing) {
            this.startRecipeProcessing();
        }
        if ((result = this.doCheckRecipe()).wasSuccessful()) {
            boolean success = executionCore.setProcessing(this.processingLogic);
            if (!success) {
                this.updateSlots();
                this.endRecipeProcessing();
                return CheckRecipeResults.SetProcessingFailed;
            }
            if (executionCore.useMainMachinePower()) {
                this.tryUseEut(this.processingLogic.getCalculatedEut());
            }
        }
        this.updateSlots();
        this.endRecipeProcessing();
        return result;
    }

    @Override
    public boolean supportsVoidProtection() {
        return false;
    }

    @Override
    public boolean supportsSingleRecipeLocking() {
        return false;
    }
}

