/*
 * Decompiled with CFR 0.152.
 */
package com.Nxer.TwistSpaceTechnology.common.modularizedMachine.modularHatches.ExecutionCores;

import com.Nxer.TwistSpaceTechnology.TwistSpaceTechnology;
import com.Nxer.TwistSpaceTechnology.common.modularizedMachine.ModularizedMachineLogic.IModularizedMachine;
import com.Nxer.TwistSpaceTechnology.common.modularizedMachine.ModularizedMachineLogic.ModularHatchTypes;
import com.Nxer.TwistSpaceTechnology.common.modularizedMachine.ModularizedMachineLogic.ModularizedMachineBase;
import com.Nxer.TwistSpaceTechnology.common.modularizedMachine.modularHatches.ExecutionCores.IExecutionCore;
import com.Nxer.TwistSpaceTechnology.common.modularizedMachine.modularHatches.IStaticModularHatch;
import com.Nxer.TwistSpaceTechnology.common.modularizedMachine.modularHatches.ModularHatchBase;
import com.Nxer.TwistSpaceTechnology.util.NBTUtils;
import com.Nxer.TwistSpaceTechnology.util.TextEnums;
import gregtech.api.enums.VoidingMode;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.fluid.IFluidStore;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.interfaces.tileentity.IVoidable;
import gregtech.api.logic.ProcessingLogic;
import java.util.Collections;
import java.util.List;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;

public abstract class ExecutionCoreBase
extends ModularHatchBase
implements IExecutionCore,
IStaticModularHatch {
    protected ItemStack[] outputItems;
    protected FluidStack[] outputFluids;
    protected int maxProgressingTime;
    protected int progressedTime;
    protected int boostedTime;
    protected long eut;
    protected boolean hasBeenSetup = false;
    protected IModularizedMachine.ISupportExecutionCore mainMachine;
    protected boolean active = false;
    protected byte trySetInactiveTimes = 0;

    public ExecutionCoreBase(int aID, String aName, String aNameRegional, int aTier) {
        super(aID, aName, aNameRegional, aTier, 0, null, new ITexture[0]);
    }

    public ExecutionCoreBase(String aName, int aTier, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, 0, aDescription, aTextures);
    }

    @Override
    public ModularHatchTypes getType() {
        return ModularHatchTypes.EXECUTION_CORE;
    }

    public void processWailaBody(ItemStack itemStack, List<String> currentTip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        NBTTagCompound tag = accessor.getNBTData();
        if (tag.func_74767_n("hasBeenSetup")) {
            int maxProgressingTime = tag.func_74762_e("maxProgressingTime");
            if (maxProgressingTime > 0) {
                currentTip.add(TextEnums.tr("Waila.ExecutionCore.1") + " : " + maxProgressingTime + " tick (" + maxProgressingTime / 20 + "s)");
                int progressedTime = tag.func_74762_e("progressedTime");
                currentTip.add(TextEnums.tr("Waila.ExecutionCore.2") + " : " + progressedTime + " tick (" + progressedTime / 20 + "s)");
                int boostedTime = tag.func_74762_e("boostedTime");
                currentTip.add(TextEnums.tr("Waila.ExecutionCore.4") + " : " + boostedTime + " tick (" + boostedTime / 20 + "s)");
                currentTip.add(TextEnums.tr("Waila.ExecutionCore.3") + " : " + tag.func_74763_f("usingEut") + " EU/t");
            } else {
                currentTip.add(TextEnums.tr("Waila.ExecutionCore.IsIdle"));
            }
        } else {
            currentTip.add(TextEnums.tr("Waila.ExecutionCore.HasNotBeenSetup"));
        }
    }

    public void getWailaBody(ItemStack itemStack, List<String> currentTip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        super.getWailaBody(itemStack, currentTip, accessor, config);
        this.processWailaBody(itemStack, currentTip, accessor, config);
    }

    public void getWailaNBTData(EntityPlayerMP player, TileEntity tile, NBTTagCompound tag, World world, int x, int y, int z) {
        super.getWailaNBTData(player, tile, tag, world, x, y, z);
        IGregTechTileEntity tileEntity = this.getBaseMetaTileEntity();
        if (tileEntity != null) {
            tag.func_74757_a("hasBeenSetup", this.hasBeenSetup && this.mainMachine != null);
            tag.func_74768_a("maxProgressingTime", this.maxProgressingTime);
            if (this.maxProgressingTime > 0) {
                int outputItemStackAmount = this.outputItems == null ? 0 : this.outputItems.length;
                tag.func_74768_a("outputItemStackAmount", outputItemStackAmount);
                int outputFluidStackAmount = this.outputFluids == null ? 0 : this.outputFluids.length;
                tag.func_74768_a("outputFluidStackAmount", outputFluidStackAmount);
                tag.func_74768_a("progressedTime", this.progressedTime);
                tag.func_74768_a("boostedTime", this.boostedTime);
                tag.func_74772_a("usingEut", this.eut);
            }
        }
    }

    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.onPostTick(aBaseMetaTileEntity, aTick);
        if (aBaseMetaTileEntity.isServerSide()) {
            this.runExecutionCoreTick(aBaseMetaTileEntity, aTick);
            if (this.maxProgressingTime <= 0 && this.active) {
                this.trySetInactive();
            }
        }
    }

    @Override
    public boolean setProcessing(ProcessingLogic processingLogic) {
        this.setOutputItems(processingLogic.getOutputItems());
        this.setOutputFluids(processingLogic.getOutputFluids());
        this.setMaxProgressingTime(processingLogic.getDuration());
        this.setEut(processingLogic.getCalculatedEut());
        return this.done();
    }

    @Override
    public void runExecutionCoreTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        if (aBaseMetaTileEntity.isServerSide() && this.hasBeenSetup && this.mainMachine != null && this.maxProgressingTime > 0) {
            if (this.progressedTime < this.maxProgressingTime - 1) {
                ++this.progressedTime;
            } else {
                if (this.outputItems != null && this.outputItems.length > 0) {
                    this.mainMachine.mergeOutputItems(this.outputItems);
                    this.outputItems = null;
                }
                if (this.outputFluids != null && this.outputFluids.length > 0) {
                    this.mainMachine.mergeOutputFluids(this.outputFluids);
                    this.outputFluids = null;
                }
                if (this.useMainMachinePower() && !this.mainMachine.tryDecreaseUsedEut(this.eut)) {
                    TwistSpaceTechnology.LOG.info("ERROR: Execution core try decrease used EU/t failed at x" + aBaseMetaTileEntity.getXCoord() + " y" + aBaseMetaTileEntity.getYCoord() + " z" + aBaseMetaTileEntity.getZCoord());
                }
                this.resetParameters();
                this.mainMachine.forceCheckProcessing();
            }
        }
    }

    @Override
    public IExecutionCore boostTick(int tick) {
        this.progressedTime += tick;
        this.boostedTime += tick;
        return this;
    }

    @Override
    public int getNeedProgressingTime() {
        return this.maxProgressingTime - this.progressedTime;
    }

    @Override
    public boolean isIdle() {
        return this.hasBeenSetup && this.maxProgressingTime < 1;
    }

    @Override
    public boolean isWorking() {
        return this.hasBeenSetup && this.maxProgressingTime > 0;
    }

    @Override
    public boolean setup(IModularizedMachine.ISupportExecutionCore mainMachine) {
        if (!this.hasBeenSetup) {
            this.mainMachine = mainMachine;
            this.hasBeenSetup = true;
            return true;
        }
        return false;
    }

    @Override
    public void shutDown() {
        this.outputItems = null;
        this.outputFluids = null;
        this.maxProgressingTime = 0;
        this.progressedTime = 0;
        this.eut = 0L;
        this.setInactiveCritical();
    }

    public void resetParameters() {
        this.maxProgressingTime = 0;
        this.progressedTime = 0;
        this.boostedTime = 0;
        this.eut = 0L;
        this.trySetInactive();
    }

    @Override
    public void reset() {
        this.outputItems = null;
        this.outputFluids = null;
        this.maxProgressingTime = 0;
        this.progressedTime = 0;
        this.eut = 0L;
        this.hasBeenSetup = false;
        this.mainMachine = null;
        this.setInactiveCritical();
    }

    public void setActive(boolean active) {
        this.active = active;
        IGregTechTileEntity mte = this.getBaseMetaTileEntity();
        if (mte != null) {
            mte.setActive(active);
        }
    }

    public void trySetActive() {
        this.trySetInactiveTimes = 0;
        this.setActive(true);
    }

    public void trySetInactive() {
        if (this.trySetInactiveTimes > 2) {
            this.trySetInactiveTimes = 0;
            this.setActive(false);
        } else {
            this.trySetInactiveTimes = (byte)(this.trySetInactiveTimes + 1);
        }
    }

    public void setInactiveCritical() {
        this.trySetInactiveTimes = 0;
        this.setActive(false);
    }

    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74757_a("MH_active", this.active);
        aNBT.func_74774_a("trySetInactiveTimes", this.trySetInactiveTimes);
        aNBT.func_74768_a("maxProgressingTime", this.maxProgressingTime);
        aNBT.func_74768_a("progressedTime", this.progressedTime);
        aNBT.func_74768_a("boostedTime", this.boostedTime);
        aNBT.func_74772_a("eut", this.eut);
        this.saveNBTDataItemStacks(aNBT);
        this.saveNBTDataFluidStacks(aNBT);
    }

    protected void saveNBTDataItemStacks(NBTTagCompound aNBT) {
        if (this.outputItems != null && this.outputItems.length > 0) {
            aNBT.func_74768_a("outputItemsLength", this.outputItems.length);
            for (int i = 0; i < this.outputItems.length; ++i) {
                NBTUtils.saveItem(aNBT, "outputItems" + i, this.outputItems[i]);
            }
        }
    }

    protected void saveNBTDataFluidStacks(NBTTagCompound aNBT) {
        if (this.outputFluids != null && this.outputFluids.length > 0) {
            aNBT.func_74768_a("outputFluidsLength", this.outputFluids.length);
            for (int i = 0; i < this.outputFluids.length; ++i) {
                NBTUtils.saveFluid(aNBT, "outputFluids" + i, this.outputFluids[i]);
            }
        }
    }

    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.active = aNBT.func_74767_n("MH_active");
        this.trySetInactiveTimes = aNBT.func_74771_c("trySetInactiveTimes");
        this.maxProgressingTime = aNBT.func_74762_e("maxProgressingTime");
        this.progressedTime = aNBT.func_74762_e("progressedTime");
        this.boostedTime = aNBT.func_74762_e("boostedTime");
        this.eut = aNBT.func_74763_f("eut");
        this.loadNBTDataItemStacks(aNBT);
        this.loadNBTDataFluidStacks(aNBT);
    }

    protected void loadNBTDataItemStacks(NBTTagCompound aNBT) {
        int length = aNBT.func_74762_e("outputItemsLength");
        if (length > 0) {
            this.outputItems = new ItemStack[length];
            for (int i = 0; i < length; ++i) {
                this.outputItems[i] = NBTUtils.loadItem(aNBT, "outputItems" + i);
            }
        }
    }

    protected void loadNBTDataFluidStacks(NBTTagCompound aNBT) {
        int length = aNBT.func_74762_e("outputFluidsLength");
        if (length > 0) {
            this.outputFluids = new FluidStack[length];
            for (int i = 0; i < length; ++i) {
                this.outputFluids[i] = NBTUtils.loadFluid(aNBT, "outputFluids" + i);
            }
        }
    }

    public boolean supportsVoidProtection() {
        return false;
    }

    public VoidingMode getVoidingMode() {
        return VoidingMode.VOID_ALL;
    }

    public void setVoidingMode(VoidingMode mode) {
    }

    public List<ItemStack> getVoidOutputSlots() {
        return Collections.emptyList();
    }

    public List<ItemStack> getItemOutputSlots(ItemStack[] toOutput) {
        IModularizedMachine.ISupportExecutionCore iSupportExecutionCore = this.mainMachine;
        if (iSupportExecutionCore instanceof IVoidable) {
            IVoidable m = (IVoidable)iSupportExecutionCore;
            return m.getItemOutputSlots(toOutput);
        }
        return Collections.emptyList();
    }

    public List<? extends IFluidStore> getFluidOutputSlots(FluidStack[] toOutput) {
        IModularizedMachine.ISupportExecutionCore iSupportExecutionCore = this.mainMachine;
        if (iSupportExecutionCore instanceof IVoidable) {
            IVoidable m = (IVoidable)iSupportExecutionCore;
            return m.getFluidOutputSlots(toOutput);
        }
        return Collections.emptyList();
    }

    public boolean canDumpItemToME() {
        IModularizedMachine.ISupportExecutionCore iSupportExecutionCore = this.mainMachine;
        if (iSupportExecutionCore instanceof IVoidable) {
            IVoidable m = (IVoidable)iSupportExecutionCore;
            return m.canDumpItemToME();
        }
        return false;
    }

    public boolean canDumpFluidToME() {
        IModularizedMachine.ISupportExecutionCore iSupportExecutionCore = this.mainMachine;
        if (iSupportExecutionCore instanceof IVoidable) {
            IVoidable m = (IVoidable)iSupportExecutionCore;
            return m.canDumpFluidToME();
        }
        return false;
    }

    public ItemStack[] getOutputItems() {
        return this.outputItems;
    }

    @Override
    public ExecutionCoreBase setOutputItems(ItemStack[] outputItems) {
        this.outputItems = outputItems;
        return this;
    }

    public FluidStack[] getOutputFluids() {
        return this.outputFluids;
    }

    @Override
    public ExecutionCoreBase setOutputFluids(FluidStack[] outputFluids) {
        this.outputFluids = outputFluids;
        return this;
    }

    public long getMaxProgressingTime() {
        return this.maxProgressingTime;
    }

    @Override
    public ExecutionCoreBase setMaxProgressingTime(int maxProgressingTime) {
        this.maxProgressingTime = maxProgressingTime;
        return this;
    }

    public long getProgressedTime() {
        return this.progressedTime;
    }

    public ExecutionCoreBase setProgressedTime(int progressedTime) {
        this.progressedTime = progressedTime;
        return this;
    }

    @Override
    public long getEut() {
        return this.eut;
    }

    @Override
    public ExecutionCoreBase setEut(long eut) {
        this.eut = eut;
        return this;
    }

    @Override
    public IModularizedMachine.ISupportExecutionCore getMainMachine() {
        return this.mainMachine;
    }

    public ExecutionCoreBase setMainMachine(IModularizedMachine.ISupportExecutionCore mainMachine) {
        this.mainMachine = mainMachine;
        return this;
    }

    public boolean isHasBeenSetup() {
        return this.hasBeenSetup;
    }

    public ExecutionCoreBase setHasBeenSetup(boolean hasBeenSetup) {
        this.hasBeenSetup = hasBeenSetup;
        return this;
    }

    @Override
    public void onCheckMachine(ModularizedMachineBase<?> machine) {
    }
}

