/*
 * Decompiled with CFR 0.152.
 */
package com.Nxer.TwistSpaceTechnology.common.modularizedMachine.modularHatches.ExecutionCores;

import com.Nxer.TwistSpaceTechnology.TwistSpaceTechnology;
import com.Nxer.TwistSpaceTechnology.common.modularizedMachine.modularHatches.ExecutionCores.ExecutionCoreBase;
import com.Nxer.TwistSpaceTechnology.util.TextEnums;
import com.Nxer.TwistSpaceTechnology.util.TstUtils;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTUtility;
import gregtech.common.misc.WirelessNetworkManager;
import java.math.BigInteger;
import java.util.List;
import java.util.UUID;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;

public class PerfectExecutionCore
extends ExecutionCoreBase {
    private UUID ownerUUID;
    protected String costEU = "";
    protected String[] description;
    protected static Textures.BlockIcons.CustomIcon ActiveFace;
    protected static Textures.BlockIcons.CustomIcon InactiveFace;

    public PerfectExecutionCore(int aID, String aName, String aNameRegional, int aTier) {
        super(aID, aName, aNameRegional, aTier);
    }

    public PerfectExecutionCore(String aName, int aTier, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, aDescription, aTextures);
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new PerfectExecutionCore(this.mName, this.mTier, this.mDescriptionArray, this.mTextures);
    }

    public void onFirstTick(IGregTechTileEntity aBaseMetaTileEntity) {
        super.onFirstTick(aBaseMetaTileEntity);
        this.ownerUUID = aBaseMetaTileEntity.getOwnerUuid();
    }

    @Override
    public void resetParameters() {
        super.resetParameters();
        this.costEU = "";
    }

    @Override
    public boolean done() {
        BigInteger costEU = BigInteger.valueOf(this.eut).multiply(BigInteger.valueOf(this.maxProgressingTime));
        if (!WirelessNetworkManager.addEUToGlobalEnergyMap((UUID)this.ownerUUID, (BigInteger)costEU.multiply(TstUtils.NEGATIVE_ONE))) {
            this.shutDown();
            IGregTechTileEntity mte = this.getBaseMetaTileEntity();
            TwistSpaceTechnology.LOG.info("Advanced Execution Core shut down because of power at x" + mte.getXCoord() + " y" + mte.getYCoord() + " z" + mte.getZCoord());
            return false;
        }
        this.costEU = GTUtility.formatNumbers((BigInteger)costEU);
        this.maxProgressingTime = 20;
        this.trySetActive();
        return true;
    }

    @Override
    public void processWailaBody(ItemStack itemStack, List<String> currentTip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        NBTTagCompound tag = accessor.getNBTData();
        if (tag.func_74767_n("hasBeenSetup")) {
            int maxProgressingTime = tag.func_74762_e("maxProgressingTime");
            if (maxProgressingTime > 0) {
                currentTip.add(TextEnums.tr("Waila.PerfectExecutionCore.1") + " : " + maxProgressingTime + " tick (" + maxProgressingTime / 20 + "s)");
                int progressedTime = tag.func_74762_e("progressedTime");
                currentTip.add(TextEnums.tr("Waila.ExecutionCore.2") + " : " + progressedTime + " tick (" + progressedTime / 20 + "s)");
                String costEU = tag.func_74779_i("costEU");
                if (costEU != null && !costEU.isEmpty()) {
                    currentTip.add(EnumChatFormatting.AQUA + TextEnums.tr("Waila.TST_MiracleDoor.1") + EnumChatFormatting.RESET + ": " + EnumChatFormatting.GOLD + costEU + EnumChatFormatting.RESET + " EU");
                }
            } else {
                currentTip.add(TextEnums.tr("Waila.ExecutionCore.IsIdle"));
            }
        } else {
            currentTip.add(TextEnums.tr("Waila.ExecutionCore.HasNotBeenSetup"));
        }
    }

    @Override
    public void getWailaNBTData(EntityPlayerMP player, TileEntity tile, NBTTagCompound tag, World world, int x, int y, int z) {
        super.getWailaNBTData(player, tile, tag, world, x, y, z);
        IGregTechTileEntity tileEntity = this.getBaseMetaTileEntity();
        if (tileEntity != null) {
            tag.func_74778_a("costEU", this.costEU);
        }
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74778_a("costEU", this.costEU);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.costEU = aNBT.func_74779_i("costEU");
    }

    @Override
    public boolean useMainMachinePower() {
        return false;
    }

    public String[] getDescription() {
        if (this.description == null || this.description.length == 0) {
            this.description = new String[]{TextEnums.tr("Tooltips.PerfectExecutionCore.01"), TextEnums.tr("Tooltips.PerfectExecutionCore.02"), TextEnums.tr("Tooltips.PerfectExecutionCore.03"), TextEnums.tr("Tooltips.PerfectExecutionCore.04"), TextEnums.AddByTwistSpaceTechnology.getText(), TextEnums.ModularizedMachineSystem.getText()};
        }
        return this.description;
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister aBlockIconRegister) {
        ActiveFace = new Textures.BlockIcons.CustomIcon("gtnhcommunitymod:ModularHatchOverlay/OVERLAY_ControlCore_Per_on");
        InactiveFace = new Textures.BlockIcons.CustomIcon("gtnhcommunitymod:ModularHatchOverlay/OVERLAY_ControlCore_Per_off");
        super.registerIcons(aBlockIconRegister);
    }

    @Override
    public ITexture[] getTexturesActive(ITexture aBaseTexture) {
        return new ITexture[]{aBaseTexture, TextureFactory.of((IIconContainer)ActiveFace)};
    }

    @Override
    public ITexture[] getTexturesInactive(ITexture aBaseTexture) {
        return new ITexture[]{aBaseTexture, TextureFactory.of((IIconContainer)InactiveFace)};
    }
}

