/*
 * Decompiled with CFR 0.152.
 */
package com.Nxer.TwistSpaceTechnology.common.ship;

import com.Nxer.TwistSpaceTechnology.common.ship.component.ShieldComponent;
import com.Nxer.TwistSpaceTechnology.common.ship.component.ShipComponent;
import com.Nxer.TwistSpaceTechnology.common.ship.system.ControlSystem;
import com.Nxer.TwistSpaceTechnology.common.ship.system.EnergySystem;
import com.Nxer.TwistSpaceTechnology.common.ship.system.PropulsionSystem;
import com.Nxer.TwistSpaceTechnology.common.ship.system.RadarSystem;
import com.Nxer.TwistSpaceTechnology.common.ship.system.ShieldSystem;
import com.Nxer.TwistSpaceTechnology.common.ship.system.WeaponSystem;
import gregtech.api.util.GTUtility;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class Ship
extends EntityMob
implements Runnable {
    public EntityPlayer owner;
    public World world;
    public String className;
    public String shipName;
    public Integer length = 0;
    public Integer field_70131_O = 0;
    public Integer field_70130_N = 0;
    public Integer dockyard = -1;
    public List<Integer> validDimId = new ArrayList<Integer>();
    public boolean forceTravel = false;
    public static final Integer maxLength = 64;
    public static final Integer maxHeight = 64;
    public static final Integer maxWidth = 64;
    public List<ShipComponent> structure = new ArrayList<ShipComponent>(maxHeight * maxLength * maxWidth);
    public PropulsionSystem propulsionSystem = new PropulsionSystem();
    public EnergySystem energySystem = new EnergySystem();
    public ControlSystem controlSystem = new ControlSystem();
    public WeaponSystem weaponSystem = new WeaponSystem();
    public ShieldSystem shieldSystem = new ShieldSystem();
    public RadarSystem radarSystem = new RadarSystem();

    public Ship(World worldIn) {
        super(worldIn);
        this.world = worldIn;
        this.init();
    }

    public void init() {
    }

    public void func_71027_c(int dimensionId) {
        if (!this.validDimId.contains(dimensionId) && !this.forceTravel) {
            GTUtility.sendChatToPlayer((EntityPlayer)this.owner, (String)("your ship :" + this.shipName + "is trying to travel to a dimension which can destroy it immediately"));
        }
        super.func_71027_c(dimensionId);
        if (this.forceTravel) {
            this.func_70106_y();
        }
        TileEntity t = new TileEntity();
    }

    public ShipComponent getComponent(int x, int y, int z) {
        return this.structure.get(this.getIndex(x, y, z));
    }

    public int getIndex(int x, int y, int z) {
        return x * this.length * this.field_70131_O + y * this.length + z;
    }

    public void setComponent(int x, int y, int z, ShipComponent shipComponent) {
        shipComponent.setPosition(x, y, z);
        this.structure.set(this.getIndex(x, y, z), shipComponent);
    }

    public boolean checkComponentStatus() {
        return this.reConstructSystems();
    }

    public boolean reConstructSystems() {
        return true;
    }

    public boolean checkEnergy() {
        return true;
    }

    public void charge() {
    }

    public void runEnergy() {
    }

    public void addBulletForWeapons() {
    }

    public void addFuelForEngine() {
    }

    public void move() {
    }

    public void openFire() {
    }

    public void damageShield(double startX, double startY, double startZ, double radio, double damage) {
        int cnt = 0;
        for (ShieldComponent shield : this.shieldSystem.shields) {
            if (!(radio >= shield.distanceTo(startX, startY, startZ))) continue;
            ++cnt;
        }
        for (ShieldComponent shield : this.shieldSystem.shields) {
            if (!(radio >= shield.distanceTo(startX, startY, startZ))) continue;
            if (shield.isNumberShield) {
                shield.shieldPoint -= 1.0;
                damage -= damage / (double)(--cnt);
                continue;
            }
            double damaged = Math.min(damage / (double)cnt, shield.shieldPoint);
            shield.shieldPoint -= damage / (double)cnt;
            --cnt;
            damage -= damaged;
        }
        if (damage > 0.1) {
            this.damage(startX, startY, startZ, radio, damage);
        }
    }

    public void damage(double startX, double startY, double startZ, double radio, double damage) {
    }

    protected void func_70088_a() {
        super.func_70088_a();
    }

    public void func_70037_a(NBTTagCompound tagCompound) {
        super.func_70037_a(tagCompound);
    }

    public void func_70014_b(NBTTagCompound tagCompound) {
        super.func_70014_b(tagCompound);
    }

    public String toString() {
        return "MyShip";
    }

    @Override
    public void run() {
        while (this.checkComponentStatus()) {
            long time = System.currentTimeMillis();
            this.charge();
            if (this.checkEnergy()) continue;
            this.runEnergy();
            this.addBulletForWeapons();
            this.addFuelForEngine();
            this.move();
            this.openFire();
            try {
                this.wait(time + 50L - System.currentTimeMillis());
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        this.func_70106_y();
    }
}

