/*
 * Decompiled with CFR 0.152.
 */
package com.Nxer.TwistSpaceTechnology.recipe.machineRecipe.expanded;

import bartworks.util.BWUtil;
import com.Nxer.TwistSpaceTechnology.TwistSpaceTechnology;
import com.Nxer.TwistSpaceTechnology.common.GTCMItemList;
import com.Nxer.TwistSpaceTechnology.common.material.MaterialPool;
import com.Nxer.TwistSpaceTechnology.common.recipeMap.GTCMRecipe;
import com.Nxer.TwistSpaceTechnology.config.Config;
import com.Nxer.TwistSpaceTechnology.util.TstUtils;
import com.Nxer.TwistSpaceTechnology.util.recipes.TST_RecipeBuilder;
import com.Nxer.TwistSpaceTechnology.util.rewrites.TST_ItemID;
import goodgenerator.items.GGMaterial;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.enums.MaterialsUEVplus;
import gregtech.api.enums.Mods;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.TierEU;
import gregtech.api.objects.ItemData;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.util.GTModHandler;
import gregtech.api.util.GTOreDictUnificator;
import gregtech.api.util.GTRecipe;
import gregtech.api.util.GTUtility;
import gtPlusPlus.core.material.Material;
import gtPlusPlus.core.material.MaterialsElements;
import gtPlusPlus.xmod.gregtech.api.enums.GregtechItemList;
import gtnhintergalactic.recipe.IGRecipeMaps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import tectech.thing.CustomItemList;

public class MiracleTopRecipePool {
    private static final RecipeMap<?> MT = GTCMRecipe.MiracleTopRecipes;
    public static final HashMap<ItemStack, ItemStack> circuitItemsToWrapped = new HashMap();
    private static final HashSet<Materials> superConductorMaterialList = new HashSet();
    private static final HashSet<OrePrefixes> targetModifyOreDict = new HashSet();
    private static final HashMap<ItemStack, FluidStack> specialMaterialCantAutoModify = new HashMap();

    public static void loadRecipes() {
        TwistSpaceTechnology.LOG.info("MiracleTopRecipePool loading recipes.");
        MiracleTopRecipePool.initStatics();
        MiracleTopRecipePool.loadCircuitAssemblerRecipes();
        MiracleTopRecipePool.loadAssemblyLineRecipes();
        MiracleTopRecipePool.loadSpaceAssemblerRecipes();
        MiracleTopRecipePool.loadCustomRecipes();
    }

    private static void loadCircuitAssemblerRecipes() {
        HashSet<TST_ItemID> IgnoreRecipeOutputs = new HashSet<TST_ItemID>();
        IgnoreRecipeOutputs.add(TST_ItemID.createNoNBT(GTModHandler.getModItem((String)"appliedenergistics2", (String)"item.ItemMultiPart", (long)1L, (int)220)));
        IgnoreRecipeOutputs.add(TST_ItemID.createNoNBT(GTModHandler.getModItem((String)"ae2fc", (String)"part_fluid_storage_bus", (long)1L)));
        IgnoreRecipeOutputs.add(TST_ItemID.createNoNBT(GTModHandler.getModItem((String)"dreamcraft", (String)"item.SchematicsAstroMiner", (long)1L)));
        IgnoreRecipeOutputs.add(TST_ItemID.createNoNBT(GTModHandler.getModItem((String)"dreamcraft", (String)"item.SchematicsMoonBuggy", (long)1L)));
        IgnoreRecipeOutputs.add(TST_ItemID.createNoNBT(GTModHandler.getModItem((String)"dreamcraft", (String)"item.SchematicsCargoRocket", (long)1L)));
        IgnoreRecipeOutputs.add(TST_ItemID.createNoNBT(GTModHandler.getModItem((String)"dreamcraft", (String)"item.SchematicsTier1", (long)1L)));
        IgnoreRecipeOutputs.add(TST_ItemID.createNoNBT(GTModHandler.getModItem((String)"dreamcraft", (String)"item.SchematicsTier2", (long)1L)));
        IgnoreRecipeOutputs.add(TST_ItemID.createNoNBT(GTModHandler.getModItem((String)"dreamcraft", (String)"item.SchematicsTier3", (long)1L)));
        IgnoreRecipeOutputs.add(TST_ItemID.createNoNBT(GTModHandler.getModItem((String)"dreamcraft", (String)"item.SchematicsTier4", (long)1L)));
        IgnoreRecipeOutputs.add(TST_ItemID.createNoNBT(GTModHandler.getModItem((String)"dreamcraft", (String)"item.SchematicsTier5", (long)1L)));
        IgnoreRecipeOutputs.add(TST_ItemID.createNoNBT(GTModHandler.getModItem((String)"dreamcraft", (String)"item.SchematicsTier6", (long)1L)));
        IgnoreRecipeOutputs.add(TST_ItemID.createNoNBT(GTModHandler.getModItem((String)"dreamcraft", (String)"item.SchematicsTier7", (long)1L)));
        IgnoreRecipeOutputs.add(TST_ItemID.createNoNBT(GTModHandler.getModItem((String)"dreamcraft", (String)"item.SchematicsTier8", (long)1L)));
        IgnoreRecipeOutputs.add(TST_ItemID.createNoNBT(CustomItemList.parametrizerMemory.get(1L, new Object[0])));
        IgnoreRecipeOutputs.add(TST_ItemID.createNoNBT(ItemList.Circuit_Board_Wetware.get(1L, new Object[0])));
        IgnoreRecipeOutputs.add(TST_ItemID.createNoNBT(ItemList.Circuit_Board_Bio.get(1L, new Object[0])));
        ArrayList<GTRecipe> recipeCache = new ArrayList<GTRecipe>();
        for (GTRecipe originalRecipe : RecipeMaps.circuitAssemblerRecipes.getAllRecipes()) {
            String itemName;
            if (IgnoreRecipeOutputs.contains((Object)TST_ItemID.createNoNBT(originalRecipe.mOutputs[0])) || (itemName = Item.field_150901_e.func_148750_c((Object)originalRecipe.mOutputs[0].func_77973_b())) == null || itemName.contains(Mods.Railcraft.ID) || itemName.contains(Mods.Forestry.ID) || itemName.contains(Mods.StevesCarts2.ID) || itemName.contains(Mods.ProjectRedCore.ID) || itemName.contains(Mods.ProjectRedTransportation.ID)) continue;
            boolean isRecipeAdded = false;
            for (GTRecipe cachedRecipe : recipeCache) {
                if (!MiracleTopRecipePool.isRecipeInputItemSame(originalRecipe, cachedRecipe)) continue;
                isRecipeAdded = true;
                break;
            }
            if (isRecipeAdded) continue;
            GTRecipe recipeCopy = originalRecipe.copy();
            if (recipeCopy.mFluidInputs != null && recipeCopy.mFluidInputs.length > 0) {
                FluidStack recipeFluid = recipeCopy.mFluidInputs[0];
                if (recipeFluid.isFluidEqual(Materials.Lead.getMolten(1L))) {
                    recipeFluid = Materials.SolderingAlloy.getMolten((long)(recipeFluid.amount / 4));
                } else if (recipeFluid.isFluidEqual(Materials.Tin.getMolten(1L))) {
                    recipeFluid = Materials.SolderingAlloy.getMolten((long)(recipeFluid.amount / 2));
                }
                recipeCopy.mFluidInputs[0] = recipeFluid;
            }
            recipeCache.add(recipeCopy);
        }
        for (GTRecipe aRecipe : recipeCache) {
            int IntegratedCircuitNum = 16;
            for (ItemStack aStack : aRecipe.mInputs) {
                if (aStack == null || aStack.func_77973_b() != ItemList.Circuit_Integrated.getItem()) continue;
                if ((IntegratedCircuitNum += aStack.func_77960_j()) <= 24) break;
                IntegratedCircuitNum -= 24;
                break;
            }
            MiracleTopRecipePool.addRecipeMT(MiracleTopRecipePool.addIntegratedCircuitToRecipe(MiracleTopRecipePool.reduplicateRecipe(MiracleTopRecipePool.ModifyRecipe(aRecipe, false), 3, 3, 4, 4, 1, 3), IntegratedCircuitNum));
        }
    }

    private static void loadAssemblyLineRecipes() {
        HashSet<TST_ItemID> GenerateRecipeOutputs = new HashSet<TST_ItemID>();
        GenerateRecipeOutputs.add(TST_ItemID.createNoNBT(ItemList.Circuit_Wetwaremainframe.get(1L, new Object[0])));
        GenerateRecipeOutputs.add(TST_ItemID.createNoNBT(ItemList.Circuit_Biowaresupercomputer.get(1L, new Object[0])));
        GenerateRecipeOutputs.add(TST_ItemID.createNoNBT(ItemList.Circuit_Biomainframe.get(1L, new Object[0])));
        GenerateRecipeOutputs.add(TST_ItemID.createNoNBT(ItemList.Circuit_OpticalAssembly.get(1L, new Object[0])));
        GenerateRecipeOutputs.add(TST_ItemID.createNoNBT(ItemList.Circuit_OpticalComputer.get(1L, new Object[0])));
        GenerateRecipeOutputs.add(TST_ItemID.createNoNBT(ItemList.Circuit_OpticalMainframe.get(1L, new Object[0])));
        GenerateRecipeOutputs.add(TST_ItemID.createNoNBT(ItemList.Circuit_Chip_NeuroCPU.get(1L, new Object[0])));
        GenerateRecipeOutputs.add(TST_ItemID.createNoNBT(ItemList.Circuit_Chip_BioCPU.get(1L, new Object[0])));
        GenerateRecipeOutputs.add(TST_ItemID.createNoNBT(com.dreammaster.gthandler.CustomItemList.PikoCircuit.get(1L, new Object[0])));
        GenerateRecipeOutputs.add(TST_ItemID.createNoNBT(com.dreammaster.gthandler.CustomItemList.QuantumCircuit.get(1L, new Object[0])));
        HashSet AdvanceCircuitPart = new HashSet();
        Collections.addAll(AdvanceCircuitPart, TST_ItemID.create(ItemList.Circuit_Parts_ResistorASMD.get(1L, new Object[0]), ItemList.Circuit_Parts_DiodeASMD.get(1L, new Object[0]), ItemList.Circuit_Parts_TransistorASMD.get(1L, new Object[0]), ItemList.Circuit_Parts_CapacitorASMD.get(1L, new Object[0]), ItemList.Circuit_Parts_InductorASMD.get(1L, new Object[0])));
        HashSet OpticalCircuitPart = new HashSet();
        Collections.addAll(OpticalCircuitPart, TST_ItemID.create(ItemList.Circuit_Parts_ResistorXSMD.get(1L, new Object[0]), ItemList.Circuit_Parts_DiodeXSMD.get(1L, new Object[0]), ItemList.Circuit_Parts_TransistorXSMD.get(1L, new Object[0]), ItemList.Circuit_Parts_CapacitorXSMD.get(1L, new Object[0]), ItemList.Circuit_Parts_InductorXSMD.get(1L, new Object[0])));
        for (GTRecipe.RecipeAssemblyLine aRecipe : GTRecipe.RecipeAssemblyLine.sAssemblylineRecipes) {
            if (!GenerateRecipeOutputs.contains((Object)TST_ItemID.createNoNBT(aRecipe.mOutput))) continue;
            if (aRecipe.mOreDictAlt != null && aRecipe.mOreDictAlt.length > 0) {
                int slot;
                ArrayList<List<ItemStack>> choiceList = new ArrayList<List<ItemStack>>();
                for (int i = 0; i < aRecipe.mInputs.length; ++i) {
                    boolean hasCircuit = false;
                    if (i < aRecipe.mOreDictAlt.length && aRecipe.mOreDictAlt[i] != null) {
                        ItemStack stack;
                        ItemData stackData;
                        ItemStack[] itemStackArray = aRecipe.mOreDictAlt[i];
                        int n = itemStackArray.length;
                        for (int j = 0; j < n && (stackData = GTOreDictUnificator.getAssociation((ItemStack)(stack = itemStackArray[j]))) != null; ++j) {
                            OrePrefixes prefix = stackData.mPrefix;
                            if (prefix != OrePrefixes.circuit) continue;
                            hasCircuit = true;
                            break;
                        }
                    }
                    if (hasCircuit) {
                        ItemStack circuitStack = aRecipe.mOreDictAlt[i][0];
                        choiceList.add(Collections.singletonList(GTOreDictUnificator.get((OrePrefixes)OrePrefixes.circuit, (Object)Objects.requireNonNull(GTOreDictUnificator.getAssociation((ItemStack)circuitStack)).mMaterial.mMaterial, (long)circuitStack.field_77994_a)));
                        continue;
                    }
                    if (i < aRecipe.mOreDictAlt.length && aRecipe.mOreDictAlt[i] != null) {
                        choiceList.add(Arrays.asList(aRecipe.mOreDictAlt[i]));
                        continue;
                    }
                    choiceList.add(Collections.singletonList(aRecipe.mInputs[i]));
                }
                ArrayList<ItemStack[]> validRecipes = new ArrayList<ItemStack[]>();
                int totalSlots = choiceList.size();
                int[] indexArray = new int[totalSlots];
                block3: do {
                    ArrayList<ItemStack> currentCombination = new ArrayList<ItemStack>();
                    boolean hasAdvanced = false;
                    boolean hasOptical = false;
                    boolean illegalRubber = false;
                    Materials usedMaterial = null;
                    for (int i = 0; i < totalSlots; ++i) {
                        Materials material;
                        ItemStack aChoice = (ItemStack)((List)choiceList.get(i)).get(indexArray[i]);
                        currentCombination.add(aChoice);
                        ItemData stackData = GTOreDictUnificator.getAssociation((ItemStack)aChoice);
                        if (stackData != null && ((material = stackData.mMaterial.mMaterial) == Materials.StyreneButadieneRubber || material == Materials.Silicone)) {
                            if (usedMaterial == null) {
                                usedMaterial = material;
                            } else if (usedMaterial != material) {
                                illegalRubber = true;
                            }
                        }
                        if (AdvanceCircuitPart.contains((Object)TST_ItemID.create(aChoice))) {
                            hasAdvanced = true;
                        }
                        if (!OpticalCircuitPart.contains((Object)TST_ItemID.create(aChoice))) continue;
                        hasOptical = true;
                    }
                    if (!(hasAdvanced && hasOptical || illegalRubber)) {
                        validRecipes.add(currentCombination.toArray(new ItemStack[0]));
                    }
                    for (slot = totalSlots - 1; slot >= 0; --slot) {
                        int n = slot;
                        indexArray[n] = indexArray[n] + 1;
                        if (indexArray[slot] < ((List)choiceList.get(slot)).size()) continue block3;
                        indexArray[slot] = 0;
                    }
                } while (slot >= 0);
                for (ItemStack[] newInputs : validRecipes) {
                    MiracleTopRecipePool.addRecipeMT(MiracleTopRecipePool.addIntegratedCircuitToRecipe(MiracleTopRecipePool.ModifyRecipe(new GTRecipe(false, newInputs, new ItemStack[]{aRecipe.mOutput}, null, null, aRecipe.mFluidInputs, null, aRecipe.mDuration, aRecipe.mEUt, 0), true), 4));
                }
                continue;
            }
            MiracleTopRecipePool.addRecipeMT(MiracleTopRecipePool.addIntegratedCircuitToRecipe(MiracleTopRecipePool.ModifyRecipe(new GTRecipe(false, aRecipe.mInputs, new ItemStack[]{aRecipe.mOutput}, null, null, aRecipe.mFluidInputs, null, aRecipe.mDuration, aRecipe.mEUt, 0), true), 4));
        }
    }

    private static void loadSpaceAssemblerRecipes() {
        HashSet<TST_ItemID> GenerateRecipeOutputs = new HashSet<TST_ItemID>();
        GenerateRecipeOutputs.add(TST_ItemID.createNoNBT(GTModHandler.getModItem((String)"OpenComputers", (String)"item", (long)1L, (int)39)));
        GenerateRecipeOutputs.add(TST_ItemID.createNoNBT(ItemList.Optically_Perfected_CPU.get(1L, new Object[0])));
        GenerateRecipeOutputs.add(TST_ItemID.createNoNBT(ItemList.Optically_Compatible_Memory.get(1L, new Object[0])));
        for (GTRecipe aRecipe : IGRecipeMaps.spaceAssemblerRecipes.getAllRecipes()) {
            if (!GenerateRecipeOutputs.contains((Object)TST_ItemID.createNoNBT(aRecipe.mOutputs[0]))) continue;
            MiracleTopRecipePool.addRecipeMT(MiracleTopRecipePool.addIntegratedCircuitToRecipe(MiracleTopRecipePool.reduplicateRecipe(MiracleTopRecipePool.ModifyRecipe(aRecipe, true), 4, 1), 16));
        }
    }

    /*
     * WARNING - void declaration
     */
    public static GTRecipe ModifyRecipe(GTRecipe baseRecipe, boolean isFluidInputMultiply) {
        ArrayList<ItemStack> inputItems = new ArrayList<ItemStack>();
        ArrayList<FluidStack> inputFluids = new ArrayList<FluidStack>();
        if (baseRecipe.mFluidInputs != null && baseRecipe.mFluidInputs.length > 0) {
            if (isFluidInputMultiply) {
                Collections.addAll(inputFluids, MiracleTopRecipePool.reduplicateRecipe((GTRecipe)baseRecipe, (int)16, (int)1).mFluidInputs);
            } else {
                Collections.addAll(inputFluids, baseRecipe.mFluidInputs);
            }
        }
        if (baseRecipe.mInputs != null && baseRecipe.mInputs.length > 0) {
            for (ItemStack aStack : TstUtils.removeIntegratedCircuitFromStacks(baseRecipe.mInputs)) {
                boolean isItemModified = false;
                boolean isNeedTraverse = true;
                for (Map.Entry<ItemStack, ItemStack> entry : circuitItemsToWrapped.entrySet()) {
                    if (!GTUtility.areStacksEqual((ItemStack)entry.getKey(), (ItemStack)aStack)) continue;
                    inputItems.add(GTUtility.copyAmountUnsafe((int)aStack.field_77994_a, (ItemStack)entry.getValue()));
                    isItemModified = true;
                    break;
                }
                if (!isItemModified && BWUtil.checkStackAndPrefix((ItemStack)aStack)) {
                    ItemData Data = Objects.requireNonNull(GTOreDictUnificator.getAssociation((ItemStack)aStack));
                    Materials materials = Data.mMaterial.mMaterial;
                    OrePrefixes OreDict = Data.mPrefix;
                    if (materials.getMolten(1L) != null && targetModifyOreDict.contains(OreDict)) {
                        void var11_15;
                        if (materials == Materials.TengamAttuned) {
                            Materials materials2 = Materials.TengamPurified;
                        }
                        inputFluids.add(var11_15.getMolten(OreDict.mMaterialAmount * 144L * (long)aStack.field_77994_a / 3628800L * 16L));
                        isItemModified = true;
                    } else if (superConductorMaterialList.contains(materials) && OreDict != OrePrefixes.circuit) {
                        inputItems.add(GTUtility.copyAmountUnsafe((int)((int)(OreDict.mMaterialAmount * (long)aStack.field_77994_a * 2L / 3628800L)), (ItemStack)GTOreDictUnificator.get((OrePrefixes)OrePrefixes.wireGt16, (Object)materials, (long)1L)));
                        isItemModified = true;
                    }
                    isNeedTraverse = false;
                }
                if (!isItemModified && isNeedTraverse) {
                    for (Map.Entry<ItemStack, ItemStack> entry : specialMaterialCantAutoModify.entrySet()) {
                        if (!GTUtility.areStacksEqual((ItemStack)entry.getKey(), (ItemStack)aStack)) continue;
                        inputFluids.add(GTUtility.copyAmount((int)(((FluidStack)entry.getValue()).amount * aStack.field_77994_a * 16), (FluidStack)((FluidStack)entry.getValue())));
                        isItemModified = true;
                        break;
                    }
                }
                if (isItemModified) continue;
                inputItems.add(GTUtility.copyAmountUnsafe((int)(aStack.field_77994_a * 16), (ItemStack)aStack));
            }
        }
        return new GTRecipe(false, inputItems.toArray(new ItemStack[0]), new ItemStack[]{GTUtility.copyAmountUnsafe((int)(baseRecipe.mOutputs[0].field_77994_a * 16), (ItemStack)baseRecipe.mOutputs[0])}, null, null, MiracleTopRecipePool.mergeSameFluid(inputFluids.toArray(new FluidStack[0])), null, baseRecipe.mDuration * 12, baseRecipe.mEUt, 0);
    }

    public static GTRecipe reduplicateRecipe(GTRecipe oRecipe, int inputItemMultiTimes, int inputFluidMultiTimes, int outputItemMultiTimes, int outputFluidMultiTimes, int eutMultiTimes, int durationMultiTimes) {
        ArrayList<ItemStack> inputItems = new ArrayList<ItemStack>();
        ArrayList<FluidStack> inputFluids = new ArrayList<FluidStack>();
        ArrayList<ItemStack> outputItems = new ArrayList<ItemStack>();
        ArrayList<FluidStack> outputFluids = new ArrayList<FluidStack>();
        if (oRecipe == null) {
            return null;
        }
        for (ItemStack itemStack : oRecipe.mInputs) {
            if (itemStack == null) continue;
            inputItems.add(GTUtility.copyAmountUnsafe((int)(itemStack.field_77994_a * inputItemMultiTimes), (ItemStack)itemStack));
        }
        for (ItemStack itemStack : oRecipe.mFluidInputs) {
            if (itemStack == null) continue;
            inputFluids.add(GTUtility.copyAmount((int)(itemStack.amount * inputFluidMultiTimes), (FluidStack)itemStack));
        }
        for (ItemStack itemStack : oRecipe.mOutputs) {
            if (itemStack == null) continue;
            outputItems.add(GTUtility.copyAmountUnsafe((int)(itemStack.field_77994_a * outputItemMultiTimes), (ItemStack)itemStack));
        }
        for (ItemStack itemStack : oRecipe.mFluidOutputs) {
            if (itemStack == null) continue;
            outputFluids.add(GTUtility.copyAmount((int)(itemStack.amount * outputFluidMultiTimes), (FluidStack)itemStack));
        }
        return new GTRecipe(false, inputItems.toArray(new ItemStack[0]), outputItems.toArray(new ItemStack[0]), null, null, inputFluids.toArray(new FluidStack[0]), outputFluids.toArray(new FluidStack[0]), oRecipe.mDuration * durationMultiTimes, oRecipe.mEUt * eutMultiTimes, 0);
    }

    public static GTRecipe reduplicateRecipe(GTRecipe oRecipe, int n, int eut) {
        return MiracleTopRecipePool.reduplicateRecipe(oRecipe, n, n, n, n, eut, n);
    }

    public static GTRecipe addIntegratedCircuitToRecipe(GTRecipe oRecipe, int circuitNum) {
        ArrayList<ItemStack> inputItems = new ArrayList<ItemStack>();
        inputItems.add(GTUtility.getIntegratedCircuit((int)circuitNum));
        if (oRecipe == null) {
            return null;
        }
        Collections.addAll(inputItems, oRecipe.mInputs);
        return new GTRecipe(false, inputItems.toArray(new ItemStack[0]), oRecipe.mOutputs, null, null, oRecipe.mFluidInputs, oRecipe.mFluidOutputs, oRecipe.mDuration, oRecipe.mEUt, 0);
    }

    public static boolean isRecipeInputItemSame(GTRecipe a, GTRecipe b) {
        if (!ItemStack.func_77989_b((ItemStack)a.mOutputs[0], (ItemStack)b.mOutputs[0])) {
            return false;
        }
        if (a.mInputs.length != b.mInputs.length) {
            return false;
        }
        for (int i = 0; i < a.mInputs.length; ++i) {
            if (ItemStack.func_77989_b((ItemStack)a.mInputs[i], (ItemStack)b.mInputs[i])) continue;
            return false;
        }
        return true;
    }

    public static FluidStack[] mergeSameFluid(FluidStack[] fluidStacks) {
        LinkedHashMap<Fluid, Integer> fluidMap = new LinkedHashMap<Fluid, Integer>();
        for (FluidStack aStack : fluidStacks) {
            fluidMap.put(aStack.getFluid(), fluidMap.getOrDefault(aStack.getFluid(), 0) + aStack.amount);
        }
        ArrayList<FluidStack> mergedList = new ArrayList<FluidStack>();
        for (Map.Entry entry : fluidMap.entrySet()) {
            mergedList.add(new FluidStack((Fluid)entry.getKey(), ((Integer)entry.getValue()).intValue()));
        }
        return mergedList.toArray(new FluidStack[0]);
    }

    public static ItemStack[] mergeSameItem(ItemStack[] itemStacks) {
        LinkedHashMap<Item, Integer> itemMap = new LinkedHashMap<Item, Integer>();
        for (ItemStack aStack : itemStacks) {
            itemMap.put(aStack.func_77973_b(), itemMap.getOrDefault(aStack.func_77973_b(), 0) + aStack.field_77994_a);
        }
        ArrayList<ItemStack> mergedList = new ArrayList<ItemStack>();
        for (Map.Entry entry : itemMap.entrySet()) {
            mergedList.add(new ItemStack((Item)entry.getKey(), ((Integer)entry.getValue()).intValue()));
        }
        return mergedList.toArray(new ItemStack[0]);
    }

    private static void addRecipeMT(GTRecipe aRecipe) {
        if (aRecipe == null) {
            return;
        }
        TST_RecipeBuilder.builder().itemInputs(aRecipe.mInputs).fluidInputs(aRecipe.mFluidInputs).itemOutputs(aRecipe.mOutputs).eut(aRecipe.mEUt).duration(aRecipe.mDuration).addTo(MT);
    }

    private static void initStatics() {
        ItemStack[] CircuitParts = new ItemStack[]{GTOreDictUnificator.get((OrePrefixes)OrePrefixes.circuit, (Object)Materials.ULV, (long)1L), GTOreDictUnificator.get((OrePrefixes)OrePrefixes.circuit, (Object)Materials.LV, (long)1L), GTOreDictUnificator.get((OrePrefixes)OrePrefixes.circuit, (Object)Materials.MV, (long)1L), GTOreDictUnificator.get((OrePrefixes)OrePrefixes.circuit, (Object)Materials.HV, (long)1L), GTOreDictUnificator.get((OrePrefixes)OrePrefixes.circuit, (Object)Materials.EV, (long)1L), GTOreDictUnificator.get((OrePrefixes)OrePrefixes.circuit, (Object)Materials.IV, (long)1L), GTOreDictUnificator.get((OrePrefixes)OrePrefixes.circuit, (Object)Materials.LuV, (long)1L), GTOreDictUnificator.get((OrePrefixes)OrePrefixes.circuit, (Object)Materials.ZPM, (long)1L), GTOreDictUnificator.get((OrePrefixes)OrePrefixes.circuit, (Object)Materials.UV, (long)1L), GTOreDictUnificator.get((OrePrefixes)OrePrefixes.circuit, (Object)Materials.UHV, (long)1L), GTOreDictUnificator.get((OrePrefixes)OrePrefixes.circuit, (Object)Materials.UEV, (long)1L), GTOreDictUnificator.get((OrePrefixes)OrePrefixes.circuit, (Object)Materials.UIV, (long)1L), GTOreDictUnificator.get((OrePrefixes)OrePrefixes.circuit, (Object)Materials.UMV, (long)1L), GTOreDictUnificator.get((OrePrefixes)OrePrefixes.circuit, (Object)Materials.UXV, (long)1L), GTOreDictUnificator.get((OrePrefixes)OrePrefixes.circuit, (Object)Materials.MAX, (long)1L), ItemList.Circuit_Parts_Crystal_Chip_Elite.get(1L, new Object[0]), ItemList.Circuit_Parts_Crystal_Chip_Master.get(1L, new Object[0]), ItemList.Circuit_Board_Coated.get(1L, new Object[0]), ItemList.Circuit_Board_Coated_Basic.get(1L, new Object[0]), ItemList.Circuit_Board_Phenolic.get(1L, new Object[0]), ItemList.Circuit_Board_Phenolic_Good.get(1L, new Object[0]), ItemList.Circuit_Board_Epoxy.get(1L, new Object[0]), ItemList.Circuit_Board_Epoxy_Advanced.get(1L, new Object[0]), ItemList.Circuit_Board_Fiberglass.get(1L, new Object[0]), ItemList.Circuit_Board_Fiberglass_Advanced.get(1L, new Object[0]), ItemList.Circuit_Board_Multifiberglass_Elite.get(1L, new Object[0]), ItemList.Circuit_Board_Multifiberglass.get(1L, new Object[0]), ItemList.Circuit_Board_Wetware.get(1L, new Object[0]), ItemList.Circuit_Board_Wetware_Extreme.get(1L, new Object[0]), ItemList.Circuit_Board_Plastic.get(1L, new Object[0]), ItemList.Circuit_Board_Plastic_Advanced.get(1L, new Object[0]), ItemList.Circuit_Board_Bio.get(1L, new Object[0]), ItemList.Circuit_Board_Bio_Ultra.get(1L, new Object[0]), ItemList.Circuit_Parts_ResistorSMD.get(1L, new Object[0]), ItemList.Circuit_Parts_InductorSMD.get(1L, new Object[0]), ItemList.Circuit_Parts_DiodeSMD.get(1L, new Object[0]), ItemList.Circuit_Parts_TransistorSMD.get(1L, new Object[0]), ItemList.Circuit_Parts_CapacitorSMD.get(1L, new Object[0]), ItemList.Circuit_Parts_ResistorASMD.get(1L, new Object[0]), ItemList.Circuit_Parts_DiodeASMD.get(1L, new Object[0]), ItemList.Circuit_Parts_TransistorASMD.get(1L, new Object[0]), ItemList.Circuit_Parts_CapacitorASMD.get(1L, new Object[0]), ItemList.Circuit_Chip_ILC.get(1L, new Object[0]), ItemList.Circuit_Chip_Ram.get(1L, new Object[0]), ItemList.Circuit_Chip_NAND.get(1L, new Object[0]), ItemList.Circuit_Chip_NOR.get(1L, new Object[0]), ItemList.Circuit_Chip_CPU.get(1L, new Object[0]), ItemList.Circuit_Chip_SoC.get(1L, new Object[0]), ItemList.Circuit_Chip_SoC2.get(1L, new Object[0]), ItemList.Circuit_Chip_PIC.get(1L, new Object[0]), ItemList.Circuit_Chip_Simple_SoC.get(1L, new Object[0]), ItemList.Circuit_Chip_HPIC.get(1L, new Object[0]), ItemList.Circuit_Chip_UHPIC.get(1L, new Object[0]), ItemList.Circuit_Chip_ULPIC.get(1L, new Object[0]), ItemList.Circuit_Chip_LPIC.get(1L, new Object[0]), ItemList.Circuit_Chip_NPIC.get(1L, new Object[0]), ItemList.Circuit_Chip_PPIC.get(1L, new Object[0]), ItemList.Circuit_Chip_QPIC.get(1L, new Object[0]), ItemList.Circuit_Chip_NanoCPU.get(1L, new Object[0]), ItemList.Circuit_Chip_QuantumCPU.get(1L, new Object[0]), ItemList.Circuit_Chip_CrystalCPU.get(1L, new Object[0]), ItemList.Circuit_Chip_CrystalSoC.get(1L, new Object[0]), ItemList.Circuit_Chip_CrystalSoC2.get(1L, new Object[0]), ItemList.Circuit_Chip_NeuroCPU.get(1L, new Object[0]), ItemList.Circuit_Chip_BioCPU.get(1L, new Object[0]), ItemList.Circuit_Chip_Stemcell.get(1L, new Object[0]), ItemList.Circuit_Chip_Biocell.get(1L, new Object[0]), ItemList.Circuit_Parts_ResistorXSMD.get(1L, new Object[0]), ItemList.Circuit_Parts_DiodeXSMD.get(1L, new Object[0]), ItemList.Circuit_Parts_TransistorXSMD.get(1L, new Object[0]), ItemList.Circuit_Parts_CapacitorXSMD.get(1L, new Object[0]), ItemList.Circuit_Parts_InductorASMD.get(1L, new Object[0]), ItemList.Circuit_Parts_InductorXSMD.get(1L, new Object[0]), ItemList.Circuit_Chip_Optical.get(1L, new Object[0]), ItemList.Circuit_Board_Optical.get(1L, new Object[0]), ItemList.Optically_Perfected_CPU.get(1L, new Object[0]), ItemList.Optical_Cpu_Containment_Housing.get(1L, new Object[0]), ItemList.Optically_Compatible_Memory.get(1L, new Object[0]), ItemList.Circuit_Parts_Crystal_Chip_Wetware.get(1L, new Object[0]), ItemList.Circuit_Parts_Chip_Bioware.get(1L, new Object[0])};
        int Count = 0;
        for (WrappedCircuitItem item : WrappedCircuitItem.values()) {
            if (Count < 15) {
                item.set(GTModHandler.getModItem((String)"GoodGenerator", (String)"circuitWrap", (long)1L, (int)Count));
            } else {
                item.set(GTModHandler.getModItem((String)"bartworks", (String)"gt.bwMetaGeneratedItem0", (long)1L, (int)(32778 - Count)));
            }
            if (CircuitParts[Count] != null && item.get(1) != null) {
                circuitItemsToWrapped.put(CircuitParts[Count], item.get(1));
            } else {
                circuitItemsToWrapped.put(GTCMItemList.TestItem0.get(1, new Object[0]), GTCMItemList.TestItem0.get(1, new Object[0]));
            }
            ++Count;
        }
        circuitItemsToWrapped.put(ItemList.Circuit_Parts_Resistor.get(1L, new Object[0]), WrappedCircuitItem.Wrapped_Circuit_Parts_ResistorSMD.get(1));
        circuitItemsToWrapped.put(ItemList.Circuit_Parts_Coil.get(1L, new Object[0]), WrappedCircuitItem.Wrapped_Circuit_Parts_InductorSMD.get(1));
        circuitItemsToWrapped.put(ItemList.Circuit_Parts_Diode.get(1L, new Object[0]), WrappedCircuitItem.Wrapped_Circuit_Parts_DiodeSMD.get(1));
        circuitItemsToWrapped.put(ItemList.Circuit_Parts_Transistor.get(1L, new Object[0]), WrappedCircuitItem.Wrapped_Circuit_Parts_TransistorSMD.get(1));
        circuitItemsToWrapped.put(ItemList.Circuit_Parts_Capacitor.get(1L, new Object[0]), WrappedCircuitItem.Wrapped_Circuit_Parts_CapacitorSMD.get(1));
        circuitItemsToWrapped.put(com.dreammaster.gthandler.CustomItemList.PikoCircuit.get(1L, new Object[0]), WrappedCircuitItem.Wrapped_Circuit_UMV.get(1));
        circuitItemsToWrapped.put(com.dreammaster.gthandler.CustomItemList.QuantumCircuit.get(1L, new Object[0]), WrappedCircuitItem.Wrapped_Circuit_UXV.get(1));
        for (Map.Entry entry : Material.mComponentMap.entrySet()) {
            String materialName = (String)entry.getKey();
            Map innerMap = (Map)entry.getValue();
            Material material = null;
            for (Material material2 : Material.mMaterialMap) {
                if (!material2.getUnlocalizedName().equals(materialName)) continue;
                material = material2;
            }
            if (material == null) continue;
            for (Map.Entry entry2 : innerMap.entrySet()) {
                String orePrefixName = (String)entry2.getKey();
                ItemStack aStack = (ItemStack)entry2.getValue();
                OrePrefixes OreDict = OrePrefixes.valueOf((String)orePrefixName);
                int amount = (int)(OreDict.mMaterialAmount * 144L * (long)aStack.field_77994_a / 3628800L);
                FluidStack fluidStack = material.getFluidStack(amount);
                if (fluidStack == null) continue;
                specialMaterialCantAutoModify.put(aStack, fluidStack);
            }
        }
        specialMaterialCantAutoModify.put(ItemList.Circuit_Parts_Reinforced_Glass_Tube.get(1L, new Object[0]), Materials.ReinforceGlass.getMolten(288L));
        superConductorMaterialList.add(Materials.SuperconductorMV);
        superConductorMaterialList.add(Materials.SuperconductorHV);
        superConductorMaterialList.add(Materials.SuperconductorEV);
        superConductorMaterialList.add(Materials.SuperconductorIV);
        superConductorMaterialList.add(Materials.SuperconductorLuV);
        superConductorMaterialList.add(Materials.SuperconductorZPM);
        superConductorMaterialList.add(Materials.SuperconductorUV);
        superConductorMaterialList.add(Materials.SuperconductorUHV);
        superConductorMaterialList.add(Materials.SuperconductorUEV);
        superConductorMaterialList.add(Materials.SuperconductorUIV);
        superConductorMaterialList.add(Materials.SuperconductorUMV);
        targetModifyOreDict.add(OrePrefixes.wireGt01);
        targetModifyOreDict.add(OrePrefixes.wireGt02);
        targetModifyOreDict.add(OrePrefixes.wireGt04);
        targetModifyOreDict.add(OrePrefixes.wireGt08);
        targetModifyOreDict.add(OrePrefixes.wireGt12);
        targetModifyOreDict.add(OrePrefixes.wireGt16);
        targetModifyOreDict.add(OrePrefixes.frameGt);
        targetModifyOreDict.add(OrePrefixes.dust);
        targetModifyOreDict.add(OrePrefixes.nugget);
        targetModifyOreDict.add(OrePrefixes.ingot);
        targetModifyOreDict.add(OrePrefixes.plate);
        targetModifyOreDict.add(OrePrefixes.plateDouble);
        targetModifyOreDict.add(OrePrefixes.plateDense);
        targetModifyOreDict.add(OrePrefixes.rod);
        targetModifyOreDict.add(OrePrefixes.round);
        targetModifyOreDict.add(OrePrefixes.bolt);
        targetModifyOreDict.add(OrePrefixes.screw);
        targetModifyOreDict.add(OrePrefixes.ring);
        targetModifyOreDict.add(OrePrefixes.foil);
        targetModifyOreDict.add(OrePrefixes.itemCasing);
        targetModifyOreDict.add(OrePrefixes.wireFine);
        targetModifyOreDict.add(OrePrefixes.gearGt);
        targetModifyOreDict.add(OrePrefixes.gearGtSmall);
        targetModifyOreDict.add(OrePrefixes.rotor);
        targetModifyOreDict.add(OrePrefixes.stickLong);
        targetModifyOreDict.add(OrePrefixes.spring);
        targetModifyOreDict.add(OrePrefixes.springSmall);
        targetModifyOreDict.add(OrePrefixes.plateSuperdense);
        targetModifyOreDict.add(OrePrefixes.pipeTiny);
        targetModifyOreDict.add(OrePrefixes.pipeSmall);
        targetModifyOreDict.add(OrePrefixes.pipeMedium);
        targetModifyOreDict.add(OrePrefixes.pipeLarge);
        targetModifyOreDict.add(OrePrefixes.pipeHuge);
        targetModifyOreDict.add(OrePrefixes.pipeQuadruple);
        targetModifyOreDict.add(OrePrefixes.pipeNonuple);
    }

    public static void loadCustomRecipes() {
        ItemStack ringBlock = GTModHandler.getModItem((String)"SGCraft", (String)"stargateRing", (long)1L, (int)0);
        ItemStack chevronBlock = GTModHandler.getModItem((String)"SGCraft", (String)"stargateRing", (long)1L, (int)1);
        ItemStack irisUpgrade = GTModHandler.getModItem((String)"SGCraft", (String)"sgIrisUpgrade", (long)1L, (int)0);
        GTValues.RA.stdBuilder().itemInputs(new ItemStack[]{GTCMItemList.SpaceWarper.get(64, new Object[0]), GTModHandler.getModItem((String)"eternalsingularity", (String)"eternal_singularity", (long)64L), GTModHandler.getModItem((String)"eternalsingularity", (String)"combined_singularity", (long)64L, (int)15), ItemList.Timepiece.get(64L, new Object[0]), ItemList.GigaChad.get(64L, new Object[0]), CustomItemList.SpacetimeCompressionFieldGeneratorTier8.get(64L, new Object[0]), CustomItemList.TimeAccelerationFieldGeneratorTier8.get(64L, new Object[0]), CustomItemList.StabilisationFieldGeneratorTier8.get(64L, new Object[0]), GTModHandler.getModItem((String)"dreamcraft", (String)"item.QuantumCircuit", (long)64L), GTModHandler.getModItem((String)Mods.GTPlusPlus.ID, (String)"particleBase", (long)64L, (int)15), GTModHandler.getModItem((String)Mods.GTPlusPlus.ID, (String)"particleBase", (long)64L, (int)16), GTModHandler.getModItem((String)Mods.GTPlusPlus.ID, (String)"particleBase", (long)64L, (int)20), GTModHandler.getModItem((String)Mods.GTPlusPlus.ID, (String)"particleBase", (long)64L, (int)21), GTModHandler.getModItem((String)Mods.GTPlusPlus.ID, (String)"particleBase", (long)64L, (int)17), ItemList.ZPM6.get(64L, new Object[0]), GTCMItemList.IndistinctTentacle.get(64, new Object[0])}).fluidInputs(new FluidStack[]{MaterialsUEVplus.Time.getMolten(114514000L), MaterialsUEVplus.Space.getMolten(114514000L), MaterialsUEVplus.MagnetohydrodynamicallyConstrainedStarMatter.getMolten(114514000L), GGMaterial.shirabon.getMolten(114514000), MaterialsUEVplus.Universium.getMolten(114514000L), MaterialsUEVplus.Eternity.getMolten(114514000L), MaterialsUEVplus.PrimordialMatter.getFluid(114514000L)}).itemOutputs(new ItemStack[]{GTCMItemList.ProofOfHeroes.get(1, new Object[0])}).specialValue(13500).eut(TierEU.RECIPE_MAX).duration(38396200).addTo(MT);
        TST_RecipeBuilder.builder().itemInputs(GTUtility.getIntegratedCircuit((int)21), GregtechItemList.InfinityInfusedShieldingCore.get(0L, new Object[0]), ItemList.Optical_Cpu_Containment_Housing.get(1L, new Object[0]), Materials.Glowstone.getNanite(4)).fluidInputs(MaterialsUEVplus.Space.getMolten(36L), MaterialsUEVplus.Time.getMolten(36L)).itemOutputs(GTCMItemList.ParticleTrapTimeSpaceShield.get(1, new Object[0])).eut(TierEU.RECIPE_UMV).duration(1280).addTo(MT);
        TST_RecipeBuilder.builder().itemInputs(GTUtility.getIntegratedCircuit((int)21), GregtechItemList.SpaceTimeBendingCore.get(0L, new Object[0]), ItemList.Optical_Cpu_Containment_Housing.get(2L, new Object[0]), Materials.Glowstone.getNanite(4)).fluidInputs(MaterialsUEVplus.Space.getMolten(144L), MaterialsUEVplus.Time.getMolten(144L), MaterialsUEVplus.SpaceTime.getMolten(288L)).itemOutputs(GTCMItemList.ParticleTrapTimeSpaceShield.get(16, new Object[0])).fluidOutputs(MaterialsUEVplus.DimensionallyTranscendentResidue.getFluid(2500L)).eut(TierEU.RECIPE_UMV).duration(1280).addTo(MT);
        GTValues.RA.stdBuilder().itemInputs(new ItemStack[]{GTUtility.copyAmount((int)1, (ItemStack)ringBlock), GTUtility.copyAmount((int)1, (ItemStack)chevronBlock), GTUtility.copyAmount((int)1, (ItemStack)chevronBlock), GTUtility.copyAmount((int)1, (ItemStack)ringBlock), GTUtility.copyAmount((int)1, (ItemStack)chevronBlock), GTUtility.copyAmount((int)1, (ItemStack)irisUpgrade), GTUtility.copyAmount((int)1, (ItemStack)irisUpgrade), GTUtility.copyAmount((int)1, (ItemStack)chevronBlock), GTUtility.copyAmount((int)1, (ItemStack)ringBlock), GTUtility.copyAmount((int)1, (ItemStack)irisUpgrade), GTUtility.copyAmount((int)1, (ItemStack)irisUpgrade), GTUtility.copyAmount((int)1, (ItemStack)ringBlock), GTUtility.copyAmount((int)1, (ItemStack)chevronBlock), GTUtility.copyAmount((int)1, (ItemStack)ringBlock), GTUtility.copyAmount((int)1, (ItemStack)ringBlock), GTUtility.copyAmount((int)1, (ItemStack)chevronBlock)}).fluidInputs(new FluidStack[]{MaterialPool.StabiliseVoidMatter.getFluidOrGas(1000)}).fluidOutputs(new FluidStack[]{MaterialPool.LiquidStargate.getFluidOrGas(1000)}).specialValue(13500).eut(TierEU.RECIPE_MAX).duration(1999999980).addTo(MT);
        TST_RecipeBuilder.builder().itemInputs(TstUtils.setStackSize(Materials.CosmicNeutronium.getDust(1), 10000000), TstUtils.setStackSize(Materials.Bedrockium.getDust(1), 10000000), TstUtils.setStackSize(Materials.Carbon.getDust(1), 10000000), TstUtils.setStackSize(Materials.Oilsands.getDust(1), 10000000), TstUtils.setStackSize(Materials.NiobiumTitanium.getDust(1), 10000000), TstUtils.setStackSize(MaterialsElements.STANDALONE.BLACK_METAL.getDust(1), 10000000), TstUtils.setStackSize(Materials.Naquadria.getDust(1), 10000000), TstUtils.setStackSize(Materials.Obsidian.getDust(1), 10000000), TstUtils.setStackSize(Materials.Coal.getDust(1), 10000000), TstUtils.setStackSize(Materials.NaquadahAlloy.getDust(1), 10000000), TstUtils.setStackSize(Materials.Tungsten.getDust(1), 10000000), TstUtils.setStackSize(MaterialsUEVplus.TranscendentMetal.getDust(1), 10000000), TstUtils.setStackSize(Materials.Perlite.getDust(1), 10000000), TstUtils.setStackSize(Materials.DarkAsh.getDust(1), 10000000), TstUtils.setStackSize(Materials.GraniticMineralSand.getDust(1), 10000000), TstUtils.setStackSize(MaterialsElements.STANDALONE.CELESTIAL_TUNGSTEN.getDust(1), 10000000)).fluidInputs(Materials.Polycaprolactam.getMolten(10000000L), Materials.NickelZincFerrite.getMolten(10000000L), Materials.DarkSteel.getMolten(10000000L), Materials.Polybenzimidazole.getMolten(10000000L), GGMaterial.tairitsu.getMolten(10000000), Materials.Tungsten.getMolten(10000000L), GGMaterial.marM200.getMolten(10000000), Materials.Vanadium.getMolten(10000000L), MaterialsElements.STANDALONE.BLACK_METAL.getFluidStack(10000000), Materials.ShadowIron.getMolten(10000000L), Materials.NaquadahAlloy.getMolten(10000000L), Materials.ShadowSteel.getMolten(10000000L), Materials.Cadmium.getMolten(10000000L), Materials.Desh.getMolten(10000000L), Materials.BlackPlutonium.getMolten(10000000L), Materials.BlackSteel.getMolten(10000000L), MaterialsElements.STANDALONE.CELESTIAL_TUNGSTEN.getFluidStack(10000000)).fluidOutputs(MaterialPool.StabiliseVoidMatter.getFluidOrGas(1)).eut(TierEU.RECIPE_MAX).duration(1999999980).addTo(MT);
        TST_RecipeBuilder.builder().itemInputs(GTCMItemList.UxvFlask.get(1, new Object[0]), GTCMItemList.ProofOfHeroes.get(64, new Object[0]), TstUtils.setStackSize(Materials.Silver.getNanite(1), 1000), TstUtils.setStackSize(Materials.Gold.getNanite(1), 1000), TstUtils.setStackSize(Materials.Neutronium.getNanite(1), 1000), TstUtils.setStackSize(MaterialsUEVplus.Universium.getNanite(1), 1000), TstUtils.setStackSize(MaterialsUEVplus.Eternity.getNanite(1), 1000), TstUtils.setStackSize(MaterialsUEVplus.TranscendentMetal.getNanite(1), 1000), TstUtils.setStackSize(Materials.Glowstone.getNanite(1), 1000), TstUtils.setStackSize(MaterialsUEVplus.WhiteDwarfMatter.getNanite(1), 1000), TstUtils.setStackSize(MaterialsUEVplus.BlackDwarfMatter.getNanite(1), 1000)).fluidInputs(MaterialPool.LiquidStargate.getFluidOrGas(50000), MaterialPool.StabiliseVoidMatter.getFluidOrGas(1000)).itemOutputs(GTCMItemList.ProofOfGods.get(1, new Object[0])).eut(TierEU.RECIPE_MAX).duration(1999999980).addTo(MT);
        MiracleTopRecipePool.loadFlaskRecipe();
        if (Config.activateMegaSpaceStation) {
            MiracleTopRecipePool.loadMaxRecipe();
        }
    }

    public static void loadMaxRecipe() {
        ItemStack[] inStack = new ItemStack[]{ItemList.Circuit_Parts_ResistorXSMD.get(16L, new Object[0]), ItemList.Circuit_Parts_DiodeXSMD.get(16L, new Object[0]), ItemList.Circuit_Parts_TransistorXSMD.get(16L, new Object[0]), ItemList.Circuit_Parts_CapacitorXSMD.get(16L, new Object[0]), ItemList.Circuit_Parts_InductorXSMD.get(16L, new Object[0])};
        ItemStack[] outStack = new ItemStack[]{GTCMItemList.HighDimensionalResistor.get(64, new Object[0]), GTCMItemList.HighDimensionalDiode.get(64, new Object[0]), GTCMItemList.HighDimensionalTransistor.get(64, new Object[0]), GTCMItemList.HighDimensionalCapacitor.get(64, new Object[0]), GTCMItemList.HighDimensionalInterface.get(64, new Object[0])};
        for (int i = 0; i < 5; ++i) {
            GTValues.RA.stdBuilder().itemInputs(new ItemStack[]{GTUtility.getIntegratedCircuit((int)12), GTOreDictUnificator.get((OrePrefixes)OrePrefixes.foil, (Object)MaterialsUEVplus.TranscendentMetal, (long)4L), GTOreDictUnificator.get((OrePrefixes)OrePrefixes.foil, (Object)MaterialsUEVplus.Universium, (long)2L), inStack[i], GTCMItemList.HighDimensionalExtend.get(1, new Object[0])}).fluidInputs(new FluidStack[]{MaterialsUEVplus.Time.getMolten(144L)}).itemOutputs(new ItemStack[]{outStack[i]}).eut(TierEU.RECIPE_UEV).duration(20).addTo(MT);
        }
    }

    public static void loadFlaskRecipe() {
        int ITEMS_FLASK_COUNT = 100000;
        GTValues.RA.stdBuilder().itemInputs(new ItemStack[]{TstUtils.setStackSize(ItemList.Electric_Motor_LV.get(1L, new Object[0]), 100000), TstUtils.setStackSize(ItemList.Electric_Piston_LV.get(1L, new Object[0]), 100000), TstUtils.setStackSize(ItemList.Electric_Pump_LV.get(1L, new Object[0]), 100000), TstUtils.setStackSize(ItemList.Field_Generator_LV.get(1L, new Object[0]), 100000), TstUtils.setStackSize(ItemList.Conveyor_Module_LV.get(1L, new Object[0]), 100000), TstUtils.setStackSize(ItemList.Robot_Arm_LV.get(1L, new Object[0]), 100000), TstUtils.setStackSize(ItemList.Emitter_LV.get(1L, new Object[0]), 100000), TstUtils.setStackSize(ItemList.Sensor_LV.get(1L, new Object[0]), 100000), TstUtils.setStackSize(ItemList.Circuit_Microprocessor.get(1L, new Object[0]), 100000), TstUtils.setStackSize(GTOreDictUnificator.get((OrePrefixes)OrePrefixes.wireGt01, (Object)Materials.RedstoneAlloy, (long)1L), 100000)}).fluidInputs(new FluidStack[]{Materials.Iron.getPlasma(1000000000L)}).itemOutputs(new ItemStack[]{GTCMItemList.LvFlask.get(1, new Object[0])}).eut(TierEU.RECIPE_MAX).duration(640).addTo(MT);
        GTValues.RA.stdBuilder().itemInputs(new ItemStack[]{GTCMItemList.LvFlask.get(1, new Object[0]), TstUtils.setStackSize(ItemList.Electric_Motor_MV.get(1L, new Object[0]), 100000), TstUtils.setStackSize(ItemList.Electric_Piston_MV.get(1L, new Object[0]), 100000), TstUtils.setStackSize(ItemList.Electric_Pump_MV.get(1L, new Object[0]), 100000), TstUtils.setStackSize(ItemList.Field_Generator_MV.get(1L, new Object[0]), 100000), TstUtils.setStackSize(ItemList.Conveyor_Module_MV.get(1L, new Object[0]), 100000), TstUtils.setStackSize(ItemList.Robot_Arm_MV.get(1L, new Object[0]), 100000), TstUtils.setStackSize(ItemList.Emitter_MV.get(1L, new Object[0]), 100000), TstUtils.setStackSize(ItemList.Sensor_MV.get(1L, new Object[0]), 100000), TstUtils.setStackSize(ItemList.Circuit_Processor.get(1L, new Object[0]), 100000), TstUtils.setStackSize(GTOreDictUnificator.get((OrePrefixes)OrePrefixes.wireGt01, (Object)Materials.SuperconductorMV, (long)1L), 100000)}).fluidInputs(new FluidStack[]{Materials.Copper.getPlasma(1000000000L)}).itemOutputs(new ItemStack[]{GTCMItemList.MvFlask.get(1, new Object[0])}).eut(TierEU.RECIPE_MAX).duration(2560).addTo(MT);
        GTValues.RA.stdBuilder().itemInputs(new ItemStack[]{GTCMItemList.MvFlask.get(1, new Object[0]), TstUtils.setStackSize(ItemList.Electric_Motor_HV.get(1L, new Object[0]), 100000), TstUtils.setStackSize(ItemList.Electric_Piston_HV.get(1L, new Object[0]), 100000), TstUtils.setStackSize(ItemList.Electric_Pump_HV.get(1L, new Object[0]), 100000), TstUtils.setStackSize(ItemList.Field_Generator_HV.get(1L, new Object[0]), 100000), TstUtils.setStackSize(ItemList.Conveyor_Module_HV.get(1L, new Object[0]), 100000), TstUtils.setStackSize(ItemList.Robot_Arm_HV.get(1L, new Object[0]), 100000), TstUtils.setStackSize(ItemList.Emitter_HV.get(1L, new Object[0]), 100000), TstUtils.setStackSize(ItemList.Sensor_HV.get(1L, new Object[0]), 100000), TstUtils.setStackSize(ItemList.Circuit_Nanoprocessor.get(1L, new Object[0]), 100000), TstUtils.setStackSize(GTOreDictUnificator.get((OrePrefixes)OrePrefixes.wireGt01, (Object)Materials.SuperconductorHV, (long)1L), 100000)}).fluidInputs(new FluidStack[]{Materials.Nickel.getPlasma(1000000000L)}).itemOutputs(new ItemStack[]{GTCMItemList.HvFlask.get(1, new Object[0])}).eut(TierEU.RECIPE_MAX).duration(10240).addTo(MT);
        GTValues.RA.stdBuilder().itemInputs(new ItemStack[]{GTCMItemList.HvFlask.get(1, new Object[0]), TstUtils.setStackSize(ItemList.Electric_Motor_EV.get(1L, new Object[0]), 100000), TstUtils.setStackSize(ItemList.Electric_Piston_EV.get(1L, new Object[0]), 100000), TstUtils.setStackSize(ItemList.Electric_Pump_EV.get(1L, new Object[0]), 100000), TstUtils.setStackSize(ItemList.Field_Generator_EV.get(1L, new Object[0]), 100000), TstUtils.setStackSize(ItemList.Conveyor_Module_EV.get(1L, new Object[0]), 100000), TstUtils.setStackSize(ItemList.Robot_Arm_EV.get(1L, new Object[0]), 100000), TstUtils.setStackSize(ItemList.Emitter_EV.get(1L, new Object[0]), 100000), TstUtils.setStackSize(ItemList.Sensor_EV.get(1L, new Object[0]), 100000), TstUtils.setStackSize(ItemList.Circuit_Quantumprocessor.get(1L, new Object[0]), 100000), TstUtils.setStackSize(GTOreDictUnificator.get((OrePrefixes)OrePrefixes.wireGt01, (Object)Materials.SuperconductorEV, (long)1L), 100000)}).fluidInputs(new FluidStack[]{Materials.Titanium.getPlasma(1000000000L)}).itemOutputs(new ItemStack[]{GTCMItemList.EvFlask.get(1, new Object[0])}).eut(TierEU.RECIPE_MAX).duration(40960).addTo(MT);
        GTValues.RA.stdBuilder().itemInputs(new ItemStack[]{GTCMItemList.EvFlask.get(1, new Object[0]), TstUtils.setStackSize(ItemList.Electric_Motor_IV.get(1L, new Object[0]), 100000), TstUtils.setStackSize(ItemList.Electric_Piston_IV.get(1L, new Object[0]), 100000), TstUtils.setStackSize(ItemList.Electric_Pump_IV.get(1L, new Object[0]), 100000), TstUtils.setStackSize(ItemList.Field_Generator_IV.get(1L, new Object[0]), 100000), TstUtils.setStackSize(ItemList.Conveyor_Module_IV.get(1L, new Object[0]), 100000), TstUtils.setStackSize(ItemList.Robot_Arm_IV.get(1L, new Object[0]), 100000), TstUtils.setStackSize(ItemList.Emitter_IV.get(1L, new Object[0]), 100000), TstUtils.setStackSize(ItemList.Sensor_IV.get(1L, new Object[0]), 100000), TstUtils.setStackSize(ItemList.Circuit_Crystalprocessor.get(1L, new Object[0]), 100000), TstUtils.setStackSize(GTOreDictUnificator.get((OrePrefixes)OrePrefixes.wireGt01, (Object)Materials.SuperconductorIV, (long)1L), 100000)}).fluidInputs(new FluidStack[]{Materials.Tungsten.getPlasma(1000000000L)}).itemOutputs(new ItemStack[]{GTCMItemList.IvFlask.get(1, new Object[0])}).eut(TierEU.RECIPE_MAX).duration(163840).addTo(MT);
        GTValues.RA.stdBuilder().itemInputs(new ItemStack[]{GTCMItemList.IvFlask.get(1, new Object[0]), TstUtils.setStackSize(ItemList.Electric_Motor_LuV.get(1L, new Object[0]), 100000), TstUtils.setStackSize(ItemList.Electric_Piston_LuV.get(1L, new Object[0]), 100000), TstUtils.setStackSize(ItemList.Electric_Pump_LuV.get(1L, new Object[0]), 100000), TstUtils.setStackSize(ItemList.Field_Generator_LuV.get(1L, new Object[0]), 100000), TstUtils.setStackSize(ItemList.Conveyor_Module_LuV.get(1L, new Object[0]), 100000), TstUtils.setStackSize(ItemList.Robot_Arm_LuV.get(1L, new Object[0]), 100000), TstUtils.setStackSize(ItemList.Emitter_LuV.get(1L, new Object[0]), 100000), TstUtils.setStackSize(ItemList.Sensor_LuV.get(1L, new Object[0]), 100000), TstUtils.setStackSize(ItemList.Circuit_Neuroprocessor.get(1L, new Object[0]), 100000), TstUtils.setStackSize(GTOreDictUnificator.get((OrePrefixes)OrePrefixes.wireGt01, (Object)Materials.SuperconductorLuV, (long)1L), 100000)}).fluidInputs(new FluidStack[]{Materials.Osmium.getPlasma(1000000000L)}).itemOutputs(new ItemStack[]{GTCMItemList.LuvFlask.get(1, new Object[0])}).eut(TierEU.RECIPE_MAX).duration(655360).addTo(MT);
        GTValues.RA.stdBuilder().itemInputs(new ItemStack[]{GTCMItemList.LuvFlask.get(1, new Object[0]), TstUtils.setStackSize(ItemList.Electric_Motor_ZPM.get(1L, new Object[0]), 100000), TstUtils.setStackSize(ItemList.Electric_Piston_ZPM.get(1L, new Object[0]), 100000), TstUtils.setStackSize(ItemList.Electric_Pump_ZPM.get(1L, new Object[0]), 100000), TstUtils.setStackSize(ItemList.Field_Generator_ZPM.get(1L, new Object[0]), 100000), TstUtils.setStackSize(ItemList.Conveyor_Module_ZPM.get(1L, new Object[0]), 100000), TstUtils.setStackSize(ItemList.Robot_Arm_ZPM.get(1L, new Object[0]), 100000), TstUtils.setStackSize(ItemList.Emitter_ZPM.get(1L, new Object[0]), 100000), TstUtils.setStackSize(ItemList.Sensor_ZPM.get(1L, new Object[0]), 100000), TstUtils.setStackSize(ItemList.Circuit_Bioprocessor.get(1L, new Object[0]), 100000), TstUtils.setStackSize(GTOreDictUnificator.get((OrePrefixes)OrePrefixes.wireGt01, (Object)Materials.SuperconductorZPM, (long)1L), 100000)}).fluidInputs(new FluidStack[]{Materials.Naquadah.getPlasma(1000000000L)}).itemOutputs(new ItemStack[]{GTCMItemList.ZpmFlask.get(1, new Object[0])}).eut(TierEU.RECIPE_MAX).duration(0x280000).addTo(MT);
        GTValues.RA.stdBuilder().itemInputs(new ItemStack[]{GTCMItemList.ZpmFlask.get(1, new Object[0]), TstUtils.setStackSize(ItemList.Electric_Motor_UV.get(1L, new Object[0]), 100000), TstUtils.setStackSize(ItemList.Electric_Piston_UV.get(1L, new Object[0]), 100000), TstUtils.setStackSize(ItemList.Electric_Pump_UV.get(1L, new Object[0]), 100000), TstUtils.setStackSize(ItemList.Field_Generator_UV.get(1L, new Object[0]), 100000), TstUtils.setStackSize(ItemList.Conveyor_Module_UV.get(1L, new Object[0]), 100000), TstUtils.setStackSize(ItemList.Robot_Arm_UV.get(1L, new Object[0]), 100000), TstUtils.setStackSize(ItemList.Emitter_UV.get(1L, new Object[0]), 100000), TstUtils.setStackSize(ItemList.Sensor_UV.get(1L, new Object[0]), 100000), TstUtils.setStackSize(ItemList.Circuit_OpticalProcessor.get(1L, new Object[0]), 100000), TstUtils.setStackSize(GTOreDictUnificator.get((OrePrefixes)OrePrefixes.wireGt01, (Object)Materials.SuperconductorUV, (long)1L), 100000)}).fluidInputs(new FluidStack[]{Materials.Neutronium.getPlasma(1000000000L)}).itemOutputs(new ItemStack[]{GTCMItemList.UvFlask.get(1, new Object[0])}).eut(TierEU.RECIPE_MAX).duration(0xA00000).addTo(MT);
        GTValues.RA.stdBuilder().itemInputs(new ItemStack[]{GTCMItemList.UvFlask.get(1, new Object[0]), TstUtils.setStackSize(ItemList.Electric_Motor_UHV.get(1L, new Object[0]), 100000), TstUtils.setStackSize(ItemList.Electric_Piston_UHV.get(1L, new Object[0]), 100000), TstUtils.setStackSize(ItemList.Electric_Pump_UHV.get(1L, new Object[0]), 100000), TstUtils.setStackSize(ItemList.Field_Generator_UHV.get(1L, new Object[0]), 100000), TstUtils.setStackSize(ItemList.Conveyor_Module_UHV.get(1L, new Object[0]), 100000), TstUtils.setStackSize(ItemList.Robot_Arm_UHV.get(1L, new Object[0]), 100000), TstUtils.setStackSize(ItemList.Emitter_UHV.get(1L, new Object[0]), 100000), TstUtils.setStackSize(ItemList.Sensor_UHV.get(1L, new Object[0]), 100000), TstUtils.setStackSize(ItemList.Circuit_OpticalAssembly.get(1L, new Object[0]), 100000), TstUtils.setStackSize(GTOreDictUnificator.get((OrePrefixes)OrePrefixes.wireGt01, (Object)Materials.SuperconductorUHV, (long)1L), 100000)}).fluidInputs(new FluidStack[]{Materials.Samarium.getPlasma(1000000000L)}).itemOutputs(new ItemStack[]{GTCMItemList.UhvFlask.get(1, new Object[0])}).eut(TierEU.RECIPE_MAX).duration(0x2800000).addTo(MT);
        GTValues.RA.stdBuilder().itemInputs(new ItemStack[]{GTCMItemList.UhvFlask.get(1, new Object[0]), TstUtils.setStackSize(ItemList.Electric_Motor_UEV.get(1L, new Object[0]), 100000), TstUtils.setStackSize(ItemList.Electric_Piston_UEV.get(1L, new Object[0]), 100000), TstUtils.setStackSize(ItemList.Electric_Pump_UEV.get(1L, new Object[0]), 100000), TstUtils.setStackSize(ItemList.Field_Generator_UEV.get(1L, new Object[0]), 100000), TstUtils.setStackSize(ItemList.Conveyor_Module_UEV.get(1L, new Object[0]), 100000), TstUtils.setStackSize(ItemList.Robot_Arm_UEV.get(1L, new Object[0]), 100000), TstUtils.setStackSize(ItemList.Emitter_UEV.get(1L, new Object[0]), 100000), TstUtils.setStackSize(ItemList.Sensor_UEV.get(1L, new Object[0]), 100000), TstUtils.setStackSize(ItemList.Circuit_CosmicProcessor.get(1L, new Object[0]), 100000), TstUtils.setStackSize(GTOreDictUnificator.get((OrePrefixes)OrePrefixes.wireGt01, (Object)Materials.SuperconductorUEV, (long)1L), 100000)}).fluidInputs(new FluidStack[]{Materials.Americium.getPlasma(1000000000L)}).itemOutputs(new ItemStack[]{GTCMItemList.UevFlask.get(1, new Object[0])}).eut(TierEU.RECIPE_MAX).duration(0xA000000).addTo(MT);
        GTValues.RA.stdBuilder().itemInputs(new ItemStack[]{GTCMItemList.UevFlask.get(1, new Object[0]), TstUtils.setStackSize(ItemList.Electric_Motor_UIV.get(1L, new Object[0]), 100000), TstUtils.setStackSize(ItemList.Electric_Piston_UIV.get(1L, new Object[0]), 100000), TstUtils.setStackSize(ItemList.Electric_Pump_UIV.get(1L, new Object[0]), 100000), TstUtils.setStackSize(ItemList.Field_Generator_UIV.get(1L, new Object[0]), 100000), TstUtils.setStackSize(ItemList.Conveyor_Module_UIV.get(1L, new Object[0]), 100000), TstUtils.setStackSize(ItemList.Robot_Arm_UIV.get(1L, new Object[0]), 100000), TstUtils.setStackSize(ItemList.Emitter_UIV.get(1L, new Object[0]), 100000), TstUtils.setStackSize(ItemList.Sensor_UIV.get(1L, new Object[0]), 100000), TstUtils.setStackSize(ItemList.Circuit_CosmicAssembly.get(1L, new Object[0]), 100000), TstUtils.setStackSize(GTOreDictUnificator.get((OrePrefixes)OrePrefixes.wireGt01, (Object)Materials.SuperconductorUIV, (long)1L), 100000)}).fluidInputs(new FluidStack[]{Materials.Thorium.getPlasma(1000000000L)}).itemOutputs(new ItemStack[]{GTCMItemList.UivFlask.get(1, new Object[0])}).eut(TierEU.RECIPE_MAX).duration(0x28000000).addTo(MT);
        GTValues.RA.stdBuilder().itemInputs(new ItemStack[]{GTCMItemList.UivFlask.get(1, new Object[0]), TstUtils.setStackSize(ItemList.Electric_Motor_UMV.get(1L, new Object[0]), 100000), TstUtils.setStackSize(ItemList.Electric_Piston_UMV.get(1L, new Object[0]), 100000), TstUtils.setStackSize(ItemList.Electric_Pump_UMV.get(1L, new Object[0]), 100000), TstUtils.setStackSize(ItemList.Field_Generator_UMV.get(1L, new Object[0]), 100000), TstUtils.setStackSize(ItemList.Conveyor_Module_UMV.get(1L, new Object[0]), 100000), TstUtils.setStackSize(ItemList.Robot_Arm_UMV.get(1L, new Object[0]), 100000), TstUtils.setStackSize(ItemList.Emitter_UMV.get(1L, new Object[0]), 100000), TstUtils.setStackSize(ItemList.Sensor_UMV.get(1L, new Object[0]), 100000), TstUtils.setStackSize(ItemList.Circuit_CosmicComputer.get(1L, new Object[0]), 100000), TstUtils.setStackSize(GTOreDictUnificator.get((OrePrefixes)OrePrefixes.wireGt01, (Object)Materials.SuperconductorUMV, (long)1L), 100000)}).fluidInputs(new FluidStack[]{Materials.Plutonium241.getPlasma(1000000000L)}).itemOutputs(new ItemStack[]{GTCMItemList.UmvFlask.get(1, new Object[0])}).eut(TierEU.RECIPE_MAX).duration(2000000000).addTo(MT);
        GTValues.RA.stdBuilder().itemInputs(new ItemStack[]{GTCMItemList.UmvFlask.get(1, new Object[0]), TstUtils.setStackSize(ItemList.Electric_Motor_UXV.get(1L, new Object[0]), 100000), TstUtils.setStackSize(ItemList.Electric_Piston_UXV.get(1L, new Object[0]), 100000), TstUtils.setStackSize(ItemList.Electric_Pump_UXV.get(1L, new Object[0]), 100000), TstUtils.setStackSize(ItemList.Field_Generator_UXV.get(1L, new Object[0]), 100000), TstUtils.setStackSize(ItemList.Conveyor_Module_UXV.get(1L, new Object[0]), 100000), TstUtils.setStackSize(ItemList.Robot_Arm_UXV.get(1L, new Object[0]), 100000), TstUtils.setStackSize(ItemList.Emitter_UXV.get(1L, new Object[0]), 100000), TstUtils.setStackSize(ItemList.Sensor_UXV.get(1L, new Object[0]), 100000), TstUtils.setStackSize(ItemList.Circuit_CosmicMainframe.get(1L, new Object[0]), 100000), TstUtils.setStackSize(GTOreDictUnificator.get((OrePrefixes)OrePrefixes.wireGt01, (Object)Materials.Infinity, (long)1L), 100000)}).fluidInputs(new FluidStack[]{Materials.Radon.getPlasma(1000000000L)}).itemOutputs(new ItemStack[]{GTCMItemList.UxvFlask.get(1, new Object[0])}).eut(TierEU.RECIPE_MAX).duration(2000000000).addTo(MT);
    }

    public static enum WrappedCircuitItem {
        Wrapped_Circuit_ULV,
        Wrapped_Circuit_LV,
        Wrapped_Circuit_MV,
        Wrapped_Circuit_HV,
        Wrapped_Circuit_EV,
        Wrapped_Circuit_IV,
        Wrapped_Circuit_LuV,
        Wrapped_Circuit_ZPM,
        Wrapped_Circuit_UV,
        Wrapped_Circuit_UHV,
        Wrapped_Circuit_UEV,
        Wrapped_Circuit_UIV,
        Wrapped_Circuit_UMV,
        Wrapped_Circuit_UXV,
        Wrapped_Circuit_MAX,
        Wrapped_Circuit_Parts_Crystal_Chip_Elite,
        Wrapped_Circuit_Parts_Crystal_Chip_Master,
        Wrapped_Circuit_Board_Coated,
        Wrapped_Circuit_Board_Coated_Basic,
        Wrapped_Circuit_Board_Phenolic,
        Wrapped_Circuit_Board_Phenolic_Good,
        Wrapped_Circuit_Board_Epoxy,
        Wrapped_Circuit_Board_Epoxy_Advanced,
        Wrapped_Circuit_Board_Fiberglass,
        Wrapped_Circuit_Board_Fiberglass_Advanced,
        Wrapped_Circuit_Board_Multifiberglass_Elite,
        Wrapped_Circuit_Board_Multifiberglass,
        Wrapped_Circuit_Board_Wetware,
        Wrapped_Circuit_Board_Wetware_Extreme,
        Wrapped_Circuit_Board_Plastic,
        Wrapped_Circuit_Board_Plastic_Advanced,
        Wrapped_Circuit_Board_Bio,
        Wrapped_Circuit_Board_Bio_Ultra,
        Wrapped_Circuit_Parts_ResistorSMD,
        Wrapped_Circuit_Parts_InductorSMD,
        Wrapped_Circuit_Parts_DiodeSMD,
        Wrapped_Circuit_Parts_TransistorSMD,
        Wrapped_Circuit_Parts_CapacitorSMD,
        Wrapped_Circuit_Parts_ResistorASMD,
        Wrapped_Circuit_Parts_DiodeASMD,
        Wrapped_Circuit_Parts_TransistorASMD,
        Wrapped_Circuit_Parts_CapacitorASMD,
        Wrapped_Circuit_Chip_ILC,
        Wrapped_Circuit_Chip_Ram,
        Wrapped_Circuit_Chip_NAND,
        Wrapped_Circuit_Chip_NOR,
        Wrapped_Circuit_Chip_CPU,
        Wrapped_Circuit_Chip_SoC,
        Wrapped_Circuit_Chip_SoC2,
        Wrapped_Circuit_Chip_PIC,
        Wrapped_Circuit_Chip_Simple_SoC,
        Wrapped_Circuit_Chip_HPIC,
        Wrapped_Circuit_Chip_UHPIC,
        Wrapped_Circuit_Chip_ULPIC,
        Wrapped_Circuit_Chip_LPIC,
        Wrapped_Circuit_Chip_NPIC,
        Wrapped_Circuit_Chip_PPIC,
        Wrapped_Circuit_Chip_QPIC,
        Wrapped_Circuit_Chip_NanoCPU,
        Wrapped_Circuit_Chip_QuantumCPU,
        Wrapped_Circuit_Chip_CrystalCPU,
        Wrapped_Circuit_Chip_CrystalSoC,
        Wrapped_Circuit_Chip_CrystalSoC2,
        Wrapped_Circuit_Chip_NeuroCPU,
        Wrapped_Circuit_Chip_BioCPU,
        Wrapped_Circuit_Chip_Stemcell,
        Wrapped_Circuit_Chip_Biocell,
        Wrapped_Circuit_Parts_ResistorXSMD,
        Wrapped_Circuit_Parts_DiodeXSMD,
        Wrapped_Circuit_Parts_TransistorXSMD,
        Wrapped_Circuit_Parts_CapacitorXSMD,
        Wrapped_Circuit_Parts_InductorASMD,
        Wrapped_Circuit_Parts_InductorXSMD,
        Wrapped_Circuit_Chip_Optical,
        Wrapped_Circuit_Board_Optical,
        Wrapped_Optically_Perfected_CPU,
        Wrapped_Optical_Cpu_Containment_Housing,
        Wrapped_Optically_Compatible_Memory,
        Wrapped_Circuit_Parts_Crystal_Chip_Wetware,
        Wrapped_Circuit_Parts_Chip_Bioware;

        private ItemStack itemStack;

        public ItemStack get(int amount) {
            return GTUtility.copyAmount((int)amount, (ItemStack)this.itemStack);
        }

        public void set(ItemStack itemStack) {
            this.itemStack = itemStack;
        }
    }
}

