/*
 * Decompiled with CFR 0.152.
 */
package com.Nxer.TwistSpaceTechnology.recipe.machineRecipe.expanded;

import com.Nxer.TwistSpaceTechnology.common.recipeMap.GTCMRecipe;
import com.Nxer.TwistSpaceTechnology.util.RecipeMathUtils;
import com.Nxer.TwistSpaceTechnology.util.TstUtils;
import com.Nxer.TwistSpaceTechnology.util.recipes.TST_RecipeBuilder;
import goodgenerator.api.recipe.GoodGeneratorRecipeMaps;
import gregtech.api.enums.Materials;
import gregtech.api.util.GTRecipe;
import gtnhlanth.common.register.WerkstoffMaterialPool;
import net.minecraftforge.fluids.FluidStack;

public class RapidHeatExchangeRecipePool {
    public static void loadRecipes() {
        FluidStack DenseSupercriticalSteam = Materials.DenseSupercriticalSteam.getGas(1L);
        for (GTRecipe aRecipe : GoodGeneratorRecipeMaps.extremeHeatExchangerFuels.getAllRecipes()) {
            if (aRecipe == null || aRecipe.mFluidInputs[0] == null || aRecipe.mFluidInputs[1] == null || aRecipe.mFluidOutputs[1] == null || aRecipe.mFluidOutputs[2] == null) continue;
            FluidStack HotFluid = aRecipe.mFluidInputs[0].copy();
            FluidStack ColdFluid = aRecipe.mFluidOutputs[2].copy();
            FluidStack Water = aRecipe.mFluidInputs[1].copy();
            FluidStack Steam = aRecipe.mFluidOutputs[1].copy();
            boolean isDense = Steam.isFluidEqual(DenseSupercriticalSteam);
            int hotFluidAmount = HotFluid.amount;
            int waterAmount = Water.amount;
            double scaledDW = (double)waterAmount / (double)hotFluidAmount;
            if (isDense) {
                Water.amount = RecipeMathUtils.roundUpToMultiple(25, (int)scaledDW);
                Steam.amount = Water.amount * 4 / 25;
            } else {
                double decimalNum = scaledDW - Math.floor(scaledDW);
                if (decimalNum == 0.0) {
                    decimalNum = 1.0;
                }
                int Multiplier = (int)(1.0 / decimalNum);
                Water.amount = Water.amount * Multiplier / HotFluid.amount;
                Steam.amount = Water.amount * 160;
                if (Steam.amount / 4000 > 0) {
                    Steam = Materials.DenseSupercriticalSteam.getGas((long)(RecipeMathUtils.roundUpToMultiple(4000, Steam.amount) / 1000));
                }
            }
            HotFluid.amount = 1;
            ColdFluid.amount = 1;
            TST_RecipeBuilder.builder().fluidInputs(HotFluid, Water).fluidOutputs(Steam, ColdFluid).duration(20).addTo(GTCMRecipe.RapidHeatExchangeRecipes);
            TST_RecipeBuilder.builder().fluidInputs(HotFluid).fluidOutputs(ColdFluid).duration(20).addTo(GTCMRecipe.RapidCoolingDownRecipes);
        }
        TST_RecipeBuilder.builder().fluidInputs(WerkstoffMaterialPool.HotSuperCoolant.getFluidOrGas(1), Materials.Water.getFluid(25L)).fluidOutputs(TstUtils.copyAmount(DenseSupercriticalSteam, 4), Materials.SuperCoolant.getFluid(1L)).duration(20).addTo(GTCMRecipe.RapidHeatExchangeRecipes);
        TST_RecipeBuilder.builder().fluidInputs(WerkstoffMaterialPool.HotSuperCoolant.getFluidOrGas(1)).fluidOutputs(Materials.SuperCoolant.getFluid(1L)).duration(20).addTo(GTCMRecipe.RapidCoolingDownRecipes);
    }
}

