/*
 * Decompiled with CFR 0.152.
 */
package com.Nxer.TwistSpaceTechnology.recipe.machineRecipe.expanded;

import bartworks.system.material.WerkstoffLoader;
import com.Nxer.TwistSpaceTechnology.common.material.MaterialPool;
import com.Nxer.TwistSpaceTechnology.config.Config;
import cpw.mods.fml.common.Loader;
import galaxyspace.SolarSystem.SolarSystemPlanets;
import gregtech.api.enums.Materials;
import java.util.HashMap;
import java.util.Map;
import net.minecraftforge.fluids.FluidStack;

public class StellarMaterialSiphonRecipePool {
    public static final Map<String, Map<Integer, FluidStack>> RECIPES = new HashMap<String, Map<Integer, FluidStack>>();

    public static void addPumpingRecipes() {
        HashMap<Integer, FluidStack> jupiterRecipes = new HashMap<Integer, FluidStack>();
        jupiterRecipes.put(1, Materials.Hydrogen.getGas(15000L));
        jupiterRecipes.put(2, Materials.Helium.getGas(500L));
        jupiterRecipes.put(3, Materials.Nitrogen.getGas(300L));
        jupiterRecipes.put(4, Materials.Oxygen.getGas(200L));
        HashMap<Integer, FluidStack> saturnRecipes = new HashMap<Integer, FluidStack>();
        saturnRecipes.put(1, Materials.Hydrogen.getGas(18000L));
        saturnRecipes.put(2, Materials.Helium.getGas(800L));
        saturnRecipes.put(3, Materials.Oxygen.getGas(500L));
        saturnRecipes.put(4, Materials.LiquidOxygen.getGas(150L));
        HashMap<Integer, FluidStack> uranusRecipes = new HashMap<Integer, FluidStack>();
        uranusRecipes.put(1, Materials.Deuterium.getGas(5000L));
        uranusRecipes.put(3, Materials.Argon.getGas(250L));
        HashMap<Integer, FluidStack> neptuneRecipes = new HashMap<Integer, FluidStack>();
        neptuneRecipes.put(1, Materials.Tritium.getGas(3000L));
        neptuneRecipes.put(2, Materials.Helium_3.getGas(500L));
        neptuneRecipes.put(3, Materials.Ammonia.getGas(400L));
        if (Loader.isModLoaded((String)"bartworks")) {
            uranusRecipes.put(2, WerkstoffLoader.Neon.getFluidOrGas(450));
            uranusRecipes.put(4, WerkstoffLoader.Krypton.getFluidOrGas(100));
            neptuneRecipes.put(4, WerkstoffLoader.Xenon.getFluidOrGas(350));
        }
        HashMap<Integer, FluidStack> blackHoleRecipes = new HashMap<Integer, FluidStack>();
        blackHoleRecipes.put(1, MaterialPool.eventHorizonDiffusers.getMolten(144));
        blackHoleRecipes.put(1, MaterialPool.entropyReductionProcess.getMolten(144));
        RECIPES.put(SolarSystemPlanets.planetJupiter.getUnlocalizedName(), jupiterRecipes);
        RECIPES.put(SolarSystemPlanets.planetSaturn.getUnlocalizedName(), saturnRecipes);
        RECIPES.put(SolarSystemPlanets.planetUranus.getUnlocalizedName(), uranusRecipes);
        RECIPES.put(SolarSystemPlanets.planetNeptune.getUnlocalizedName(), neptuneRecipes);
        RECIPES.put("blackHole", blackHoleRecipes);
    }

    public static void loadRecipes() {
        if (Config.activateMegaSpaceStation) {
            StellarMaterialSiphonRecipePool.addPumpingRecipes();
        }
    }
}

