/*
 * Decompiled with CFR 0.152.
 */
package com.Nxer.TwistSpaceTechnology.system.Disassembler;

import bartworks.API.BorosilicateGlass;
import com.Nxer.TwistSpaceTechnology.common.machine.multiMachineClasses.GTCM_MultiMachineBase;
import com.Nxer.TwistSpaceTechnology.common.recipeMap.GTCMRecipe;
import com.Nxer.TwistSpaceTechnology.config.Config;
import com.Nxer.TwistSpaceTechnology.system.Disassembler.TST_DisassemblerRecipeHandler;
import com.Nxer.TwistSpaceTechnology.system.Disassembler.TST_SimpleDisassemblyRecipe;
import com.Nxer.TwistSpaceTechnology.util.TextEnums;
import com.Nxer.TwistSpaceTechnology.util.TextLocalization;
import com.Nxer.TwistSpaceTechnology.util.rewrites.TST_ItemID;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import goodgenerator.api.recipe.GoodGeneratorRecipeMaps;
import goodgenerator.loader.Loaders;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.HatchElement;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IHatchElement;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.CheckRecipeResultRegistry;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTRecipe;
import gregtech.api.util.GTStructureUtility;
import gregtech.api.util.GTUtility;
import gregtech.api.util.HatchElementBuilder;
import gregtech.api.util.MultiblockTooltipBuilder;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import tectech.thing.casing.TTCasingsContainer;

public class TST_Disassembler
extends GTCM_MultiMachineBase<TST_Disassembler> {
    private static final int horizontalOffSet = 13;
    private static final int verticalOffSet = 21;
    private static final int depthOffSet = 0;
    private static final String STRUCTURE_PIECE_MAIN = "mainTSTDisassembler";
    private static IStructureDefinition<TST_Disassembler> STRUCTURE_DEFINITION = null;
    public int tierComponentCasing = -2;
    private static Set<GTRecipe> allRecipes = null;
    private static MultiblockTooltipBuilder tooltip;

    public TST_Disassembler(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public TST_Disassembler(String aName) {
        super(aName);
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new TST_Disassembler(this.mName);
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece(STRUCTURE_PIECE_MAIN, stackSize, hintsOnly, 13, 21, 0);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        return this.survivialBuildPiece(STRUCTURE_PIECE_MAIN, stackSize, 13, 21, 0, elementBudget, env, false, true);
    }

    public IStructureDefinition<TST_Disassembler> getStructureDefinition() {
        if (STRUCTURE_DEFINITION == null) {
            STRUCTURE_DEFINITION = StructureDefinition.builder().addShape(STRUCTURE_PIECE_MAIN, StructureUtility.transpose((String[][])new String[][]{{"                           ", "                           ", "                           ", "                           ", "                           ", "                           ", "                           ", "                           ", "                           ", "                           ", "                           ", "                           ", "                           ", "           D   D           ", "           D   D           ", "           D   D           ", "                           ", "                           ", "                           ", "                           ", "                           ", "                           ", "                           ", "                           ", "                           ", "                           ", "                           ", "                           "}, {"                           ", "                           ", "                           ", "                           ", "                           ", "                           ", "                           ", "                           ", "                           ", "                           ", "                           ", "                           ", "                           ", "                           ", "                           ", "                           ", "           D   D           ", "           D   D           ", "                           ", "                           ", "                           ", "                           ", "                           ", "                           ", "                           ", "                           ", "                           ", "                           "}, {"                           ", "                           ", "                           ", "                           ", "                           ", "                           ", "                           ", "                           ", "                           ", "                           ", "                           ", "                           ", "                           ", "                           ", "                           ", "                           ", "                           ", "                           ", "           D   D           ", "           D G D           ", "            GGG            ", "             G             ", "                           ", "                           ", "                           ", "                           ", "                           ", "                           "}, {"                           ", "                           ", "                           ", "                           ", "                           ", "                           ", "                           ", "                           ", "                           ", "                           ", "                           ", "                           ", "                           ", "            EEE            ", "                           ", "                           ", "                           ", "                           ", "                           ", "            GGG            ", "           DGGGD           ", "            GGG            ", "             G             ", "                           ", "                           ", "                           ", "                           ", "                           "}, {"                           ", "                           ", "                           ", "                           ", "                           ", "                           ", "                           ", "                           ", "                           ", "                           ", "                           ", "                           ", "            FFF            ", "          EEBBBEE          ", "            FFF            ", "                           ", "                           ", "                           ", "                           ", "                           ", "            GGG            ", "           DGGGD           ", "            GGG            ", "             G             ", "                           ", "                           ", "                           ", "                           "}, {"                           ", "                           ", "                           ", "                           ", "                           ", "                           ", "                           ", "                           ", "                           ", "                           ", "                           ", "                           ", "          FF   FF          ", "         EBBABABBE         ", "          FF   FF          ", "                           ", "                           ", "                           ", "                           ", "                           ", "                           ", "           D G D           ", "            GGG            ", "            GGG            ", "             G             ", "                           ", "                           ", "                           "}, {"                           ", "                           ", "                           ", "                           ", "                           ", "                           ", "                           ", "                           ", "                           ", "                           ", "                           ", "                           ", "         F                 ", "        EBAA B AA          ", "         F                 ", "                           ", "                           ", "                           ", "                           ", "                           ", "                           ", "                           ", "           D G D           ", "            GGG            ", "            GGG            ", "             G             ", "                           ", "                           "}, {"                           ", "                           ", "                           ", "                           ", "                           ", "                           ", "                           ", "                           ", "                           ", "                           ", "                           ", "                           ", "        F                  ", "       EBA   B             ", "        F                  ", "                           ", "                           ", "                           ", "                           ", "                           ", "                           ", "                           ", "           D   D           ", "             G             ", "            GGG            ", "            GGG            ", "             G             ", "                           "}, {"                           ", "                           ", "                           ", "                           ", "                           ", "                           ", "                           ", "                           ", "                           ", "                           ", "                           ", "                           ", "        F                  ", "       EBA                 ", "        F                  ", "                           ", "                           ", "                           ", "                           ", "                           ", "                           ", "                           ", "                           ", "           D   D           ", "             G             ", "            GGG            ", "            GGG            ", "             G             "}, {"                           ", "                           ", "                           ", "                           ", "                           ", "                           ", "                           ", "            FFF            ", "          FF   FF          ", "                 F         ", "                  F        ", "                  F        ", "       F           F       ", "     GEBA          FEG     ", "       F           F       ", "                  F        ", "                  F        ", "                 F         ", "          FF   FF          ", "            FFF            ", "                           ", "                           ", "                           ", "           D   D           ", "                           ", "             G             ", "            GGG            ", "             G             "}, {"                           ", "                           ", "                           ", "           D   D           ", "                           ", "                           ", "            EEE            ", "          EEBBBEE          ", "         EBBABABBE         ", "          AA B AABE        ", "             B   ABE       ", "                 ABE       ", "     GEF          ABEG     ", "     GBBBBB  H  BBBBBG     ", "     GEF          ABEG     ", "                 ABE       ", "             B   ABE       ", "          AA B AABE        ", "         EBBABABBE         ", "          EEBBBEE          ", "            EEE            ", "                           ", "                           ", "           D   D           ", "                           ", "             G             ", "            GGG            ", "             G             "}, {"                           ", "                           ", "                           ", "           D   D           ", "                           ", "                           ", "                           ", "            FFF            ", "          FF   FF          ", "                 F         ", "                  F        ", "                  F        ", "       F           F       ", "     GEBA          FEG     ", "       F           F       ", "                  F        ", "                  F        ", "                 F         ", "          FF   FF          ", "            FFF            ", "                           ", "                           ", "                           ", "                           ", "                           ", "             G             ", "            GGG            ", "             G             "}, {"                           ", "                           ", "                           ", "           D   D           ", "                           ", "                           ", "                           ", "                           ", "                           ", "                           ", "                           ", "                           ", "     J  F            J     ", "     G EBA           G     ", "     J  F            J     ", "                           ", "                           ", "                           ", "                           ", "                           ", "                           ", "                           ", "                           ", "                           ", "                           ", "             G             ", "            GGG            ", "             G             "}, {"                           ", "                           ", "                           ", "                           ", "           D   D           ", "                           ", "                           ", "                           ", "                           ", "                           ", "                           ", "     J               J     ", "     G  F            G     ", "     G EBA   B       G     ", "     G  F            G     ", "     J               J     ", "                           ", "                           ", "                           ", "                           ", "                           ", "                           ", "                           ", "                           ", "                           ", "             G             ", "            GGG            ", "             G             "}, {"                           ", "                           ", "                           ", "                           ", "           D   D           ", "                           ", "                           ", "                           ", "                           ", "                           ", "     J               J     ", "     G               G     ", "         F                 ", "     G  EBAA B AA    G     ", "         F                 ", "     G               G     ", "     J               J     ", "                           ", "                           ", "                           ", "                           ", "                           ", "                           ", "                           ", "                           ", "             G             ", "            GGG            ", "             G             "}, {"                           ", "                           ", "                           ", "                           ", "                           ", "           D   D           ", "                           ", "                           ", "                           ", "     J               J     ", "     G               G     ", "                           ", "          FF   FF          ", "     G   EBBABABBE   G     ", "          FF   FF          ", "                           ", "     G               G     ", "     J               J     ", "                           ", "                           ", "                           ", "                           ", "                           ", "                           ", "                           ", "             G             ", "            GGG            ", "             G             "}, {"                           ", "                           ", "                           ", "                           ", "                           ", "           D   D           ", "                           ", "             H             ", "     J               J     ", "     G               G     ", "                           ", "                           ", "            FFF            ", "     G    EEBBBEE    G     ", "            FFF            ", "                           ", "                           ", "     G               G     ", "     J               J     ", "                           ", "                           ", "                           ", "                           ", "                           ", "                           ", "             G             ", "            GGG            ", "             G             "}, {"                           ", "                           ", "                           ", "                           ", "                           ", "                           ", "           DGHGD           ", "     J      GGG      J     ", "     G               G     ", "                           ", "                           ", "                           ", "                           ", "     G      EEE      G     ", "                           ", "                           ", "                           ", "                           ", "     G               G     ", "     J               J     ", "                           ", "                           ", "                           ", "                           ", "                           ", "            JGJ            ", "            GGG            ", "             G             "}, {"                           ", "                           ", "                           ", "                           ", "                           ", "            GHG            ", "     J      JGJ      J     ", "     G     D   D     G     ", "           D   D           ", "                           ", "                           ", "                           ", "                           ", "    JG               GJ    ", "                           ", "                           ", "                           ", "                           ", "                           ", "     G               G     ", "     J               J     ", "                           ", "                           ", "                           ", "            J J            ", "             G             ", "            GGG            ", "             G             "}, {"                           ", "                           ", "                           ", "                           ", "            GCG            ", "     J       G       J     ", "     G      J J      G     ", "                           ", "                           ", "           D   D           ", "           D   D           ", "                           ", "                           ", "   JGGJ             JGGJ   ", "                           ", "                           ", "                           ", "                           ", "                           ", "                           ", "     G               G     ", "     J               J     ", "                           ", "            J J            ", "                           ", "             G             ", "            GGG            ", "             G             "}, {"            III            ", "            GCG            ", "            GCG            ", "            GCG            ", "     J      JGJ      J     ", "     G               G     ", "            J J            ", "                           ", "                           ", "                           ", "                           ", "           D   D           ", "           D   D           ", "  JG GGJ   D   D   JGG GJ  ", "                           ", "                           ", "                           ", "                           ", "                           ", "                           ", "                           ", "     G               G     ", "     J      J J      J     ", "                           ", "             G             ", "             G             ", "            GGG            ", "             G             "}, {"            I~I            ", "             G             ", "            JGJ            ", "     J       G       J     ", "     G      J J      G     ", "                           ", "            J J            ", "                           ", "                           ", "                           ", "                           ", "                           ", "                           ", " JG  G GJ         JG G  GJ ", "                           ", "                           ", "                           ", "                           ", "                           ", "                           ", "                           ", "            J J            ", "     G               G     ", "     J       G       J     ", "             G             ", "             G             ", "            GGG            ", "             G             "}, {"            III            ", "             G             ", "     G      J J      G     ", "     G               G     ", "     G      J J      G     ", "     G               G     ", "     G      J J      G     ", "     G               G     ", "     G               G     ", "     G               G     ", "     G               G     ", "     G               G     ", "     G               G     ", "GGGGGGGGGGGGGGGGGGGGGGGGGGG", "     G               G     ", "     G               G     ", "     G               G     ", "     G               G     ", "     G               G     ", "     G               G     ", "     G      GGG      G     ", "     G      GGG      G     ", "     G      GGG      G     ", "     G      GGG      G     ", "     G      GGG      G     ", "            GGG            ", "            GGG            ", "            GGG            "}})).addElement('A', BorosilicateGlass.ofBoroGlassAnyTier()).addElement('B', StructureUtility.withChannel((String)"component", (IStructureElement)StructureUtility.ofBlocksTiered((block, meta) -> block == Loaders.componentAssemblylineCasing ? meta : -1, IntStream.range(0, 14).mapToObj(i -> Pair.of((Object)Loaders.componentAssemblylineCasing, (Object)i)).collect(Collectors.toList()), (Object)-2, (t, meta) -> {
                t.tierComponentCasing = meta;
            }, t -> t.tierComponentCasing))).addElement('C', StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings2, (int)5)).addElement('D', StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings2, (int)8)).addElement('E', StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings2, (int)9)).addElement('F', StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings9, (int)1)).addElement('G', StructureUtility.ofBlock((Block)TTCasingsContainer.sBlockCasingsTT, (int)4)).addElement('H', StructureUtility.ofBlock((Block)TTCasingsContainer.sBlockCasingsTT, (int)8)).addElement('I', (IStructureElement)HatchElementBuilder.builder().atLeast(new IHatchElement[]{HatchElement.InputBus, HatchElement.OutputBus, HatchElement.OutputHatch}).adder(GTCM_MultiMachineBase::addToMachineList).dot(1).casingIndex(1028).buildAndChain(TTCasingsContainer.sBlockCasingsTT, 4)).addElement('J', GTStructureUtility.ofFrame((Materials)Materials.CosmicNeutronium)).build();
        }
        return STRUCTURE_DEFINITION;
    }

    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.repairMachine();
        this.tierComponentCasing = -2;
        return this.checkPiece(STRUCTURE_PIECE_MAIN, 13, 21, 0);
    }

    public Set<GTRecipe> getAllRecipes() {
        if (allRecipes == null) {
            allRecipes = new HashSet<GTRecipe>();
            allRecipes.addAll(GoodGeneratorRecipeMaps.componentAssemblyLineRecipes.getAllRecipes());
            allRecipes.addAll(GTCMRecipe.MiracleTopRecipes.getAllRecipes());
            allRecipes.addAll(RecipeMaps.assemblylineVisualRecipes.getAllRecipes());
            allRecipes.addAll(RecipeMaps.assemblerRecipes.getAllRecipes());
            allRecipes.addAll(GTCMRecipe.PreciseHighEnergyPhotonicQuantumMasterRecipes.getAllRecipes());
        }
        return allRecipes;
    }

    private byte getRealTierComponentCasing() {
        return (byte)(this.tierComponentCasing + 1);
    }

    @Override
    public String[] getInfoData() {
        String[] origin = super.getInfoData();
        String[] ret = new String[origin.length + 1];
        System.arraycopy(origin, 0, ret, 0, origin.length);
        ret[origin.length] = EnumChatFormatting.AQUA + TextEnums.tr("MachineInfoData.ComponentBlockTier") + ": " + EnumChatFormatting.GOLD + this.getRealTierComponentCasing();
        return ret;
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74768_a("tierComponentCasing", this.tierComponentCasing);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.tierComponentCasing = aNBT.func_74762_e("tierComponentCasing");
    }

    @Override
    @NotNull
    public CheckRecipeResult checkProcessing() {
        ArrayList<ItemStack> inputItems = this.getStoredInputsNoSeparation();
        if (inputItems.isEmpty()) {
            return CheckRecipeResultRegistry.NO_RECIPE;
        }
        byte tier = this.getRealTierComponentCasing();
        ArrayList<ItemStack> outputItems = new ArrayList<ItemStack>();
        ArrayList<FluidStack> outputFluids = new ArrayList<FluidStack>();
        long processed = 0L;
        for (ItemStack items : inputItems) {
            byte recipeTier;
            TST_SimpleDisassemblyRecipe disassemblyRecipe;
            if (items.field_77994_a <= 0 || (disassemblyRecipe = TST_DisassemblerRecipeHandler.DisassemblerRecipeMap.get((Object)TST_ItemID.createNoNBT(items))) == null) continue;
            if (tier < 14 && (recipeTier = disassemblyRecipe.getTier()) > tier + 1) {
                if (processed != 0L) continue;
                return CheckRecipeResultRegistry.insufficientMachineTier((int)(recipeTier - 1));
            }
            int recipeNeed = disassemblyRecipe.getItemAmount();
            if (items.field_77994_a < recipeNeed) continue;
            int outputMultiplier = items.field_77994_a / recipeNeed;
            items.field_77994_a -= outputMultiplier * recipeNeed;
            processed += (long)outputMultiplier;
            if (disassemblyRecipe.hasOutputItems()) {
                outputItems.addAll(disassemblyRecipe.getOutputItems(outputMultiplier));
            }
            if (!disassemblyRecipe.hasOutputFluids()) continue;
            outputFluids.addAll(disassemblyRecipe.getOutputFluids(outputMultiplier));
        }
        if (processed == 0L) {
            return CheckRecipeResultRegistry.NO_RECIPE;
        }
        long tempProgressTime = Math.max(1L, processed / (4L * (long)tier)) * (long)Config.CostTicksPerItemDisassembling_Disassembler;
        int n = this.mMaxProgresstime = tempProgressTime > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)tempProgressTime;
        if (!outputItems.isEmpty()) {
            this.mOutputItems = outputItems.toArray(new ItemStack[0]);
        }
        if (!outputFluids.isEmpty()) {
            this.mOutputFluids = outputFluids.toArray(new FluidStack[0]);
        }
        this.updateSlots();
        return CheckRecipeResultRegistry.SUCCESSFUL;
    }

    public void onFirstTick(IGregTechTileEntity aBaseMetaTileEntity) {
        super.onFirstTick(aBaseMetaTileEntity);
        TST_DisassemblerRecipeHandler.initDisassemblerRecipes();
    }

    @NotNull
    public CheckRecipeResult checkProcessingOld() {
        ArrayList inputItems = this.getStoredInputs();
        if (inputItems.isEmpty()) {
            return CheckRecipeResultRegistry.NO_RECIPE;
        }
        byte tier = this.getRealTierComponentCasing();
        ArrayList<ItemStack> outputItems = new ArrayList<ItemStack>();
        ArrayList<FluidStack> outputFluids = new ArrayList<FluidStack>();
        long processed = 0L;
        block0: for (ItemStack items : inputItems) {
            if (items.field_77994_a <= 0) continue;
            for (GTRecipe recipe : this.getAllRecipes()) {
                long amount;
                byte recipeTier;
                if (items.field_77994_a <= 0) continue block0;
                if (recipe.mInputs == null || recipe.mOutputs.length > 1 || recipe.mFluidOutputs != null && recipe.mFluidOutputs.length > 0 || !GTUtility.areStacksEqual((ItemStack)items, (ItemStack)recipe.mOutputs[0])) continue;
                if (items.field_77994_a < recipe.mOutputs[0].field_77994_a) continue block0;
                if (tier < 14 && (recipeTier = GTUtility.getTier((long)recipe.mEUt)) > tier + 1) {
                    if (processed != 0L) continue block0;
                    return CheckRecipeResultRegistry.insufficientMachineTier((int)(recipeTier - 1));
                }
                int outputMultiplier = items.field_77994_a / recipe.mOutputs[0].field_77994_a;
                items.field_77994_a -= outputMultiplier * recipe.mOutputs[0].field_77994_a;
                processed += (long)outputMultiplier;
                if (recipe.mInputs != null) {
                    for (ItemStack itemStack : recipe.mInputs) {
                        if (itemStack.field_77994_a <= 0) continue;
                        amount = (long)itemStack.field_77994_a * (long)outputMultiplier;
                        if (amount <= Integer.MAX_VALUE) {
                            outputItems.add(GTUtility.copyAmountUnsafe((int)((int)amount), (ItemStack)itemStack));
                            continue;
                        }
                        while (amount > 0L) {
                            if (amount > Integer.MAX_VALUE) {
                                outputItems.add(GTUtility.copyAmountUnsafe((int)Integer.MAX_VALUE, (ItemStack)itemStack));
                                amount -= Integer.MAX_VALUE;
                                continue;
                            }
                            outputItems.add(GTUtility.copyAmountUnsafe((int)((int)amount), (ItemStack)itemStack));
                            amount = 0L;
                        }
                    }
                }
                if (recipe.mFluidInputs == null) continue;
                for (ItemStack itemStack : recipe.mFluidInputs) {
                    if (itemStack.amount <= 0) continue;
                    amount = (long)itemStack.amount * (long)outputMultiplier;
                    if (amount <= Integer.MAX_VALUE) {
                        outputFluids.add(GTUtility.copyAmount((int)((int)amount), (FluidStack)itemStack));
                        continue;
                    }
                    while (amount > 0L) {
                        if (amount > Integer.MAX_VALUE) {
                            outputFluids.add(GTUtility.copyAmount((int)Integer.MAX_VALUE, (FluidStack)itemStack));
                            amount -= Integer.MAX_VALUE;
                            continue;
                        }
                        outputFluids.add(GTUtility.copyAmount((int)((int)amount), (FluidStack)itemStack));
                        amount = 0L;
                    }
                }
            }
        }
        if (processed == 0L) {
            return CheckRecipeResultRegistry.NO_RECIPE;
        }
        long tempProgressTime = Math.max(1L, processed / (4L * (long)tier)) * (long)Config.CostTicksPerItemDisassembling_Disassembler;
        int n = this.mMaxProgresstime = tempProgressTime > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)tempProgressTime;
        if (!outputItems.isEmpty()) {
            this.mOutputItems = outputItems.toArray(new ItemStack[0]);
        }
        if (!outputFluids.isEmpty()) {
            this.mOutputFluids = outputFluids.toArray(new FluidStack[0]);
        }
        this.updateSlots();
        return CheckRecipeResultRegistry.SUCCESSFUL;
    }

    @Override
    protected boolean isEnablePerfectOverclock() {
        return false;
    }

    @Override
    protected float getSpeedBonus() {
        return 1.0f;
    }

    @Override
    public int getMaxParallelRecipes() {
        return 1;
    }

    @Override
    public boolean supportsInputSeparation() {
        return false;
    }

    @Override
    public boolean supportsSingleRecipeLocking() {
        return false;
    }

    @Override
    public boolean supportsBatchMode() {
        return false;
    }

    @Override
    public boolean supportsVoidProtection() {
        return false;
    }

    protected MultiblockTooltipBuilder createTooltip() {
        if (tooltip == null) {
            tooltip = new MultiblockTooltipBuilder();
            tooltip.addMachineType(TextEnums.tr("Tooltip_TSTDisassembler_MachineType")).addInfo(TextEnums.tr("Tooltip_TSTDisassembler_Controller")).addInfo(TextEnums.tr("Tooltip_TSTDisassembler_01")).addInfo(TextEnums.tr("Tooltip_TSTDisassembler_02")).addInfo(TextEnums.tr("Tooltip_TSTDisassembler_03")).addInfo(TextEnums.tr("Tooltip_TSTDisassembler_04")).addSeparator().addInfo(TextLocalization.StructureTooComplex).addInfo(TextLocalization.BLUE_PRINT_INFO).addStructureInfo(TextLocalization.Tooltip_Details).addStructureInfo(TextEnums.tr("Tooltip_TSTDisassembler_2_01")).addStructureInfo(TextEnums.tr("Tooltip_TSTDisassembler_2_02")).addStructureInfo(TextEnums.tr("Tooltip_TSTDisassembler_2_03")).addStructureInfo(TextEnums.tr("Tooltip_TSTDisassembler_2_04")).addStructureInfo(TextEnums.tr("Tooltip_TSTDisassembler_2_05")).addStructureInfo(TextEnums.tr("Tooltip_TSTDisassembler_2_06")).addStructureInfo(TextEnums.tr("Tooltip_TSTDisassembler_2_07")).beginStructureBlock(27, 23, 28, false).addInputBus(TextLocalization.textUseBlueprint, new int[]{1}).addOutputBus(TextLocalization.textUseBlueprint, new int[]{1}).addOutputHatch(TextLocalization.textUseBlueprint, new int[]{1}).toolTipFinisher(new String[]{"Twist Space Technology"});
        }
        return tooltip;
    }

    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection aFacing, int colorIndex, boolean aActive, boolean redstoneLevel) {
        if (side == aFacing) {
            if (aActive) {
                return new ITexture[]{Textures.BlockIcons.casingTexturePages[0][12], TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_DTPF_ON).extFacing().build(), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_FUSION1_GLOW).extFacing().glow().build()};
            }
            return new ITexture[]{Textures.BlockIcons.casingTexturePages[0][12], TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_DTPF_OFF).extFacing().build()};
        }
        return new ITexture[]{Textures.BlockIcons.casingTexturePages[0][12]};
    }
}

