/*
 * Decompiled with CFR 0.152.
 */
package com.Nxer.TwistSpaceTechnology.system.Disassembler;

import com.Nxer.TwistSpaceTechnology.util.rewrites.TST_ItemID;
import gregtech.api.util.GTUtility;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class TST_SimpleDisassemblyRecipe {
    private TST_ItemID itemToDisassemble = null;
    private int itemAmount = 0;
    private ItemStack[] outputItems = new ItemStack[0];
    private FluidStack[] outputFluids = new FluidStack[0];
    private long eut = 0L;
    private byte tier = 0;

    public boolean hasOutputItems() {
        return this.outputItems.length > 0;
    }

    public boolean hasOutputFluids() {
        return this.outputFluids.length > 0;
    }

    public List<ItemStack> getOutputItems(int multiplier) {
        if (this.outputItems.length < 1) {
            return Collections.emptyList();
        }
        ArrayList<ItemStack> outputs = new ArrayList<ItemStack>();
        for (ItemStack itemStack : this.outputItems) {
            long amount = (long)multiplier * (long)itemStack.field_77994_a;
            if (amount > Integer.MAX_VALUE) {
                long t;
                for (t = amount; t > Integer.MAX_VALUE; t -= Integer.MAX_VALUE) {
                    outputs.add(GTUtility.copyAmountUnsafe((int)Integer.MAX_VALUE, (ItemStack)itemStack));
                }
                if (t <= 0L) continue;
                outputs.add(GTUtility.copyAmountUnsafe((int)((int)t), (ItemStack)itemStack));
                continue;
            }
            outputs.add(GTUtility.copyAmountUnsafe((int)((int)amount), (ItemStack)itemStack));
        }
        return outputs;
    }

    public List<FluidStack> getOutputFluids(int multiplier) {
        if (this.outputFluids.length < 1) {
            return Collections.emptyList();
        }
        ArrayList<FluidStack> outputs = new ArrayList<FluidStack>();
        for (FluidStack fluidStack : this.outputFluids) {
            long amount = (long)multiplier * (long)fluidStack.amount;
            if (amount > Integer.MAX_VALUE) {
                long t;
                for (t = amount; t > Integer.MAX_VALUE; t -= Integer.MAX_VALUE) {
                    outputs.add(GTUtility.copyAmount((int)Integer.MAX_VALUE, (FluidStack)fluidStack));
                }
                if (t <= 0L) continue;
                outputs.add(GTUtility.copyAmount((int)((int)t), (FluidStack)fluidStack));
                continue;
            }
            outputs.add(GTUtility.copyAmount((int)((int)amount), (FluidStack)fluidStack));
        }
        return outputs;
    }

    public TST_ItemID getItemToDisassemble() {
        return this.itemToDisassemble;
    }

    public TST_SimpleDisassemblyRecipe setItemToDisassemble(TST_ItemID itemToDisassemble) {
        this.itemToDisassemble = itemToDisassemble;
        return this;
    }

    public int getItemAmount() {
        return this.itemAmount;
    }

    public TST_SimpleDisassemblyRecipe setItemAmount(int itemAmount) {
        this.itemAmount = itemAmount;
        return this;
    }

    public ItemStack[] getOutputItems() {
        return this.outputItems;
    }

    public TST_SimpleDisassemblyRecipe setOutputItems(ItemStack ... outputItems) {
        if (outputItems != null && outputItems.length > 0) {
            this.outputItems = (ItemStack[])Stream.of(outputItems).filter(is -> is != null && is.field_77994_a > 0).toArray(ItemStack[]::new);
        }
        return this;
    }

    public FluidStack[] getOutputFluids() {
        return this.outputFluids;
    }

    public TST_SimpleDisassemblyRecipe setOutputFluids(FluidStack ... outputFluids) {
        if (outputFluids != null && outputFluids.length > 0) {
            this.outputFluids = outputFluids;
        }
        return this;
    }

    public long getEut() {
        return this.eut;
    }

    public TST_SimpleDisassemblyRecipe setEut(long eut) {
        this.eut = eut;
        return this;
    }

    public byte getTier() {
        return this.tier;
    }

    public TST_SimpleDisassemblyRecipe setTier(byte tier) {
        this.tier = tier;
        return this;
    }
}

