/*
 * Decompiled with CFR 0.152.
 */
package com.Nxer.TwistSpaceTechnology.system.DysonSphereProgram.machines;

import com.Nxer.TwistSpaceTechnology.common.GTCMItemList;
import com.Nxer.TwistSpaceTechnology.common.init.TstBlocks;
import com.Nxer.TwistSpaceTechnology.common.misc.CheckRecipeResults.CheckRecipeResults;
import com.Nxer.TwistSpaceTechnology.common.misc.MachineShutDownReasons.SimpleShutDownReasons;
import com.Nxer.TwistSpaceTechnology.common.modularizedMachine.ModularizedMachineLogic.ModularHatchTypes;
import com.Nxer.TwistSpaceTechnology.common.modularizedMachine.ModularizedMachineLogic.ModularizedHatchElement;
import com.Nxer.TwistSpaceTechnology.common.modularizedMachine.ModularizedMachineLogic.ModularizedMachineBase;
import com.Nxer.TwistSpaceTechnology.common.modularizedMachine.ModularizedMachineLogic.ModularizedMachineSupportAllModuleBase;
import com.Nxer.TwistSpaceTechnology.common.recipeMap.GTCMRecipe;
import com.Nxer.TwistSpaceTechnology.config.Config;
import com.Nxer.TwistSpaceTechnology.util.TextEnums;
import com.Nxer.TwistSpaceTechnology.util.TextLocalization;
import com.Nxer.TwistSpaceTechnology.util.rewrites.TST_ItemID;
import com.google.common.collect.ImmutableList;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.drawable.UITexture;
import com.gtnewhorizons.modularui.api.math.Alignment;
import com.gtnewhorizons.modularui.api.math.Color;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.screen.UIBuildContext;
import com.gtnewhorizons.modularui.common.widget.ButtonWidget;
import com.gtnewhorizons.modularui.common.widget.TextWidget;
import com.gtnewhorizons.modularui.common.widget.textfield.TextFieldWidget;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import goodgenerator.items.GGMaterial;
import gregtech.api.enums.HatchElement;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.enums.MaterialsUEVplus;
import gregtech.api.enums.Textures;
import gregtech.api.gui.modularui.GTUITextures;
import gregtech.api.interfaces.IHatchElement;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.MTEHatchInput;
import gregtech.api.metatileentity.implementations.MTEHatchInputBus;
import gregtech.api.metatileentity.implementations.MTEHatchMultiInput;
import gregtech.api.metatileentity.implementations.MTEMultiBlockBase;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.CheckRecipeResultRegistry;
import gregtech.api.util.GTUtility;
import gregtech.api.util.HatchElementBuilder;
import gregtech.api.util.MultiblockTooltipBuilder;
import gregtech.api.util.shutdown.ShutDownReasonRegistry;
import gregtech.common.misc.WirelessNetworkManager;
import gregtech.common.tileentities.machines.IRecipeProcessingAwareHatch;
import gregtech.common.tileentities.machines.MTEHatchCraftingInputME;
import gregtech.common.tileentities.machines.MTEHatchInputME;
import gtPlusPlus.core.material.MaterialsElements;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.Pair;
import tectech.thing.block.BlockQuantumGlass;
import tectech.thing.casing.TTCasingsContainer;
import tectech.thing.metaTileEntity.multi.base.render.TTRenderedExtendedFacingTexture;

public class TST_StrangeMatterAggregator
extends ModularizedMachineSupportAllModuleBase<TST_StrangeMatterAggregator> {
    protected static Fluid[] SpaceTimeMaintenanceConsumablesFluids;
    protected static Fluid[][] ByproductFluids;
    protected static TST_ItemID CoreElement;
    protected static TST_ItemID AnnihilationConstrainer;
    protected static TST_ItemID AntiMatter;
    protected static TST_ItemID Tesseract;
    protected static TST_ItemID StellarFrame;
    protected static Fluid HydrogenPlasma;
    protected UUID ownerUUID;
    protected MTEHatchInput SpaceTimeMaintenanceConsumablesInputHatch;
    protected MTEHatchInputBus CoreElementInputBus;
    protected int oscillatorPieceNeed = 1;
    protected int constraintorPieceNeed = 1;
    protected int mergerPieceNeed = 1;
    protected int spaceTimeMaintenanceFluidTier = 1;
    protected Fluid spaceTimeMaintenanceFluidInUse;
    protected int maintenanceFluidConsumption = Config.MaintenanceFluidConsumption_T1SpaceTime_StrangeMatterAggregator;
    protected int byproductOutputBaseAmount = 0;
    protected int oscillatorTier = 0;
    protected int oscillatorPiece = 0;
    protected int constraintorTier = 0;
    protected int constraintorPiece = 0;
    protected int mergerTier = 0;
    protected int mergerPiece = 0;
    protected int rings = 0;
    protected boolean wirelessMode = false;
    protected int maxConsecutivePoint = Config.MaxConsecutivePoint_T1SpaceTimeMerger_StrangeMatterAggregator;
    protected double auxiliaryMaterialConsumptionRate = 1.0;
    protected int recipeTime = Config.RecipeTime_T1SpaceTimeOscillator_StrangeMatterAggregator;
    protected long powerConsumption = Config.PowerConsume_StrangeMatterAggregator;
    protected long totalPowerConsumption = this.powerConsumption * (long)this.recipeTime;
    protected double inputFactor = Config.BaseInputValue_StrangeMatterAggregator;
    protected int tesseractFactor = Config.BasicRodAmountPerConstrainerProduce_SpaceTime_StrangeMatterAggregator;
    protected long constrainerFactor = Config.BasicRodAmountPerConstrainerProduce_SpaceTime_StrangeMatterAggregator;
    protected int fluidConsumptionFactor = Config.FluidInputMultiply_SpaceTimeMaintenance_StrangeMatterAggregator;
    protected int consecutivePoint = 0;
    private static final Collection<ModularHatchTypes> supportedModularHatchTypes;
    protected static final int horizontalOffSet_main = 8;
    protected static final int verticalOffSet_main = 8;
    protected static final int depthOffSet_main = 0;
    protected static final int horizontalOffSet_ring = 17;
    protected static final int verticalOffSet_ring = 17;
    protected static final int depthOffSet_ring_first = -4;
    protected static final int depthOffSet_ring_distance = 16;
    protected static final String STRUCTURE_PIECE_MAIN = "main";
    protected static final String STRUCTURE_PIECE_RING_O = "ringOscillator";
    protected static final String STRUCTURE_PIECE_RING_C = "ringConstraintor";
    protected static final String STRUCTURE_PIECE_RING_M = "ringMerger";
    protected static final String STRUCTURE_PIECE_END = "end";
    protected static IStructureDefinition<TST_StrangeMatterAggregator> STRUCTURE_DEFINITION;
    protected String[] buildingRingPieceArray = new String[]{"ringOscillator", "ringConstraintor", "ringMerger"};
    protected static final String[][] shapeMain;
    protected static final String[][] shapeRing_SpaceTimeOscillator;
    protected static final String[][] shapeRing_SpaceTimeConstraintor;
    protected static final String[][] shapeRing_SpaceTimeMerger;
    protected static final String[][] shapeEnd;
    private static MultiblockTooltipBuilder tooltip;
    protected static final int SYNC_WINDOW_STRUCTURE_ID = 114;
    protected static final int SYNC_WINDOW_RUNNING_ID = 115;
    protected static Textures.BlockIcons.CustomIcon ActiveFace;
    protected static Textures.BlockIcons.CustomIcon InactiveFace;

    public TST_StrangeMatterAggregator(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public TST_StrangeMatterAggregator(String aName) {
        super(aName);
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new TST_StrangeMatterAggregator(this.mName);
    }

    public static void initStatics() {
        SpaceTimeMaintenanceConsumablesFluids = new Fluid[]{MaterialsUEVplus.SpaceTime.getMolten(576L).getFluid(), MaterialsUEVplus.Universium.getMolten(96L).getFluid(), MaterialsUEVplus.MagnetohydrodynamicallyConstrainedStarMatter.getMolten(16L).getFluid()};
        ByproductFluids = new Fluid[][]{{Materials.Infinity.getMolten(1L).getFluid(), MaterialsElements.STANDALONE.HYPOGEN.getFluid()}, {MaterialsUEVplus.SpaceTime.getMolten(1L).getFluid(), GGMaterial.shirabon.getMolten(1).getFluid()}, {MaterialsUEVplus.Universium.getMolten(1L).getFluid()}};
        CoreElement = TST_ItemID.create(GTCMItemList.CoreElement.get(1, new Object[0]));
        AnnihilationConstrainer = TST_ItemID.create(GTCMItemList.AnnihilationConstrainer.get(1, new Object[0]));
        AntiMatter = TST_ItemID.create(GTCMItemList.Antimatter.get(1, new Object[0]));
        Tesseract = TST_ItemID.create(ItemList.Tesseract.get(1L, new Object[0]));
        StellarFrame = TST_ItemID.create(GTCMItemList.StellarConstructionFrameMaterial.get(1, new Object[0]));
        HydrogenPlasma = Materials.Hydrogen.getPlasma(1L).getFluid();
    }

    protected void calculateParametersWithStructure() {
        int n;
        double d;
        int n2;
        this.wirelessMode = this.mEnergyHatches.isEmpty() && this.mExoticEnergyHatches.isEmpty();
        switch (this.mergerTier) {
            case 2: {
                n2 = Config.MaxConsecutivePoint_T2SpaceTimeMerger_StrangeMatterAggregator;
                break;
            }
            case 3: {
                n2 = Config.MaxConsecutivePoint_T3SpaceTimeMerger_StrangeMatterAggregator;
                break;
            }
            default: {
                n2 = Config.MaxConsecutivePoint_T1SpaceTimeMerger_StrangeMatterAggregator;
            }
        }
        this.maxConsecutivePoint = n2;
        switch (this.constraintorTier) {
            case 2: {
                d = Config.AuxiliaryMaterialConsumptionRate_T2SpaceTimeConstraintor_StrangeMatterAggregator;
                break;
            }
            case 3: {
                d = Config.AuxiliaryMaterialConsumptionRate_T3SpaceTimeConstraintor_StrangeMatterAggregator;
                break;
            }
            default: {
                d = Config.AuxiliaryMaterialConsumptionRate_T1SpaceTimeConstraintor_StrangeMatterAggregator;
            }
        }
        this.auxiliaryMaterialConsumptionRate = d;
        switch (this.oscillatorTier) {
            case 2: {
                n = Config.RecipeTime_T2SpaceTimeOscillator_StrangeMatterAggregator;
                break;
            }
            case 3: {
                n = Config.RecipeTime_T3SpaceTimeOscillator_StrangeMatterAggregator;
                break;
            }
            default: {
                n = Config.RecipeTime_T1SpaceTimeOscillator_StrangeMatterAggregator;
            }
        }
        this.recipeTime = this.constraintorTier * n;
        this.inputFactor = 1.0 + (double)(Config.BaseInputValue_StrangeMatterAggregator - 1) / Math.pow(this.oscillatorPiece, 0.5);
        this.powerConsumption = (long)((double)this.mergerTier * Math.pow(this.mergerPiece, 0.7) * (double)Config.PowerConsume_StrangeMatterAggregator);
        if (this.wirelessMode) {
            this.totalPowerConsumption = this.powerConsumption * (long)this.recipeTime;
        }
        this.calculateParametersWithSettings();
    }

    protected void calculateParametersWithSettings() {
        int n;
        int n2;
        int n3;
        int n4;
        if (1 > this.spaceTimeMaintenanceFluidTier || 3 < this.spaceTimeMaintenanceFluidTier) {
            this.spaceTimeMaintenanceFluidTier = 1;
        }
        int tierIndex = this.spaceTimeMaintenanceFluidTier - 1;
        this.spaceTimeMaintenanceFluidInUse = SpaceTimeMaintenanceConsumablesFluids[tierIndex];
        switch (this.spaceTimeMaintenanceFluidTier) {
            case 2: {
                n4 = Config.MaintenanceFluidConsumption_T2Universium_StrangeMatterAggregator;
                break;
            }
            case 3: {
                n4 = Config.MaintenanceFluidConsumption_T3MagnetoConstrainedStarMatter_StrangeMatterAggregator;
                break;
            }
            default: {
                n4 = Config.MaintenanceFluidConsumption_T1SpaceTime_StrangeMatterAggregator;
            }
        }
        int base = n4;
        this.maintenanceFluidConsumption = (int)Math.max(1.0, (double)base * Math.pow(this.oscillatorTier * this.oscillatorPiece, 0.8) / (double)this.constraintorPiece);
        switch (this.spaceTimeMaintenanceFluidTier) {
            case 2: {
                n3 = Config.BasicRodAmountPerConstrainerProduce_Universium_StrangeMatterAggregator;
                break;
            }
            case 3: {
                n3 = Config.BasicRodAmountPerConstrainerProduce_MagnetoConstrainedStarMatter_StrangeMatterAggregator;
                break;
            }
            default: {
                n3 = Config.BasicRodAmountPerConstrainerProduce_SpaceTime_StrangeMatterAggregator;
            }
        }
        this.tesseractFactor = n3;
        this.constrainerFactor = (long)this.oscillatorTier * (long)this.oscillatorPiece * (long)this.constraintorTier * (long)this.constraintorPiece * (long)this.mergerTier * (long)this.mergerPiece * (long)this.tesseractFactor;
        switch (this.spaceTimeMaintenanceFluidTier) {
            case 2: {
                n2 = Config.FluidInputMultiply_UniversiumMaintenance_StrangeMatterAggregator;
                break;
            }
            case 3: {
                n2 = Config.FluidInputMultiply_MagnetoConstrainedStarMatterMaintenance_StrangeMatterAggregator;
                break;
            }
            default: {
                n2 = Config.FluidInputMultiply_SpaceTimeMaintenance_StrangeMatterAggregator;
            }
        }
        this.fluidConsumptionFactor = n2;
        switch (this.spaceTimeMaintenanceFluidTier) {
            case 2: {
                n = Config.ByproductBaseAmount_T2_StrangeMatterAggregator;
                break;
            }
            case 3: {
                n = Config.ByproductBaseAmount_T3_StrangeMatterAggregator;
                break;
            }
            default: {
                n = Config.ByproductBaseAmount_T1_StrangeMatterAggregator;
            }
        }
        this.byproductOutputBaseAmount = this.mergerPiece * n;
    }

    public void onFirstTick(IGregTechTileEntity aBaseMetaTileEntity) {
        super.onFirstTick(aBaseMetaTileEntity);
        if (aBaseMetaTileEntity.isServerSide()) {
            this.ownerUUID = aBaseMetaTileEntity.getOwnerUuid();
        }
    }

    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.onPostTick(aBaseMetaTileEntity, aTick);
        if (aBaseMetaTileEntity.isServerSide() && this.consecutivePoint != 0 && !aBaseMetaTileEntity.isActive()) {
            this.consecutivePoint = 0;
        }
    }

    protected CheckRecipeResult setRunning() {
        if (this.wirelessMode) {
            this.lEUt = 0L;
            if (!WirelessNetworkManager.addEUToGlobalEnergyMap((UUID)this.ownerUUID, (long)((long)(this.getEuModifier() * (float)this.totalPowerConsumption)))) {
                return CheckRecipeResultRegistry.insufficientPower((long)((long)(this.getEuModifier() * (float)this.totalPowerConsumption)));
            }
        } else {
            this.lEUt = -((long)(this.getEuModifier() * (float)this.powerConsumption));
        }
        this.mMaxProgresstime = (int)Math.max(1.0f, (float)this.recipeTime * this.getSpeedBonus());
        return CheckRecipeResultRegistry.SUCCESSFUL;
    }

    @Override
    public CheckRecipeResult checkProcessingMM() {
        int i;
        int i2;
        int remainder;
        int stack;
        long consumeAnnihilationConstrainer;
        if (!this.consumeSpaceTimeMaintenanceFluid()) {
            this.consecutivePoint = 0;
            this.stopMachine(SimpleShutDownReasons.NoSpaceTimeMaintenanceFluidInput);
            return CheckRecipeResults.NoSpaceTimeMaintenanceFluidInput;
        }
        CheckRecipeResult setPower = this.setRunning();
        if (!setPower.wasSuccessful()) {
            this.consecutivePoint = 0;
            this.stopMachine(ShutDownReasonRegistry.POWER_LOSS);
            return setPower;
        }
        Pair<List<ItemStack>, List<ItemStack>> coreElementsAndAnnihilationConstrainers = this.getCoreElementAndAnnihilationConstrainerStacks();
        List annihilationConstrainerStacks = (List)coreElementsAndAnnihilationConstrainers.getRight();
        if (annihilationConstrainerStacks.isEmpty()) {
            return CheckRecipeResults.NoAnnihilationConstrainerInput;
        }
        ArrayList<ItemStack> allInputItems = this.getStoredInputsNoSeparation();
        ArrayList<FluidStack> allInputFluids = this.getStoredFluidsWithDualInput();
        if (allInputItems.isEmpty() || allInputFluids.isEmpty()) {
            return CheckRecipeResultRegistry.NO_RECIPE;
        }
        long annihilationConstrainerAmount = 0L;
        for (ItemStack i3 : annihilationConstrainerStacks) {
            annihilationConstrainerAmount += (long)i3.field_77994_a;
        }
        long coreElementAmount = 0L;
        List coreElementStacks = (List)coreElementsAndAnnihilationConstrainers.getLeft();
        for (ItemStack i4 : coreElementStacks) {
            coreElementAmount += (long)i4.field_77994_a;
        }
        ArrayList<FluidStack> hydrogenPlasma = new ArrayList<FluidStack>();
        long hydrogenPlasmaAmount = 0L;
        for (FluidStack f : allInputFluids) {
            if (null == f && 0 >= f.amount || f.getFluid() != HydrogenPlasma) continue;
            hydrogenPlasma.add(f);
            hydrogenPlasmaAmount += (long)f.amount;
        }
        double recipeHydrogenPlasma = this.inputFactor * (double)this.fluidConsumptionFactor;
        if ((double)hydrogenPlasmaAmount < recipeHydrogenPlasma) {
            return CheckRecipeResultRegistry.NO_RECIPE;
        }
        ArrayList<ItemStack> antiMatters = new ArrayList<ItemStack>();
        long antiMatterAmount = 0L;
        ArrayList<ItemStack> stellarFrames = new ArrayList<ItemStack>();
        long stellarFramesAmount = 0L;
        ArrayList<ItemStack> tesseracts = new ArrayList<ItemStack>();
        long tesseractAmount = 0L;
        for (ItemStack i5 : allInputItems) {
            if (null == i5 || 0 >= i5.field_77994_a) continue;
            if (AntiMatter.equalItemStack(i5)) {
                antiMatters.add(i5);
                antiMatterAmount += (long)i5.field_77994_a;
                continue;
            }
            if (StellarFrame.equalItemStack(i5)) {
                stellarFrames.add(i5);
                stellarFramesAmount += (long)i5.field_77994_a;
                continue;
            }
            if (!Tesseract.equalItemStack(i5)) continue;
            tesseracts.add(i5);
            tesseractAmount += (long)i5.field_77994_a;
        }
        if ((double)antiMatterAmount < this.inputFactor || stellarFramesAmount < 1L || tesseractAmount < 1L) {
            return CheckRecipeResultRegistry.NO_RECIPE;
        }
        long antiMatterRodMaxOutput = annihilationConstrainerAmount * this.constrainerFactor;
        long rodAmountRecipe = 1 + this.consecutivePoint;
        double parallel = (double)antiMatterRodMaxOutput / (double)rodAmountRecipe;
        parallel = Math.min(parallel, (double)antiMatterAmount / this.inputFactor);
        parallel = Math.min(parallel, (double)hydrogenPlasmaAmount / recipeHydrogenPlasma);
        parallel = Math.min(parallel, (double)(tesseractAmount * (long)this.tesseractFactor) / this.auxiliaryMaterialConsumptionRate);
        long rodsMax = (long)((double)stellarFramesAmount / this.auxiliaryMaterialConsumptionRate);
        long tParallel = rodsMax / rodAmountRecipe;
        if ((parallel = Math.min(parallel, (double)tParallel)) < 1.0) {
            return CheckRecipeResultRegistry.NO_RECIPE;
        }
        long outputRodAmount = (long)(parallel * (double)rodAmountRecipe);
        long consumeAntiMatter = Math.max(1L, (long)(parallel * this.inputFactor));
        for (ItemStack i6 : antiMatters) {
            if ((long)i6.field_77994_a >= consumeAntiMatter) {
                i6.field_77994_a -= (int)consumeAntiMatter;
                break;
            }
            consumeAntiMatter -= (long)i6.field_77994_a;
            i6.field_77994_a = 0;
        }
        long annihilationConstrainerToConsume = consumeAnnihilationConstrainer = (long)Math.max(1.0, Math.ceil((double)outputRodAmount / (double)this.constrainerFactor));
        for (ItemStack i7 : annihilationConstrainerStacks) {
            if ((long)i7.field_77994_a >= annihilationConstrainerToConsume) {
                i7.field_77994_a -= (int)annihilationConstrainerToConsume;
                break;
            }
            annihilationConstrainerToConsume -= (long)i7.field_77994_a;
            i7.field_77994_a = 0;
        }
        long consumeHydrogenPlasma = (long)Math.max(1.0, parallel * recipeHydrogenPlasma);
        for (FluidStack f : hydrogenPlasma) {
            if ((long)f.amount >= consumeHydrogenPlasma) {
                f.amount -= (int)consumeHydrogenPlasma;
                break;
            }
            consumeHydrogenPlasma -= (long)f.amount;
            f.amount = 0;
        }
        long consumeTesseract = (long)Math.max(1.0, parallel * this.auxiliaryMaterialConsumptionRate / (double)this.tesseractFactor);
        for (ItemStack i8 : tesseracts) {
            if ((long)i8.field_77994_a >= consumeTesseract) {
                i8.field_77994_a -= (int)consumeTesseract;
                break;
            }
            consumeTesseract -= (long)i8.field_77994_a;
            i8.field_77994_a = 0;
        }
        long consumeStellarFrame = (long)Math.max(1.0, this.auxiliaryMaterialConsumptionRate * (double)outputRodAmount);
        for (ItemStack i9 : stellarFrames) {
            if ((long)i9.field_77994_a >= consumeStellarFrame) {
                i9.field_77994_a -= (int)consumeStellarFrame;
                break;
            }
            consumeStellarFrame -= (long)i9.field_77994_a;
            i9.field_77994_a = 0;
        }
        ArrayList<ItemStack> outputItems = new ArrayList<ItemStack>();
        long byproductAmount = (long)this.byproductOutputBaseAmount * (long)this.consecutivePoint;
        if (coreElementAmount > 0L) {
            byproductAmount *= 2L;
            long toConsume = 0L;
            if (coreElementAmount >= consumeAnnihilationConstrainer) {
                toConsume = consumeAnnihilationConstrainer;
                if (outputRodAmount > Integer.MAX_VALUE) {
                    stack = (int)(outputRodAmount / Integer.MAX_VALUE);
                    remainder = (int)(outputRodAmount % Integer.MAX_VALUE);
                    for (i2 = 0; i2 < stack; ++i2) {
                        outputItems.add(GTCMItemList.StrangeAnnihilationFuelRod.get(Integer.MAX_VALUE, new Object[0]));
                    }
                    outputItems.add(GTCMItemList.StrangeAnnihilationFuelRod.get(remainder, new Object[0]));
                } else {
                    outputItems.add(GTCMItemList.StrangeAnnihilationFuelRod.get((int)outputRodAmount, new Object[0]));
                }
            } else {
                int i10;
                int remainder2;
                int stack2;
                long strangeRod = coreElementAmount * this.constrainerFactor;
                long antiMatterRod = outputRodAmount - strangeRod;
                toConsume = coreElementAmount;
                if (strangeRod > Integer.MAX_VALUE) {
                    stack2 = (int)(strangeRod / Integer.MAX_VALUE);
                    remainder2 = (int)(strangeRod % Integer.MAX_VALUE);
                    for (i10 = 0; i10 < stack2; ++i10) {
                        outputItems.add(GTCMItemList.StrangeAnnihilationFuelRod.get(Integer.MAX_VALUE, new Object[0]));
                    }
                    outputItems.add(GTCMItemList.StrangeAnnihilationFuelRod.get(remainder2, new Object[0]));
                } else {
                    outputItems.add(GTCMItemList.StrangeAnnihilationFuelRod.get((int)outputRodAmount, new Object[0]));
                }
                if (antiMatterRod > Integer.MAX_VALUE) {
                    stack2 = (int)(antiMatterRod / Integer.MAX_VALUE);
                    remainder2 = (int)(antiMatterRod % Integer.MAX_VALUE);
                    for (i10 = 0; i10 < stack2; ++i10) {
                        outputItems.add(GTCMItemList.AntimatterFuelRod.get(Integer.MAX_VALUE, new Object[0]));
                    }
                    outputItems.add(GTCMItemList.AntimatterFuelRod.get(remainder2, new Object[0]));
                } else {
                    outputItems.add(GTCMItemList.AntimatterFuelRod.get((int)outputRodAmount, new Object[0]));
                }
            }
            if (0L < toConsume) {
                for (ItemStack i11 : coreElementStacks) {
                    if ((long)i11.field_77994_a >= toConsume) {
                        i11.field_77994_a -= (int)toConsume;
                        break;
                    }
                    toConsume -= (long)i11.field_77994_a;
                    i11.field_77994_a = 0;
                }
            }
        } else if (outputRodAmount > Integer.MAX_VALUE) {
            int stack3 = (int)(outputRodAmount / Integer.MAX_VALUE);
            int remainder3 = (int)(outputRodAmount % Integer.MAX_VALUE);
            for (i = 0; i < stack3; ++i) {
                outputItems.add(GTCMItemList.AntimatterFuelRod.get(Integer.MAX_VALUE, new Object[0]));
            }
            outputItems.add(GTCMItemList.AntimatterFuelRod.get(remainder3, new Object[0]));
        } else {
            outputItems.add(GTCMItemList.AntimatterFuelRod.get((int)outputRodAmount, new Object[0]));
        }
        ArrayList<FluidStack> outputFluids = new ArrayList<FluidStack>();
        if (this.consecutivePoint > 0) {
            Fluid[] byproducts = ByproductFluids[this.spaceTimeMaintenanceFluidTier - 1];
            if (byproductAmount > Integer.MAX_VALUE) {
                stack = (int)(byproductAmount / Integer.MAX_VALUE);
                remainder = (int)(byproductAmount % Integer.MAX_VALUE);
                for (i2 = 0; i2 < byproducts.length; ++i2) {
                    for (int j = 0; j < stack; ++j) {
                        outputFluids.add(new FluidStack(byproducts[i2], Integer.MAX_VALUE));
                    }
                    outputFluids.add(new FluidStack(byproducts[i2], remainder));
                }
            } else {
                for (i = 0; i < byproducts.length; ++i) {
                    outputFluids.add(new FluidStack(byproducts[i], (int)byproductAmount));
                }
            }
        }
        if (!outputItems.isEmpty()) {
            this.mOutputItems = outputItems.toArray(new ItemStack[0]);
        }
        if (!outputFluids.isEmpty()) {
            this.mOutputFluids = outputFluids.toArray(new FluidStack[0]);
        }
        this.updateSlots();
        this.consecutivePoint = this.consecutivePoint < this.maxConsecutivePoint ? ++this.consecutivePoint : this.maxConsecutivePoint;
        return CheckRecipeResultRegistry.SUCCESSFUL;
    }

    public RecipeMap<?> getRecipeMap() {
        return GTCMRecipe.StrangeMatterAggregatorRecipes;
    }

    public void updateSlots() {
        super.updateSlots();
        if (null != this.SpaceTimeMaintenanceConsumablesInputHatch && this.SpaceTimeMaintenanceConsumablesInputHatch.isValid()) {
            this.SpaceTimeMaintenanceConsumablesInputHatch.updateSlots();
        }
        if (null != this.CoreElementInputBus && this.CoreElementInputBus.isValid()) {
            this.CoreElementInputBus.updateSlots();
        }
    }

    public void startRecipeProcessing() {
        IRecipeProcessingAwareHatch aware;
        MTEHatchInput mTEHatchInput;
        super.startRecipeProcessing();
        if (null != this.SpaceTimeMaintenanceConsumablesInputHatch && this.SpaceTimeMaintenanceConsumablesInputHatch.isValid() && (mTEHatchInput = this.SpaceTimeMaintenanceConsumablesInputHatch) instanceof IRecipeProcessingAwareHatch) {
            aware = (IRecipeProcessingAwareHatch)mTEHatchInput;
            aware.startRecipeProcessing();
        }
        if (null != this.CoreElementInputBus && this.CoreElementInputBus.isValid() && (mTEHatchInput = this.CoreElementInputBus) instanceof IRecipeProcessingAwareHatch) {
            aware = (IRecipeProcessingAwareHatch)mTEHatchInput;
            aware.startRecipeProcessing();
        }
    }

    public void endRecipeProcessing() {
        IRecipeProcessingAwareHatch aware;
        MTEHatchInput mTEHatchInput;
        super.endRecipeProcessing();
        if (null != this.SpaceTimeMaintenanceConsumablesInputHatch && this.SpaceTimeMaintenanceConsumablesInputHatch.isValid() && (mTEHatchInput = this.SpaceTimeMaintenanceConsumablesInputHatch) instanceof IRecipeProcessingAwareHatch) {
            aware = (IRecipeProcessingAwareHatch)mTEHatchInput;
            this.setResultIfFailure(aware.endRecipeProcessing((MTEMultiBlockBase)this));
        }
        if (null != this.CoreElementInputBus && this.CoreElementInputBus.isValid() && (mTEHatchInput = this.CoreElementInputBus) instanceof IRecipeProcessingAwareHatch) {
            aware = (IRecipeProcessingAwareHatch)mTEHatchInput;
            this.setResultIfFailure(aware.endRecipeProcessing((MTEMultiBlockBase)this));
        }
    }

    protected Pair<List<ItemStack>, List<ItemStack>> getCoreElementAndAnnihilationConstrainerStacks() {
        if (null == this.CoreElementInputBus || !this.CoreElementInputBus.isValid() || this.CoreElementInputBus instanceof MTEHatchCraftingInputME) {
            return Pair.of(Collections.emptyList(), Collections.emptyList());
        }
        ArrayList coreElements = new ArrayList();
        ArrayList annihilationConstrainers = new ArrayList();
        IGregTechTileEntity te = this.CoreElementInputBus.getBaseMetaTileEntity();
        for (int i = te.func_70302_i_() - 1; i >= 0; --i) {
            ItemStack itemStack = te.func_70301_a(i);
            if (itemStack == null || itemStack.field_77994_a <= 0) continue;
            if (CoreElement.equalItemStack(itemStack)) {
                coreElements.add(itemStack);
                continue;
            }
            if (!AnnihilationConstrainer.equalItemStack(itemStack)) continue;
            annihilationConstrainers.add(itemStack);
        }
        return Pair.of(coreElements.isEmpty() ? Collections.emptyList() : coreElements, annihilationConstrainers.isEmpty() ? Collections.emptyList() : annihilationConstrainers);
    }

    protected boolean consumeSpaceTimeMaintenanceFluid() {
        MTEHatchInput matchedFluidStacks;
        if (null == this.SpaceTimeMaintenanceConsumablesInputHatch || !this.SpaceTimeMaintenanceConsumablesInputHatch.isValid()) {
            return false;
        }
        MTEHatchInput mTEHatchInput = this.SpaceTimeMaintenanceConsumablesInputHatch;
        if (mTEHatchInput instanceof MTEHatchMultiInput) {
            MTEHatchMultiInput m = (MTEHatchMultiInput)mTEHatchInput;
            matchedFluidStacks = new ArrayList();
            int matchedAmount = 0;
            for (FluidStack f : m.getStoredFluid()) {
                if (f.getFluid() != this.spaceTimeMaintenanceFluidInUse) continue;
                matchedFluidStacks.add(f);
                if ((matchedAmount += f.amount) >= this.maintenanceFluidConsumption) break;
            }
            if (matchedAmount >= this.maintenanceFluidConsumption) {
                int toConsume = this.maintenanceFluidConsumption;
                for (FluidStack f : matchedFluidStacks) {
                    if (f.amount >= toConsume) {
                        f.amount -= toConsume;
                        return true;
                    }
                    toConsume -= f.amount;
                    f.amount = 0;
                }
            }
            return false;
        }
        matchedFluidStacks = this.SpaceTimeMaintenanceConsumablesInputHatch;
        if (matchedFluidStacks instanceof MTEHatchInputME) {
            MTEHatchInputME me = (MTEHatchInputME)matchedFluidStacks;
            for (FluidStack f : me.getStoredFluids()) {
                if (null == f || f.getFluid() != this.spaceTimeMaintenanceFluidInUse) continue;
                if (f.amount >= this.maintenanceFluidConsumption) {
                    f.amount -= this.maintenanceFluidConsumption;
                    return true;
                }
                return false;
            }
            return false;
        }
        FluidStack f = this.SpaceTimeMaintenanceConsumablesInputHatch.getFillableStack();
        if (null != f && f.getFluid() == this.spaceTimeMaintenanceFluidInUse && f.amount >= this.maintenanceFluidConsumption) {
            f.amount -= this.maintenanceFluidConsumption;
            return true;
        }
        return false;
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74768_a("oscillatorPieceNeed", this.oscillatorPieceNeed);
        aNBT.func_74768_a("constraintorPieceNeed", this.constraintorPieceNeed);
        aNBT.func_74768_a("mergerPieceNeed", this.mergerPieceNeed);
        aNBT.func_74768_a("spaceTimeMaintenanceFluidTier", this.spaceTimeMaintenanceFluidTier);
        aNBT.func_74768_a("oscillatorTier", this.oscillatorTier);
        aNBT.func_74768_a("oscillatorPiece", this.oscillatorPiece);
        aNBT.func_74768_a("constraintorTier", this.constraintorTier);
        aNBT.func_74768_a("constraintorPiece", this.constraintorPiece);
        aNBT.func_74768_a("mergerTier", this.mergerTier);
        aNBT.func_74768_a("mergerPiece", this.mergerPiece);
        aNBT.func_74768_a("rings", this.rings);
        aNBT.func_74757_a("wirelessMode", this.wirelessMode);
        aNBT.func_74768_a("consecutivePoint", this.consecutivePoint);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.oscillatorPieceNeed = aNBT.func_74762_e("oscillatorPieceNeed");
        this.constraintorPieceNeed = aNBT.func_74762_e("constraintorPieceNeed");
        this.mergerPieceNeed = aNBT.func_74762_e("mergerPieceNeed");
        this.spaceTimeMaintenanceFluidTier = aNBT.func_74762_e("spaceTimeMaintenanceFluidTier");
        this.oscillatorTier = aNBT.func_74762_e("oscillatorTier");
        this.oscillatorPiece = aNBT.func_74762_e("oscillatorPiece");
        this.constraintorTier = aNBT.func_74762_e("constraintorTier");
        this.constraintorPiece = aNBT.func_74762_e("constraintorPiece");
        this.mergerTier = aNBT.func_74762_e("mergerTier");
        this.mergerPiece = aNBT.func_74762_e("mergerPiece");
        this.rings = aNBT.func_74762_e("rings");
        this.wirelessMode = aNBT.func_74767_n("wirelessMode");
        this.consecutivePoint = aNBT.func_74762_e("consecutivePoint");
        this.flushBuildingRingPieceArray();
    }

    @Override
    public void getWailaBody(ItemStack itemStack, List<String> currentTip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        super.getWailaBody(itemStack, currentTip, accessor, config);
        NBTTagCompound tag = accessor.getNBTData();
        if (tag.func_74767_n("isActive")) {
            currentTip.add("" + EnumChatFormatting.WHITE + EnumChatFormatting.BOLD + TextEnums.tr("StrangeMatterAggregator.MachineInfoData.consecutivePoint") + EnumChatFormatting.GRAY + " : " + EnumChatFormatting.YELLOW + tag.func_74762_e("consecutivePoint"));
            currentTip.add("" + EnumChatFormatting.AQUA + (Object)((Object)TextEnums.CurrentPowerConsumption) + EnumChatFormatting.GRAY + " : " + EnumChatFormatting.WHITE + GTUtility.formatNumbers((long)tag.func_74763_f("powerConsumption")) + " EU/t");
        }
    }

    @Override
    public void getWailaNBTData(EntityPlayerMP player, TileEntity tile, NBTTagCompound tag, World world, int x, int y, int z) {
        super.getWailaNBTData(player, tile, tag, world, x, y, z);
        IGregTechTileEntity tileEntity = this.getBaseMetaTileEntity();
        if (tileEntity != null && tileEntity.isActive()) {
            tag.func_74768_a("consecutivePoint", this.consecutivePoint);
            tag.func_74772_a("powerConsumption", (long)((float)this.powerConsumption * this.getEuModifier()));
        }
    }

    @Override
    public String[] getInfoData() {
        String[] origin = super.getInfoData();
        String[] ret = new String[origin.length + 8];
        System.arraycopy(origin, 0, ret, 0, origin.length);
        ret[origin.length] = EnumChatFormatting.AQUA + TextEnums.tr("StrangeMatterAggregator.MachineInfoData.oscillatorTier") + EnumChatFormatting.WHITE + ": " + EnumChatFormatting.GOLD + this.oscillatorTier;
        ret[origin.length + 1] = EnumChatFormatting.AQUA + TextEnums.tr("StrangeMatterAggregator.MachineInfoData.oscillatorPiece") + EnumChatFormatting.WHITE + ": " + EnumChatFormatting.GOLD + this.oscillatorPiece;
        ret[origin.length + 2] = EnumChatFormatting.AQUA + TextEnums.tr("StrangeMatterAggregator.MachineInfoData.constraintorTier") + EnumChatFormatting.WHITE + ": " + EnumChatFormatting.GOLD + this.constraintorTier;
        ret[origin.length + 3] = EnumChatFormatting.AQUA + TextEnums.tr("StrangeMatterAggregator.MachineInfoData.constraintorPiece") + EnumChatFormatting.WHITE + ": " + EnumChatFormatting.GOLD + this.constraintorPiece;
        ret[origin.length + 4] = EnumChatFormatting.AQUA + TextEnums.tr("StrangeMatterAggregator.MachineInfoData.mergerTier") + EnumChatFormatting.WHITE + ": " + EnumChatFormatting.GOLD + this.mergerTier;
        ret[origin.length + 5] = EnumChatFormatting.AQUA + TextEnums.tr("StrangeMatterAggregator.MachineInfoData.mergerPiece") + EnumChatFormatting.WHITE + ": " + EnumChatFormatting.GOLD + this.mergerPiece;
        ret[origin.length + 6] = EnumChatFormatting.AQUA + TextEnums.tr("StrangeMatterAggregator.MachineInfoData.totalRings") + EnumChatFormatting.WHITE + ": " + EnumChatFormatting.GOLD + this.rings;
        ret[origin.length + 7] = "" + EnumChatFormatting.YELLOW + EnumChatFormatting.BOLD + TextEnums.tr("StrangeMatterAggregator.MachineInfoData.consecutivePoint") + EnumChatFormatting.WHITE + ": " + EnumChatFormatting.GOLD + this.consecutivePoint;
        return ret;
    }

    public boolean addSpaceTimeMaintenanceConsumablesInputHatchToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity == null) {
            return false;
        }
        if (aMetaTileEntity instanceof MTEHatchInput) {
            MTEHatchInput hatch = (MTEHatchInput)aMetaTileEntity;
            hatch.updateTexture(aBaseCasingIndex);
            hatch.updateCraftingIcon(this.getMachineCraftingIcon());
            this.setHatchRecipeMap(hatch);
            this.SpaceTimeMaintenanceConsumablesInputHatch = hatch;
            return true;
        }
        return false;
    }

    public boolean addCoreElementInputBusToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity == null) {
            return false;
        }
        if (aMetaTileEntity instanceof MTEHatchInputBus) {
            MTEHatchInputBus hatch = (MTEHatchInputBus)aMetaTileEntity;
            hatch.updateTexture(aBaseCasingIndex);
            hatch.updateCraftingIcon(this.getMachineCraftingIcon());
            hatch.mRecipeMap = this.getRecipeMap();
            this.CoreElementInputBus = hatch;
            return true;
        }
        return false;
    }

    @Override
    public Collection<ModularHatchTypes> getSupportedModularHatchTypes() {
        return supportedModularHatchTypes;
    }

    @Override
    protected boolean canMultiplyModularHatchType() {
        return false;
    }

    @Override
    public boolean checkMachineMM(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.oscillatorTier = 0;
        this.oscillatorPiece = 0;
        this.constraintorTier = 0;
        this.constraintorPiece = 0;
        this.mergerTier = 0;
        this.mergerPiece = 0;
        this.rings = 0;
        this.SpaceTimeMaintenanceConsumablesInputHatch = null;
        this.CoreElementInputBus = null;
        if (!this.checkPiece(STRUCTURE_PIECE_MAIN, 8, 8, 0)) {
            return false;
        }
        while (true) {
            if (this.checkPiece(STRUCTURE_PIECE_RING_O, 17, 17, -4 - this.rings * 16)) {
                ++this.oscillatorPiece;
            } else if (this.checkPiece(STRUCTURE_PIECE_RING_C, 17, 17, -4 - this.rings * 16)) {
                ++this.constraintorPiece;
            } else {
                if (!this.checkPiece(STRUCTURE_PIECE_RING_M, 17, 17, -4 - this.rings * 16)) break;
                ++this.mergerPiece;
            }
            ++this.rings;
        }
        if (this.oscillatorPiece < 1 || this.constraintorPiece < 1 || this.mergerPiece < 1) {
            return false;
        }
        if (!this.checkPiece(STRUCTURE_PIECE_END, 8, 8, -4 - this.rings * 16)) {
            return false;
        }
        this.calculateParametersWithStructure();
        return this.wirelessMode || this.getMaxInputEu() >= Config.PowerConsume_StrangeMatterAggregator;
    }

    protected void flushBuildingRingPieceArray() {
        int p;
        this.buildingRingPieceArray = new String[this.oscillatorPieceNeed + this.constraintorPieceNeed + this.mergerPieceNeed];
        for (p = 0; p < this.oscillatorPieceNeed; ++p) {
            this.buildingRingPieceArray[p] = STRUCTURE_PIECE_RING_O;
        }
        int oc = this.oscillatorPieceNeed + this.constraintorPieceNeed;
        while (p < oc) {
            this.buildingRingPieceArray[p] = STRUCTURE_PIECE_RING_C;
            ++p;
        }
        int ocm = oc + this.mergerPieceNeed;
        while (p < ocm) {
            this.buildingRingPieceArray[p] = STRUCTURE_PIECE_RING_M;
            ++p;
        }
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece(STRUCTURE_PIECE_MAIN, stackSize, hintsOnly, 8, 8, 0);
        int limit = stackSize.field_77994_a;
        if (this.buildingRingPieceArray.length > 3) {
            limit = Config.StructureLoopBuildingLimit_StrangeMatterAggregator;
        }
        int offset = 0;
        for (int i = 0; i < limit; ++i) {
            for (int j = 0; j < this.buildingRingPieceArray.length; ++j) {
                this.buildPiece(this.buildingRingPieceArray[j], stackSize, hintsOnly, 17, 17, -4 - offset * 16);
                ++offset;
            }
        }
        this.buildPiece(STRUCTURE_PIECE_END, stackSize, hintsOnly, 8, 8, -4 - offset * 16);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        int built = this.survivalBuildPiece(STRUCTURE_PIECE_MAIN, stackSize, 8, 8, 0, elementBudget, env, false, true);
        if (built >= 0) {
            return built;
        }
        int limit = stackSize.field_77994_a;
        if (this.buildingRingPieceArray.length > 3) {
            limit = Config.StructureLoopBuildingLimit_StrangeMatterAggregator;
        }
        int offset = 0;
        for (int i = 0; i < limit; ++i) {
            for (int j = 0; j < this.buildingRingPieceArray.length; ++j) {
                built = this.survivalBuildPiece(this.buildingRingPieceArray[j], stackSize, 17, 17, -4 - offset * 16, elementBudget, env, false, true);
                if (built >= 0) {
                    return built;
                }
                ++offset;
            }
        }
        return this.survivalBuildPiece(STRUCTURE_PIECE_END, stackSize, 8, 8, -4 - 16 * offset, elementBudget, env, false, true);
    }

    public IStructureDefinition<TST_StrangeMatterAggregator> getStructureDefinition() {
        if (null == STRUCTURE_DEFINITION) {
            STRUCTURE_DEFINITION = StructureDefinition.builder().addShape(STRUCTURE_PIECE_MAIN, StructureUtility.transpose((String[][])shapeMain)).addShape(STRUCTURE_PIECE_RING_O, StructureUtility.transpose((String[][])shapeRing_SpaceTimeOscillator)).addShape(STRUCTURE_PIECE_RING_C, StructureUtility.transpose((String[][])shapeRing_SpaceTimeConstraintor)).addShape(STRUCTURE_PIECE_RING_M, StructureUtility.transpose((String[][])shapeRing_SpaceTimeMerger)).addShape(STRUCTURE_PIECE_END, StructureUtility.transpose((String[][])shapeEnd)).addElement('A', StructureUtility.ofBlock((Block)TTCasingsContainer.sBlockCasingsBA0, (int)10)).addElement('B', StructureUtility.ofBlock((Block)TTCasingsContainer.sBlockCasingsBA0, (int)11)).addElement('C', StructureUtility.ofBlock((Block)TTCasingsContainer.sBlockCasingsBA0, (int)12)).addElement('D', StructureUtility.ofBlock((Block)TTCasingsContainer.sBlockCasingsTT, (int)9)).addElement('E', StructureUtility.ofBlock((Block)TTCasingsContainer.sBlockCasingsTT, (int)10)).addElement('F', StructureUtility.ofBlock((Block)TTCasingsContainer.sBlockCasingsTT, (int)14)).addElement('G', StructureUtility.ofBlock((Block)BlockQuantumGlass.INSTANCE, (int)0)).addElement('H', (IStructureElement)HatchElementBuilder.builder().atLeast(new IHatchElement[]{HatchElement.OutputBus, HatchElement.OutputHatch, ModularizedHatchElement.SpeedController, ModularizedHatchElement.PowerConsumptionController}).adder(ModularizedMachineBase::addToMachineList).dot(1).casingIndex(1024).buildAndChain(new IStructureElement[]{StructureUtility.ofBlock((Block)TTCasingsContainer.sBlockCasingsBA0, (int)12)})).addElement('I', (IStructureElement)HatchElementBuilder.builder().atLeast(new IHatchElement[]{HatchElement.InputHatch}).adder(TST_StrangeMatterAggregator::addSpaceTimeMaintenanceConsumablesInputHatchToMachineList).dot(3).casingIndex(1024).buildAndChain(new IStructureElement[]{StructureUtility.ofBlock((Block)TTCasingsContainer.sBlockCasingsBA0, (int)12)})).addElement('J', (IStructureElement)HatchElementBuilder.builder().atLeast(new IHatchElement[]{HatchElement.InputBus, HatchElement.InputHatch}).adder(ModularizedMachineBase::addToMachineList).dot(2).casingIndex(1024).buildAndChain(new IStructureElement[]{StructureUtility.ofBlock((Block)TTCasingsContainer.sBlockCasingsBA0, (int)12)})).addElement('K', (IStructureElement)HatchElementBuilder.builder().atLeast(new IHatchElement[]{HatchElement.InputBus}).adder(TST_StrangeMatterAggregator::addCoreElementInputBusToMachineList).dot(4).casingIndex(1024).buildAndChain(new IStructureElement[]{StructureUtility.ofBlock((Block)TTCasingsContainer.sBlockCasingsBA0, (int)12)})).addElement('X', StructureUtility.withChannel((String)"oscillator", (IStructureElement)StructureUtility.ofBlocksTiered(TST_StrangeMatterAggregator::getSpaceTimeOscillatorTier, (List)ImmutableList.of((Object)Pair.of((Object)TstBlocks.SpaceTimeOscillator, (Object)0), (Object)Pair.of((Object)TstBlocks.SpaceTimeOscillator, (Object)1), (Object)Pair.of((Object)TstBlocks.SpaceTimeOscillator, (Object)2)), (Object)0, (m, t) -> {
                m.oscillatorTier = t;
            }, m -> m.oscillatorTier))).addElement('Y', StructureUtility.withChannel((String)"constraintor", (IStructureElement)StructureUtility.ofBlocksTiered(TST_StrangeMatterAggregator::getSpaceTimeConstraintor, (List)ImmutableList.of((Object)Pair.of((Object)TstBlocks.SpaceTimeConstraintor, (Object)0), (Object)Pair.of((Object)TstBlocks.SpaceTimeConstraintor, (Object)1), (Object)Pair.of((Object)TstBlocks.SpaceTimeConstraintor, (Object)2)), (Object)0, (m, t) -> {
                m.constraintorTier = t;
            }, m -> m.constraintorTier))).addElement('Z', StructureUtility.withChannel((String)"merger", (IStructureElement)StructureUtility.ofBlocksTiered(TST_StrangeMatterAggregator::getSpaceTimeMerger, (List)ImmutableList.of((Object)Pair.of((Object)TstBlocks.SpaceTimeMerger, (Object)0), (Object)Pair.of((Object)TstBlocks.SpaceTimeMerger, (Object)1), (Object)Pair.of((Object)TstBlocks.SpaceTimeMerger, (Object)2)), (Object)0, (m, t) -> {
                m.mergerTier = t;
            }, m -> m.mergerTier))).build();
        }
        return STRUCTURE_DEFINITION;
    }

    public static int getSpaceTimeOscillatorTier(Block b, int m) {
        if (b != TstBlocks.SpaceTimeOscillator) {
            return 0;
        }
        return m + 1;
    }

    public static int getSpaceTimeConstraintor(Block b, int m) {
        if (b != TstBlocks.SpaceTimeConstraintor) {
            return 0;
        }
        return m + 1;
    }

    public static int getSpaceTimeMerger(Block b, int m) {
        if (b != TstBlocks.SpaceTimeMerger) {
            return 0;
        }
        return m + 1;
    }

    protected MultiblockTooltipBuilder createTooltip() {
        if (tooltip == null) {
            tooltip = new MultiblockTooltipBuilder();
            tooltip.addMachineType(TextEnums.tr("Tooltip_StrangeMatterAggregator_MachineType")).addInfo(TextEnums.tr("Tooltip_StrangeMatterAggregator_01")).addInfo(TextEnums.tr("Tooltip_StrangeMatterAggregator_02")).addInfo(TextEnums.tr("Tooltip_StrangeMatterAggregator_03")).addInfo(TextEnums.tr("Tooltip_StrangeMatterAggregator_04")).addInfo(TextEnums.tr("Tooltip_StrangeMatterAggregator_05")).addInfo(TextEnums.tr("Tooltip_StrangeMatterAggregator_06")).addInfo(TextEnums.tr("Tooltip_StrangeMatterAggregator_07")).addInfo(TextEnums.tr("Tooltip_StrangeMatterAggregator_08")).addInfo(TextEnums.tr("Tooltip_StrangeMatterAggregator_09")).addInfo(TextEnums.tr("Tooltip_StrangeMatterAggregator_10")).addInfo(TextEnums.tr("Tooltip_StrangeMatterAggregator_11")).addInfo(TextEnums.tr("Tooltip_StrangeMatterAggregator_12")).addInfo(TextEnums.tr("Tooltip_StrangeMatterAggregator_13")).addInfo(TextEnums.tr("Tooltip_StrangeMatterAggregator_14")).addInfo(TextEnums.tr("Tooltip_StrangeMatterAggregator_15")).addInfo(TextEnums.tr("Tooltip_StrangeMatterAggregator_16")).addInfo(TextEnums.tr("Tooltip_StrangeMatterAggregator_17")).addInfo(TextEnums.tr("Tooltip_StrangeMatterAggregator_18")).addInfo(TextEnums.tr("Tooltip_StrangeMatterAggregator_19")).addInfo(TextEnums.tr("Tooltip_StrangeMatterAggregator_20")).addInfo(TextEnums.tr("Tooltip_StrangeMatterAggregator_21")).addInfo(TextEnums.tr("Tooltip_StrangeMatterAggregator_22")).addInfo(TextEnums.tr("Tooltip_StrangeMatterAggregator_23")).addInfo(EnumChatFormatting.GOLD + TextLocalization.Text_SeparatingLine).addInfo(TextEnums.tr("Tooltip_StrangeMatterAggregator_24")).addInfo(TextEnums.tr("Tooltip_StrangeMatterAggregator_25")).addInfo(TextEnums.tr("Tooltip_StrangeMatterAggregator_26")).addInfo(TextEnums.tr("Tooltip_StrangeMatterAggregator_27")).addInfo(TextEnums.tr("Tooltip_StrangeMatterAggregator_28")).addInfo(TextEnums.tr("Tooltip_StrangeMatterAggregator_29")).addInfo(TextEnums.InstallingModuleNearControllerImproveMachine.getText()).addInfo(TextEnums.ModularizedMachineSystem.getText()).addSeparator().addInfo(TextLocalization.StructureTooComplex).addInfo(TextLocalization.BLUE_PRINT_INFO).addStructureInfo(TextEnums.ModularizedMachineSystem.getText()).addStructureInfo(TextEnums.ModularizedMachineSystemDescription01.getText()).addStructureInfo(TextEnums.ModularizedMachineSystemDescription02.getText()).addStructureInfo(TextEnums.PowerConsumptionControllerDescription.getText()).addStructureInfo(TextEnums.SpeedControllerDescription.getText()).addStructureInfo(TextEnums.NotMultiplyInstallSameTypeModuleAll.getText()).addStructureInfo(TextLocalization.Text_SeparatingLine).addStructureInfo(TextEnums.tr("Tooltip_StrangeMatterAggregator.structure.UI_Description.01")).addOtherStructurePart(TextEnums.tr("Tooltip_StrangeMatterAggregator.structure.SpaceTimeMaintenanceFluidInputHatch"), TextEnums.tr("Tooltip_StrangeMatterAggregator.structure.Left"), new int[]{3}).addOtherStructurePart(TextEnums.tr("Tooltip_StrangeMatterAggregator.structure.CoreElementAndAnnihilationConstrainerInputBus"), TextEnums.tr("Tooltip_StrangeMatterAggregator.structure.Right"), new int[]{4}).addInputHatch(TextLocalization.textUseBlueprint, new int[]{2}).addInputBus(TextLocalization.textUseBlueprint, new int[]{2}).addOtherStructurePart(TextEnums.ModularHatch.getText(), TextLocalization.textUseBlueprint, new int[]{1}).addOutputBus(TextLocalization.textUseBlueprint, new int[]{1}).addOutputHatch(TextLocalization.textUseBlueprint, new int[]{1}).addEnergyHatch(TextLocalization.textUseBlueprint, new int[]{1}).toolTipFinisher(new String[]{"Twist Space Technology"});
        }
        return tooltip;
    }

    @Override
    public boolean supportsVoidProtection() {
        return false;
    }

    @Override
    public boolean supportsInputSeparation() {
        return false;
    }

    @Override
    public boolean supportsSingleRecipeLocking() {
        return false;
    }

    @Override
    public boolean supportsBatchMode() {
        return false;
    }

    public void addUIWidgets(ModularWindow.Builder builder, UIBuildContext buildContext) {
        super.addUIWidgets(builder, buildContext);
        buildContext.addSyncedWindow(114, this::createStructureConfigurationWindow);
        buildContext.addSyncedWindow(115, this::createRunningConfigurationWindow);
        ((ModularWindow.Builder)builder.widget(new ButtonWidget().setOnClick((clickData, widget) -> {
            if (!widget.isClient()) {
                widget.getContext().openSyncedWindow(114);
            }
        }).setSize(16, 16).setBackground(() -> {
            ArrayList<UITexture> ret = new ArrayList<UITexture>();
            ret.add(GTUITextures.BUTTON_STANDARD);
            ret.add(GTUITextures.OVERLAY_BUTTON_CYCLIC);
            return ret.toArray(new IDrawable[0]);
        }).addTooltip(TextEnums.tr("StrangeMatterAggregator.UI.BuildingInfoMenuButton.name")).setPos(174, 130))).widget(new ButtonWidget().setOnClick((clickData, widget) -> {
            if (!widget.isClient()) {
                widget.getContext().openSyncedWindow(115);
            }
        }).setSize(16, 16).setBackground(() -> {
            ArrayList<UITexture> ret = new ArrayList<UITexture>();
            ret.add(GTUITextures.BUTTON_STANDARD);
            ret.add(GTUITextures.OVERLAY_BUTTON_CYCLIC);
            return ret.toArray(new IDrawable[0]);
        }).addTooltip(TextEnums.tr("StrangeMatterAggregator.UI.RunningInfoMenuButton.name")).setPos(174, 112));
    }

    protected ModularWindow createStructureConfigurationWindow(EntityPlayer player) {
        ModularWindow.Builder builder = ModularWindow.builder((int)240, (int)80);
        builder.setBackground(new IDrawable[]{GTUITextures.BACKGROUND_SINGLEBLOCK_DEFAULT});
        builder.setGuiTint(this.getGUIColorization());
        ((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)builder.widget(TextWidget.localised((String)"StrangeMatterAggregator.UI.Structure.ConfigurationDescription.text", (Object[])new Object[0]).setPos(20, 10).setSize(200, 14))).widget(TextWidget.localised((String)"StrangeMatterAggregator.UI.OscillatorPieceNeed.text", (Object[])new Object[0]).setPos(1, 36).setSize(100, 14))).widget(new TextFieldWidget().setSetterInt(val -> {
            this.oscillatorPieceNeed = val;
            this.flushBuildingRingPieceArray();
        }).setGetterInt(() -> this.oscillatorPieceNeed).setNumbers(1, 64).setOnScrollNumbers(1, 4, 16).setTextAlignment(Alignment.Center).setTextColor(Color.WHITE.normal).setSize(40, 18).setPos(30, 50).setBackground(new IDrawable[]{GTUITextures.BACKGROUND_TEXT_FIELD}))).widget(TextWidget.localised((String)"StrangeMatterAggregator.UI.ConstraintorPieceNeed.text", (Object[])new Object[0]).setPos(71, 36).setSize(100, 14))).widget(new TextFieldWidget().setSetterInt(val -> {
            this.constraintorPieceNeed = val;
            this.flushBuildingRingPieceArray();
        }).setGetterInt(() -> this.constraintorPieceNeed).setNumbers(1, 64).setOnScrollNumbers(1, 4, 16).setTextAlignment(Alignment.Center).setTextColor(Color.WHITE.normal).setSize(40, 18).setPos(100, 50).setBackground(new IDrawable[]{GTUITextures.BACKGROUND_TEXT_FIELD}))).widget(TextWidget.localised((String)"StrangeMatterAggregator.UI.MergerPieceNeed.text", (Object[])new Object[0]).setPos(141, 36).setSize(100, 14))).widget(new TextFieldWidget().setSetterInt(val -> {
            this.mergerPieceNeed = val;
            this.flushBuildingRingPieceArray();
        }).setGetterInt(() -> this.mergerPieceNeed).setNumbers(1, 64).setOnScrollNumbers(1, 4, 16).setTextAlignment(Alignment.Center).setTextColor(Color.WHITE.normal).setSize(40, 18).setPos(170, 50).setBackground(new IDrawable[]{GTUITextures.BACKGROUND_TEXT_FIELD}));
        return builder.build();
    }

    protected ModularWindow createRunningConfigurationWindow(EntityPlayer player) {
        ModularWindow.Builder builder = ModularWindow.builder((int)240, (int)80);
        builder.setBackground(new IDrawable[]{GTUITextures.BACKGROUND_SINGLEBLOCK_DEFAULT});
        builder.setGuiTint(this.getGUIColorization());
        ((ModularWindow.Builder)builder.widget(TextWidget.localised((String)"StrangeMatterAggregator.UI.Running.ConfigurationDescription.text", (Object[])new Object[0]).setPos(20, 10).setSize(200, 14))).widget(new TextFieldWidget().setSetterInt(val -> {
            this.spaceTimeMaintenanceFluidTier = val;
            this.calculateParametersWithSettings();
        }).setGetterInt(() -> this.spaceTimeMaintenanceFluidTier).setNumbers(1, 3).setOnScrollNumbers(1, 1, 1).setTextAlignment(Alignment.Center).setTextColor(Color.WHITE.normal).setSize(40, 18).setPos(100, 36).setBackground(new IDrawable[]{GTUITextures.BACKGROUND_TEXT_FIELD}));
        return builder.build();
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister aBlockIconRegister) {
        ActiveFace = new Textures.BlockIcons.CustomIcon("gtnhcommunitymod:ModularHatchOverlay/OVERLAY_ControlCore_Per_on");
        InactiveFace = new Textures.BlockIcons.CustomIcon("gtnhcommunitymod:ModularHatchOverlay/OVERLAY_ControlCore_Per_off");
        super.registerIcons(aBlockIconRegister);
    }

    public ITexture[] getTexture(IGregTechTileEntity baseMetaTileEntity, ForgeDirection side, ForgeDirection facing, int colorIndex, boolean active, boolean redstoneLevel) {
        if (side == facing) {
            return new ITexture[]{Textures.BlockIcons.casingTexturePages[8][12], new TTRenderedExtendedFacingTexture((IIconContainer)(active ? ActiveFace : InactiveFace))};
        }
        return new ITexture[]{Textures.BlockIcons.casingTexturePages[8][12]};
    }

    static {
        supportedModularHatchTypes = ImmutableList.of((Object)((Object)ModularHatchTypes.POWER_CONSUMPTION_CONTROLLER), (Object)((Object)ModularHatchTypes.SPEED_CONTROLLER));
        STRUCTURE_DEFINITION = null;
        shapeMain = new String[][]{{"                 ", "                 ", "       CCC       ", "                 "}, {"                 ", "       BBB       ", "     CCAAACC     ", "       BBB       "}, {"                 ", "     BBBFBBB     ", "    CAACCCAAC    ", "     BBGGGBB     "}, {"                 ", "    BBBBBBBBB    ", "   CACCCCCCCAC   ", "    BGG   GGB    "}, {"       BBB       ", "   BBBBBBBBBBB   ", "  CACCCCFCCCCAC  ", "   BG       GB   "}, {"       BJB       ", "  BBBFBBBBBFBBB  ", " CACCFCCCCCFCCAC ", "  BG         GB  "}, {"      BBBBB      ", "  BBBBBBBBBBBBB  ", " CACCCCCCCCCCCAC ", "  BG         GB  "}, {"    BBBHHHBBB    ", " BBBBBBBBBBBBBBB ", "CACCCCCCCCCCCCCAC", " BG    D D    GB "}, {"    BIBH~HBKB    ", " BFBBBBBBBBBBBFB ", "CACCFCCCCCCCFCCAC", " BG     E     GB "}, {"    BBBHHHBBB    ", " BBBBBBBBBBBBBBB ", "CACCCCCCCCCCCCCAC", " BG    D D    GB "}, {"      BBBBB      ", "  BBBBBBBBBBBBB  ", " CACCCCCCCCCCCAC ", "  BG         GB  "}, {"       BJB       ", "  BBBFBBBBBFBBB  ", " CACCFCCCCCFCCAC ", "  BG         GB  "}, {"       BBB       ", "   BBBBBBBBBBB   ", "  CACCCCFCCCCAC  ", "   BG       GB   "}, {"                 ", "    BBBBBBBBB    ", "   CACCCCCCCAC   ", "    BGG   GGB    "}, {"                 ", "     BBBFBBB     ", "    CAACCCAAC    ", "     BBGGGBB     "}, {"                 ", "       BBB       ", "     CCAAACC     ", "       BBB       "}, {"                 ", "                 ", "       CCC       ", "                 "}};
        shapeRing_SpaceTimeOscillator = new String[][]{{"                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "               AAAAA               ", "               AAAAA               ", "               AAAAA               ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   "}, {"                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "               BBBBB               ", "            AAAAAAAAAAA            ", "            AAAAAAAAAAA            ", "            AAAAAAAAAAA            ", "               BBBBB               ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   "}, {"                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "            BBB     BBB            ", "          AAAAACCCCCAAAAA          ", "          AAAAACCCCCAAAAA          ", "          AAAAACCCCCAAAAA          ", "            BBB     BBB            ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   "}, {"                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "          BB           BB          ", "        AAAACCC     CCCAAAA        ", "        AAAACCC     CCCAAAA        ", "        AAAACCC     CCCAAAA        ", "          BB           BB          ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   "}, {"                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "        BB               BB        ", "       AAACC           CCAAA       ", "       AAACC           CCAAA       ", "       AAACC           CCAAA       ", "        BB               BB        ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   "}, {"                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "       B                   B       ", "      AACC       A       CCAA      ", "      AACC      ADA      CCAA      ", "      AACC       A       CCAA      ", "       B                   B       ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   "}, {"                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "      B         BBB         B      ", "     AAC       BFAFB       CAA     ", "     AAC       BAAAB       CAA     ", "     AAC       BFAFB       CAA     ", "      B         BBB         B      ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   "}, {"                                   ", "                                   ", "                                   ", "                                   ", "                BBB                ", "              BBCCCBB              ", "     B        BCCCCCB        B     ", "    AAC      BCCAAACCB      CAA    ", "    AAC      BCCACACCB      CAA    ", "    AAC      BCCAAACCB      CAA    ", "     B        BCCCCCB        B     ", "              BBCCCBB              ", "                BBB                ", "                                   ", "                                   ", "                                   "}, {"                                   ", "                                   ", "                                   ", "                BBB                ", "              BB   BB              ", "             B       B             ", "    B        B       B        B    ", "   AAC      B   AAA   B      CAA   ", "   AAC      B   ACA   B      CAA   ", "   AAC      B   AAA   B      CAA   ", "    B        B       B        B    ", "             B       B             ", "              BB   BB              ", "                BBB                ", "                                   ", "                                   "}, {"                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "    B           XXX           B    ", "   AAC         XDEDX         CAA   ", "   AAC         XEEEX         CAA   ", "   AAC         XDEDX         CAA   ", "    B           XXX           B    ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   "}, {"                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "   B                           B   ", "  AAC                         CAA  ", "  AAC                         CAA  ", "  AAC                         CAA  ", "   B                           B   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   "}, {"                GGG                ", "                GGG                ", "                GGG                ", "                GGG                ", "                GGG                ", "                GGG                ", "   B            GGG            B   ", "  AAC           GGG           CAA  ", "  AAC           GGG           CAA  ", "  AAC           GGG           CAA  ", "   B            GGG            B   ", "                GGG                ", "                GGG                ", "                GGG                ", "                GGG                ", "                GGG                "}, {"              GG   GG              ", "              GG   GG              ", "              GG   GG              ", "              GG   GG              ", "              GG   GG              ", "              GG   GG              ", "  B           GG   GG           B  ", " AAC    B     GG   GG     B    CAA ", " AAC    B     GG   GG     B    CAA ", " AAC    B     GG   GG     B    CAA ", "  B           GG   GG           B  ", "              GG   GG              ", "              GG   GG              ", "              GG   GG              ", "              GG   GG              ", "              GG   GG              "}, {"             G       G             ", "             G       G             ", "             G       G             ", "             G       G             ", "             G       G             ", "        B    G       G    B        ", "  B     B    G       G    B     B  ", " AAC   B     G       G     B   CAA ", " AAC   B     G       G     B   CAA ", " AAC   B     G       G     B   CAA ", "  B     B    G       G    B     B  ", "        B    G       G    B        ", "             G       G             ", "             G       G             ", "             G       G             ", "             G       G             "}, {"            G         G            ", "            G         G            ", "            G         G            ", "            G         G            ", "        B   G         G   B        ", "       B    G         G    B       ", "  B    B    G         G    B    B  ", " AAC   C    G         G    C   CAA ", " AAC   C    G         G    C   CAA ", " AAC   C    G         G    C   CAA ", "  B    B    G         G    B    B  ", "       B    G         G    B       ", "        B   G         G   B        ", "            G         G            ", "            G         G            ", "            G         G            "}, {"            G         G            ", "            G         G            ", "            G         G            ", "            G         G            ", "        B   G         G   B        ", "       B    G         G    B       ", " B     C    G         G    C     B ", "AAC   BC X  G         G  X CB   CAA", "AAC   BC X  G         G  X CB   CAA", "AAC   BC X  G         G  X CB   CAA", " B     C    G         G    C     B ", "       B    G         G    B       ", "        B   G         G   B        ", "            G         G            ", "            G         G            ", "            G         G            "}, {"           G           G           ", "           G    D D    G           ", "           G           G           ", "        B  G    D D    G  B        ", "       B   G           G   B       ", "       C   G    D D    G   C       ", " B    BC X G           G X CB    B ", "AAC   FAAD G    D D    G DAAF   CAA", "AAC  AAAAE G           G EAAAA  CAA", "AAC   FAAD G    D D    G DAAF   CAA", " B    BC X G           G X CB    B ", "       C   G    D D    G   C       ", "       B   G           G   B       ", "        B  G    D D    G  B        ", "           G           G           ", "           G    D D    G           "}, {"           G     E     G           ", "           G     E     G           ", "           G     E     G           ", "        B  G     E     G  B        ", "       B   G     E     G   B       ", "       C   G     E     G   C       ", " B    BC X G     E     G X CB    B ", "AAC  AAAAE G     E     G EAAAA  CAA", "AAC  DACCE G     E     G ECCAD  CAA", "AAC  AAAAE G     E     G EAAAA  CAA", " B    BC X G     E     G X CB    B ", "       C   G     E     G   C       ", "       B   G     E     G   B       ", "        B  G     E     G  B        ", "           G     E     G           ", "           G     E     G           "}, {"           G           G           ", "           G    D D    G           ", "           G           G           ", "        B  G    D D    G  B        ", "       B   G           G   B       ", "       C   G    D D    G   C       ", " B    BC X G           G X CB    B ", "AAC   FAAD G    D D    G DAAF   CAA", "AAC  AAAAE G           G EAAAA  CAA", "AAC   FAAD G    D D    G DAAF   CAA", " B    BC X G           G X CB    B ", "       C   G    D D    G   C       ", "       B   G           G   B       ", "        B  G    D D    G  B        ", "           G           G           ", "           G    D D    G           "}, {"            G         G            ", "            G         G            ", "            G         G            ", "            G         G            ", "        B   G         G   B        ", "       B    G         G    B       ", " B     C    G         G    C     B ", "AAC   BC X  G         G  X CB   CAA", "AAC   BC X  G         G  X CB   CAA", "AAC   BC X  G         G  X CB   CAA", " B     C    G         G    C     B ", "       B    G         G    B       ", "        B   G         G   B        ", "            G         G            ", "            G         G            ", "            G         G            "}, {"            G         G            ", "            G         G            ", "            G         G            ", "            G         G            ", "        B   G         G   B        ", "       B    G         G    B       ", "  B    B    G         G    B    B  ", " AAC   C    G         G    C   CAA ", " AAC   C    G         G    C   CAA ", " AAC   C    G         G    C   CAA ", "  B    B    G         G    B    B  ", "       B    G         G    B       ", "        B   G         G   B        ", "            G         G            ", "            G         G            ", "            G         G            "}, {"             G       G             ", "             G       G             ", "             G       G             ", "             G       G             ", "             G       G             ", "        B    G       G    B        ", "  B     B    G       G    B     B  ", " AAC   B     G       G     B   CAA ", " AAC   B     G       G     B   CAA ", " AAC   B     G       G     B   CAA ", "  B     B    G       G    B     B  ", "        B    G       G    B        ", "             G       G             ", "             G       G             ", "             G       G             ", "             G       G             "}, {"              GG   GG              ", "              GG   GG              ", "              GG   GG              ", "              GG   GG              ", "              GG   GG              ", "              GG   GG              ", "  B           GG   GG           B  ", " AAC    B     GG   GG     B    CAA ", " AAC    B     GG   GG     B    CAA ", " AAC    B     GG   GG     B    CAA ", "  B           GG   GG           B  ", "              GG   GG              ", "              GG   GG              ", "              GG   GG              ", "              GG   GG              ", "              GG   GG              "}, {"                GGG                ", "                GGG                ", "                GGG                ", "                GGG                ", "                GGG                ", "                GGG                ", "   B            GGG            B   ", "  AAC           GGG           CAA  ", "  AAC           GGG           CAA  ", "  AAC           GGG           CAA  ", "   B            GGG            B   ", "                GGG                ", "                GGG                ", "                GGG                ", "                GGG                ", "                GGG                "}, {"                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "   B                           B   ", "  AAC                         CAA  ", "  AAC                         CAA  ", "  AAC                         CAA  ", "   B                           B   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   "}, {"                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "    B           XXX           B    ", "   AAC         XDEDX         CAA   ", "   AAC         XEEEX         CAA   ", "   AAC         XDEDX         CAA   ", "    B           XXX           B    ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   "}, {"                                   ", "                                   ", "                                   ", "                BBB                ", "              BB   BB              ", "             B       B             ", "    B        B       B        B    ", "   AAC      B   AAA   B      CAA   ", "   AAC      B   ACA   B      CAA   ", "   AAC      B   AAA   B      CAA   ", "    B        B       B        B    ", "             B       B             ", "              BB   BB              ", "                BBB                ", "                                   ", "                                   "}, {"                                   ", "                                   ", "                                   ", "                                   ", "                BBB                ", "              BBCCCBB              ", "     B        BCCCCCB        B     ", "    AAC      BCCAAACCB      CAA    ", "    AAC      BCCACACCB      CAA    ", "    AAC      BCCAAACCB      CAA    ", "     B        BCCCCCB        B     ", "              BBCCCBB              ", "                BBB                ", "                                   ", "                                   ", "                                   "}, {"                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "      B         BBB         B      ", "     AAC       BFAFB       CAA     ", "     AAC       BAAAB       CAA     ", "     AAC       BFAFB       CAA     ", "      B         BBB         B      ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   "}, {"                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "       B                   B       ", "      AACC       A       CCAA      ", "      AACC      ADA      CCAA      ", "      AACC       A       CCAA      ", "       B                   B       ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   "}, {"                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "        BB               BB        ", "       AAACC           CCAAA       ", "       AAACC           CCAAA       ", "       AAACC           CCAAA       ", "        BB               BB        ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   "}, {"                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "          BB           BB          ", "        AAAACCC     CCCAAAA        ", "        AAAACCC     CCCAAAA        ", "        AAAACCC     CCCAAAA        ", "          BB           BB          ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   "}, {"                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "            BBB     BBB            ", "          AAAAACCCCCAAAAA          ", "          AAAAACCCCCAAAAA          ", "          AAAAACCCCCAAAAA          ", "            BBB     BBB            ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   "}, {"                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "               BBBBB               ", "            AAAAAAAAAAA            ", "            AAAAAAAAAAA            ", "            AAAAAAAAAAA            ", "               BBBBB               ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   "}, {"                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "               AAAAA               ", "               AAAAA               ", "               AAAAA               ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   "}};
        shapeRing_SpaceTimeConstraintor = new String[][]{{"                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "               AAAAA               ", "               AAAAA               ", "               AAAAA               ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   "}, {"                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "               BBBBB               ", "            AAAAAAAAAAA            ", "            AAAAAAAAAAA            ", "            AAAAAAAAAAA            ", "               BBBBB               ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   "}, {"                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "            BBB     BBB            ", "          AAAAACCCCCAAAAA          ", "          AAAAACCCCCAAAAA          ", "          AAAAACCCCCAAAAA          ", "            BBB     BBB            ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   "}, {"                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "          BB           BB          ", "        AAAACCC     CCCAAAA        ", "        AAAACCC     CCCAAAA        ", "        AAAACCC     CCCAAAA        ", "          BB           BB          ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   "}, {"                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "        BB               BB        ", "       AAACC           CCAAA       ", "       AAACC           CCAAA       ", "       AAACC           CCAAA       ", "        BB               BB        ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   "}, {"                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "       B                   B       ", "      AACC       A       CCAA      ", "      AACC      ADA      CCAA      ", "      AACC       A       CCAA      ", "       B                   B       ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   "}, {"                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "      B         BBB         B      ", "     AAC       BFAFB       CAA     ", "     AAC       BAAAB       CAA     ", "     AAC       BFAFB       CAA     ", "      B         BBB         B      ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   "}, {"                                   ", "                                   ", "                                   ", "                                   ", "                BBB                ", "              BBCCCBB              ", "     B        BCCCCCB        B     ", "    AAC      BCCAAACCB      CAA    ", "    AAC      BCCACACCB      CAA    ", "    AAC      BCCAAACCB      CAA    ", "     B        BCCCCCB        B     ", "              BBCCCBB              ", "                BBB                ", "                                   ", "                                   ", "                                   "}, {"                                   ", "                                   ", "                                   ", "                BBB                ", "              BB   BB              ", "             B       B             ", "    B        B       B        B    ", "   AAC      B   AAA   B      CAA   ", "   AAC      B   ACA   B      CAA   ", "   AAC      B   AAA   B      CAA   ", "    B        B       B        B    ", "             B       B             ", "              BB   BB              ", "                BBB                ", "                                   ", "                                   "}, {"                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "    B           YYY           B    ", "   AAC         YDEDY         CAA   ", "   AAC         YEEEY         CAA   ", "   AAC         YDEDY         CAA   ", "    B           YYY           B    ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   "}, {"                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "   B                           B   ", "  AAC                         CAA  ", "  AAC                         CAA  ", "  AAC                         CAA  ", "   B                           B   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   "}, {"                GGG                ", "                GGG                ", "                GGG                ", "                GGG                ", "                GGG                ", "                GGG                ", "   B            GGG            B   ", "  AAC           GGG           CAA  ", "  AAC           GGG           CAA  ", "  AAC           GGG           CAA  ", "   B            GGG            B   ", "                GGG                ", "                GGG                ", "                GGG                ", "                GGG                ", "                GGG                "}, {"              GG   GG              ", "              GG   GG              ", "              GG   GG              ", "              GG   GG              ", "              GG   GG              ", "              GG   GG              ", "  B           GG   GG           B  ", " AAC    B     GG   GG     B    CAA ", " AAC    B     GG   GG     B    CAA ", " AAC    B     GG   GG     B    CAA ", "  B           GG   GG           B  ", "              GG   GG              ", "              GG   GG              ", "              GG   GG              ", "              GG   GG              ", "              GG   GG              "}, {"             G       G             ", "             G       G             ", "             G       G             ", "             G       G             ", "             G       G             ", "        B    G       G    B        ", "  B     B    G       G    B     B  ", " AAC   B     G       G     B   CAA ", " AAC   B     G       G     B   CAA ", " AAC   B     G       G     B   CAA ", "  B     B    G       G    B     B  ", "        B    G       G    B        ", "             G       G             ", "             G       G             ", "             G       G             ", "             G       G             "}, {"            G         G            ", "            G         G            ", "            G         G            ", "            G         G            ", "        B   G         G   B        ", "       B    G         G    B       ", "  B    B    G         G    B    B  ", " AAC   C    G         G    C   CAA ", " AAC   C    G         G    C   CAA ", " AAC   C    G         G    C   CAA ", "  B    B    G         G    B    B  ", "       B    G         G    B       ", "        B   G         G   B        ", "            G         G            ", "            G         G            ", "            G         G            "}, {"            G         G            ", "            G         G            ", "            G         G            ", "            G         G            ", "        B   G         G   B        ", "       B    G         G    B       ", " B     C    G         G    C     B ", "AAC   BC Y  G         G  Y CB   CAA", "AAC   BC Y  G         G  Y CB   CAA", "AAC   BC Y  G         G  Y CB   CAA", " B     C    G         G    C     B ", "       B    G         G    B       ", "        B   G         G   B        ", "            G         G            ", "            G         G            ", "            G         G            "}, {"           G           G           ", "           G    D D    G           ", "           G           G           ", "        B  G    D D    G  B        ", "       B   G           G   B       ", "       C   G    D D    G   C       ", " B    BC Y G           G Y CB    B ", "AAC   FAAD G    D D    G DAAF   CAA", "AAC  AAAAE G           G EAAAA  CAA", "AAC   FAAD G    D D    G DAAF   CAA", " B    BC Y G           G Y CB    B ", "       C   G    D D    G   C       ", "       B   G           G   B       ", "        B  G    D D    G  B        ", "           G           G           ", "           G    D D    G           "}, {"           G     E     G           ", "           G     E     G           ", "           G     E     G           ", "        B  G     E     G  B        ", "       B   G     E     G   B       ", "       C   G     E     G   C       ", " B    BC Y G     E     G Y CB    B ", "AAC  AAAAE G     E     G EAAAA  CAA", "AAC  DACCE G     E     G ECCAD  CAA", "AAC  AAAAE G     E     G EAAAA  CAA", " B    BC Y G     E     G Y CB    B ", "       C   G     E     G   C       ", "       B   G     E     G   B       ", "        B  G     E     G  B        ", "           G     E     G           ", "           G     E     G           "}, {"           G           G           ", "           G    D D    G           ", "           G           G           ", "        B  G    D D    G  B        ", "       B   G           G   B       ", "       C   G    D D    G   C       ", " B    BC Y G           G Y CB    B ", "AAC   FAAD G    D D    G DAAF   CAA", "AAC  AAAAE G           G EAAAA  CAA", "AAC   FAAD G    D D    G DAAF   CAA", " B    BC Y G           G Y CB    B ", "       C   G    D D    G   C       ", "       B   G           G   B       ", "        B  G    D D    G  B        ", "           G           G           ", "           G    D D    G           "}, {"            G         G            ", "            G         G            ", "            G         G            ", "            G         G            ", "        B   G         G   B        ", "       B    G         G    B       ", " B     C    G         G    C     B ", "AAC   BC Y  G         G  Y CB   CAA", "AAC   BC Y  G         G  Y CB   CAA", "AAC   BC Y  G         G  Y CB   CAA", " B     C    G         G    C     B ", "       B    G         G    B       ", "        B   G         G   B        ", "            G         G            ", "            G         G            ", "            G         G            "}, {"            G         G            ", "            G         G            ", "            G         G            ", "            G         G            ", "        B   G         G   B        ", "       B    G         G    B       ", "  B    B    G         G    B    B  ", " AAC   C    G         G    C   CAA ", " AAC   C    G         G    C   CAA ", " AAC   C    G         G    C   CAA ", "  B    B    G         G    B    B  ", "       B    G         G    B       ", "        B   G         G   B        ", "            G         G            ", "            G         G            ", "            G         G            "}, {"             G       G             ", "             G       G             ", "             G       G             ", "             G       G             ", "             G       G             ", "        B    G       G    B        ", "  B     B    G       G    B     B  ", " AAC   B     G       G     B   CAA ", " AAC   B     G       G     B   CAA ", " AAC   B     G       G     B   CAA ", "  B     B    G       G    B     B  ", "        B    G       G    B        ", "             G       G             ", "             G       G             ", "             G       G             ", "             G       G             "}, {"              GG   GG              ", "              GG   GG              ", "              GG   GG              ", "              GG   GG              ", "              GG   GG              ", "              GG   GG              ", "  B           GG   GG           B  ", " AAC    B     GG   GG     B    CAA ", " AAC    B     GG   GG     B    CAA ", " AAC    B     GG   GG     B    CAA ", "  B           GG   GG           B  ", "              GG   GG              ", "              GG   GG              ", "              GG   GG              ", "              GG   GG              ", "              GG   GG              "}, {"                GGG                ", "                GGG                ", "                GGG                ", "                GGG                ", "                GGG                ", "                GGG                ", "   B            GGG            B   ", "  AAC           GGG           CAA  ", "  AAC           GGG           CAA  ", "  AAC           GGG           CAA  ", "   B            GGG            B   ", "                GGG                ", "                GGG                ", "                GGG                ", "                GGG                ", "                GGG                "}, {"                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "   B                           B   ", "  AAC                         CAA  ", "  AAC                         CAA  ", "  AAC                         CAA  ", "   B                           B   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   "}, {"                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "    B           YYY           B    ", "   AAC         YDEDY         CAA   ", "   AAC         YEEEY         CAA   ", "   AAC         YDEDY         CAA   ", "    B           YYY           B    ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   "}, {"                                   ", "                                   ", "                                   ", "                BBB                ", "              BB   BB              ", "             B       B             ", "    B        B       B        B    ", "   AAC      B   AAA   B      CAA   ", "   AAC      B   ACA   B      CAA   ", "   AAC      B   AAA   B      CAA   ", "    B        B       B        B    ", "             B       B             ", "              BB   BB              ", "                BBB                ", "                                   ", "                                   "}, {"                                   ", "                                   ", "                                   ", "                                   ", "                BBB                ", "              BBCCCBB              ", "     B        BCCCCCB        B     ", "    AAC      BCCAAACCB      CAA    ", "    AAC      BCCACACCB      CAA    ", "    AAC      BCCAAACCB      CAA    ", "     B        BCCCCCB        B     ", "              BBCCCBB              ", "                BBB                ", "                                   ", "                                   ", "                                   "}, {"                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "      B         BBB         B      ", "     AAC       BFAFB       CAA     ", "     AAC       BAAAB       CAA     ", "     AAC       BFAFB       CAA     ", "      B         BBB         B      ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   "}, {"                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "       B                   B       ", "      AACC       A       CCAA      ", "      AACC      ADA      CCAA      ", "      AACC       A       CCAA      ", "       B                   B       ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   "}, {"                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "        BB               BB        ", "       AAACC           CCAAA       ", "       AAACC           CCAAA       ", "       AAACC           CCAAA       ", "        BB               BB        ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   "}, {"                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "          BB           BB          ", "        AAAACCC     CCCAAAA        ", "        AAAACCC     CCCAAAA        ", "        AAAACCC     CCCAAAA        ", "          BB           BB          ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   "}, {"                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "            BBB     BBB            ", "          AAAAACCCCCAAAAA          ", "          AAAAACCCCCAAAAA          ", "          AAAAACCCCCAAAAA          ", "            BBB     BBB            ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   "}, {"                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "               BBBBB               ", "            AAAAAAAAAAA            ", "            AAAAAAAAAAA            ", "            AAAAAAAAAAA            ", "               BBBBB               ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   "}, {"                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "               AAAAA               ", "               AAAAA               ", "               AAAAA               ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   "}};
        shapeRing_SpaceTimeMerger = new String[][]{{"                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "               AAAAA               ", "               AAAAA               ", "               AAAAA               ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   "}, {"                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "               BBBBB               ", "            AAAAAAAAAAA            ", "            AAAAAAAAAAA            ", "            AAAAAAAAAAA            ", "               BBBBB               ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   "}, {"                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "            BBB     BBB            ", "          AAAAACCCCCAAAAA          ", "          AAAAACCCCCAAAAA          ", "          AAAAACCCCCAAAAA          ", "            BBB     BBB            ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   "}, {"                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "          BB           BB          ", "        AAAACCC     CCCAAAA        ", "        AAAACCC     CCCAAAA        ", "        AAAACCC     CCCAAAA        ", "          BB           BB          ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   "}, {"                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "        BB               BB        ", "       AAACC           CCAAA       ", "       AAACC           CCAAA       ", "       AAACC           CCAAA       ", "        BB               BB        ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   "}, {"                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "       B                   B       ", "      AACC       A       CCAA      ", "      AACC      ADA      CCAA      ", "      AACC       A       CCAA      ", "       B                   B       ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   "}, {"                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "      B         BBB         B      ", "     AAC       BFAFB       CAA     ", "     AAC       BAAAB       CAA     ", "     AAC       BFAFB       CAA     ", "      B         BBB         B      ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   "}, {"                                   ", "                                   ", "                                   ", "                                   ", "                BBB                ", "              BBCCCBB              ", "     B        BCCCCCB        B     ", "    AAC      BCCAAACCB      CAA    ", "    AAC      BCCACACCB      CAA    ", "    AAC      BCCAAACCB      CAA    ", "     B        BCCCCCB        B     ", "              BBCCCBB              ", "                BBB                ", "                                   ", "                                   ", "                                   "}, {"                                   ", "                                   ", "                                   ", "                BBB                ", "              BB   BB              ", "             B       B             ", "    B        B       B        B    ", "   AAC      B   AAA   B      CAA   ", "   AAC      B   ACA   B      CAA   ", "   AAC      B   AAA   B      CAA   ", "    B        B       B        B    ", "             B       B             ", "              BB   BB              ", "                BBB                ", "                                   ", "                                   "}, {"                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "    B           ZZZ           B    ", "   AAC         ZDEDZ         CAA   ", "   AAC         ZEEEZ         CAA   ", "   AAC         ZDEDZ         CAA   ", "    B           ZZZ           B    ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   "}, {"                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "   B                           B   ", "  AAC                         CAA  ", "  AAC                         CAA  ", "  AAC                         CAA  ", "   B                           B   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   "}, {"                GGG                ", "                GGG                ", "                GGG                ", "                GGG                ", "                GGG                ", "                GGG                ", "   B            GGG            B   ", "  AAC           GGG           CAA  ", "  AAC           GGG           CAA  ", "  AAC           GGG           CAA  ", "   B            GGG            B   ", "                GGG                ", "                GGG                ", "                GGG                ", "                GGG                ", "                GGG                "}, {"              GG   GG              ", "              GG   GG              ", "              GG   GG              ", "              GG   GG              ", "              GG   GG              ", "              GG   GG              ", "  B           GG   GG           B  ", " AAC    B     GG   GG     B    CAA ", " AAC    B     GG   GG     B    CAA ", " AAC    B     GG   GG     B    CAA ", "  B           GG   GG           B  ", "              GG   GG              ", "              GG   GG              ", "              GG   GG              ", "              GG   GG              ", "              GG   GG              "}, {"             G       G             ", "             G       G             ", "             G       G             ", "             G       G             ", "             G       G             ", "        B    G       G    B        ", "  B     B    G       G    B     B  ", " AAC   B     G       G     B   CAA ", " AAC   B     G       G     B   CAA ", " AAC   B     G       G     B   CAA ", "  B     B    G       G    B     B  ", "        B    G       G    B        ", "             G       G             ", "             G       G             ", "             G       G             ", "             G       G             "}, {"            G         G            ", "            G         G            ", "            G         G            ", "            G         G            ", "        B   G         G   B        ", "       B    G         G    B       ", "  B    B    G         G    B    B  ", " AAC   C    G         G    C   CAA ", " AAC   C    G         G    C   CAA ", " AAC   C    G         G    C   CAA ", "  B    B    G         G    B    B  ", "       B    G         G    B       ", "        B   G         G   B        ", "            G         G            ", "            G         G            ", "            G         G            "}, {"            G         G            ", "            G         G            ", "            G         G            ", "            G         G            ", "        B   G         G   B        ", "       B    G         G    B       ", " B     C    G         G    C     B ", "AAC   BC Z  G         G  Z CB   CAA", "AAC   BC Z  G         G  Z CB   CAA", "AAC   BC Z  G         G  Z CB   CAA", " B     C    G         G    C     B ", "       B    G         G    B       ", "        B   G         G   B        ", "            G         G            ", "            G         G            ", "            G         G            "}, {"           G           G           ", "           G    D D    G           ", "           G           G           ", "        B  G    D D    G  B        ", "       B   G           G   B       ", "       C   G    D D    G   C       ", " B    BC Z G           G Z CB    B ", "AAC   FAAD G    D D    G DAAF   CAA", "AAC  AAAAE G           G EAAAA  CAA", "AAC   FAAD G    D D    G DAAF   CAA", " B    BC Z G           G Z CB    B ", "       C   G    D D    G   C       ", "       B   G           G   B       ", "        B  G    D D    G  B        ", "           G           G           ", "           G    D D    G           "}, {"           G     E     G           ", "           G     E     G           ", "           G     E     G           ", "        B  G     E     G  B        ", "       B   G     E     G   B       ", "       C   G     E     G   C       ", " B    BC Z G     E     G Z CB    B ", "AAC  AAAAE G     E     G EAAAA  CAA", "AAC  DACCE G     E     G ECCAD  CAA", "AAC  AAAAE G     E     G EAAAA  CAA", " B    BC Z G     E     G Z CB    B ", "       C   G     E     G   C       ", "       B   G     E     G   B       ", "        B  G     E     G  B        ", "           G     E     G           ", "           G     E     G           "}, {"           G           G           ", "           G    D D    G           ", "           G           G           ", "        B  G    D D    G  B        ", "       B   G           G   B       ", "       C   G    D D    G   C       ", " B    BC Z G           G Z CB    B ", "AAC   FAAD G    D D    G DAAF   CAA", "AAC  AAAAE G           G EAAAA  CAA", "AAC   FAAD G    D D    G DAAF   CAA", " B    BC Z G           G Z CB    B ", "       C   G    D D    G   C       ", "       B   G           G   B       ", "        B  G    D D    G  B        ", "           G           G           ", "           G    D D    G           "}, {"            G         G            ", "            G         G            ", "            G         G            ", "            G         G            ", "        B   G         G   B        ", "       B    G         G    B       ", " B     C    G         G    C     B ", "AAC   BC Z  G         G  Z CB   CAA", "AAC   BC Z  G         G  Z CB   CAA", "AAC   BC Z  G         G  Z CB   CAA", " B     C    G         G    C     B ", "       B    G         G    B       ", "        B   G         G   B        ", "            G         G            ", "            G         G            ", "            G         G            "}, {"            G         G            ", "            G         G            ", "            G         G            ", "            G         G            ", "        B   G         G   B        ", "       B    G         G    B       ", "  B    B    G         G    B    B  ", " AAC   C    G         G    C   CAA ", " AAC   C    G         G    C   CAA ", " AAC   C    G         G    C   CAA ", "  B    B    G         G    B    B  ", "       B    G         G    B       ", "        B   G         G   B        ", "            G         G            ", "            G         G            ", "            G         G            "}, {"             G       G             ", "             G       G             ", "             G       G             ", "             G       G             ", "             G       G             ", "        B    G       G    B        ", "  B     B    G       G    B     B  ", " AAC   B     G       G     B   CAA ", " AAC   B     G       G     B   CAA ", " AAC   B     G       G     B   CAA ", "  B     B    G       G    B     B  ", "        B    G       G    B        ", "             G       G             ", "             G       G             ", "             G       G             ", "             G       G             "}, {"              GG   GG              ", "              GG   GG              ", "              GG   GG              ", "              GG   GG              ", "              GG   GG              ", "              GG   GG              ", "  B           GG   GG           B  ", " AAC    B     GG   GG     B    CAA ", " AAC    B     GG   GG     B    CAA ", " AAC    B     GG   GG     B    CAA ", "  B           GG   GG           B  ", "              GG   GG              ", "              GG   GG              ", "              GG   GG              ", "              GG   GG              ", "              GG   GG              "}, {"                GGG                ", "                GGG                ", "                GGG                ", "                GGG                ", "                GGG                ", "                GGG                ", "   B            GGG            B   ", "  AAC           GGG           CAA  ", "  AAC           GGG           CAA  ", "  AAC           GGG           CAA  ", "   B            GGG            B   ", "                GGG                ", "                GGG                ", "                GGG                ", "                GGG                ", "                GGG                "}, {"                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "   B                           B   ", "  AAC                         CAA  ", "  AAC                         CAA  ", "  AAC                         CAA  ", "   B                           B   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   "}, {"                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "    B           ZZZ           B    ", "   AAC         ZDEDZ         CAA   ", "   AAC         ZEEEZ         CAA   ", "   AAC         ZDEDZ         CAA   ", "    B           ZZZ           B    ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   "}, {"                                   ", "                                   ", "                                   ", "                BBB                ", "              BB   BB              ", "             B       B             ", "    B        B       B        B    ", "   AAC      B   AAA   B      CAA   ", "   AAC      B   ACA   B      CAA   ", "   AAC      B   AAA   B      CAA   ", "    B        B       B        B    ", "             B       B             ", "              BB   BB              ", "                BBB                ", "                                   ", "                                   "}, {"                                   ", "                                   ", "                                   ", "                                   ", "                BBB                ", "              BBCCCBB              ", "     B        BCCCCCB        B     ", "    AAC      BCCAAACCB      CAA    ", "    AAC      BCCACACCB      CAA    ", "    AAC      BCCAAACCB      CAA    ", "     B        BCCCCCB        B     ", "              BBCCCBB              ", "                BBB                ", "                                   ", "                                   ", "                                   "}, {"                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "      B         BBB         B      ", "     AAC       BFAFB       CAA     ", "     AAC       BAAAB       CAA     ", "     AAC       BFAFB       CAA     ", "      B         BBB         B      ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   "}, {"                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "       B                   B       ", "      AACC       A       CCAA      ", "      AACC      ADA      CCAA      ", "      AACC       A       CCAA      ", "       B                   B       ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   "}, {"                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "        BB               BB        ", "       AAACC           CCAAA       ", "       AAACC           CCAAA       ", "       AAACC           CCAAA       ", "        BB               BB        ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   "}, {"                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "          BB           BB          ", "        AAAACCC     CCCAAAA        ", "        AAAACCC     CCCAAAA        ", "        AAAACCC     CCCAAAA        ", "          BB           BB          ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   "}, {"                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "            BBB     BBB            ", "          AAAAACCCCCAAAAA          ", "          AAAAACCCCCAAAAA          ", "          AAAAACCCCCAAAAA          ", "            BBB     BBB            ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   "}, {"                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "               BBBBB               ", "            AAAAAAAAAAA            ", "            AAAAAAAAAAA            ", "            AAAAAAAAAAA            ", "               BBBBB               ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   "}, {"                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "               AAAAA               ", "               AAAAA               ", "               AAAAA               ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   ", "                                   "}};
        shapeEnd = new String[][]{{"                 ", "                 ", "       CCC       ", "                 "}, {"                 ", "       BBB       ", "     CCAAACC     ", "       BBB       "}, {"       GGG       ", "     BBGGGBB     ", "    CAACCCAAC    ", "     BBBFBBB     "}, {"     GG   GG     ", "    BGG   GGB    ", "   CACCCCCCCAC   ", "    BBBBBBBBB    "}, {"    G       G    ", "   BG       GB   ", "  CACCCCFCCCCAC  ", "   BBBBBBBBBBB   "}, {"   G         G   ", "  BG         GB  ", " CACCFCCCCCFCCAC ", "  BBBFBBBBBFBBB  "}, {"   G         G   ", "  BG         GB  ", " CACCCCCCCCCCCAC ", "  BBBBBBBBBBBBB  "}, {"  G           G  ", " BG    D D    GB ", "CACCCCCCCCCCCCCAC", " BBBBBBBBBBBBBBB "}, {"  G     E     G  ", " BG     E     GB ", "CACCFCCCCCCCFCCAC", " BFBBBBBBBBBBBFB "}, {"  G           G  ", " BG    D D    GB ", "CACCCCCCCCCCCCCAC", " BBBBBBBBBBBBBBB "}, {"   G         G   ", "  BG         GB  ", " CACCCCCCCCCCCAC ", "  BBBBBBBBBBBBB  "}, {"   G         G   ", "  BG         GB  ", " CACCFCCCCCFCCAC ", "  BBBFBBBBBFBBB  "}, {"    G       G    ", "   BG       GB   ", "  CACCCCFCCCCAC  ", "   BBBBBBBBBBB   "}, {"     GG   GG     ", "    BGG   GGB    ", "   CACCCCCCCAC   ", "    BBBBBBBBB    "}, {"       GGG       ", "     BBGGGBB     ", "    CAACCCAAC    ", "     BBBFBBB     "}, {"                 ", "       BBB       ", "     CCAAACC     ", "       BBB       "}, {"                 ", "                 ", "       CCC       ", "                 "}};
    }
}

