/*
 * Decompiled with CFR 0.152.
 */
package com.Nxer.TwistSpaceTechnology.system.OreProcess.logic;

import bartworks.system.material.WerkstoffLoader;
import com.Nxer.TwistSpaceTechnology.TwistSpaceTechnology;
import com.Nxer.TwistSpaceTechnology.common.recipeMap.GTCMRecipe;
import com.Nxer.TwistSpaceTechnology.system.OreProcess.logic.OP_Bartworks_OreHandler;
import com.Nxer.TwistSpaceTechnology.system.OreProcess.logic.OP_GTPP_OreHandler;
import com.Nxer.TwistSpaceTechnology.util.recipes.TST_RecipeBuilder;
import com.google.common.collect.Sets;
import goodgenerator.items.GGMaterial;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.util.GTModHandler;
import gregtech.api.util.GTOreDictUnificator;
import gregtech.api.util.GTUtility;
import gtnhlanth.common.register.WerkstoffMaterialPool;
import ic2.core.Ic2Items;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;

public class OP_NormalProcessing {
    public static final Set<OrePrefixes> basicStoneTypes = Sets.newHashSet((Object[])new OrePrefixes[]{OrePrefixes.ore, OrePrefixes.oreBasalt, OrePrefixes.oreBlackgranite, OrePrefixes.oreRedgranite, OrePrefixes.oreMarble, OrePrefixes.oreNetherrack, OrePrefixes.oreEndstone});
    public static final Set<OrePrefixes> basicStoneTypesExceptNormalStone = Sets.newHashSet((Object[])new OrePrefixes[]{OrePrefixes.oreBasalt, OrePrefixes.oreBlackgranite, OrePrefixes.oreRedgranite, OrePrefixes.oreMarble, OrePrefixes.oreNetherrack, OrePrefixes.oreEndstone});
    public static final Map<Materials, ItemStack> processingLineMaterials = new HashMap<Materials, ItemStack>();

    public static void initProcessingLineMaterials() {
        processingLineMaterials.put(Materials.Platinum, WerkstoffLoader.PTMetallicPowder.get(OrePrefixes.dust, 1));
        processingLineMaterials.put(Materials.Palladium, WerkstoffLoader.PDMetallicPowder.get(OrePrefixes.dust, 1));
        processingLineMaterials.put(Materials.Iridium, WerkstoffLoader.IrLeachResidue.get(OrePrefixes.dust, 1));
        processingLineMaterials.put(Materials.Osmium, WerkstoffLoader.IrOsLeachResidue.get(OrePrefixes.dust, 1));
        processingLineMaterials.put(Materials.Samarium, WerkstoffMaterialPool.SamariumOreConcentrate.get(OrePrefixes.dust, 1));
        processingLineMaterials.put(Materials.Cerium, WerkstoffMaterialPool.CeriumOreConcentrate.get(OrePrefixes.dust, 1));
    }

    public static ItemStack getDustStack(Materials material, int amount) {
        ItemStack t = processingLineMaterials.get(material);
        if (t != null) {
            return GTUtility.copyAmountUnsafe((int)(amount * 3), (ItemStack)t);
        }
        return GTUtility.copyAmountUnsafe((int)amount, (ItemStack)GTOreDictUnificator.get((OrePrefixes)OrePrefixes.dust, (Object)material, (long)1L));
    }

    public static void enumOreProcessingRecipes() {
        OP_NormalProcessing.initProcessingLineMaterials();
        HashSet specialProcesses = Sets.newHashSet((Object[])new Materials[]{Materials.Samarium, Materials.Cerium, Materials.Naquadah, Materials.NaquadahEnriched, Materials.Naquadria});
        for (int i = 0; i < GregTechAPI.sGeneratedMaterials.length; ++i) {
            if (GregTechAPI.sGeneratedMaterials[i] == null) continue;
            Materials material = GregTechAPI.sGeneratedMaterials[i];
            if (!specialProcesses.isEmpty() && specialProcesses.contains(material)) {
                specialProcesses.remove(material);
                continue;
            }
            OP_NormalProcessing.processOreRecipe(material, i);
        }
        OP_GTPP_OreHandler.processGTPPOreRecipes();
        OP_Bartworks_OreHandler.processBWOreRecipes();
        OP_NormalProcessing.processSpecialOreRecipe();
    }

    public static void processSpecialOreRecipe() {
        ItemStack[] outputs = new ItemStack[]{WerkstoffMaterialPool.CeriumOreConcentrate.get(OrePrefixes.dust, 11)};
        ItemStack[] outputsRich = new ItemStack[]{WerkstoffMaterialPool.CeriumOreConcentrate.get(OrePrefixes.dust, 22)};
        OP_NormalProcessing.registryOreProcessRecipe(GTOreDictUnificator.get((OrePrefixes)OrePrefixes.rawOre, (Object)Materials.Cerium, (long)1L), outputs);
        for (OrePrefixes prefixes : basicStoneTypes) {
            if (GTOreDictUnificator.get((OrePrefixes)prefixes, (Object)Materials.Cerium, (long)1L) == null) continue;
            OP_NormalProcessing.registryOreProcessRecipe(GTOreDictUnificator.get((OrePrefixes)prefixes, (Object)Materials.Cerium, (long)1L), OP_NormalProcessing.isRich(prefixes) ? outputsRich : outputs);
        }
        outputs = new ItemStack[]{WerkstoffMaterialPool.SamariumOreConcentrate.get(OrePrefixes.dust, 11)};
        outputsRich = new ItemStack[]{WerkstoffMaterialPool.SamariumOreConcentrate.get(OrePrefixes.dust, 22)};
        OP_NormalProcessing.registryOreProcessRecipe(GTOreDictUnificator.get((OrePrefixes)OrePrefixes.rawOre, (Object)Materials.Samarium, (long)1L), outputs);
        for (OrePrefixes prefixes : basicStoneTypes) {
            if (GTOreDictUnificator.get((OrePrefixes)prefixes, (Object)Materials.Samarium, (long)1L) == null) continue;
            OP_NormalProcessing.registryOreProcessRecipe(GTOreDictUnificator.get((OrePrefixes)prefixes, (Object)Materials.Samarium, (long)1L), OP_NormalProcessing.isRich(prefixes) ? outputsRich : outputs);
        }
        outputs = new ItemStack[]{GGMaterial.naquadahEarth.get(OrePrefixes.dust, 8), GGMaterial.enrichedNaquadahEarth.get(OrePrefixes.dust, 3)};
        outputsRich = new ItemStack[]{GGMaterial.naquadahEarth.get(OrePrefixes.dust, 16), GGMaterial.enrichedNaquadahEarth.get(OrePrefixes.dust, 8)};
        OP_NormalProcessing.registryOreProcessRecipe(GTOreDictUnificator.get((OrePrefixes)OrePrefixes.rawOre, (Object)Materials.Naquadah, (long)1L), outputs);
        for (OrePrefixes prefixes : basicStoneTypes) {
            if (GTOreDictUnificator.get((OrePrefixes)prefixes, (Object)Materials.Naquadah, (long)1L) == null) continue;
            OP_NormalProcessing.registryOreProcessRecipe(GTOreDictUnificator.get((OrePrefixes)prefixes, (Object)Materials.Naquadah, (long)1L), OP_NormalProcessing.isRich(prefixes) ? outputsRich : outputs);
        }
        outputs = new ItemStack[]{GGMaterial.enrichedNaquadahEarth.get(OrePrefixes.dust, 8), GGMaterial.naquadriaEarth.get(OrePrefixes.dust, 3)};
        outputsRich = new ItemStack[]{GGMaterial.enrichedNaquadahEarth.get(OrePrefixes.dust, 16), GGMaterial.naquadriaEarth.get(OrePrefixes.dust, 6)};
        OP_NormalProcessing.registryOreProcessRecipe(GTOreDictUnificator.get((OrePrefixes)OrePrefixes.rawOre, (Object)Materials.NaquadahEnriched, (long)1L), outputs);
        for (OrePrefixes prefixes : basicStoneTypes) {
            if (GTOreDictUnificator.get((OrePrefixes)prefixes, (Object)Materials.NaquadahEnriched, (long)1L) == null) continue;
            OP_NormalProcessing.registryOreProcessRecipe(GTOreDictUnificator.get((OrePrefixes)prefixes, (Object)Materials.NaquadahEnriched, (long)1L), OP_NormalProcessing.isRich(prefixes) ? outputsRich : outputs);
        }
        outputs = new ItemStack[]{GGMaterial.naquadriaEarth.get(OrePrefixes.dust, 8), GGMaterial.naquadriaEarth.get(OrePrefixes.dust, 3)};
        outputsRich = new ItemStack[]{GGMaterial.naquadriaEarth.get(OrePrefixes.dust, 16), GGMaterial.naquadriaEarth.get(OrePrefixes.dust, 6)};
        OP_NormalProcessing.registryOreProcessRecipe(GTOreDictUnificator.get((OrePrefixes)OrePrefixes.rawOre, (Object)Materials.Naquadria, (long)1L), outputs);
        for (OrePrefixes prefixes : basicStoneTypes) {
            if (GTOreDictUnificator.get((OrePrefixes)prefixes, (Object)Materials.Naquadria, (long)1L) == null) continue;
            OP_NormalProcessing.registryOreProcessRecipe(GTOreDictUnificator.get((OrePrefixes)prefixes, (Object)Materials.Naquadria, (long)1L), OP_NormalProcessing.isRich(prefixes) ? outputsRich : outputs);
        }
        OP_NormalProcessing.processOreRecipe(GTModHandler.getModItem((String)"TConstruct", (String)"SearedBrick", (long)1L, (int)1), Materials.Cobalt, true);
        OP_NormalProcessing.processOreRecipe(GTModHandler.getModItem((String)"TConstruct", (String)"SearedBrick", (long)1L, (int)2), Materials.Ardite, true);
        OP_NormalProcessing.processOreRecipe(GTUtility.copyAmountUnsafe((int)1, (ItemStack)Ic2Items.uraniumOre), Materials.Uranium, false);
        OP_NormalProcessing.registryOreProcessRecipe(GTModHandler.getModItem((String)"HardcoreEnderExpansion", (String)"end_powder_ore", (long)1L), new ItemStack[]{GTModHandler.getModItem((String)"HardcoreEnderExpansion", (String)"end_powder", (long)24L)});
        OP_NormalProcessing.processOreRecipe(new ItemStack(Blocks.field_150366_p), Materials.Iron, false);
    }

    public static void processOreRecipe(Materials material, int ID) {
        if (GTOreDictUnificator.get((OrePrefixes)OrePrefixes.ore, (Object)material, (long)1L) == null) {
            return;
        }
        ItemStack[] outputs = OP_NormalProcessing.getOutputs(material, false);
        ItemStack[] outputsRich = OP_NormalProcessing.getOutputs(material, true);
        OP_NormalProcessing.registryOreProcessRecipe(GTModHandler.getModItem((String)"gregtech", (String)"gt.blockores", (long)1L, (int)ID), outputs);
        OP_NormalProcessing.registryOreProcessRecipe(GTOreDictUnificator.get((OrePrefixes)OrePrefixes.rawOre, (Object)material, (long)1L), outputs);
        for (OrePrefixes prefixes : basicStoneTypesExceptNormalStone) {
            if (GTOreDictUnificator.get((OrePrefixes)prefixes, (Object)material, (long)1L) == null) {
                TwistSpaceTechnology.LOG.info("Failed to get ore: material=" + material + " , prefixes=" + prefixes);
                continue;
            }
            OP_NormalProcessing.registryOreProcessRecipe(GTOreDictUnificator.get((OrePrefixes)prefixes, (Object)material, (long)1L), OP_NormalProcessing.isRich(prefixes) ? outputsRich : outputs);
        }
    }

    public static void processOreRecipe(ItemStack inputOreItems, Materials material, boolean isRich) {
        OP_NormalProcessing.registryOreProcessRecipe(inputOreItems, OP_NormalProcessing.getOutputs(material, isRich));
    }

    public static ItemStack[] getOutputs(Materials material, boolean isRich) {
        ArrayList<ItemStack> outputs = new ArrayList<ItemStack>();
        if (!material.mOreByProducts.isEmpty()) {
            outputs.add(OP_NormalProcessing.getDustStack(material, 4));
            if (material.mOreByProducts.size() == 1) {
                for (Materials byproduct : material.mOreByProducts) {
                    if (byproduct == null) continue;
                    outputs.add(OP_NormalProcessing.getDustStack(byproduct, 3));
                }
            } else {
                for (Materials byproduct : material.mOreByProducts) {
                    if (byproduct == null || byproduct == Materials.Netherrack || byproduct == Materials.Endstone || byproduct == Materials.Stone) continue;
                    outputs.add(OP_NormalProcessing.getDustStack(byproduct, 2));
                }
            }
        } else {
            outputs.add(OP_NormalProcessing.getDustStack(material, 8));
        }
        if (GTOreDictUnificator.get((OrePrefixes)OrePrefixes.gem, (Object)material, (long)1L) != null) {
            if (GTOreDictUnificator.get((OrePrefixes)OrePrefixes.gemExquisite, (Object)material, (long)1L) != null) {
                outputs.add(GTOreDictUnificator.get((OrePrefixes)OrePrefixes.gemExquisite, (Object)material, (long)1L));
                outputs.add(GTOreDictUnificator.get((OrePrefixes)OrePrefixes.gemFlawless, (Object)material, (long)2L));
                outputs.add(GTOreDictUnificator.get((OrePrefixes)OrePrefixes.gem, (Object)material, (long)2L));
            } else {
                outputs.add(GTOreDictUnificator.get((OrePrefixes)OrePrefixes.gem, (Object)material, (long)4L));
            }
        }
        if (isRich) {
            for (ItemStack out : outputs) {
                out.field_77994_a *= 2;
            }
        }
        return outputs.toArray(new ItemStack[0]);
    }

    public static void registryOreProcessRecipe(ItemStack input, ItemStack[] output) {
        if (input == null) {
            return;
        }
        TST_RecipeBuilder.builder().itemInputs(input).itemOutputs(output).fluidInputs(Materials.Lubricant.getFluid(1L)).noOptimize().eut(30).duration(128).addTo(GTCMRecipe.OreProcessingRecipes);
    }

    public static boolean isRich(OrePrefixes prefixes) {
        return prefixes == OrePrefixes.oreNetherrack || prefixes == OrePrefixes.oreEndstone;
    }
}

