/*
 * Decompiled with CFR 0.152.
 */
package com.Nxer.TwistSpaceTechnology.system.ProcessingArrayBackend;

import com.Nxer.TwistSpaceTechnology.TwistSpaceTechnology;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.SoundResource;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.metatileentity.implementations.MTEBasicMachineWithRecipe;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.RecipeMaps;
import gtPlusPlus.api.recipe.GTPPRecipeMaps;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PAHelper {
    public static final Map<RecipeMap<?>, RecipeMap<?>> CONVERT_TO_NO_CELL = new HashMap();
    public static final Map<MTEBasicMachineWithRecipe, SoundResource> SOUND_RESOURCE = new HashMap<MTEBasicMachineWithRecipe, SoundResource>();

    public static void initStatics() {
        CONVERT_TO_NO_CELL.put(RecipeMaps.mixerRecipes, GTPPRecipeMaps.mixerNonCellRecipes);
        CONVERT_TO_NO_CELL.put(RecipeMaps.centrifugeRecipes, GTPPRecipeMaps.centrifugeNonCellRecipes);
        CONVERT_TO_NO_CELL.put(RecipeMaps.electrolyzerRecipes, GTPPRecipeMaps.electrolyzerNonCellRecipes);
        try {
            for (IMetaTileEntity im : GregTechAPI.METATILEENTITIES) {
                SoundResource soundResource;
                if (!(im instanceof MTEBasicMachineWithRecipe)) continue;
                MTEBasicMachineWithRecipe mte = (MTEBasicMachineWithRecipe)im;
                Field fSound = mte.getClass().getField("mSoundResourceLocation");
                fSound.setAccessible(true);
                ResourceLocation sound = (ResourceLocation)fSound.get(mte);
                if (sound == null || (soundResource = SoundResource.get((String)sound.toString())) == null) continue;
                SOUND_RESOURCE.put(mte, soundResource);
            }
        }
        catch (Exception toLog) {
            TwistSpaceTechnology.LOG.info((Object)toLog);
        }
    }

    @Nullable
    public static MTEBasicMachineWithRecipe getMTE(ItemStack itemStack) {
        if (null == itemStack || itemStack.field_77994_a < 1) {
            return null;
        }
        if (itemStack.func_77973_b() != Item.func_150898_a((Block)GregTechAPI.sBlockMachines)) {
            return null;
        }
        int meta = itemStack.func_77960_j();
        if (meta < 0 || meta >= 32766) {
            return null;
        }
        IMetaTileEntity mte = GregTechAPI.METATILEENTITIES[meta];
        if (mte instanceof MTEBasicMachineWithRecipe) {
            MTEBasicMachineWithRecipe m = (MTEBasicMachineWithRecipe)mte;
            return m;
        }
        return null;
    }

    @Nullable
    public static RecipeMap<?> getRecipeMapFromMTE(@Nullable MTEBasicMachineWithRecipe mte) {
        if (null == mte) {
            return null;
        }
        RecipeMap r = mte.getRecipeMap();
        RecipeMap t = CONVERT_TO_NO_CELL.get(r);
        return t != null ? t : r;
    }

    public static long getVoltageFromMTE(@Nullable MTEBasicMachineWithRecipe mte) {
        if (null == mte) {
            return 0L;
        }
        return GTValues.V[mte.mTier] * (long)mte.mAmperage;
    }

    @NotNull
    public static SoundResource getSoundFromMTE(@Nullable MTEBasicMachineWithRecipe mte) {
        if (null == mte) {
            return SoundResource.NONE;
        }
        SoundResource soundResource = SOUND_RESOURCE.get(mte);
        return soundResource == null ? SoundResource.NONE : soundResource;
    }
}

