/*
 * Decompiled with CFR 0.152.
 */
package com.Nxer.TwistSpaceTechnology.util;

import bartworks.system.material.Werkstoff;
import com.Nxer.TwistSpaceTechnology.common.material.MaterialPool;
import com.Nxer.TwistSpaceTechnology.common.material.MaterialsTST;
import cpw.mods.fml.common.FMLCommonHandler;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.util.GTLanguageManager;

public class LanguageManager {
    public static void init() {
        if (!FMLCommonHandler.instance().getCurrentLanguage().equals("zh_CN")) {
            return;
        }
        LanguageManager.addWerkstoffLocalization(MaterialPool.HolmiumGarnet, "\u94ac\u77f3\u69b4\u77f3");
        LanguageManager.addWerkstoffLocalization(MaterialPool.PureMana, "\u81f3\u7eaf\u9b54\u529b");
        LanguageManager.addWerkstoffLocalization(MaterialPool.LiquidMana, "\u6db2\u6001\u9b54\u529b");
        LanguageManager.addWerkstoffLocalization(MaterialPool.PurifiedMana, "\u7eaf\u51c0\u9b54\u529b");
        LanguageManager.addWerkstoffLocalization(MaterialPool.StabiliseVoidMatter, "\u7a33\u5b9a\u865a\u7a7a\u7269\u8d28");
        LanguageManager.addWerkstoffLocalization(MaterialPool.LiquidStargate, "\u6db2\u6001\u661f\u95e8");
        LanguageManager.addWerkstoffLocalization(MaterialPool.ConcentratedUUMatter, "\u6d53\u7f29UU\u7269\u8d28");
        LanguageManager.addWerkstoffLocalization(MaterialPool.EntropicFlux, "\u9ad8\u80fd\u7ef4\u5ea6\u71b5\u6d41\u4f53");
        LanguageManager.addWerkstoffTooltipLocalization(MaterialPool.EntropicFlux, "\u71b5\u7684\u8d77\u6e90");
        LanguageManager.addWerkstoffLocalization(MaterialPool.ChronoentropicFlux, "\u65f6\u7a7a\u6e6e\u706d\u7ef4\u5ea6\u71b5\u6d41\u4f53");
        LanguageManager.addWerkstoffTooltipLocalization(MaterialPool.ChronoentropicFlux, "\u71b5\u589e");
    }

    public static void initGTMaterials() {
        if (!FMLCommonHandler.instance().getCurrentLanguage().equals("zh_CN")) {
            return;
        }
        LanguageManager.addGTMaterialLocalization(MaterialsTST.NeutroniumAlloy, "\u4e2d\u5b50\u5408\u91d1");
        LanguageManager.addGTMaterialLocalization(MaterialsTST.AxonisAlloy, "\u7075\u97f5\u5408\u91d1");
        LanguageManager.addGTMaterialLocalization(MaterialsTST.Axonium, "\u7115\u5f8b\u74a8\u91d1");
        LanguageManager.addGTMaterialLocalization(MaterialsTST.Dubnium, "\u9485\u675c");
        LanguageManager.addGTMaterialNanitesLocalization(MaterialsTST.Axonium);
        GTLanguageManager.addStringLocalization((String)"tst.blockcasings.multi.32767.name", (String)"\u4efb\u610f\u672c\u65b9\u5757\u7684\u5b50\u65b9\u5757");
        GTLanguageManager.addStringLocalization((String)"tst.blockmetal01.0.name", (String)"%material\u5757");
        GTLanguageManager.addStringLocalization((String)"tst.blockmetal01.1.name", (String)"%material\u5757");
        GTLanguageManager.addStringLocalization((String)"tst.blockmetal01.2.name", (String)"%material\u5757");
        GTLanguageManager.addStringLocalization((String)"tst.blockmetal01.3.name", (String)"%material\u5757");
        GTLanguageManager.addStringLocalization((String)"tst.blockmetal01.32767.name", (String)"\u4efb\u610f\u672c\u65b9\u5757\u7684\u5b50\u65b9\u5757");
    }

    public static void addWerkstoffLocalization(Werkstoff aWerkstoff, String localizedName) {
        String unlocalizedName = aWerkstoff.getDefaultName().toLowerCase();
        String mName = unlocalizedName.replace(" ", "");
        GTLanguageManager.addStringLocalization((String)("Material." + mName), (String)localizedName);
        GTLanguageManager.addStringLocalization((String)("bw.werkstoff." + aWerkstoff.getmID() + ".name"), (String)localizedName);
        if (aWerkstoff.hasItemType(OrePrefixes.cellMolten)) {
            GTLanguageManager.addStringLocalization((String)("fluid.molten." + unlocalizedName), (String)("\u7194\u878d" + localizedName));
        }
        if (aWerkstoff.hasItemType(OrePrefixes.cell)) {
            GTLanguageManager.addStringLocalization((String)("fluid." + unlocalizedName), (String)localizedName);
        }
    }

    public static void addWerkstoffTooltipLocalization(Werkstoff aWerkstoff, String localizedTooltip) {
        GTLanguageManager.addStringLocalization((String)("bw.werkstoff." + aWerkstoff.getmID() + ".tooltip"), (String)localizedTooltip);
    }

    public static void addGTMaterialLocalization(Materials aMaterial, String localizedName) {
        String mName = aMaterial.mDefaultLocalName.toLowerCase().replace(" ", "");
        int mID = aMaterial.mMetaItemSubID;
        GTLanguageManager.addStringLocalization((String)("gt.blockframes." + mID + ".name"), (String)"%material\u6846\u67b6");
        GTLanguageManager.addStringLocalization((String)("gt.blockores.1" + mID + ".name"), (String)"%material\u77ff\u77f3");
        GTLanguageManager.addStringLocalization((String)("gt.blockores.2" + mID + ".name"), (String)"%material\u77ff\u77f3");
        GTLanguageManager.addStringLocalization((String)("gt.blockores.3" + mID + ".name"), (String)"%material\u77ff\u77f3");
        GTLanguageManager.addStringLocalization((String)("gt.blockores.4" + mID + ".name"), (String)"%material\u77ff\u77f3");
        GTLanguageManager.addStringLocalization((String)("gt.blockores.5" + mID + ".name"), (String)"%material\u77ff\u77f3");
        GTLanguageManager.addStringLocalization((String)("gt.blockores.6" + mID + ".name"), (String)"%material\u77ff\u77f3");
        GTLanguageManager.addStringLocalization((String)("gt.blockores.16" + mID + ".name"), (String)"\u8d2b\u7620%material\u77ff\u77f3");
        GTLanguageManager.addStringLocalization((String)("gt.blockores.17" + mID + ".name"), (String)"\u8d2b\u7620%material\u77ff\u77f3");
        GTLanguageManager.addStringLocalization((String)("gt.blockores.18" + mID + ".name"), (String)"\u8d2b\u7620%material\u77ff\u77f3");
        GTLanguageManager.addStringLocalization((String)("gt.blockores.19" + mID + ".name"), (String)"\u8d2b\u7620%material\u77ff\u77f3");
        GTLanguageManager.addStringLocalization((String)("gt.blockores.20" + mID + ".name"), (String)"\u8d2b\u7620%material\u77ff\u77f3");
        GTLanguageManager.addStringLocalization((String)("gt.blockores.21" + mID + ".name"), (String)"\u8d2b\u7620%material\u77ff\u77f3");
        GTLanguageManager.addStringLocalization((String)("gt.blockores.22" + mID + ".name"), (String)"\u8d2b\u7620%material\u77ff\u77f3");
        GTLanguageManager.addStringLocalization((String)("gt.metaitem.01." + mID + ".name"), (String)"\u5c0f\u64ae%material\u7c89");
        GTLanguageManager.addStringLocalization((String)("gt.metaitem.01.1" + mID + ".name"), (String)"\u5c0f\u5806%material\u7c89");
        GTLanguageManager.addStringLocalization((String)("gt.metaitem.01.2" + mID + ".name"), (String)"%material\u7c89");
        GTLanguageManager.addStringLocalization((String)("gt.metaitem.01.9" + mID + ".name"), (String)"%material\u7c92");
        GTLanguageManager.addStringLocalization((String)("gt.metaitem.01.11" + mID + ".name"), (String)"%material\u952d");
        GTLanguageManager.addStringLocalization((String)("gt.metaitem.01.12" + mID + ".name"), (String)"\u70ed%material\u952d");
        GTLanguageManager.addStringLocalization((String)("gt.metaitem.01.13" + mID + ".name"), (String)"\u53cc\u91cd%material\u952d");
        GTLanguageManager.addStringLocalization((String)("gt.metaitem.01.14" + mID + ".name"), (String)"\u4e09\u91cd%material\u952d");
        GTLanguageManager.addStringLocalization((String)("gt.metaitem.01.15" + mID + ".name"), (String)"\u56db\u91cd%material\u952d");
        GTLanguageManager.addStringLocalization((String)("gt.metaitem.01.16" + mID + ".name"), (String)"\u4e94\u91cd%material\u952d");
        GTLanguageManager.addStringLocalization((String)("gt.metaitem.01.17" + mID + ".name"), (String)"%material\u677f");
        GTLanguageManager.addStringLocalization((String)("gt.metaitem.01.18" + mID + ".name"), (String)"\u53cc\u91cd%material\u677f");
        GTLanguageManager.addStringLocalization((String)("gt.metaitem.01.19" + mID + ".name"), (String)"\u4e09\u91cd%material\u677f");
        GTLanguageManager.addStringLocalization((String)("gt.metaitem.01.20" + mID + ".name"), (String)"\u56db\u91cd%material\u677f");
        GTLanguageManager.addStringLocalization((String)("gt.metaitem.01.21" + mID + ".name"), (String)"\u4e94\u91cd%material\u677f");
        GTLanguageManager.addStringLocalization((String)("gt.metaitem.01.22" + mID + ".name"), (String)"\u81f4\u5bc6%material\u677f");
        GTLanguageManager.addStringLocalization((String)("gt.metaitem.01.23" + mID + ".name"), (String)"%material\u6746");
        GTLanguageManager.addStringLocalization((String)("gt.metaitem.01.24" + mID + ".name"), (String)"%material\u5f39\u7c27");
        GTLanguageManager.addStringLocalization((String)("gt.metaitem.01.25" + mID + ".name"), (String)"%material\u6eda\u73e0");
        GTLanguageManager.addStringLocalization((String)("gt.metaitem.01.26" + mID + ".name"), (String)"%material\u87ba\u6813");
        GTLanguageManager.addStringLocalization((String)("gt.metaitem.01.27" + mID + ".name"), (String)"%material\u87ba\u4e1d");
        GTLanguageManager.addStringLocalization((String)("gt.metaitem.01.28" + mID + ".name"), (String)"%material\u73af");
        GTLanguageManager.addStringLocalization((String)("gt.metaitem.01.29" + mID + ".name"), (String)"%material\u7b94");
        GTLanguageManager.addStringLocalization((String)("gt.metaitem.01.31" + mID + ".name"), (String)"%material\u7b49\u79bb\u5b50\u5355\u5143");
        GTLanguageManager.addStringLocalization((String)("gt.metaitem.02." + mID + ".name"), (String)"%material\u5251\u5203");
        GTLanguageManager.addStringLocalization((String)("gt.metaitem.02.1" + mID + ".name"), (String)"%material\u9550\u5934");
        GTLanguageManager.addStringLocalization((String)("gt.metaitem.02.2" + mID + ".name"), (String)"%material\u94f2\u5934");
        GTLanguageManager.addStringLocalization((String)("gt.metaitem.02.3" + mID + ".name"), (String)"%material\u65a7\u5934");
        GTLanguageManager.addStringLocalization((String)("gt.metaitem.02.4" + mID + ".name"), (String)"%material\u9504\u5934");
        GTLanguageManager.addStringLocalization((String)("gt.metaitem.02.5" + mID + ".name"), (String)"%material\u9524\u5934");
        GTLanguageManager.addStringLocalization((String)("gt.metaitem.02.6" + mID + ".name"), (String)"%material\u9509\u5200\u5203");
        GTLanguageManager.addStringLocalization((String)("gt.metaitem.02.7" + mID + ".name"), (String)"%material\u952f\u5203");
        GTLanguageManager.addStringLocalization((String)("gt.metaitem.02.8" + mID + ".name"), (String)"%material\u94bb\u5934");
        GTLanguageManager.addStringLocalization((String)("gt.metaitem.02.9" + mID + ".name"), (String)"%material\u94fe\u952f\u5203");
        GTLanguageManager.addStringLocalization((String)("gt.metaitem.02.10" + mID + ".name"), (String)"%material\u6273\u624b\u9876");
        GTLanguageManager.addStringLocalization((String)("gt.metaitem.02.11" + mID + ".name"), (String)"%material\u4e07\u7528\u94f2\u5934");
        GTLanguageManager.addStringLocalization((String)("gt.metaitem.02.12" + mID + ".name"), (String)"%material\u9570\u5200\u5203");
        GTLanguageManager.addStringLocalization((String)("gt.metaitem.02.13" + mID + ".name"), (String)"%material\u7281\u5934");
        GTLanguageManager.addStringLocalization((String)("gt.metaitem.02.15" + mID + ".name"), (String)"%material\u5706\u952f\u952f\u5203");
        GTLanguageManager.addStringLocalization((String)("gt.metaitem.02.16" + mID + ".name"), (String)"%material\u6da1\u8f6e\u6247\u53f6");
        GTLanguageManager.addStringLocalization((String)("gt.metaitem.02.18" + mID + ".name"), (String)"%material\u5916\u58f3");
        GTLanguageManager.addStringLocalization((String)("gt.metaitem.02.19" + mID + ".name"), (String)"\u7ec6%material\u5bfc\u7ebf");
        GTLanguageManager.addStringLocalization((String)("gt.metaitem.02.20" + mID + ".name"), (String)"\u5c0f\u578b%material\u9f7f\u8f6e");
        GTLanguageManager.addStringLocalization((String)("gt.metaitem.02.21" + mID + ".name"), (String)"%material\u8f6c\u5b50");
        GTLanguageManager.addStringLocalization((String)("gt.metaitem.02.22" + mID + ".name"), (String)"\u957f%material\u6746");
        GTLanguageManager.addStringLocalization((String)("gt.metaitem.02.23" + mID + ".name"), (String)"\u5c0f\u578b%material\u5f39\u7c27");
        GTLanguageManager.addStringLocalization((String)("gt.metaitem.02.24" + mID + ".name"), (String)"%material\u5f39\u7c27");
        GTLanguageManager.addStringLocalization((String)("gt.metaitem.02.31" + mID + ".name"), (String)"%material\u9f7f\u8f6e");
        GTLanguageManager.addStringLocalization((String)("gt.metaitem.03.6" + mID + ".name"), (String)"\u8d85\u81f4\u5bc6%material\u677f");
        GTLanguageManager.addStringLocalization((String)("gt.metaitem.99." + mID + ".name"), (String)"\u7194\u878d%material\u5355\u5143");
        GTLanguageManager.addStringLocalization((String)("Material." + mName), (String)localizedName);
        GTLanguageManager.addStringLocalization((String)("fluid.molten." + mName), (String)("\u7194\u878d" + localizedName));
        GTLanguageManager.addStringLocalization((String)("fluid.plasma." + mName), (String)(localizedName + "\u7b49\u79bb\u5b50\u4f53"));
        GTLanguageManager.addStringLocalization((String)("gt.blockmachines.gt_frame_" + mName + ".name"), (String)"%material\u6846\u67b6(\u65b9\u5757\u5b9e\u4f53)");
        GTLanguageManager.addStringLocalization((String)("gt.blockmachines.wire." + mName + ".01.name"), (String)"1x%material\u5bfc\u7ebf");
        GTLanguageManager.addStringLocalization((String)("gt.blockmachines.wire." + mName + ".02.name"), (String)"2x%material\u5bfc\u7ebf");
        GTLanguageManager.addStringLocalization((String)("gt.blockmachines.wire." + mName + ".04.name"), (String)"4x%material\u5bfc\u7ebf");
        GTLanguageManager.addStringLocalization((String)("gt.blockmachines.wire." + mName + ".08.name"), (String)"8x%material\u5bfc\u7ebf");
        GTLanguageManager.addStringLocalization((String)("gt.blockmachines.wire." + mName + ".12.name"), (String)"12x%material\u5bfc\u7ebf");
        GTLanguageManager.addStringLocalization((String)("gt.blockmachines.wire." + mName + ".16.name"), (String)"16x%material\u5bfc\u7ebf");
    }

    public static void addGTMaterialNanitesLocalization(Materials aMaterial) {
        GTLanguageManager.addStringLocalization((String)("gt.metaitem.03.4" + aMaterial.mMetaItemSubID + ".name"), (String)"%material\u7eb3\u7c73\u8702\u7fa4");
    }
}

