/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.common.jsonexplain.tez;

import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.common.jsonexplain.JsonParser;
import org.apache.hadoop.hive.common.jsonexplain.tez.Connection;
import org.apache.hadoop.hive.common.jsonexplain.tez.Op;
import org.apache.hadoop.hive.common.jsonexplain.tez.Printer;
import org.apache.hadoop.hive.common.jsonexplain.tez.Stage;
import org.apache.hadoop.hive.common.jsonexplain.tez.Vertex;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.map.JsonMappingException;
import org.json.JSONException;
import org.json.JSONObject;

public final class TezJsonParser
implements JsonParser {
    public final Map<String, Stage> stages = new HashMap<String, Stage>();
    protected final Log LOG;
    public final Set<Object> printSet = new HashSet<Object>();
    public final Map<Op, List<Connection>> inlineMap = new HashMap<Op, List<Connection>>();

    public TezJsonParser() {
        this.LOG = LogFactory.getLog(this.getClass().getName());
    }

    public void extractStagesAndPlans(JSONObject inputObject) throws JSONException, JsonParseException, JsonMappingException, Exception, IOException {
        JSONObject stagePlans;
        JSONObject dependency = inputObject.getJSONObject("STAGE DEPENDENCIES");
        if (dependency != null && dependency.length() > 0) {
            for (String stageName : JSONObject.getNames((JSONObject)dependency)) {
                this.stages.put(stageName, new Stage(stageName, this));
            }
            for (String stageName : JSONObject.getNames((JSONObject)dependency)) {
                JSONObject dependentStageNames = dependency.getJSONObject(stageName);
                this.stages.get(stageName).addDependency(dependentStageNames, this.stages);
            }
        }
        if ((stagePlans = inputObject.getJSONObject("STAGE PLANS")) != null && stagePlans.length() > 0) {
            for (String stageName : JSONObject.getNames((JSONObject)stagePlans)) {
                JSONObject stagePlan = stagePlans.getJSONObject(stageName);
                this.stages.get(stageName).extractVertex(stagePlan);
            }
        }
    }

    public static String prefixString(List<Boolean> indentFlag) {
        StringBuilder sb = new StringBuilder();
        for (int index = 0; index < indentFlag.size(); ++index) {
            if (indentFlag.get(index).booleanValue()) {
                sb.append("|  ");
                continue;
            }
            sb.append("   ");
        }
        return sb.toString();
    }

    public static String prefixString(List<Boolean> indentFlag, String tail) {
        StringBuilder sb = new StringBuilder();
        for (int index = 0; index < indentFlag.size(); ++index) {
            if (indentFlag.get(index).booleanValue()) {
                sb.append("|  ");
                continue;
            }
            sb.append("   ");
        }
        int len = sb.length();
        return sb.replace(len - tail.length(), len, tail).toString();
    }

    @Override
    public void print(JSONObject inputObject, PrintStream outputStream) throws Exception {
        this.LOG.info("JsonParser is parsing:" + inputObject.toString());
        this.extractStagesAndPlans(inputObject);
        Printer printer = new Printer();
        if (inputObject.has("cboInfo")) {
            printer.println(inputObject.getString("cboInfo"));
            printer.println();
        }
        for (Stage candidate : this.stages.values()) {
            if (candidate.tezStageDependency == null || candidate.tezStageDependency.size() <= 0) continue;
            printer.println("Vertex dependency in root stage");
            for (Map.Entry<Vertex, List<Connection>> entry : candidate.tezStageDependency.entrySet()) {
                StringBuffer sb = new StringBuffer();
                sb.append(entry.getKey().name);
                sb.append(" <- ");
                boolean printcomma = false;
                for (Connection connection : entry.getValue()) {
                    if (printcomma) {
                        sb.append(", ");
                    } else {
                        printcomma = true;
                    }
                    sb.append(connection.from.name + " (" + connection.type + ")");
                }
                printer.println(sb.toString());
            }
            printer.println();
        }
        ArrayList<Boolean> indentFlag = new ArrayList<Boolean>();
        for (Stage candidate : this.stages.values()) {
            if (!candidate.childStages.isEmpty()) continue;
            candidate.print(printer, indentFlag);
        }
        outputStream.println(printer.toString());
    }

    public void addInline(Op op, Connection connection) {
        List<Connection> list = this.inlineMap.get(op);
        if (list == null) {
            list = new ArrayList<Connection>();
            list.add(connection);
            this.inlineMap.put(op, list);
        } else {
            list.add(connection);
        }
    }

    public boolean isInline(Vertex v) {
        for (List<Connection> list : this.inlineMap.values()) {
            for (Connection connection : list) {
                if (!connection.from.equals(v)) continue;
                return true;
            }
        }
        return false;
    }
}

