/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.http.lib;

import java.io.IOException;
import java.security.Principal;
import java.util.HashMap;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.http.FilterContainer;
import org.apache.hadoop.http.FilterInitializer;

public class StaticUserWebFilter
extends FilterInitializer {
    static final String DEPRECATED_UGI_KEY = "dfs.web.ugi";
    private static final Log LOG = LogFactory.getLog(StaticUserWebFilter.class);

    @Override
    public void initFilter(FilterContainer container, Configuration conf) {
        HashMap<String, String> options = new HashMap<String, String>();
        String username = StaticUserWebFilter.getUsernameFromConf(conf);
        options.put("hadoop.http.staticuser.user", username);
        container.addFilter("static_user_filter", StaticUserFilter.class.getName(), options);
    }

    static String getUsernameFromConf(Configuration conf) {
        String oldStyleUgi = conf.get(DEPRECATED_UGI_KEY);
        if (oldStyleUgi != null) {
            LOG.warn("dfs.web.ugi should not be used. Instead, use hadoop.http.staticuser.user.");
            String[] parts = oldStyleUgi.split(",");
            return parts[0];
        }
        return conf.get("hadoop.http.staticuser.user", "dr.who");
    }

    public static class StaticUserFilter
    implements Filter {
        private User user;
        private String username;

        public void destroy() {
        }

        public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
            HttpServletRequest httpRequest = (HttpServletRequest)request;
            if (httpRequest.getRemoteUser() != null) {
                chain.doFilter(request, response);
            } else {
                HttpServletRequestWrapper wrapper = new HttpServletRequestWrapper(httpRequest){

                    public Principal getUserPrincipal() {
                        return StaticUserFilter.this.user;
                    }

                    public String getRemoteUser() {
                        return StaticUserFilter.this.username;
                    }
                };
                chain.doFilter((ServletRequest)wrapper, response);
            }
        }

        public void init(FilterConfig conf) throws ServletException {
            this.username = conf.getInitParameter("hadoop.http.staticuser.user");
            this.user = new User(this.username);
        }
    }

    static class User
    implements Principal {
        private final String name;

        public User(String name) {
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public int hashCode() {
            return this.name.hashCode();
        }

        @Override
        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (other == null || other.getClass() != this.getClass()) {
                return false;
            }
            return ((User)other).name.equals(this.name);
        }

        @Override
        public String toString() {
            return this.name;
        }
    }
}

