/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.cli.operation;

import com.google.common.collect.Sets;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.common.metrics.common.Metrics;
import org.apache.hadoop.hive.common.metrics.common.MetricsFactory;
import org.apache.hadoop.hive.common.metrics.common.MetricsScope;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.processors.CommandProcessorResponse;
import org.apache.hadoop.hive.ql.session.OperationLog;
import org.apache.hive.service.cli.FetchOrientation;
import org.apache.hive.service.cli.HiveSQLException;
import org.apache.hive.service.cli.OperationHandle;
import org.apache.hive.service.cli.OperationState;
import org.apache.hive.service.cli.OperationStatus;
import org.apache.hive.service.cli.OperationType;
import org.apache.hive.service.cli.RowSet;
import org.apache.hive.service.cli.TableSchema;
import org.apache.hive.service.cli.session.HiveSession;
import org.apache.hive.service.cli.thrift.TProtocolVersion;

public abstract class Operation {
    protected final HiveSession parentSession;
    private OperationState state = OperationState.INITIALIZED;
    private MetricsScope currentStateScope;
    private final OperationHandle opHandle;
    private HiveConf configuration;
    public static final Log LOG = LogFactory.getLog(Operation.class.getName());
    public static final FetchOrientation DEFAULT_FETCH_ORIENTATION = FetchOrientation.FETCH_NEXT;
    public static final long DEFAULT_FETCH_MAX_ROWS = 100L;
    protected boolean hasResultSet;
    protected volatile HiveSQLException operationException;
    protected volatile Future<?> backgroundHandle;
    protected OperationLog operationLog;
    protected boolean isOperationLogEnabled;
    private long operationTimeout;
    private long lastAccessTime;
    protected static final EnumSet<FetchOrientation> DEFAULT_FETCH_ORIENTATION_SET = EnumSet.of(FetchOrientation.FETCH_NEXT, FetchOrientation.FETCH_FIRST);
    protected static Set<OperationState> scopeStates = Sets.immutableEnumSet((Enum)OperationState.INITIALIZED, (Enum[])new OperationState[]{OperationState.PENDING, OperationState.RUNNING});
    protected static Set<OperationState> terminalStates = Sets.immutableEnumSet((Enum)OperationState.CLOSED, (Enum[])new OperationState[]{OperationState.CANCELED, OperationState.FINISHED, OperationState.ERROR, OperationState.UNKNOWN});

    protected Operation(HiveSession parentSession, OperationType opType, boolean runInBackground) {
        this.parentSession = parentSession;
        this.opHandle = new OperationHandle(opType, parentSession.getProtocolVersion());
        this.lastAccessTime = System.currentTimeMillis();
        this.operationTimeout = HiveConf.getTimeVar(parentSession.getHiveConf(), HiveConf.ConfVars.HIVE_SERVER2_IDLE_OPERATION_TIMEOUT, TimeUnit.MILLISECONDS);
        this.setMetrics(this.state);
    }

    public Future<?> getBackgroundHandle() {
        return this.backgroundHandle;
    }

    protected void setBackgroundHandle(Future<?> backgroundHandle) {
        this.backgroundHandle = backgroundHandle;
    }

    public void setConfiguration(HiveConf configuration) {
        this.configuration = new HiveConf(configuration);
    }

    public HiveConf getConfiguration() {
        return new HiveConf(this.configuration);
    }

    public boolean shouldRunAsync() {
        return false;
    }

    public HiveSession getParentSession() {
        return this.parentSession;
    }

    public OperationHandle getHandle() {
        return this.opHandle;
    }

    public TProtocolVersion getProtocolVersion() {
        return this.opHandle.getProtocolVersion();
    }

    public OperationType getType() {
        return this.opHandle.getOperationType();
    }

    public OperationStatus getStatus() {
        return new OperationStatus(this.state, this.operationException);
    }

    public boolean hasResultSet() {
        return this.hasResultSet;
    }

    protected void setHasResultSet(boolean hasResultSet) {
        this.hasResultSet = hasResultSet;
        this.opHandle.setHasResultSet(hasResultSet);
    }

    public OperationLog getOperationLog() {
        return this.operationLog;
    }

    protected final OperationState setState(OperationState newState) throws HiveSQLException {
        this.state.validateTransition(newState);
        this.state = newState;
        this.setMetrics(this.state);
        this.lastAccessTime = System.currentTimeMillis();
        return this.state;
    }

    public boolean isTimedOut(long current) {
        if (this.operationTimeout == 0L) {
            return false;
        }
        if (this.operationTimeout > 0L) {
            return this.state.isTerminal() && this.lastAccessTime + this.operationTimeout <= current;
        }
        return this.lastAccessTime + -this.operationTimeout <= current;
    }

    public long getLastAccessTime() {
        return this.lastAccessTime;
    }

    public long getOperationTimeout() {
        return this.operationTimeout;
    }

    public void setOperationTimeout(long operationTimeout) {
        this.operationTimeout = operationTimeout;
    }

    protected void setOperationException(HiveSQLException operationException) {
        this.operationException = operationException;
    }

    protected final void assertState(List<OperationState> states) throws HiveSQLException {
        if (!states.contains((Object)this.state)) {
            throw new HiveSQLException("Expected states: " + states.toString() + ", but found " + (Object)((Object)this.state));
        }
        this.lastAccessTime = System.currentTimeMillis();
    }

    public boolean isDone() {
        return this.state.isTerminal();
    }

    protected void createOperationLog() {
        if (this.parentSession.isOperationLogEnabled()) {
            File operationLogFile = new File(this.parentSession.getOperationLogSessionDir(), this.opHandle.getHandleIdentifier().toString());
            this.isOperationLogEnabled = true;
            try {
                if (operationLogFile.exists()) {
                    LOG.warn("The operation log file should not exist, but it is already there: " + operationLogFile.getAbsolutePath());
                    operationLogFile.delete();
                }
                if (!(operationLogFile.createNewFile() || operationLogFile.canRead() && operationLogFile.canWrite())) {
                    LOG.warn("The already existed operation log file cannot be recreated, and it cannot be read or written: " + operationLogFile.getAbsolutePath());
                    this.isOperationLogEnabled = false;
                    return;
                }
            }
            catch (Exception e) {
                LOG.warn("Unable to create operation log file: " + operationLogFile.getAbsolutePath(), e);
                this.isOperationLogEnabled = false;
                return;
            }
            try {
                this.operationLog = new OperationLog(this.opHandle.toString(), operationLogFile, this.parentSession.getHiveConf());
            }
            catch (FileNotFoundException e) {
                LOG.warn("Unable to instantiate OperationLog object for operation: " + this.opHandle, e);
                this.isOperationLogEnabled = false;
                return;
            }
            OperationLog.setCurrentOperationLog((OperationLog)this.operationLog);
        }
    }

    protected void unregisterOperationLog() {
        if (this.isOperationLogEnabled) {
            OperationLog.removeCurrentOperationLog();
        }
    }

    protected void beforeRun() {
        this.createOperationLog();
    }

    protected void afterRun() {
        this.unregisterOperationLog();
    }

    protected abstract void runInternal() throws HiveSQLException;

    public final void run() throws HiveSQLException {
        this.beforeRun();
        try {
            Metrics metrics = MetricsFactory.getInstance();
            if (metrics != null) {
                try {
                    metrics.incrementCounter("open_operations");
                }
                catch (Exception e) {
                    LOG.warn("Error Reporting open operation to Metrics system", e);
                }
            }
            this.runInternal();
        }
        finally {
            this.afterRun();
        }
    }

    protected synchronized void cleanupOperationLog() {
        if (this.isOperationLogEnabled) {
            if (this.opHandle == null) {
                LOG.warn("Operation seems to be in invalid state, opHandle is null");
                return;
            }
            if (this.operationLog == null) {
                LOG.warn("Operation [ " + this.opHandle.getHandleIdentifier() + " ] " + "logging is enabled, " + "but its OperationLog object cannot be found. " + "Perhaps the operation has already terminated.");
            } else {
                this.operationLog.close();
            }
        }
    }

    public abstract void cancel(OperationState var1) throws HiveSQLException;

    public abstract void close() throws HiveSQLException;

    public abstract TableSchema getResultSetSchema() throws HiveSQLException;

    public abstract RowSet getNextRowSet(FetchOrientation var1, long var2) throws HiveSQLException;

    public RowSet getNextRowSet() throws HiveSQLException {
        return this.getNextRowSet(FetchOrientation.FETCH_NEXT, 100L);
    }

    protected void validateDefaultFetchOrientation(FetchOrientation orientation) throws HiveSQLException {
        this.validateFetchOrientation(orientation, DEFAULT_FETCH_ORIENTATION_SET);
    }

    protected void validateFetchOrientation(FetchOrientation orientation, EnumSet<FetchOrientation> supportedOrientations) throws HiveSQLException {
        if (!supportedOrientations.contains((Object)orientation)) {
            throw new HiveSQLException("The fetch type " + orientation.toString() + " is not supported for this resultset", "HY106");
        }
    }

    protected HiveSQLException toSQLException(String prefix, CommandProcessorResponse response) {
        HiveSQLException ex = new HiveSQLException(prefix + ": " + response.getErrorMessage(), response.getSQLState(), response.getResponseCode());
        if (response.getException() != null) {
            ex.initCause(response.getException());
        }
        return ex;
    }

    protected void setMetrics(OperationState state) {
        Metrics metrics = MetricsFactory.getInstance();
        if (metrics != null) {
            try {
                if (this.currentStateScope != null) {
                    metrics.endScope(this.currentStateScope);
                    this.currentStateScope = null;
                }
                if (scopeStates.contains((Object)state)) {
                    this.currentStateScope = metrics.createScope("hs2_operation_" + state.toString());
                }
                if (terminalStates.contains((Object)state)) {
                    metrics.incrementCounter("hs2_completed_operation_" + state.toString());
                }
            }
            catch (IOException e) {
                LOG.warn("Error metrics", e);
            }
        }
    }
}

