/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import junit.framework.Assert;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.TestableZooKeeper;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.server.NettyServerCnxnFactory;
import org.apache.zookeeper.server.ServerCnxn;
import org.apache.zookeeper.test.ClientBase;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyServerCnxnTest
extends ClientBase {
    private static final Logger LOG = LoggerFactory.getLogger(NettyServerCnxnTest.class);

    public void setUp() throws Exception {
        System.setProperty("zookeeper.serverCnxnFactory", "org.apache.zookeeper.server.NettyServerCnxnFactory");
        super.setUp();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=30000L)
    public void testSendCloseSession() throws Exception {
        Assert.assertTrue((String)"Didn't instantiate ServerCnxnFactory with NettyServerCnxnFactory!", (boolean)(this.serverFactory instanceof NettyServerCnxnFactory));
        NettyServerCnxnFactory nettyServerFactory = (NettyServerCnxnFactory)this.serverFactory;
        final CountDownLatch channelLatch = new CountDownLatch(1);
        NettyServerCnxnFactory nettyServerCnxnFactory = nettyServerFactory;
        nettyServerCnxnFactory.getClass();
        NettyServerCnxnFactory.CnxnChannelHandler channelHandler = new NettyServerCnxnFactory.CnxnChannelHandler(nettyServerCnxnFactory){

            public void channelDisconnected(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
                LOG.info("Recieves channel disconnected event");
                channelLatch.countDown();
            }
        };
        LOG.info("Adding custom channel handler for simulation");
        nettyServerFactory.bootstrap.getPipeline().remove("servercnxnfactory");
        nettyServerFactory.bootstrap.getPipeline().addLast("servercnxnfactory", (ChannelHandler)channelHandler);
        TestableZooKeeper zk = this.createClient();
        String path = "/a";
        try {
            zk.create("/a", "test".getBytes(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            Assert.assertNotNull((String)"Didn't create znode:/a", (Object)zk.exists("/a", false));
            Iterable<ServerCnxn> connections = this.serverFactory.getConnections();
            Assert.assertEquals((String)"Mismatch in number of live connections!", (int)1, (int)this.serverFactory.getNumAliveConnections());
            for (ServerCnxn serverCnxn : connections) {
                serverCnxn.sendCloseSession();
            }
            LOG.info("Waiting for the channel disconnected event");
            channelLatch.await(CONNECTION_TIMEOUT, TimeUnit.MILLISECONDS);
            Assert.assertEquals((String)"Mismatch in number of live connections!", (int)0, (int)this.serverFactory.getNumAliveConnections());
        }
        finally {
            zk.close();
        }
    }
}

