/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.zookeeper.ZKTestCase;
import org.apache.zookeeper.server.persistence.FileTxnLog;
import org.apache.zookeeper.server.persistence.Util;
import org.apache.zookeeper.test.ClientBase;
import org.junit.Assert;
import org.junit.Test;

public class ZooKeeperServerTest
extends ZKTestCase {
    @Test
    public void testSortDataDirAscending() {
        File[] files = new File[]{new File("foo.10027c6de"), new File("foo.10027c6df"), new File("bar.10027c6dd"), new File("foo.10027c6dc"), new File("foo.20027c6dc")};
        File[] orig = (File[])files.clone();
        List<File> filelist = Util.sortDataDir(files, "foo", true);
        Assert.assertEquals((Object)orig[2], (Object)filelist.get(0));
        Assert.assertEquals((Object)orig[3], (Object)filelist.get(1));
        Assert.assertEquals((Object)orig[0], (Object)filelist.get(2));
        Assert.assertEquals((Object)orig[1], (Object)filelist.get(3));
        Assert.assertEquals((Object)orig[4], (Object)filelist.get(4));
    }

    @Test
    public void testSortDataDirDescending() {
        File[] files = new File[]{new File("foo.10027c6de"), new File("foo.10027c6df"), new File("bar.10027c6dd"), new File("foo.10027c6dc"), new File("foo.20027c6dc")};
        File[] orig = (File[])files.clone();
        List<File> filelist = Util.sortDataDir(files, "foo", false);
        Assert.assertEquals((Object)orig[4], (Object)filelist.get(0));
        Assert.assertEquals((Object)orig[1], (Object)filelist.get(1));
        Assert.assertEquals((Object)orig[0], (Object)filelist.get(2));
        Assert.assertEquals((Object)orig[3], (Object)filelist.get(3));
        Assert.assertEquals((Object)orig[2], (Object)filelist.get(4));
    }

    @Test
    public void testGetLogFiles() {
        File[] files = new File[]{new File("log.10027c6de"), new File("log.10027c6df"), new File("snapshot.10027c6dd"), new File("log.10027c6dc"), new File("log.20027c6dc")};
        File[] orig = (File[])files.clone();
        File[] filelist = FileTxnLog.getLogFiles(files, Long.parseLong("10027c6de", 16));
        Assert.assertEquals((long)3L, (long)filelist.length);
        Assert.assertEquals((Object)orig[0], (Object)filelist[0]);
        Assert.assertEquals((Object)orig[1], (Object)filelist[1]);
        Assert.assertEquals((Object)orig[4], (Object)filelist[2]);
    }

    @Test
    public void testForceSyncDefaultEnabled() {
        File file = new File("foo.10027c6de");
        FileTxnLog log = new FileTxnLog(file);
        Assert.assertTrue((boolean)log.isForceSync());
    }

    @Test
    public void testForceSyncDefaultDisabled() {
        try {
            File file = new File("foo.10027c6de");
            System.setProperty("zookeeper.forceSync", "no");
            FileTxnLog log = new FileTxnLog(file);
            Assert.assertFalse((boolean)log.isForceSync());
        }
        finally {
            System.setProperty("zookeeper.forceSync", "yes");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInvalidSnapshot() {
        File f = null;
        File tmpFileDir = null;
        try {
            tmpFileDir = ClientBase.createTmpDir();
            f = new File(tmpFileDir, "snapshot.0");
            if (!f.exists()) {
                f.createNewFile();
            }
            Assert.assertFalse((String)"Snapshot file size is greater than 9 bytes", (boolean)Util.isValidSnapshot(f));
            Assert.assertTrue((String)"Can't delete file", (boolean)f.delete());
        }
        catch (IOException iOException) {
        }
        finally {
            if (null != tmpFileDir) {
                ClientBase.recursiveDelete(tmpFileDir);
            }
        }
    }
}

