/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.shaded.org.apache.kafka.common.requests;

import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.message.CreatePartitionsRequestData;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.message.CreatePartitionsResponseData;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.ApiKeys;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.ByteBufferAccessor;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.requests.AbstractRequest;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.requests.AbstractResponse;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.requests.ApiError;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.requests.CreatePartitionsResponse;
import java.nio.ByteBuffer;

public class CreatePartitionsRequest
extends AbstractRequest {
    private final CreatePartitionsRequestData data;

    CreatePartitionsRequest(CreatePartitionsRequestData data, short apiVersion) {
        super(ApiKeys.CREATE_PARTITIONS, apiVersion);
        this.data = data;
    }

    @Override
    public CreatePartitionsRequestData data() {
        return this.data;
    }

    @Override
    public AbstractResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        CreatePartitionsResponseData response = new CreatePartitionsResponseData();
        response.setThrottleTimeMs(throttleTimeMs);
        ApiError apiError = ApiError.fromThrowable(e);
        for (CreatePartitionsRequestData.CreatePartitionsTopic topic : this.data.topics()) {
            response.results().add(new CreatePartitionsResponseData.CreatePartitionsTopicResult().setName(topic.name()).setErrorCode(apiError.error().code()).setErrorMessage(apiError.message()));
        }
        return new CreatePartitionsResponse(response);
    }

    public static CreatePartitionsRequest parse(ByteBuffer buffer, short version) {
        return new CreatePartitionsRequest(new CreatePartitionsRequestData(new ByteBufferAccessor(buffer), version), version);
    }

    public static class Builder
    extends AbstractRequest.Builder<CreatePartitionsRequest> {
        private final CreatePartitionsRequestData data;

        public Builder(CreatePartitionsRequestData data) {
            super(ApiKeys.CREATE_PARTITIONS);
            this.data = data;
        }

        @Override
        public CreatePartitionsRequest build(short version) {
            return new CreatePartitionsRequest(this.data, version);
        }

        public String toString() {
            return this.data.toString();
        }
    }
}

