/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.shaded.org.apache.kafka.common.requests;

import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.message.EnvelopeResponseData;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.ApiKeys;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.ByteBufferAccessor;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.Errors;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.requests.AbstractResponse;
import java.nio.ByteBuffer;
import java.util.Map;

public class EnvelopeResponse
extends AbstractResponse {
    private final EnvelopeResponseData data;

    public EnvelopeResponse(ByteBuffer responseData, Errors error) {
        super(ApiKeys.ENVELOPE);
        this.data = new EnvelopeResponseData().setResponseData(responseData).setErrorCode(error.code());
    }

    public EnvelopeResponse(Errors error) {
        this(null, error);
    }

    public EnvelopeResponse(EnvelopeResponseData data) {
        super(ApiKeys.ENVELOPE);
        this.data = data;
    }

    public ByteBuffer responseData() {
        return this.data.responseData();
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        return this.errorCounts(this.error());
    }

    public Errors error() {
        return Errors.forCode(this.data.errorCode());
    }

    @Override
    public EnvelopeResponseData data() {
        return this.data;
    }

    @Override
    public int throttleTimeMs() {
        return 0;
    }

    public static EnvelopeResponse parse(ByteBuffer buffer, short version) {
        return new EnvelopeResponse(new EnvelopeResponseData(new ByteBufferAccessor(buffer), version));
    }
}

