/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.shaded.org.apache.kafka.common.requests;

import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.TopicPartition;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.message.FetchSnapshotRequestData;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.message.FetchSnapshotResponseData;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.ApiKeys;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.ByteBufferAccessor;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.Errors;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.requests.AbstractRequest;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.requests.FetchSnapshotResponse;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Optional;
import java.util.function.UnaryOperator;

public final class FetchSnapshotRequest
extends AbstractRequest {
    private final FetchSnapshotRequestData data;

    public FetchSnapshotRequest(FetchSnapshotRequestData data, short version) {
        super(ApiKeys.FETCH_SNAPSHOT, version);
        this.data = data;
    }

    @Override
    public FetchSnapshotResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        return new FetchSnapshotResponse(new FetchSnapshotResponseData().setThrottleTimeMs(throttleTimeMs).setErrorCode(Errors.forException(e).code()));
    }

    @Override
    public FetchSnapshotRequestData data() {
        return this.data;
    }

    public static FetchSnapshotRequestData singleton(String clusterId, TopicPartition topicPartition, UnaryOperator<FetchSnapshotRequestData.PartitionSnapshot> operator) {
        FetchSnapshotRequestData.PartitionSnapshot partitionSnapshot = (FetchSnapshotRequestData.PartitionSnapshot)operator.apply(new FetchSnapshotRequestData.PartitionSnapshot().setPartition(topicPartition.partition()));
        return new FetchSnapshotRequestData().setClusterId(clusterId).setTopics(Collections.singletonList(new FetchSnapshotRequestData.TopicSnapshot().setName(topicPartition.topic()).setPartitions(Collections.singletonList(partitionSnapshot))));
    }

    public static Optional<FetchSnapshotRequestData.PartitionSnapshot> forTopicPartition(FetchSnapshotRequestData data, TopicPartition topicPartition) {
        return data.topics().stream().filter(topic -> topic.name().equals(topicPartition.topic())).flatMap(topic -> topic.partitions().stream()).filter(partition -> partition.partition() == topicPartition.partition()).findAny();
    }

    public static FetchSnapshotRequest parse(ByteBuffer buffer, short version) {
        return new FetchSnapshotRequest(new FetchSnapshotRequestData(new ByteBufferAccessor(buffer), version), version);
    }

    public static class Builder
    extends AbstractRequest.Builder<FetchSnapshotRequest> {
        private final FetchSnapshotRequestData data;

        public Builder(FetchSnapshotRequestData data) {
            super(ApiKeys.FETCH_SNAPSHOT);
            this.data = data;
        }

        @Override
        public FetchSnapshotRequest build(short version) {
            return new FetchSnapshotRequest(this.data, version);
        }

        public String toString() {
            return this.data.toString();
        }
    }
}

