/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.shaded.org.apache.kafka.common.security.oauthbearer.internals.unsecured;

import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.KafkaException;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.config.ConfigException;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.security.auth.AuthenticateCallbackHandler;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.security.auth.SaslExtensions;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.security.auth.SaslExtensionsCallback;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.security.oauthbearer.OAuthBearerTokenCallback;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.security.oauthbearer.internals.OAuthBearerClientInitialResponse;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.security.oauthbearer.internals.unsecured.OAuthBearerConfigException;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.security.oauthbearer.internals.unsecured.OAuthBearerIllegalTokenException;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.security.oauthbearer.internals.unsecured.OAuthBearerUnsecuredJws;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.utils.Time;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.utils.Utils;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.sasl.SaslException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuthBearerUnsecuredLoginCallbackHandler
implements AuthenticateCallbackHandler {
    private final Logger log = LoggerFactory.getLogger(OAuthBearerUnsecuredLoginCallbackHandler.class);
    private static final String OPTION_PREFIX = "unsecuredLogin";
    private static final String PRINCIPAL_CLAIM_NAME_OPTION = "unsecuredLoginPrincipalClaimName";
    private static final String LIFETIME_SECONDS_OPTION = "unsecuredLoginLifetimeSeconds";
    private static final String SCOPE_CLAIM_NAME_OPTION = "unsecuredLoginScopeClaimName";
    private static final Set<String> RESERVED_CLAIMS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("iat", "exp")));
    private static final String DEFAULT_PRINCIPAL_CLAIM_NAME = "sub";
    private static final String DEFAULT_LIFETIME_SECONDS_ONE_HOUR = "3600";
    private static final String DEFAULT_SCOPE_CLAIM_NAME = "scope";
    private static final String STRING_CLAIM_PREFIX = "unsecuredLoginStringClaim_";
    private static final String NUMBER_CLAIM_PREFIX = "unsecuredLoginNumberClaim_";
    private static final String LIST_CLAIM_PREFIX = "unsecuredLoginListClaim_";
    private static final String EXTENSION_PREFIX = "unsecuredLoginExtension_";
    private static final String QUOTE = "\"";
    private Time time = Time.SYSTEM;
    private Map<String, String> moduleOptions = null;
    private boolean configured = false;
    private static final Pattern DOUBLEQUOTE = Pattern.compile("\"", 16);
    private static final Pattern BACKSLASH = Pattern.compile("\\", 16);

    void time(Time time) {
        this.time = Objects.requireNonNull(time);
    }

    public boolean configured() {
        return this.configured;
    }

    @Override
    public void configure(Map<String, ?> configs, String saslMechanism, List<AppConfigurationEntry> jaasConfigEntries) {
        if (!"OAUTHBEARER".equals(saslMechanism)) {
            throw new IllegalArgumentException(String.format("Unexpected SASL mechanism: %s", saslMechanism));
        }
        if (Objects.requireNonNull(jaasConfigEntries).size() != 1 || jaasConfigEntries.get(0) == null) {
            throw new IllegalArgumentException(String.format("Must supply exactly 1 non-null JAAS mechanism configuration (size was %d)", jaasConfigEntries.size()));
        }
        this.moduleOptions = Collections.unmodifiableMap(jaasConfigEntries.get(0).getOptions());
        this.configured = true;
    }

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        if (!this.configured()) {
            throw new IllegalStateException("Callback handler not configured");
        }
        for (Callback callback : callbacks) {
            if (callback instanceof OAuthBearerTokenCallback) {
                try {
                    this.handleTokenCallback((OAuthBearerTokenCallback)callback);
                    continue;
                }
                catch (KafkaException e) {
                    throw new IOException(e.getMessage(), e);
                }
            }
            if (callback instanceof SaslExtensionsCallback) {
                try {
                    this.handleExtensionsCallback((SaslExtensionsCallback)callback);
                    continue;
                }
                catch (KafkaException e) {
                    throw new IOException(e.getMessage(), e);
                }
            }
            throw new UnsupportedCallbackException(callback);
        }
    }

    @Override
    public void close() {
    }

    private void handleTokenCallback(OAuthBearerTokenCallback callback) {
        String claimsJson;
        if (callback.token() != null) {
            throw new IllegalArgumentException("Callback had a token already");
        }
        if (this.moduleOptions.isEmpty()) {
            this.log.debug("Token not provided, this login cannot be used to establish client connections");
            callback.token(null);
            return;
        }
        if (this.moduleOptions.keySet().stream().noneMatch(name -> !name.startsWith(EXTENSION_PREFIX))) {
            throw new OAuthBearerConfigException("Extensions provided in login context without a token");
        }
        String principalClaimNameValue = this.optionValue(PRINCIPAL_CLAIM_NAME_OPTION);
        String principalClaimName = Utils.isBlank(principalClaimNameValue) ? DEFAULT_PRINCIPAL_CLAIM_NAME : principalClaimNameValue.trim();
        String scopeClaimNameValue = this.optionValue(SCOPE_CLAIM_NAME_OPTION);
        String scopeClaimName = Utils.isBlank(scopeClaimNameValue) ? DEFAULT_SCOPE_CLAIM_NAME : scopeClaimNameValue.trim();
        String headerJson = "{" + this.claimOrHeaderJsonText("alg", "none") + "}";
        String lifetimeSecondsValueToUse = this.optionValue(LIFETIME_SECONDS_OPTION, DEFAULT_LIFETIME_SECONDS_ONE_HOUR);
        try {
            claimsJson = String.format("{%s,%s%s}", this.expClaimText(Long.parseLong(lifetimeSecondsValueToUse)), this.claimOrHeaderJsonText("iat", (double)this.time.milliseconds() / 1000.0), this.commaPrependedStringNumberAndListClaimsJsonText());
        }
        catch (NumberFormatException e) {
            throw new OAuthBearerConfigException(e.getMessage());
        }
        try {
            Base64.Encoder urlEncoderNoPadding = Base64.getUrlEncoder().withoutPadding();
            OAuthBearerUnsecuredJws jws = new OAuthBearerUnsecuredJws(String.format("%s.%s.", urlEncoderNoPadding.encodeToString(headerJson.getBytes(StandardCharsets.UTF_8)), urlEncoderNoPadding.encodeToString(claimsJson.getBytes(StandardCharsets.UTF_8))), principalClaimName, scopeClaimName);
            this.log.info("Retrieved token with principal {}", (Object)jws.principalName());
            callback.token(jws);
        }
        catch (OAuthBearerIllegalTokenException e) {
            throw new OAuthBearerConfigException(e.getMessage(), e);
        }
    }

    private void handleExtensionsCallback(SaslExtensionsCallback callback) {
        HashMap<String, String> extensions = new HashMap<String, String>();
        for (Map.Entry<String, String> configEntry : this.moduleOptions.entrySet()) {
            String key = configEntry.getKey();
            if (!key.startsWith(EXTENSION_PREFIX)) continue;
            extensions.put(key.substring(EXTENSION_PREFIX.length()), configEntry.getValue());
        }
        SaslExtensions saslExtensions = new SaslExtensions(extensions);
        try {
            OAuthBearerClientInitialResponse.validateExtensions(saslExtensions);
        }
        catch (SaslException e) {
            throw new ConfigException(e.getMessage());
        }
        callback.extensions(saslExtensions);
    }

    private String commaPrependedStringNumberAndListClaimsJsonText() throws OAuthBearerConfigException {
        StringBuilder sb = new StringBuilder();
        for (String key : this.moduleOptions.keySet()) {
            if (key.startsWith(STRING_CLAIM_PREFIX) && key.length() > STRING_CLAIM_PREFIX.length()) {
                sb.append(',').append(this.claimOrHeaderJsonText(this.confirmNotReservedClaimName(key.substring(STRING_CLAIM_PREFIX.length())), this.optionValue(key)));
                continue;
            }
            if (key.startsWith(NUMBER_CLAIM_PREFIX) && key.length() > NUMBER_CLAIM_PREFIX.length()) {
                sb.append(',').append(this.claimOrHeaderJsonText(this.confirmNotReservedClaimName(key.substring(NUMBER_CLAIM_PREFIX.length())), Double.valueOf(this.optionValue(key))));
                continue;
            }
            if (!key.startsWith(LIST_CLAIM_PREFIX) || key.length() <= LIST_CLAIM_PREFIX.length()) continue;
            sb.append(',').append(this.claimOrHeaderJsonArrayText(this.confirmNotReservedClaimName(key.substring(LIST_CLAIM_PREFIX.length())), this.listJsonText(this.optionValue(key))));
        }
        return sb.toString();
    }

    private String confirmNotReservedClaimName(String claimName) throws OAuthBearerConfigException {
        if (RESERVED_CLAIMS.contains(claimName)) {
            throw new OAuthBearerConfigException(String.format("Cannot explicitly set the '%s' claim", claimName));
        }
        return claimName;
    }

    private String listJsonText(String value) {
        String delimiter;
        String unescapedDelimiterChar;
        if (value.isEmpty() || value.length() <= 1) {
            return "[]";
        }
        switch (unescapedDelimiterChar = value.substring(0, 1)) {
            case "\\": 
            case ".": 
            case "[": 
            case "(": 
            case "{": 
            case "|": 
            case "^": 
            case "$": {
                delimiter = "\\" + unescapedDelimiterChar;
                break;
            }
            default: {
                delimiter = unescapedDelimiterChar;
            }
        }
        String listText = value.substring(1);
        String[] elements = listText.split(delimiter);
        StringBuilder sb = new StringBuilder();
        for (String element : elements) {
            sb.append(sb.length() == 0 ? (char)'[' : ',');
            sb.append('\"').append(this.escape(element)).append('\"');
        }
        if (listText.startsWith(unescapedDelimiterChar) || listText.endsWith(unescapedDelimiterChar) || listText.contains(unescapedDelimiterChar + unescapedDelimiterChar)) {
            sb.append(",\"\"");
        }
        return sb.append(']').toString();
    }

    private String optionValue(String key) {
        return this.optionValue(key, null);
    }

    private String optionValue(String key, String defaultValue) {
        String explicitValue = this.option(key);
        return explicitValue != null ? explicitValue : defaultValue;
    }

    private String option(String key) {
        if (!this.configured) {
            throw new IllegalStateException("Callback handler not configured");
        }
        return this.moduleOptions.get(Objects.requireNonNull(key));
    }

    private String claimOrHeaderJsonText(String claimName, Number claimValue) {
        return QUOTE + this.escape(claimName) + QUOTE + ":" + claimValue;
    }

    private String claimOrHeaderJsonText(String claimName, String claimValue) {
        return QUOTE + this.escape(claimName) + QUOTE + ":" + QUOTE + this.escape(claimValue) + QUOTE;
    }

    private String claimOrHeaderJsonArrayText(String claimName, String escapedClaimValue) {
        if (!escapedClaimValue.startsWith("[") || !escapedClaimValue.endsWith("]")) {
            throw new IllegalArgumentException(String.format("Illegal JSON array: %s", escapedClaimValue));
        }
        return QUOTE + this.escape(claimName) + QUOTE + ":" + escapedClaimValue;
    }

    private String escape(String jsonStringValue) {
        String replace1 = DOUBLEQUOTE.matcher(jsonStringValue).replaceAll(Matcher.quoteReplacement("\\\""));
        return BACKSLASH.matcher(replace1).replaceAll(Matcher.quoteReplacement("\\\\"));
    }

    private String expClaimText(long lifetimeSeconds) {
        return this.claimOrHeaderJsonText("exp", (double)this.time.milliseconds() / 1000.0 + (double)lifetimeSeconds);
    }
}

