/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.transforms;

import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.cache.Cache;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.cache.LRUCache;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.cache.SynchronizedCache;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.config.ConfigDef;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.connector.ConnectRecord;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.data.Schema;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.data.SchemaBuilder;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.data.Struct;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.transforms.Transformation;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.transforms.util.SimpleConfig;
import java.util.Collections;
import java.util.Map;

public abstract class HoistField<R extends ConnectRecord<R>>
implements Transformation<R> {
    public static final String OVERVIEW_DOC = "Wrap data using the specified field name in a Struct when schema present, or a Map in the case of schemaless data.<p/>Use the concrete transformation type designed for the record key (<code>" + Key.class.getName() + "</code>) or value (<code>" + Value.class.getName() + "</code>).";
    private static final String FIELD_CONFIG = "field";
    public static final ConfigDef CONFIG_DEF = new ConfigDef().define("field", ConfigDef.Type.STRING, ConfigDef.NO_DEFAULT_VALUE, ConfigDef.Importance.MEDIUM, "Field name for the single field that will be created in the resulting Struct or Map.");
    private Cache<Schema, Schema> schemaUpdateCache;
    private String fieldName;

    @Override
    public void configure(Map<String, ?> props) {
        SimpleConfig config = new SimpleConfig(CONFIG_DEF, props);
        this.fieldName = config.getString(FIELD_CONFIG);
        this.schemaUpdateCache = new SynchronizedCache<Schema, Schema>(new LRUCache(16));
    }

    @Override
    public R apply(R record) {
        Schema schema = this.operatingSchema(record);
        Object value = this.operatingValue(record);
        if (schema == null) {
            return this.newRecord(record, null, Collections.singletonMap(this.fieldName, value));
        }
        Schema updatedSchema = this.schemaUpdateCache.get(schema);
        if (updatedSchema == null) {
            updatedSchema = SchemaBuilder.struct().field(this.fieldName, schema).build();
            this.schemaUpdateCache.put(schema, updatedSchema);
        }
        Struct updatedValue = new Struct(updatedSchema).put(this.fieldName, value);
        return this.newRecord(record, updatedSchema, updatedValue);
    }

    @Override
    public void close() {
        this.schemaUpdateCache = null;
    }

    @Override
    public ConfigDef config() {
        return CONFIG_DEF;
    }

    protected abstract Schema operatingSchema(R var1);

    protected abstract Object operatingValue(R var1);

    protected abstract R newRecord(R var1, Schema var2, Object var3);

    public static class Value<R extends ConnectRecord<R>>
    extends HoistField<R> {
        @Override
        protected Schema operatingSchema(R record) {
            return ((ConnectRecord)record).valueSchema();
        }

        @Override
        protected Object operatingValue(R record) {
            return ((ConnectRecord)record).value();
        }

        @Override
        protected R newRecord(R record, Schema updatedSchema, Object updatedValue) {
            return ((ConnectRecord)record).newRecord(((ConnectRecord)record).topic(), ((ConnectRecord)record).kafkaPartition(), ((ConnectRecord)record).keySchema(), ((ConnectRecord)record).key(), updatedSchema, updatedValue, ((ConnectRecord)record).timestamp());
        }
    }

    public static class Key<R extends ConnectRecord<R>>
    extends HoistField<R> {
        @Override
        protected Schema operatingSchema(R record) {
            return ((ConnectRecord)record).keySchema();
        }

        @Override
        protected Object operatingValue(R record) {
            return ((ConnectRecord)record).key();
        }

        @Override
        protected R newRecord(R record, Schema updatedSchema, Object updatedValue) {
            return ((ConnectRecord)record).newRecord(((ConnectRecord)record).topic(), ((ConnectRecord)record).kafkaPartition(), updatedSchema, updatedValue, ((ConnectRecord)record).valueSchema(), ((ConnectRecord)record).value(), ((ConnectRecord)record).timestamp());
        }
    }
}

