/*
 * Decompiled with CFR 0.152.
 */
package net.querz.io;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;

public class LittleEndianInputStream
implements DataInput {
    private final DataInputStream in;

    public LittleEndianInputStream(InputStream in) {
        this.in = in instanceof DataInputStream ? (DataInputStream)in : new DataInputStream(in);
    }

    @Override
    public void readFully(byte[] b) throws IOException {
        this.in.readFully(b);
    }

    @Override
    public void readFully(byte[] b, int off, int len) throws IOException {
        this.in.readFully(b, off, len);
    }

    @Override
    public int skipBytes(int n) throws IOException {
        return this.in.skipBytes(n);
    }

    @Override
    public boolean readBoolean() throws IOException {
        return this.in.readBoolean();
    }

    @Override
    public byte readByte() throws IOException {
        return this.in.readByte();
    }

    @Override
    public int readUnsignedByte() throws IOException {
        return this.in.readUnsignedByte();
    }

    @Override
    public short readShort() throws IOException {
        return Short.reverseBytes(this.in.readShort());
    }

    @Override
    public int readUnsignedShort() throws IOException {
        return Short.toUnsignedInt(Short.reverseBytes(this.in.readShort()));
    }

    @Override
    public char readChar() throws IOException {
        return Character.reverseBytes(this.in.readChar());
    }

    @Override
    public int readInt() throws IOException {
        return Integer.reverseBytes(this.in.readInt());
    }

    @Override
    public long readLong() throws IOException {
        return Long.reverseBytes(this.in.readLong());
    }

    @Override
    public float readFloat() throws IOException {
        return Float.intBitsToFloat(Integer.reverseBytes(this.in.readInt()));
    }

    @Override
    public double readDouble() throws IOException {
        return Double.longBitsToDouble(Long.reverseBytes(this.in.readLong()));
    }

    @Override
    @Deprecated
    public String readLine() throws IOException {
        return this.in.readLine();
    }

    @Override
    public String readUTF() throws IOException {
        byte[] bytes = new byte[this.readUnsignedShort()];
        this.readFully(bytes);
        return new String(bytes, StandardCharsets.UTF_8);
    }
}

