/*
 * Decompiled with CFR 0.152.
 */
package net.querz.mcaselector.changer;

import java.util.ArrayList;
import java.util.function.Supplier;
import net.querz.mcaselector.changer.Field;
import net.querz.mcaselector.changer.fields.BiomeField;
import net.querz.mcaselector.changer.fields.CompressionField;
import net.querz.mcaselector.changer.fields.CustomField;
import net.querz.mcaselector.changer.fields.DataVersionField;
import net.querz.mcaselector.changer.fields.DeleteEntitiesField;
import net.querz.mcaselector.changer.fields.DeleteSectionsField;
import net.querz.mcaselector.changer.fields.DeleteStructureField;
import net.querz.mcaselector.changer.fields.FixHeightmapsField;
import net.querz.mcaselector.changer.fields.FixStatusField;
import net.querz.mcaselector.changer.fields.ForceBlendField;
import net.querz.mcaselector.changer.fields.InhabitedTimeField;
import net.querz.mcaselector.changer.fields.LastUpdateField;
import net.querz.mcaselector.changer.fields.LightPopulatedField;
import net.querz.mcaselector.changer.fields.PreventRetrogenField;
import net.querz.mcaselector.changer.fields.ReferenceField;
import net.querz.mcaselector.changer.fields.ReplaceBlocksField;
import net.querz.mcaselector.changer.fields.ScriptField;
import net.querz.mcaselector.changer.fields.StatusField;
import net.querz.mcaselector.changer.fields.TimestampField;

public enum FieldType {
    LIGHT_POPULATED("LightPopulated", LightPopulatedField::new, false, false),
    DATA_VERSION("DataVersion", DataVersionField::new, false, false),
    INHABITED_TIME("InhabitedTime", InhabitedTimeField::new, false, false),
    TIMESTAMP("Timestamp", TimestampField::new, false, false),
    COMPRESSION("Compression", CompressionField::new, false, false),
    LAST_UPDATE("LastUpdate", LastUpdateField::new, false, false),
    STATUS("Status", StatusField::new, false, true),
    BIOME("Biome", BiomeField::new, false, false),
    REPLACE_BLOCKS("ReplaceBlocks", ReplaceBlocksField::new, false, true),
    DELETE_ENTITIES("DeleteEntities", DeleteEntitiesField::new, false, false),
    DELETE_SECTIONS("DeleteSections", DeleteSectionsField::new, false, true),
    FIX_STATUS("FixStatus", FixStatusField::new, false, true),
    FIX_HEIGHTMAPS("FixHeightmaps", FixHeightmapsField::new, false, false),
    DELETE_STRUCTURE("DeleteStructureReference", DeleteStructureField::new, false, false),
    STRUCTURE_REFERENCE("FixStructureReferences", ReferenceField::new, true, false),
    PREVENT_RETROGEN("PreventRetrogen", PreventRetrogenField::new, false, false),
    FORCE_BLEND("ForceBlend", ForceBlendField::new, false, false),
    CUSTOM("Custom", CustomField::new, false, false),
    SCRIPT("Script", ScriptField::new, true, false);

    private final String name;
    private final Supplier<? extends Field<?>> constructor;
    private final boolean headlessOnly;
    private final boolean clearCache;
    private static FieldType[] uiValues;

    private FieldType(String name, Supplier<? extends Field<?>> constructor, boolean headlessOnly, boolean clearCache) {
        this.name = name;
        this.constructor = constructor;
        this.headlessOnly = headlessOnly;
        this.clearCache = clearCache;
    }

    public Field<?> newInstance() {
        return this.constructor.get();
    }

    public static FieldType getByName(String name) {
        for (FieldType f : FieldType.values()) {
            if (!f.name.equals(name)) continue;
            return f;
        }
        return null;
    }

    public boolean requiresClearCache() {
        return this.clearCache;
    }

    public String toString() {
        return this.name;
    }

    public static FieldType[] uiValues() {
        return uiValues;
    }

    static {
        ArrayList<FieldType> uiValues = new ArrayList<FieldType>(8);
        for (FieldType fieldType : FieldType.values()) {
            if (fieldType.headlessOnly) continue;
            uiValues.add(fieldType);
        }
        FieldType.uiValues = uiValues.toArray(new FieldType[0]);
    }
}

