/*
 * Decompiled with CFR 0.152.
 */
package net.querz.mcaselector.changer.fields;

import java.util.List;
import java.util.StringJoiner;
import net.querz.mcaselector.changer.Field;
import net.querz.mcaselector.changer.FieldType;
import net.querz.mcaselector.io.mca.ChunkData;
import net.querz.mcaselector.util.range.Range;
import net.querz.mcaselector.util.range.RangeParser;
import net.querz.mcaselector.version.ChunkFilter;
import net.querz.mcaselector.version.VersionHandler;

public class DeleteSectionsField
extends Field<List<Range>> {
    public DeleteSectionsField() {
        super(FieldType.DELETE_SECTIONS);
    }

    @Override
    public List<Range> getOldValue(ChunkData data) {
        return null;
    }

    @Override
    public boolean parseNewValue(String s) {
        if (this.getNewValue() != null) {
            ((List)this.getNewValue()).clear();
        }
        this.setNewValue(RangeParser.parseRanges(s, ","));
        if (this.getNewValue() != null && !((List)this.getNewValue()).isEmpty()) {
            return true;
        }
        return super.parseNewValue(s);
    }

    @Override
    public void change(ChunkData data) {
        VersionHandler.getImpl(data, ChunkFilter.Sections.class).deleteSections(data, (List)this.getNewValue());
        VersionHandler.getImpl(data, ChunkFilter.Entities.class).deleteEntities(data, (List)this.getNewValue());
        ChunkFilter.Heightmap heightmap = VersionHandler.getImpl(data, ChunkFilter.Heightmap.class);
        heightmap.worldSurface(data);
        heightmap.oceanFloor(data);
        heightmap.motionBlocking(data);
        heightmap.motionBlockingNoLeaves(data);
    }

    @Override
    public void force(ChunkData data) {
        this.change(data);
    }

    @Override
    public String toString() {
        if (((List)this.getNewValue()).size() == 1 && ((Range)((List)this.getNewValue()).get(0)).isMaxRange()) {
            return this.getType().toString() + " = true";
        }
        StringJoiner sj = new StringJoiner(", ");
        ((List)this.getNewValue()).forEach(r -> sj.add(r.toString()));
        return this.getType().toString() + " = \"" + String.valueOf(sj) + "\"";
    }

    @Override
    public String valueToString() {
        if (((List)this.getNewValue()).size() == 1 && ((Range)((List)this.getNewValue()).get(0)).isMaxRange()) {
            return "true";
        }
        StringJoiner sj = new StringJoiner(", ");
        ((List)this.getNewValue()).forEach(r -> sj.add(r.toString()));
        return sj.toString();
    }
}

