/*
 * Decompiled with CFR 0.152.
 */
package net.querz.mcaselector.changer.fields;

import java.util.HashMap;
import java.util.Map;
import net.querz.mcaselector.changer.Field;
import net.querz.mcaselector.changer.FieldType;
import net.querz.mcaselector.io.mca.ChunkData;
import net.querz.mcaselector.version.ChunkFilter;
import net.querz.mcaselector.version.VersionHandler;
import net.querz.mcaselector.version.mapping.registry.BlockRegistry;
import net.querz.nbt.CompoundTag;
import net.querz.nbt.io.snbt.ParseException;
import net.querz.nbt.io.snbt.SNBTParser;

public class ReplaceBlocksField
extends Field<Map<String, ChunkFilter.BlockReplaceData>> {
    public ReplaceBlocksField() {
        super(FieldType.REPLACE_BLOCKS);
    }

    @Override
    public boolean parseNewValue(String s) {
        HashMap<Object, ChunkFilter.BlockReplaceData> newValue = new HashMap<Object, ChunkFilter.BlockReplaceData>();
        String trimmed = s.trim();
        while (!trimmed.isEmpty()) {
            ChunkFilter.BlockReplaceData data;
            String[] fromTo = trimmed.split("=", 2);
            if (fromTo.length != 2) {
                return super.parseNewValue(s);
            }
            Object from = fromTo[0].trim();
            if (((String)from).startsWith("'") && ((String)from).endsWith("'") && ((String)from).length() > 2) {
                from = ((String)from).substring(1, ((String)from).length() - 1);
            } else if (!((String)from).startsWith("minecraft:") && !BlockRegistry.isValidName((String)(from = "minecraft:" + (String)from))) {
                return super.parseNewValue(s);
            }
            String to = fromTo[1].trim();
            int read = 0;
            CompoundTag toState = null;
            Object toName = null;
            if (to.startsWith("{")) {
                try {
                    SNBTParser parser = new SNBTParser(to);
                    toState = (CompoundTag)parser.parse(true);
                    read += parser.getReadChars() - 1;
                }
                catch (ParseException ex) {
                    return super.parseNewValue(s);
                }
            } else if (to.startsWith("'")) {
                int i;
                for (i = 1; i < to.length() && to.charAt(i) != '\''; ++i) {
                }
                toName = to.substring(1, Math.max(i, to.length()));
                if (!((String)toName).endsWith("'")) {
                    return super.parseNewValue(s);
                }
                if (((String)(toName = ((String)toName).substring(0, ((String)toName).length() - 1))).isEmpty()) {
                    return super.parseNewValue(s);
                }
                read += i + 1;
            } else {
                int i;
                for (i = 0; i < to.length() && to.charAt(i) != ',' && to.charAt(i) != ';'; ++i) {
                }
                toName = to.substring(0, i);
                if (!((String)toName).startsWith("minecraft:")) {
                    toName = "minecraft:" + (String)toName;
                }
                if (!BlockRegistry.isValidName((String)toName)) {
                    return super.parseNewValue(s);
                }
                read += i;
            }
            to = to.substring(read).trim();
            CompoundTag toTile = null;
            if (to.startsWith(";")) {
                if ((to = to.substring(1).trim()).isEmpty()) {
                    return super.parseNewValue(s);
                }
                try {
                    SNBTParser parser = new SNBTParser(to);
                    toTile = (CompoundTag)parser.parse(true);
                    int readTile = parser.getReadChars();
                    to = to.substring(readTile - 1);
                }
                catch (ParseException ex) {
                    return super.parseNewValue(s);
                }
            }
            if (toName != null && toTile != null) {
                data = new ChunkFilter.BlockReplaceData((String)toName, toTile);
            } else if (toName != null) {
                data = new ChunkFilter.BlockReplaceData((String)toName);
            } else if (toState != null && toTile != null) {
                data = new ChunkFilter.BlockReplaceData(toState, toTile);
            } else if (toState != null) {
                data = new ChunkFilter.BlockReplaceData(toState);
            } else {
                return super.parseNewValue(s);
            }
            newValue.put(from, data);
            to = to.trim();
            if (to.startsWith(",")) {
                trimmed = to.substring(1).trim();
                continue;
            }
            if (to.isEmpty()) break;
            return super.parseNewValue(s);
        }
        if (newValue.isEmpty()) {
            return super.parseNewValue(s);
        }
        this.setNewValue(newValue);
        return true;
    }

    @Override
    public Map<String, ChunkFilter.BlockReplaceData> getOldValue(ChunkData data) {
        return null;
    }

    @Override
    public void change(ChunkData data) {
        VersionHandler.getImpl(data, ChunkFilter.Blocks.class).replaceBlocks(data, (Map)this.getNewValue());
        ChunkFilter.Heightmap heightmap = VersionHandler.getImpl(data, ChunkFilter.Heightmap.class);
        heightmap.worldSurface(data);
        heightmap.oceanFloor(data);
        heightmap.motionBlocking(data);
        heightmap.motionBlockingNoLeaves(data);
    }

    @Override
    public void force(ChunkData data) {
        this.change(data);
    }

    @Override
    public String toString() {
        return this.getType().toString() + " = \"" + this.valueToString() + "\"";
    }

    @Override
    public String valueToString() {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (Map.Entry entry : ((Map)this.getNewValue()).entrySet()) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            String from = (String)entry.getKey();
            if (!from.startsWith("minecraft:")) {
                sb.append("'").append(from).append("'");
            } else {
                sb.append((String)entry.getKey());
            }
            sb.append("=");
            sb.append(this.escapeString(((ChunkFilter.BlockReplaceData)entry.getValue()).toString()));
        }
        return sb.toString();
    }

    private String escapeString(String s) {
        return s.replace("\\", "\\\\").replace("\"", "\\\"");
    }
}

