/*
 * Decompiled with CFR 0.152.
 */
package net.querz.mcaselector.cli;

import me.tongfei.progressbar.ProgressBar;
import me.tongfei.progressbar.ProgressBarBuilder;
import me.tongfei.progressbar.ProgressBarStyle;
import net.querz.mcaselector.util.progress.Progress;

public class CLIProgress
implements Progress {
    private final ProgressBar progressBar;
    private boolean cancelled = false;
    private Runnable doneAction;

    public CLIProgress(String name) {
        ProgressBarBuilder builder = new ProgressBarBuilder().setStyle(ProgressBarStyle.ASCII).setTaskName(name).setUpdateIntervalMillis(200);
        this.progressBar = builder.build();
    }

    @Override
    public void setMax(int max) {
        this.progressBar.maxHint(max);
        this.progressBar.reset();
    }

    @Override
    public void updateProgress(String msg, int progress) {
        this.progressBar.stepTo(progress);
        this.progressBar.setExtraMessage(msg);
        this.checkDone();
    }

    @Override
    public void done(String msg) {
        this.progressBar.close();
        if (this.doneAction != null) {
            this.doneAction.run();
        }
    }

    @Override
    public boolean taskCancelled() {
        return this.cancelled;
    }

    @Override
    public void cancelTask() {
        this.cancelled = true;
        this.progressBar.setExtraMessage("cancelled");
        this.progressBar.close();
    }

    @Override
    public void incrementProgress(String msg) {
        this.progressBar.stepBy(1L);
        this.progressBar.setExtraMessage(msg);
        this.checkDone();
    }

    @Override
    public void incrementProgress(String msg, int progress) {
        this.progressBar.stepBy(progress);
        this.progressBar.setExtraMessage(msg);
        this.checkDone();
    }

    @Override
    public void setMessage(String msg) {
        this.progressBar.setExtraMessage(msg);
    }

    public void onDone(Runnable doneAction) {
        this.doneAction = doneAction;
    }

    private void checkDone() {
        if (this.progressBar.getCurrent() >= this.progressBar.getMax()) {
            this.progressBar.refresh();
            if (this.doneAction != null) {
                this.doneAction.run();
            }
            this.progressBar.close();
        }
    }
}

