/*
 * Decompiled with CFR 0.152.
 */
package net.querz.mcaselector.cli;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.FutureTask;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.querz.mcaselector.text.Translation;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.ParseException;

public class Translations {
    static void printMissingTranslations(FutureTask<Boolean> future) {
        Set<Locale> locales = Translation.getAvailableLanguages();
        for (Locale locale : locales) {
            Translation.load(locale);
            boolean printedLanguage = false;
            for (Translation translation : Translation.values()) {
                if (translation.isTranslated()) continue;
                if (!printedLanguage) {
                    System.out.println(String.valueOf(locale) + ":");
                    printedLanguage = true;
                }
                System.out.println("  " + translation.getKey());
            }
        }
        future.run();
    }

    static void printTranslation(CommandLine line, FutureTask<Boolean> future) throws ParseException {
        String l = line.getOptionValue("locale");
        if (l == null) {
            throw new ParseException("no locale");
        }
        if (l.equals("updateResources")) {
            Set<Locale> locales = Translation.getAvailableLanguages();
            for (Locale locale : locales) {
                Translation.load(locale);
                try (OutputStreamWriter osw = new OutputStreamWriter((OutputStream)new FileOutputStream("src/main/resources/lang/" + String.valueOf(locale) + ".txt"), StandardCharsets.UTF_8);){
                    boolean first = true;
                    for (Translation translation : Translation.values()) {
                        osw.write((first ? "" : "\n") + translation.getKey() + ";" + (translation.isTranslated() ? translation.toString().replace("\n", "\\n") : ""));
                        first = false;
                    }
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        } else {
            Pattern languageFilePattern = Pattern.compile("^(?<locale>-?(?<language>-?[a-z]{2})_(?<country>-?[A-Z]{2}))$");
            Matcher matcher = languageFilePattern.matcher(l);
            if (!matcher.matches()) {
                throw new ParseException("invalid locale " + l);
            }
            String language = matcher.group("language");
            String country = matcher.group("country");
            Locale locale = Locale.of(language, country);
            Translation.load(locale);
            try (OutputStreamWriter osw = new OutputStreamWriter((OutputStream)System.out, StandardCharsets.UTF_8);){
                for (Translation translation : Translation.values()) {
                    osw.write(translation.getKey() + ";" + (translation.isTranslated() ? translation.toString().replace("\n", "\\n") : "") + "\n");
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        future.run();
    }

    static void printTranslationKeys(FutureTask<Boolean> future) {
        for (Translation translation : Translation.values()) {
            System.out.println(translation.getKey() + ";");
        }
        future.run();
    }
}

