/*
 * Decompiled with CFR 0.152.
 */
package net.querz.mcaselector.config;

import com.google.gson.Gson;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.TreeMap;
import net.querz.mcaselector.logging.Logging;
import net.querz.mcaselector.util.math.Bits;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class Config {
    public static final File BASE_DIR;
    public static final File BASE_CACHE_DIR;
    public static final File BASE_LOG_DIR;
    public static final File BASE_CONFIG_FILE;
    public static final File BASE_OVERLAYS_FILE;
    public static final float MAX_SCALE = 15.9999f;
    public static final float MIN_SCALE = 0.05f;
    public static final int MIN_ZOOM_LEVEL;
    public static final int MAX_ZOOM_LEVEL;
    public static final double IMAGE_POOL_SIZE = 2.5;
    public static final int MAX_RECENT_FILES = 16;
    private static final Logger LOGGER;

    private static File getEnvFilesWithDefault(String def, String suffix, char divider, String ... envs) {
        File file;
        for (String env : envs) {
            String value = System.getenv(env);
            if (value == null || value.isEmpty()) continue;
            String[] split = value.split("" + divider);
            if (split.length > 1) {
                for (String part : split) {
                    File f = new File(Config.resolveHome(part), suffix);
                    if (!f.exists()) continue;
                    return f;
                }
                file = new File(Config.resolveHome(split[0]), suffix);
            } else {
                file = new File(Config.resolveHome(value), suffix);
            }
            if (!Config.attemptCreateDirectory(file)) continue;
            return file;
        }
        file = new File(Config.resolveHome(def), suffix);
        if (Config.attemptCreateDirectory(file)) {
            return file;
        }
        throw new RuntimeException("failed to create directories for " + suffix + ", please check permissions for " + Config.resolveHome(def));
    }

    private static boolean attemptCreateDirectory(File file) {
        File parent = file.getParentFile();
        if (parent == null) {
            return false;
        }
        try {
            Files.createDirectories(parent.getCanonicalFile().toPath(), new FileAttribute[0]);
            return true;
        }
        catch (IOException ex) {
            return false;
        }
    }

    private static String resolveHome(String dir) {
        if (dir.startsWith("~/")) {
            return System.getProperty("user.home") + dir.substring(1);
        }
        return dir;
    }

    public abstract void save();

    protected String save(Gson gson) {
        return gson.toJson(this);
    }

    protected void save(Gson gson, File file) {
        try {
            Files.writeString(file.toPath(), (CharSequence)this.save(gson), new OpenOption[0]);
        }
        catch (IOException ex) {
            LOGGER.warn("error writing config file " + String.valueOf(file), (Throwable)ex);
        }
    }

    protected static String loadString(File file) {
        try {
            return Files.readString(file.toPath());
        }
        catch (IOException ex) {
            LOGGER.warn("error reading config file " + String.valueOf(file), (Throwable)ex);
            return null;
        }
    }

    static {
        String path = ".";
        try {
            String jarPath = Config.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath();
            if (!jarPath.endsWith(".jar")) {
                path = jarPath.replaceAll("build/classes/java/main/$", "");
            } else {
                File jarFile = new File(jarPath);
                path = jarFile.getParent();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        BASE_DIR = new File(path);
        String osName = System.getProperty("os.name").toLowerCase();
        if (osName.contains("mac")) {
            BASE_CACHE_DIR = new File(System.getProperty("user.home"), "Library/Caches/mcaselector");
            BASE_LOG_DIR = new File(System.getProperty("user.home"), "Library/Logs/mcaselector");
            BASE_CONFIG_FILE = new File(System.getProperty("user.home"), "Library/Application Support/mcaselector/settings.json");
            BASE_OVERLAYS_FILE = new File(System.getProperty("user.home"), "Library/Application Support/mcaselector/overlays.json");
        } else if (osName.contains("windows")) {
            BASE_CACHE_DIR = Config.getEnvFilesWithDefault(BASE_DIR.getAbsolutePath(), "mcaselector/cache", ';', "LOCALAPPDATA");
            BASE_LOG_DIR = Config.getEnvFilesWithDefault(BASE_DIR.getAbsolutePath(), "mcaselector/log", ';', "LOCALAPPDATA");
            BASE_CONFIG_FILE = Config.getEnvFilesWithDefault(BASE_DIR.getAbsolutePath(), "mcaselector/settings.json", ';', "LOCALAPPDATA");
            BASE_OVERLAYS_FILE = Config.getEnvFilesWithDefault(BASE_DIR.getAbsolutePath(), "mcaselector/overlays.json", ';', "LOCALAPPDATA");
        } else {
            BASE_CACHE_DIR = Config.getEnvFilesWithDefault("~/.cache", "mcaselector", ':', "XDG_CACHE_HOME", "XDG_CACHE_DIRS");
            BASE_LOG_DIR = Config.getEnvFilesWithDefault("~/.local/share", "mcaselector/log", ':', "XDG_DATA_HOME", "XDG_DATA_DIRS");
            BASE_CONFIG_FILE = Config.getEnvFilesWithDefault("~/.mcaselector", "mcaselector/settings.json", ':', "XDG_CONFIG_HOME", "XDG_CONFIG_DIRS");
            BASE_OVERLAYS_FILE = Config.getEnvFilesWithDefault("~/.mcaselector", "mcaselector/overlays.json", ':', "XDG_CONFIG_HOME", "XDG_CONFIG_DIRS");
        }
        if (!BASE_CACHE_DIR.exists()) {
            BASE_CACHE_DIR.mkdirs();
        }
        if (!BASE_LOG_DIR.exists()) {
            BASE_LOG_DIR.mkdirs();
        }
        if (!BASE_OVERLAYS_FILE.getParentFile().exists()) {
            BASE_OVERLAYS_FILE.getParentFile().mkdirs();
        }
        Logging.setLogDir(BASE_LOG_DIR);
        MIN_ZOOM_LEVEL = Bits.getMsb(0);
        MAX_ZOOM_LEVEL = Bits.getMsb(15);
        LOGGER = LogManager.getLogger(Config.class);
    }

    public static class RecentFiles
    extends TreeMap<Long, File> {
        public void addRecentFile(File file) {
            if (file == null) {
                return;
            }
            for (Map.Entry entry : this.entrySet()) {
                if (!((File)entry.getValue()).equals(file)) continue;
                this.remove(entry.getKey());
                this.put(System.currentTimeMillis(), file);
                return;
            }
            if (this.size() >= 16) {
                this.remove(this.firstKey());
            }
            this.put(System.currentTimeMillis(), file);
        }
    }
}

