/*
 * Decompiled with CFR 0.152.
 */
package net.querz.mcaselector.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Pattern;
import net.querz.mcaselector.config.Config;
import net.querz.mcaselector.config.adapter.ColorAdapter;
import net.querz.mcaselector.config.adapter.FileAdapter;
import net.querz.mcaselector.config.adapter.LocaleAdapter;
import net.querz.mcaselector.io.FileHelper;
import net.querz.mcaselector.logging.GsonNamingStrategy;
import net.querz.mcaselector.logging.Logging;
import net.querz.mcaselector.text.Translation;
import net.querz.mcaselector.ui.Color;

public class GlobalConfig
extends Config {
    private static final Gson gsonInstance;
    public static final Color DEFAULT_REGION_SELECTION_COLOR;
    public static final Color DEFAULT_CHUNK_SELECTION_COLOR;
    public static final Color DEFAULT_PASTE_CHUNKS_COLOR;
    public static final Locale DEFAULT_LOCALE;
    public static final int DEFAULT_PROCESS_THREADS;
    public static final int DEFAULT_WRITE_THREADS;
    public static final int DEFAULT_MAX_LOADED_FILES = 1;
    public static final boolean DEFAULT_DEBUG = false;
    public static final String DEFAULT_MC_SAVES_DIR;
    private Locale locale = DEFAULT_LOCALE;
    private Color regionSelectionColor = DEFAULT_REGION_SELECTION_COLOR;
    private Color chunkSelectionColor = DEFAULT_CHUNK_SELECTION_COLOR;
    private Color pasteChunksColor = DEFAULT_PASTE_CHUNKS_COLOR;
    private int processThreads = DEFAULT_PROCESS_THREADS;
    private int writeThreads = DEFAULT_WRITE_THREADS;
    private int maxLoadedFiles = 1;
    private String mcSavesDir = DEFAULT_MC_SAVES_DIR;
    private boolean debug = false;
    private TreeMap<Long, RecentWorld> recentWorlds = new TreeMap();
    private Config.RecentFiles recentFilterScripts = new Config.RecentFiles();
    private Config.RecentFiles recentChangeScripts = new Config.RecentFiles();
    private Config.RecentFiles recentOverlayScripts = new Config.RecentFiles();
    private TempScript filterScript = new TempScript(null, false, "");
    private TempScript changeScript = new TempScript(null, false, "");
    private TempScript overlayScript = new TempScript(null, false, "");
    private static final Gson toStringGsonInstance;

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
        Translation.load(locale);
    }

    public Color getRegionSelectionColor() {
        return this.regionSelectionColor;
    }

    public void setRegionSelectionColor(Color regionSelectionColor) {
        this.regionSelectionColor = regionSelectionColor;
    }

    public Color getChunkSelectionColor() {
        return this.chunkSelectionColor;
    }

    public void setChunkSelectionColor(Color chunkSelectionColor) {
        this.chunkSelectionColor = chunkSelectionColor;
    }

    public Color getPasteChunksColor() {
        return this.pasteChunksColor;
    }

    public void setPasteChunksColor(Color pasteChunksColor) {
        this.pasteChunksColor = pasteChunksColor;
    }

    public int getProcessThreads() {
        return this.processThreads;
    }

    public void setProcessThreads(int processThreads) {
        this.processThreads = processThreads;
    }

    public int getWriteThreads() {
        return this.writeThreads;
    }

    public void setWriteThreads(int writeThreads) {
        this.writeThreads = writeThreads;
    }

    public int getMaxLoadedFiles() {
        return this.maxLoadedFiles;
    }

    public void setMaxLoadedFiles(int maxLoadedFiles) {
        this.maxLoadedFiles = maxLoadedFiles;
    }

    public String getMcSavesDir() {
        return this.mcSavesDir;
    }

    public void setMcSavesDir(String mcSavesDir) {
        this.mcSavesDir = mcSavesDir;
    }

    public boolean getDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
        Logging.setLogLevel(debug ? "DEBUG" : "WARN");
        Logging.updateThreadContext();
    }

    public TreeMap<Long, RecentWorld> getRecentWorlds() {
        return this.recentWorlds;
    }

    public void addRecentWorld(File world, List<File> dimensionDirectories) {
        if (world == null) {
            return;
        }
        for (Map.Entry<Long, RecentWorld> entry : this.recentWorlds.entrySet()) {
            if (!entry.getValue().recentWorld.equals(world)) continue;
            this.recentWorlds.remove(entry.getKey());
            this.recentWorlds.put(System.currentTimeMillis(), new RecentWorld(world, dimensionDirectories));
            return;
        }
        if (this.recentWorlds.size() >= 16) {
            this.recentWorlds.remove(this.recentWorlds.firstKey());
        }
        this.recentWorlds.put(System.currentTimeMillis(), new RecentWorld(world, dimensionDirectories));
    }

    public Config.RecentFiles getRecentFilterScripts() {
        return this.recentFilterScripts;
    }

    public void addRecentFilterScript(File file) {
        this.recentFilterScripts.addRecentFile(file);
    }

    public Config.RecentFiles getRecentChangeScripts() {
        return this.recentChangeScripts;
    }

    public void addRecentChangeScript(File file) {
        this.recentChangeScripts.addRecentFile(file);
    }

    public Config.RecentFiles getRecentOverlayScripts() {
        return this.recentOverlayScripts;
    }

    public void addRecentOverlayScript(File file) {
        this.recentOverlayScripts.addRecentFile(file);
    }

    public TempScript getFilterScript() {
        return this.filterScript;
    }

    public void setFilterScript(TempScript filterScript) {
        this.filterScript = filterScript;
    }

    public TempScript getChangeScript() {
        return this.changeScript;
    }

    public void setChangeScript(TempScript changeScript) {
        this.changeScript = changeScript;
    }

    public TempScript getOverlayScript() {
        return this.overlayScript;
    }

    public void setOverlayScript(TempScript overlayScript) {
        this.overlayScript = overlayScript;
    }

    @Override
    public void save() {
        this.save(gsonInstance, BASE_CONFIG_FILE);
    }

    public static GlobalConfig load() {
        String json = GlobalConfig.loadString(BASE_CONFIG_FILE);
        if (json == null) {
            return new GlobalConfig();
        }
        GlobalConfig cfg = gsonInstance.fromJson(json, GlobalConfig.class);
        cfg.setDebug(cfg.getDebug());
        return cfg;
    }

    public String toString() {
        return toStringGsonInstance.toJson(this);
    }

    static {
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapter((Type)((Object)Color.class), new ColorAdapter());
        builder.registerTypeAdapter((Type)((Object)File.class), new FileAdapter(BASE_DIR.getAbsolutePath()));
        builder.registerTypeAdapter((Type)((Object)Locale.class), new LocaleAdapter());
        builder.setPrettyPrinting();
        gsonInstance = builder.create();
        DEFAULT_REGION_SELECTION_COLOR = new Color(1.0, 0.45, 0.0, 0.8);
        DEFAULT_CHUNK_SELECTION_COLOR = new Color(1.0, 0.45, 0.0, 0.8);
        DEFAULT_PASTE_CHUNKS_COLOR = new Color(0.0, 1.0, 0.0, 0.8);
        DEFAULT_LOCALE = Locale.UK;
        DEFAULT_PROCESS_THREADS = Math.min(Math.max(Runtime.getRuntime().availableProcessors() - 2, 1), 4);
        DEFAULT_WRITE_THREADS = Math.min(Math.max(Runtime.getRuntime().availableProcessors(), 1), 4);
        DEFAULT_MC_SAVES_DIR = FileHelper.getMCSavesDir();
        builder = new GsonBuilder();
        builder.registerTypeAdapter((Type)((Object)Color.class), new ColorAdapter());
        builder.registerTypeAdapter((Type)((Object)File.class), new FileAdapter(BASE_DIR.getAbsolutePath()));
        builder.registerTypeAdapter((Type)((Object)Locale.class), new LocaleAdapter());
        builder.serializeNulls();
        builder.excludeFieldsWithModifiers(8);
        builder.setFieldNamingStrategy(new GsonNamingStrategy());
        toStringGsonInstance = builder.create();
    }

    public record TempScript(File file, boolean saved, String text) {
    }

    public record RecentWorld(File recentWorld, List<File> dimensionDirectories) {
        private static final Pattern dimensionFolderPattern = Pattern.compile("^DIM-?\\d+$");

        @Override
        public String toString() {
            String name = this.recentWorld.getName();
            if (dimensionFolderPattern.matcher(name).matches()) {
                File parent = this.recentWorld.getParentFile();
                if (parent == null) {
                    return name;
                }
                return parent.getName() + "/" + name;
            }
            return name;
        }
    }
}

