/*
 * Decompiled with CFR 0.152.
 */
package net.querz.mcaselector.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.lang.reflect.Type;
import java.util.List;
import java.util.UUID;
import net.querz.mcaselector.config.Config;
import net.querz.mcaselector.config.adapter.FileAdapter;
import net.querz.mcaselector.config.adapter.WorldDirectoriesAdapter;
import net.querz.mcaselector.io.WorldDirectories;
import net.querz.mcaselector.logging.GsonNamingStrategy;
import net.querz.mcaselector.util.math.Bits;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class WorldConfig
extends Config {
    private static final Gson gsonInstance;
    public static final int DEFAULT_RENDER_HEIGHT = 319;
    public static final boolean DEFAULT_RENDER_LAYER_ONLY = false;
    public static final boolean DEFAULT_RENDER_CAVES = false;
    public static final boolean DEFAULT_SHADE = true;
    public static final boolean DEFAULT_SHADE_WATER = true;
    public static final boolean DEFAULT_SHADE_ALTITUDE = true;
    public static final boolean DEFAULT_SMOOTH_RENDERING = false;
    public static final boolean DEFAULT_SMOOTH_OVERLAYS = true;
    public static final String DEFAULT_TILEMAP_BACKGROUND = "BLACK";
    public static final boolean DEFAULT_SHOW_NONEXISTENT_REGIONS = true;
    private transient File regionDir = null;
    private transient WorldDirectories worldDirs = null;
    private transient UUID worldUUID = null;
    private transient File cacheDir = null;
    private transient File cacheDBDir = null;
    private transient List<File> dimensionDirectories = null;
    private transient File[] zoomLevelCacheDirs = null;
    private int renderHeight = 319;
    private boolean renderLayerOnly = false;
    private boolean renderCaves = false;
    private boolean shade = true;
    private boolean shadeWater = true;
    private boolean shadeAltitude = true;
    private boolean smoothRendering = false;
    private boolean smoothOverlays = true;
    private String tileMapBackground = "BLACK";
    private boolean showNonexistentRegions = true;
    private static final Logger LOGGER;
    private static final Gson toStringGsonInstance;

    public File getRegionDir() {
        return this.regionDir;
    }

    public void setWorldDirs(WorldDirectories worldDirs) {
        this.worldDirs = worldDirs;
        this.worldUUID = UUID.nameUUIDFromBytes(worldDirs.getRegion().getAbsolutePath().getBytes());
        this.setCacheDir(BASE_CACHE_DIR);
        this.regionDir = worldDirs.getRegion();
        this.zoomLevelCacheDirs = new File[Bits.lsbPosition(MAX_ZOOM_LEVEL) + 1];
        for (int i = MAX_ZOOM_LEVEL; i > 0; i >>= 1) {
            this.zoomLevelCacheDirs[Bits.lsbPosition((int)i)] = new File(this.cacheDir, "" + i);
        }
    }

    public WorldDirectories getWorldDirs() {
        return this.worldDirs;
    }

    public UUID getWorldUUID() {
        return this.worldUUID;
    }

    public File getCacheDir() {
        return this.cacheDir;
    }

    public File getCacheDBDir() {
        return this.cacheDBDir;
    }

    public File getCacheDir(int zoomLevel) {
        return this.zoomLevelCacheDirs[Bits.lsbPosition(zoomLevel)];
    }

    public File[] getCacheDirs() {
        return this.zoomLevelCacheDirs;
    }

    public void setCacheDir(File cacheDir) {
        this.cacheDir = new File(cacheDir, this.worldUUID.toString().replace("-", ""));
        this.cacheDBDir = new File(cacheDir, "cache");
    }

    public List<File> getDimensionDirectories() {
        return this.dimensionDirectories;
    }

    public int getRenderHeight() {
        return this.renderHeight;
    }

    public void setRenderHeight(int renderHeight) {
        this.renderHeight = renderHeight;
    }

    public boolean getRenderLayerOnly() {
        return this.renderLayerOnly;
    }

    public void setRenderLayerOnly(boolean renderLayerOnly) {
        this.renderLayerOnly = renderLayerOnly;
    }

    public boolean getRenderCaves() {
        return this.renderCaves;
    }

    public void setRenderCaves(boolean renderCaves) {
        this.renderCaves = renderCaves;
    }

    public boolean getShade() {
        return this.shade;
    }

    public void setShade(boolean shade) {
        this.shade = shade;
    }

    public boolean getShadeWater() {
        return this.shadeWater;
    }

    public void setShadeWater(boolean shadeWater) {
        this.shadeWater = shadeWater;
    }

    public boolean getShadeAltitude() {
        return this.shadeAltitude;
    }

    public void setShadeAltitude(boolean shadeAltitude) {
        this.shadeAltitude = shadeAltitude;
    }

    public boolean getSmoothRendering() {
        return this.smoothRendering;
    }

    public void setSmoothRendering(boolean smoothRendering) {
        this.smoothRendering = smoothRendering;
    }

    public boolean getSmoothOverlays() {
        return this.smoothOverlays;
    }

    public void setSmoothOverlays(boolean smoothOverlays) {
        this.smoothOverlays = smoothOverlays;
    }

    public String getTileMapBackground() {
        return this.tileMapBackground;
    }

    public void setTileMapBackground(String tileMapBackground) {
        this.tileMapBackground = tileMapBackground;
    }

    public boolean getShowNonexistentRegions() {
        return this.showNonexistentRegions;
    }

    public void setShowNonexistentRegions(boolean showNonexistentRegions) {
        this.showNonexistentRegions = showNonexistentRegions;
    }

    @Override
    public void save() {
        this.save(gsonInstance, new File(this.cacheDir, "world_settings.json"));
    }

    public static WorldConfig load(WorldDirectories worldDirectories, List<File> dimensionDirectories) {
        LOGGER.debug("setting world directories to {}", (Object)worldDirectories);
        UUID worldUUID = UUID.nameUUIDFromBytes(worldDirectories.getRegion().getAbsolutePath().getBytes());
        File cacheDir = new File(BASE_CACHE_DIR, worldUUID.toString().replace("-", ""));
        String json = WorldConfig.loadString(new File(cacheDir, "world_settings.json"));
        WorldConfig cfg = json == null ? new WorldConfig() : gsonInstance.fromJson(json, WorldConfig.class);
        cfg.worldUUID = worldUUID;
        cfg.regionDir = worldDirectories.getRegion();
        cfg.worldDirs = worldDirectories;
        cfg.dimensionDirectories = dimensionDirectories;
        cfg.setCacheDir(BASE_CACHE_DIR);
        cfg.zoomLevelCacheDirs = new File[Bits.lsbPosition(MAX_ZOOM_LEVEL) + 1];
        for (int i = MAX_ZOOM_LEVEL; i > 0; i >>= 1) {
            cfg.zoomLevelCacheDirs[Bits.lsbPosition((int)i)] = new File(cfg.cacheDir, "" + i);
        }
        return cfg;
    }

    public String toString() {
        return toStringGsonInstance.toJson(this);
    }

    static {
        GsonBuilder builder = new GsonBuilder();
        builder.setPrettyPrinting();
        gsonInstance = builder.create();
        LOGGER = LogManager.getLogger(WorldConfig.class);
        builder = new GsonBuilder();
        builder.excludeFieldsWithModifiers(8);
        builder.serializeNulls();
        builder.setFieldNamingStrategy(new GsonNamingStrategy());
        builder.registerTypeAdapter((Type)((Object)File.class), new FileAdapter(BASE_DIR.getAbsolutePath()));
        builder.registerTypeAdapter((Type)((Object)WorldDirectories.class), new WorldDirectoriesAdapter());
        toStringGsonInstance = builder.create();
    }
}

