/*
 * Decompiled with CFR 0.152.
 */
package net.querz.mcaselector.filter;

import java.io.Serializable;
import net.querz.mcaselector.filter.Comparator;
import net.querz.mcaselector.filter.FilterType;
import net.querz.mcaselector.filter.Operator;
import net.querz.mcaselector.io.mca.ChunkData;

public abstract class Filter<T>
implements Serializable {
    private String rawValue;
    private boolean valid = true;
    private final FilterType type;
    private Operator operator;
    private Filter<?> parent;

    public Filter(FilterType type) {
        this(type, Operator.AND);
    }

    public Filter(FilterType type, Operator operator) {
        this.type = type;
        this.operator = operator;
    }

    public boolean isValid() {
        return this.valid;
    }

    protected void setValid(boolean valid) {
        this.valid = valid;
    }

    public String getRawValue() {
        return this.rawValue;
    }

    public void setRawValue(String rawValue) {
        this.rawValue = rawValue;
    }

    public Operator getOperator() {
        return this.operator;
    }

    public void setOperator(Operator operator) {
        this.operator = operator;
    }

    public FilterType getType() {
        return this.type;
    }

    public void setParent(Filter<?> parent) {
        this.parent = parent;
    }

    public Filter<?> getParent() {
        return this.parent;
    }

    public void resetTempData() {
    }

    public boolean selectionOnly() {
        return false;
    }

    public abstract T getFilterValue();

    public abstract void setFilterValue(String var1);

    public abstract Comparator[] getComparators();

    public abstract Comparator getComparator();

    public abstract void setComparator(Comparator var1);

    public abstract boolean matches(ChunkData var1);

    public abstract Filter<T> clone();

    protected static String escape(String value) {
        if (value == null) {
            return "\"\"";
        }
        return "\"" + value.replaceAll("\\\\", "\\\\\\\\").replaceAll("\"", "\\\\\"") + "\"";
    }
}

