/*
 * Decompiled with CFR 0.152.
 */
package net.querz.mcaselector.filter;

import net.querz.mcaselector.filter.Comparator;
import net.querz.mcaselector.filter.Filter;
import net.querz.mcaselector.filter.FilterType;
import net.querz.mcaselector.filter.Operator;
import net.querz.mcaselector.io.mca.ChunkData;

public abstract class TextFilter<T>
extends Filter<T> {
    private static final Comparator[] comparators = new Comparator[]{Comparator.CONTAINS, Comparator.CONTAINS_NOT, Comparator.INTERSECTS};
    protected T value;
    private Comparator comparator;

    public TextFilter(FilterType type, Operator operator, Comparator comparator, T value) {
        super(type, operator);
        this.comparator = comparator;
        this.value = value;
    }

    @Override
    public Comparator[] getComparators() {
        return comparators;
    }

    @Override
    public Comparator getComparator() {
        return this.comparator;
    }

    @Override
    public void setComparator(Comparator comparator) {
        this.comparator = comparator;
    }

    @Override
    public boolean matches(ChunkData data) {
        return switch (this.comparator) {
            case Comparator.CONTAINS -> this.contains(this.value, data);
            case Comparator.CONTAINS_NOT -> this.containsNot(this.value, data);
            case Comparator.INTERSECTS -> this.intersects(this.value, data);
            default -> false;
        };
    }

    @Override
    public T getFilterValue() {
        return this.value;
    }

    public void setValue(T value) {
        this.value = value;
    }

    public abstract String getFormatText();

    public abstract boolean contains(T var1, ChunkData var2);

    public abstract boolean containsNot(T var1, ChunkData var2);

    public abstract boolean intersects(T var1, ChunkData var2);
}

