/*
 * Decompiled with CFR 0.152.
 */
package net.querz.mcaselector.filter.filters;

import it.unimi.dsi.fastutil.longs.Long2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectSortedMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectSortedMaps;
import java.io.IOException;
import net.querz.mcaselector.filter.Comparator;
import net.querz.mcaselector.filter.FilterType;
import net.querz.mcaselector.filter.IntFilter;
import net.querz.mcaselector.filter.Operator;
import net.querz.mcaselector.io.FileHelper;
import net.querz.mcaselector.io.mca.ChunkData;
import net.querz.mcaselector.io.mca.RegionMCAFile;
import net.querz.mcaselector.util.point.Point2i;
import net.querz.mcaselector.version.ChunkFilter;
import net.querz.mcaselector.version.VersionHandler;
import net.querz.nbt.StringTag;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BorderFilter
extends IntFilter {
    private static final Logger LOGGER = LogManager.getLogger(BorderFilter.class);
    protected final Object regionBufferLock;
    protected Long2ObjectSortedMap<RegionMCAFile> regionBuffer;

    public BorderFilter() {
        this(Operator.AND, Comparator.LARGER, 0, new Object());
    }

    private BorderFilter(Operator operator, Comparator comparator, int value, Object lock) {
        super(FilterType.BORDER, operator, comparator, value);
        this.regionBufferLock = lock;
        this.regionBuffer = Long2ObjectSortedMaps.synchronize(new Long2ObjectLinkedOpenHashMap(32), this.regionBufferLock);
    }

    @Override
    protected Integer getNumber(ChunkData data) {
        if (data.region() == null || data.region().getData() == null) {
            return 9;
        }
        ChunkFilter.Status filter = VersionHandler.getImpl(data, ChunkFilter.Status.class);
        StringTag tag = filter.getStatus(data);
        if (tag == null || !tag.getValue().equals("full")) {
            return 9;
        }
        int count = 0;
        Point2i location = data.region().getAbsoluteLocation();
        Point2i relative = this.getRelativeChunk(location);
        RegionMCAFile self = this.getRegionHeader(location.chunkToRegion());
        if (self == null) {
            return 9;
        }
        RegionMCAFile mcaFileTop = null;
        RegionMCAFile mcaFileRight = null;
        RegionMCAFile mcaFileBottom = null;
        RegionMCAFile mcaFileLeft = null;
        RegionMCAFile mcaFileTopLeft = null;
        RegionMCAFile mcaFileTopRight = null;
        RegionMCAFile mcaFileBottomRight = null;
        RegionMCAFile mcaFileBottomLeft = null;
        if (relative.getX() == 0) {
            Point2i left = location.add(-1, 0);
            mcaFileLeft = this.getRegionHeader(left.chunkToRegion());
            if (relative.getZ() == 0) {
                Point2i topLeft = location.add(-1, -1);
                mcaFileTopLeft = this.getRegionHeader(topLeft.chunkToRegion());
            } else {
                mcaFileTopLeft = mcaFileLeft;
            }
        }
        if (relative.getX() == 31) {
            Point2i right = location.add(1, 0);
            mcaFileRight = this.getRegionHeader(right.chunkToRegion());
            if (relative.getZ() == 31) {
                Point2i bottomRight = location.add(1, 1);
                mcaFileBottomRight = this.getRegionHeader(bottomRight.chunkToRegion());
            } else {
                mcaFileBottomRight = mcaFileRight;
            }
        }
        if (relative.getZ() == 0) {
            Point2i top = location.add(0, -1);
            mcaFileTop = this.getRegionHeader(top.chunkToRegion());
            if (relative.getX() == 31) {
                Point2i topRight = location.add(1, -1);
                mcaFileTopRight = this.getRegionHeader(topRight.chunkToRegion());
            } else {
                mcaFileTopRight = mcaFileTop;
            }
        } else {
            mcaFileTop = self;
            mcaFileTopRight = relative.getX() != 31 ? self : mcaFileRight;
        }
        if (relative.getZ() == 31) {
            Point2i bottom = location.add(0, 1);
            mcaFileBottom = this.getRegionHeader(bottom.chunkToRegion());
            if (relative.getX() == 0) {
                Point2i bottomLeft = location.add(-1, 1);
                mcaFileBottomLeft = this.getRegionHeader(bottomLeft.chunkToRegion());
            } else {
                mcaFileBottomLeft = mcaFileBottom;
            }
        } else {
            mcaFileBottom = self;
            mcaFileBottomLeft = relative.getX() != 0 ? self : mcaFileLeft;
        }
        if (relative.getX() != 0) {
            mcaFileLeft = self;
            mcaFileTopLeft = relative.getZ() != 0 ? self : mcaFileTop;
        }
        if (relative.getX() != 31) {
            mcaFileRight = self;
            mcaFileBottomRight = relative.getZ() != 31 ? self : mcaFileBottom;
        }
        if (mcaFileTop == null || !mcaFileTop.hasChunkIndex(location.add(0, -1))) {
            ++count;
        }
        if (mcaFileRight == null || !mcaFileRight.hasChunkIndex(location.add(1, 0))) {
            ++count;
        }
        if (mcaFileBottom == null || !mcaFileBottom.hasChunkIndex(location.add(0, 1))) {
            ++count;
        }
        if (mcaFileLeft == null || !mcaFileLeft.hasChunkIndex(location.add(-1, 0))) {
            ++count;
        }
        if (mcaFileTopLeft == null || !mcaFileTopLeft.hasChunkIndex(location.add(-1, -1))) {
            ++count;
        }
        if (mcaFileTopRight == null || !mcaFileTopRight.hasChunkIndex(location.add(1, -1))) {
            ++count;
        }
        if (mcaFileBottomRight == null || !mcaFileBottomRight.hasChunkIndex(location.add(1, 1))) {
            ++count;
        }
        if (mcaFileBottomLeft == null || !mcaFileBottomLeft.hasChunkIndex(location.add(-1, 1))) {
            ++count;
        }
        return count;
    }

    private Point2i getRelativeChunk(Point2i chunkCoordinate) {
        return new Point2i(chunkCoordinate.getX() & 0x1F, chunkCoordinate.getZ() & 0x1F);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RegionMCAFile getRegionHeader(Point2i region) {
        long key = region.asLong();
        Object object = this.regionBufferLock;
        synchronized (object) {
            if (this.regionBuffer.containsKey(key)) {
                return (RegionMCAFile)this.regionBuffer.get(key);
            }
            RegionMCAFile regionMCAFile = new RegionMCAFile(FileHelper.createMCAFilePath(region));
            if (!regionMCAFile.getFile().exists() || regionMCAFile.getFile().length() <= 8192L) {
                this.push(key, null);
                return null;
            }
            try {
                regionMCAFile.loadBorderChunks();
            }
            catch (IOException ex) {
                LOGGER.warn("failed to read data from {}", (Object)regionMCAFile.getFile(), (Object)ex);
                this.push(key, null);
                return null;
            }
            this.push(key, regionMCAFile);
            return regionMCAFile;
        }
    }

    private void push(long key, RegionMCAFile regionMCAFile) {
        if (this.regionBuffer.size() == 32) {
            this.regionBuffer.remove(this.regionBuffer.firstLongKey());
        }
        this.regionBuffer.put(key, regionMCAFile);
    }

    @Override
    public void setFilterValue(String raw) {
        super.setFilterValue(raw);
        if (this.isValid() && ((Integer)this.getFilterValue() < 0 || (Integer)this.getFilterValue() > 4)) {
            this.setFilterNumber(0);
            this.setValid(false);
        }
    }

    @Override
    public BorderFilter clone() {
        BorderFilter bf = new BorderFilter(this.getOperator(), this.getComparator(), this.value, this.regionBufferLock);
        bf.regionBuffer = this.regionBuffer;
        return bf;
    }

    @Override
    public void resetTempData() {
        this.regionBuffer.clear();
    }

    @Override
    public boolean selectionOnly() {
        return true;
    }
}

