/*
 * Decompiled with CFR 0.152.
 */
package net.querz.mcaselector.filter.filters;

import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import net.querz.mcaselector.filter.Comparator;
import net.querz.mcaselector.filter.Filter;
import net.querz.mcaselector.filter.FilterType;
import net.querz.mcaselector.filter.Operator;
import net.querz.mcaselector.filter.TextFilter;
import net.querz.mcaselector.io.mca.ChunkData;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CustomFilter
extends TextFilter<String> {
    private static final Logger LOGGER = LogManager.getLogger(CustomFilter.class);
    private static final String baseScript = "import net.querz.nbt.*; def test() {%s}";
    private static ScriptEngine engine;
    private static final Object lock;
    private static final Comparator[] comparators;

    public CustomFilter() {
        this(Operator.AND, Comparator.EQUAL, null);
    }

    private CustomFilter(Operator operator, Comparator comparator, String value) {
        super(FilterType.CUSTOM, operator, comparator, value);
        if (engine == null) {
            ScriptEngineManager factory = new ScriptEngineManager();
            engine = factory.getEngineByName("Groovy");
            engine.put("region", null);
            engine.put("poi", null);
            engine.put("entities", null);
        }
    }

    @Override
    public Comparator[] getComparators() {
        return comparators;
    }

    @Override
    public void setFilterValue(String raw) {
        try {
            String script = String.format(baseScript, raw);
            engine.eval(script);
            this.setValue(raw);
            this.setRawValue(raw);
            this.setValid(true);
        }
        catch (ScriptException e) {
            this.setValue(null);
            this.setValid(false);
        }
    }

    public String toString() {
        return "Custom " + this.getComparator().getQueryString() + " " + CustomFilter.escape((String)this.getFilterValue());
    }

    @Override
    public Filter<String> clone() {
        return new CustomFilter(this.getOperator(), this.getComparator(), (String)this.value);
    }

    @Override
    public String getFormatText() {
        return "[Groovy]";
    }

    @Override
    public boolean matches(ChunkData data) {
        return switch (this.getComparator()) {
            case Comparator.EQUAL -> this.isEqual((String)this.value, data);
            case Comparator.NOT_EQUAL -> {
                if (!this.isEqual((String)this.value, data)) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEqual(String value, ChunkData data) {
        Object object = lock;
        synchronized (object) {
            engine.put("region", data.region() != null && data.region().getData() != null ? data.region().getData() : null);
            engine.put("poi", data.poi() != null && data.poi().getData() != null ? data.poi().getData() : null);
            engine.put("entities", data.entities() != null && data.entities().getData() != null ? data.entities().getData() : null);
            try {
                Object result = ((Invocable)((Object)engine)).invokeFunction("test", new Object[0]);
                return result instanceof Boolean && (Boolean)result != false;
            }
            catch (NoSuchMethodException | ScriptException ex) {
                LOGGER.warn("failed to invoke custom script", (Throwable)ex);
            }
        }
        return false;
    }

    @Override
    public boolean contains(String value, ChunkData data) {
        throw new UnsupportedOperationException("\"contains\" not allowed in CustomFilter");
    }

    @Override
    public boolean containsNot(String value, ChunkData data) {
        throw new UnsupportedOperationException("\"!contains\" not allowed in CustomFilter");
    }

    @Override
    public boolean intersects(String value, ChunkData data) {
        throw new UnsupportedOperationException("\"intersects\" not allowed in CustomFilter");
    }

    static {
        lock = new Object();
        comparators = new Comparator[]{Comparator.EQUAL, Comparator.NOT_EQUAL};
    }
}

