/*
 * Decompiled with CFR 0.152.
 */
package net.querz.mcaselector.filter.filters;

import java.util.ArrayList;
import java.util.List;
import net.querz.mcaselector.filter.Comparator;
import net.querz.mcaselector.filter.Filter;
import net.querz.mcaselector.filter.FilterType;
import net.querz.mcaselector.filter.Operator;
import net.querz.mcaselector.filter.RegionMatcher;
import net.querz.mcaselector.io.mca.ChunkData;
import net.querz.mcaselector.util.point.Point2i;

public class GroupFilter
extends Filter<List<Filter<?>>> {
    private List<Filter<?>> children = new ArrayList();
    private boolean negated = false;

    public GroupFilter() {
        super(FilterType.GROUP);
    }

    public GroupFilter(boolean negated) {
        super(FilterType.GROUP);
        this.setNegated(negated);
    }

    public GroupFilter(Operator operator) {
        super(FilterType.GROUP, operator);
    }

    public boolean isEmpty() {
        return this.children.isEmpty();
    }

    public int addFilter(Filter<?> filter) {
        filter.setParent(this);
        this.children.add(filter);
        return this.children.size() - 1;
    }

    @Override
    public FilterType getType() {
        return this.negated ? FilterType.NOT_GROUP : FilterType.GROUP;
    }

    public void setNegated(boolean negated) {
        this.negated = negated;
    }

    public boolean isNegated() {
        return this.negated;
    }

    public int addFilterAfter(Filter<?> filter, Filter<?> after) {
        filter.setParent(this);
        int i = this.children.indexOf(after);
        if (i >= 0) {
            this.children.add(i + 1, filter);
        } else {
            this.children.add(filter);
        }
        return i + 1;
    }

    public void removeFilter(Filter<?> filter) {
        this.children.remove(filter);
    }

    @Override
    public List<Filter<?>> getFilterValue() {
        return this.children;
    }

    @Override
    public void setFilterValue(String raw) {
    }

    @Override
    public Comparator[] getComparators() {
        return new Comparator[0];
    }

    @Override
    public Comparator getComparator() {
        return null;
    }

    @Override
    public void setComparator(Comparator comparator) {
    }

    @Override
    public boolean matches(ChunkData data) {
        boolean currentResult = true;
        for (int i = 0; i < this.children.size(); ++i) {
            if ((this.children.get(i).getOperator() == Operator.AND || i == 0) && currentResult) {
                currentResult = this.children.get(i).matches(data);
                continue;
            }
            if (this.children.get(i).getOperator() != Operator.OR) continue;
            if (currentResult) {
                return !this.negated;
            }
            currentResult = this.children.get(i).matches(data);
        }
        return this.negated != currentResult;
    }

    public boolean appliesToRegion(Point2i region) {
        boolean currentResult = true;
        for (int i = 0; i < this.children.size(); ++i) {
            RegionMatcher regionMatcher;
            Filter<?> filter;
            if ((this.children.get(i).getOperator() == Operator.AND || i == 0) && currentResult) {
                filter = this.children.get(i);
                if (filter instanceof RegionMatcher) {
                    regionMatcher = (RegionMatcher)((Object)filter);
                    currentResult = regionMatcher.matchesRegion(region);
                    continue;
                }
                currentResult = true;
                continue;
            }
            if (this.children.get(i).getOperator() != Operator.OR) continue;
            if (currentResult) {
                return !this.negated;
            }
            filter = this.children.get(i);
            if (filter instanceof RegionMatcher) {
                regionMatcher = (RegionMatcher)((Object)filter);
                currentResult = regionMatcher.matchesRegion(region);
                continue;
            }
            currentResult = true;
        }
        return this.negated != currentResult;
    }

    public String toString() {
        return this.toString(0);
    }

    private String toString(int depth) {
        boolean showGroup;
        boolean bl = showGroup = (this.negated || depth != 0) && !this.children.isEmpty();
        StringBuilder s = new StringBuilder(showGroup ? (this.negated ? "!(" : "(") : "");
        for (int i = 0; i < this.children.size(); ++i) {
            String child = this.children.get(i).getType() == FilterType.GROUP ? ((GroupFilter)this.children.get(i)).toString(depth + 1) : this.children.get(i).toString();
            if (child.isEmpty()) continue;
            s.append((String)(i != 0 ? " " + String.valueOf((Object)this.children.get(i).getOperator()) + " " : "")).append(child);
        }
        s.append(showGroup ? ")" : "");
        return s.toString();
    }

    @Override
    public boolean isValid() {
        for (Filter<?> c : this.children) {
            if (c.isValid()) continue;
            return false;
        }
        return true;
    }

    @Override
    public GroupFilter clone() {
        ArrayList cloneChildren = new ArrayList(this.children.size());
        this.children.forEach(c -> cloneChildren.add((Filter<?>)c.clone()));
        GroupFilter clone = new GroupFilter(this.getOperator());
        clone.negated = this.negated;
        clone.children = cloneChildren;
        return clone;
    }

    @Override
    public void resetTempData() {
        for (Filter<?> child : this.children) {
            child.resetTempData();
        }
    }

    @Override
    public boolean selectionOnly() {
        for (Filter<?> child : this.children) {
            if (!child.selectionOnly()) continue;
            return true;
        }
        return false;
    }
}

