/*
 * Decompiled with CFR 0.152.
 */
package net.querz.mcaselector.filter.filters;

import net.querz.mcaselector.filter.Comparator;
import net.querz.mcaselector.filter.FilterType;
import net.querz.mcaselector.filter.LongFilter;
import net.querz.mcaselector.filter.Operator;
import net.querz.mcaselector.io.mca.ChunkData;
import net.querz.mcaselector.text.TextHelper;
import net.querz.mcaselector.version.ChunkFilter;
import net.querz.mcaselector.version.VersionHandler;
import net.querz.nbt.LongTag;

public class LastUpdateFilter
extends LongFilter {
    public LastUpdateFilter() {
        this(Operator.AND, Comparator.EQUAL, 0L);
    }

    private LastUpdateFilter(Operator operator, Comparator comparator, long value) {
        super(FilterType.LAST_UPDATE, operator, comparator, value);
    }

    @Override
    protected Long getNumber(ChunkData data) {
        LongTag tag = VersionHandler.getImpl(data, ChunkFilter.LastUpdate.class).getLastUpdate(data);
        return tag == null ? 0L : tag.asLong();
    }

    @Override
    public void setFilterValue(String raw) {
        super.setFilterValue(raw);
        if (!this.isValid()) {
            try {
                this.setFilterNumber(TextHelper.parseDuration(raw) * 20L);
                this.setValid(true);
                this.setRawValue(raw);
            }
            catch (IllegalArgumentException ex) {
                this.setFilterNumber(0L);
                this.setValid(false);
            }
        }
    }

    @Override
    public String toString() {
        return "LastUpdate " + this.getComparator().getQueryString() + " \"" + this.getRawValue() + "\"";
    }

    @Override
    public String getFormatText() {
        return "duration";
    }

    @Override
    public LastUpdateFilter clone() {
        return new LastUpdateFilter(this.getOperator(), this.getComparator(), this.value);
    }
}

