/*
 * Decompiled with CFR 0.152.
 */
package net.querz.mcaselector.filter.filters;

import net.querz.mcaselector.filter.ByteFilter;
import net.querz.mcaselector.filter.Comparator;
import net.querz.mcaselector.filter.FilterType;
import net.querz.mcaselector.filter.Operator;
import net.querz.mcaselector.io.mca.ChunkData;
import net.querz.mcaselector.version.ChunkFilter;
import net.querz.mcaselector.version.VersionHandler;
import net.querz.nbt.ByteTag;

public class LightPopulatedFilter
extends ByteFilter {
    private static final Comparator[] comparators = new Comparator[]{Comparator.EQUAL, Comparator.NOT_EQUAL};

    public LightPopulatedFilter() {
        this(Operator.AND, Comparator.EQUAL, 0);
    }

    private LightPopulatedFilter(Operator operator, Comparator comparator, byte value) {
        super(FilterType.LIGHT_POPULATED, operator, comparator, value);
    }

    @Override
    public Comparator[] getComparators() {
        return comparators;
    }

    @Override
    protected Byte getNumber(ChunkData data) {
        ByteTag tag = VersionHandler.getImpl(data, ChunkFilter.LightPopulated.class).getLightPopulated(data);
        return tag == null ? (byte)0 : tag.asByte();
    }

    @Override
    public void setFilterValue(String raw) {
        super.setFilterValue(raw);
        if (this.isValid() && (Byte)this.getFilterValue() != 1 && (Byte)this.getFilterValue() != 0) {
            this.setFilterNumber((byte)0);
            this.setValid(false);
        }
    }

    @Override
    public String getFormatText() {
        return "1|0";
    }

    @Override
    public LightPopulatedFilter clone() {
        return new LightPopulatedFilter(this.getOperator(), this.getComparator(), this.value);
    }
}

