/*
 * Decompiled with CFR 0.152.
 */
package net.querz.mcaselector.filter.filters;

import javax.script.ScriptException;
import net.querz.mcaselector.filter.Comparator;
import net.querz.mcaselector.filter.Filter;
import net.querz.mcaselector.filter.FilterType;
import net.querz.mcaselector.filter.Operator;
import net.querz.mcaselector.filter.TextFilter;
import net.querz.mcaselector.io.GroovyScriptEngine;
import net.querz.mcaselector.io.mca.ChunkData;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ScriptFilter
extends TextFilter<String> {
    private static final Logger LOGGER = LogManager.getLogger(ScriptFilter.class);
    private final GroovyScriptEngine engine = new GroovyScriptEngine();
    private static final Comparator[] comparators = new Comparator[]{Comparator.EQUAL};

    public ScriptFilter() {
        this(Operator.AND, Comparator.EQUAL, null);
    }

    private ScriptFilter(Operator operator, Comparator comparator, String value) {
        super(FilterType.SCRIPT, operator, comparator, value);
    }

    @Override
    public Comparator[] getComparators() {
        return comparators;
    }

    @Override
    public void setFilterValue(String raw) {
        try {
            this.engine.eval(raw);
            this.setValue(raw);
            this.setRawValue(raw);
            this.setValid(true);
        }
        catch (ScriptException e) {
            this.setValue(null);
            this.setValid(false);
        }
    }

    @Override
    public Filter<String> clone() {
        return new ScriptFilter(this.getOperator(), this.getComparator(), (String)this.value);
    }

    @Override
    public String getFormatText() {
        return "[Groovy]";
    }

    @Override
    public boolean matches(ChunkData data) {
        try {
            return this.engine.test("filter", data);
        }
        catch (NoSuchMethodException | ScriptException ex) {
            LOGGER.warn("failed to invoke filter function in custom filter script", (Throwable)ex);
            return false;
        }
    }

    public void before() {
        try {
            this.engine.run("before", new Object[0]);
        }
        catch (NoSuchMethodException | ScriptException ex) {
            LOGGER.warn("failed to invoke before function in custom script", (Throwable)ex);
        }
    }

    public void after() {
        try {
            this.engine.run("after", new Object[0]);
        }
        catch (NoSuchMethodException | ScriptException ex) {
            LOGGER.warn("failed to invoke after function in custom script", (Throwable)ex);
        }
    }

    @Override
    public boolean contains(String value, ChunkData data) {
        throw new UnsupportedOperationException("\"contains\" not allowed in ScriptFilter");
    }

    @Override
    public boolean containsNot(String value, ChunkData data) {
        throw new UnsupportedOperationException("\"!contains\" not allowed in ScriptFilter");
    }

    @Override
    public boolean intersects(String value, ChunkData data) {
        throw new UnsupportedOperationException("\"intersects\" not allowed in ScriptFilter");
    }
}

