/*
 * Decompiled with CFR 0.152.
 */
package net.querz.mcaselector.filter.filters;

import net.querz.mcaselector.filter.Comparator;
import net.querz.mcaselector.filter.FilterType;
import net.querz.mcaselector.filter.Operator;
import net.querz.mcaselector.filter.TextFilter;
import net.querz.mcaselector.io.mca.ChunkData;
import net.querz.mcaselector.version.ChunkFilter;
import net.querz.mcaselector.version.VersionHandler;
import net.querz.mcaselector.version.mapping.registry.StatusRegistry;
import net.querz.nbt.StringTag;

public class StatusFilter
extends TextFilter<StatusRegistry.StatusIdentifier> {
    private static final Comparator[] comparators = new Comparator[]{Comparator.EQUAL, Comparator.NOT_EQUAL};

    public StatusFilter() {
        this(Operator.AND, Comparator.EQUAL, null, null);
    }

    private StatusFilter(Operator operator, Comparator comparator, String rawValue, StatusRegistry.StatusIdentifier value) {
        super(FilterType.STATUS, operator, comparator, value);
        this.setRawValue(rawValue);
    }

    @Override
    public Comparator[] getComparators() {
        return comparators;
    }

    @Override
    public String getFormatText() {
        return "empty,...";
    }

    @Override
    public boolean matches(ChunkData data) {
        return switch (this.getComparator()) {
            case Comparator.EQUAL -> this.isEqual((StatusRegistry.StatusIdentifier)this.value, data);
            case Comparator.NOT_EQUAL -> {
                if (!this.isEqual((StatusRegistry.StatusIdentifier)this.value, data)) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    public boolean isEqual(StatusRegistry.StatusIdentifier value, ChunkData data) {
        StringTag tag = VersionHandler.getImpl(data, ChunkFilter.Status.class).getStatus(data);
        return tag != null && value.equals(tag.getValue());
    }

    @Override
    public boolean contains(StatusRegistry.StatusIdentifier value, ChunkData data) {
        throw new UnsupportedOperationException("\"contains\" not allowed in StatusFilter");
    }

    @Override
    public boolean containsNot(StatusRegistry.StatusIdentifier value, ChunkData data) {
        throw new UnsupportedOperationException("\"!contains\" not allowed in StatusFilter");
    }

    @Override
    public boolean intersects(StatusRegistry.StatusIdentifier value, ChunkData data) {
        throw new UnsupportedOperationException("\"intersects\" not allowed in StatusFilter");
    }

    @Override
    public void setFilterValue(String raw) {
        if (StatusRegistry.isValidName(raw)) {
            this.setValue(new StatusRegistry.StatusIdentifier(raw));
            this.setRawValue(raw);
            this.setValid(true);
        } else {
            this.setValue(null);
            this.setValid(false);
        }
    }

    public String toString() {
        return "Status " + this.getComparator().getQueryString() + " " + ((StatusRegistry.StatusIdentifier)this.getFilterValue()).getStatusWithNamespace();
    }

    @Override
    public StatusFilter clone() {
        return new StatusFilter(this.getOperator(), this.getComparator(), this.getRawValue(), (StatusRegistry.StatusIdentifier)this.value);
    }
}

