/*
 * Decompiled with CFR 0.152.
 */
package net.querz.mcaselector.filter.filters;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import net.querz.mcaselector.filter.Comparator;
import net.querz.mcaselector.filter.FilterType;
import net.querz.mcaselector.filter.Operator;
import net.querz.mcaselector.filter.TextFilter;
import net.querz.mcaselector.io.mca.ChunkData;
import net.querz.mcaselector.version.ChunkFilter;
import net.querz.mcaselector.version.VersionHandler;
import net.querz.mcaselector.version.mapping.registry.StructureRegistry;
import net.querz.nbt.CompoundTag;
import net.querz.nbt.LongArrayTag;

public class StructureFilter
extends TextFilter<List<String>> {
    public StructureFilter() {
        this(Operator.AND, Comparator.CONTAINS, null);
    }

    private StructureFilter(Operator operator, Comparator comparator, List<String> value) {
        super(FilterType.STRUCTURES, operator, comparator, value);
        this.setRawValue(String.join((CharSequence)",", value == null ? new ArrayList(0) : value));
    }

    @Override
    public boolean contains(List<String> value, ChunkData data) {
        if (data.region() == null || data.region().getData() == null) {
            return false;
        }
        CompoundTag references = VersionHandler.getImpl(data, ChunkFilter.Structures.class).getStructureReferences(data);
        if (references == null) {
            return false;
        }
        block0: for (String name : value) {
            for (String alt : StructureRegistry.getAlts(name)) {
                LongArrayTag longArrayStructure = references.getLongArrayTag(alt);
                if (longArrayStructure == null || longArrayStructure.isEmpty()) continue;
                continue block0;
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean containsNot(List<String> value, ChunkData data) {
        return !this.contains(value, data);
    }

    @Override
    public boolean intersects(List<String> value, ChunkData data) {
        if (data.region() == null || data.region().getData() == null) {
            return false;
        }
        CompoundTag references = VersionHandler.getImpl(data, ChunkFilter.Structures.class).getStructureReferences(data);
        if (references == null) {
            return false;
        }
        for (String name : (List)this.getFilterValue()) {
            for (String alt : StructureRegistry.getAlts(name)) {
                LongArrayTag longArrayStructure = references.getLongArrayTag(alt);
                if (longArrayStructure == null || longArrayStructure.isEmpty()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void setFilterValue(String raw) {
        String[] values = raw.split(",");
        if (values.length == 0) {
            this.setValid(false);
            this.setValue(null);
            return;
        }
        for (int i = 0; i < values.length; ++i) {
            values[i] = values[i].trim();
            String name = values[i];
            if (name.startsWith("'") && name.endsWith("'") && name.length() >= 2) {
                values[i] = name.substring(1, name.length() - 1);
                continue;
            }
            if (StructureRegistry.isValidName(name)) continue;
            this.setValue(null);
            this.setValid(false);
            return;
        }
        this.setValid(true);
        this.setValue(Arrays.asList(values));
        this.setRawValue(raw);
    }

    @Override
    public String getFormatText() {
        return "<structure>[,<structure>,...]";
    }

    public String toString() {
        return "Structures " + this.getComparator().getQueryString() + " \"" + this.getRawValue() + "\"";
    }

    @Override
    public StructureFilter clone() {
        return new StructureFilter(this.getOperator(), this.getComparator(), new ArrayList<String>((Collection)this.value));
    }
}

