/*
 * Decompiled with CFR 0.152.
 */
package net.querz.mcaselector.filter.filters;

import net.querz.mcaselector.filter.Comparator;
import net.querz.mcaselector.filter.FilterType;
import net.querz.mcaselector.filter.IntFilter;
import net.querz.mcaselector.filter.Operator;
import net.querz.mcaselector.filter.RegionMatcher;
import net.querz.mcaselector.io.mca.ChunkData;
import net.querz.mcaselector.util.point.Point2i;
import net.querz.mcaselector.version.ChunkFilter;
import net.querz.mcaselector.version.VersionHandler;
import net.querz.nbt.IntTag;

public class ZPosFilter
extends IntFilter
implements RegionMatcher {
    public ZPosFilter() {
        this(Operator.AND, Comparator.EQUAL, 0);
    }

    public ZPosFilter(Operator operator, Comparator comparator, int value) {
        super(FilterType.Z_POS, operator, comparator, value);
    }

    @Override
    protected Integer getNumber(ChunkData data) {
        IntTag tag = VersionHandler.getImpl(data, ChunkFilter.Pos.class).getZPos(data);
        return tag == null ? null : Integer.valueOf(tag.asInt());
    }

    @Override
    public boolean matchesRegion(Point2i region) {
        Point2i chunk = region.regionToChunk();
        for (int i = 0; i < 32; ++i) {
            Point2i p = chunk.add(i);
            if (!this.matches(this.getFilterNumber(), p.getZ(), this.getComparator())) continue;
            return true;
        }
        return false;
    }

    @Override
    public ZPosFilter clone() {
        return new ZPosFilter(this.getOperator(), this.getComparator(), this.value);
    }
}

