/*
 * Decompiled with CFR 0.152.
 */
package net.querz.mcaselector.io;

import java.util.AbstractQueue;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Predicate;

public class DynamicPriorityBlockingQueue<E>
extends AbstractQueue<E>
implements BlockingQueue<E> {
    private Node<E> first;
    private Node<E> last;
    private int size;
    private final ReentrantLock lock = new ReentrantLock();
    private final Condition notEmpty = this.lock.newCondition();

    @Override
    public Iterator<E> iterator() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            ElementIterator<E> elementIterator = new ElementIterator<E>(this, this.first);
            return elementIterator;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeIf(Predicate<? super E> filter) {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            boolean removed = false;
            NodeIterator<E> itr = new NodeIterator<E>(this, this.first);
            while (itr.hasNext()) {
                Node node = (Node)itr.next();
                if (!filter.test(node.element)) continue;
                node.remove();
                removed = true;
            }
            boolean bl = removed;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public int size() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            int n = this.size;
            return n;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public void put(E e) throws InterruptedException {
        this.offer(e);
    }

    @Override
    public boolean offer(E e, long timeout, TimeUnit unit) {
        return this.offer(e);
    }

    @Override
    public E take() throws InterruptedException {
        E result;
        ReentrantLock lock = this.lock;
        lock.lockInterruptibly();
        try {
            while ((result = this.dequeue()) == null) {
                this.notEmpty.await();
            }
        }
        finally {
            lock.unlock();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E poll(long timeout, TimeUnit unit) throws InterruptedException {
        E result;
        long nanos = unit.toNanos(timeout);
        ReentrantLock lock = this.lock;
        lock.lockInterruptibly();
        try {
            while ((result = this.dequeue()) == null && nanos > 0L) {
                nanos = this.notEmpty.awaitNanos(nanos);
            }
        }
        finally {
            lock.unlock();
        }
        return result;
    }

    @Override
    public int remainingCapacity() {
        return Integer.MAX_VALUE;
    }

    @Override
    public int drainTo(Collection<? super E> c) {
        return this.drainTo(c, Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int drainTo(Collection<? super E> c, int maxElements) {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            int n = Math.min(this.size, maxElements);
            for (int i = 0; i < n; ++i) {
                c.add(this.dequeue());
            }
            int n2 = n;
            return n2;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public boolean offer(E e) {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            if (this.first == null) {
                this.first = new Node<E>(e);
                this.last = this.first;
            } else {
                this.last.next = new Node<E>(e, this.last);
                this.last = this.last.next;
            }
            ++this.size;
            this.notEmpty.signal();
        }
        finally {
            lock.unlock();
        }
        return true;
    }

    @Override
    public E poll() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            E e = this.dequeue();
            return e;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public E peek() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            if (this.first == null) {
                E e = null;
                return e;
            }
            Object v = this.first.element;
            return (E)v;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            NodeIterator<E> itr = new NodeIterator<E>(this, this.first);
            while (itr.hasNext()) {
                Node node = (Node)itr.next();
                node.remove();
            }
            this.first = null;
            this.last = null;
            this.size = 0;
        }
        finally {
            lock.unlock();
        }
    }

    private E dequeue() {
        if (this.first == null) {
            return null;
        }
        Node current = this.first;
        NodeIterator<E> itr = new NodeIterator<E>(this, this.first);
        while (itr.hasNext()) {
            Node node = (Node)itr.next();
            if (node.compareTo(current) >= 0) continue;
            current = node;
        }
        current.remove();
        return (E)current.element;
    }

    private class ElementIterator<V>
    implements Iterator<V> {
        Node<V> current;

        ElementIterator(DynamicPriorityBlockingQueue dynamicPriorityBlockingQueue, Node<V> first) {
            this.current = first;
        }

        @Override
        public boolean hasNext() {
            return this.current != null;
        }

        @Override
        public V next() {
            if (this.current == null) {
                throw new NoSuchElementException();
            }
            Object e = this.current.element;
            this.current = this.current.next;
            return e;
        }
    }

    private class Node<V>
    implements Comparable<Node<V>> {
        V element;
        Node<V> next;
        Node<V> previous;

        Node(V element) {
            this.element = element;
        }

        Node(V element, Node<V> previous) {
            this.element = element;
            this.previous = previous;
        }

        @Override
        public int compareTo(Node<V> o) {
            return ((Comparable)this.element).compareTo(o.element);
        }

        public void remove() {
            if (this.previous != null) {
                this.previous.next = this.next;
            }
            if (this.next != null) {
                this.next.previous = this.previous;
            }
            if (this == DynamicPriorityBlockingQueue.this.first) {
                DynamicPriorityBlockingQueue.this.first = this.next;
            }
            if (this == DynamicPriorityBlockingQueue.this.last) {
                DynamicPriorityBlockingQueue.this.last = this.previous;
            }
            this.next = null;
            this.previous = null;
            --DynamicPriorityBlockingQueue.this.size;
        }
    }

    private class NodeIterator<V>
    implements Iterator<Node<V>> {
        Node<V> current;

        NodeIterator(DynamicPriorityBlockingQueue dynamicPriorityBlockingQueue, Node<V> first) {
            this.current = first;
        }

        @Override
        public boolean hasNext() {
            return this.current != null;
        }

        @Override
        public Node<V> next() {
            if (this.current == null) {
                throw new NoSuchElementException();
            }
            Node<V> n = this.current;
            this.current = this.current.next;
            return n;
        }
    }
}

