/*
 * Decompiled with CFR 0.152.
 */
package net.querz.mcaselector.io;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import net.querz.mcaselector.io.Job;
import net.querz.mcaselector.io.JobHandler;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

class PausableThreadPoolExecutor
extends ThreadPoolExecutor {
    private static final Logger LOGGER = LogManager.getLogger(PausableThreadPoolExecutor.class);
    private boolean isPaused;
    private final ReentrantLock pauseLock = new ReentrantLock();
    private final Condition unpaused = this.pauseLock.newCondition();
    private Consumer<Job> beforeExecute;
    private Consumer<Job> afterExecute;

    public PausableThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue);
    }

    public PausableThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory, Consumer<Job> beforeExecute, Consumer<Job> afterExecute) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory);
        this.beforeExecute = beforeExecute;
        this.afterExecute = afterExecute;
    }

    public PausableThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, RejectedExecutionHandler handler) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, handler);
    }

    public PausableThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory, RejectedExecutionHandler handler) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory, handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void beforeExecute(Thread t, Runnable r) {
        super.beforeExecute(t, r);
        this.pauseLock.lock();
        try {
            while (this.isPaused) {
                this.unpaused.await();
            }
        }
        catch (InterruptedException ex) {
            t.interrupt();
        }
        finally {
            this.pauseLock.unlock();
        }
        this.beforeExecute.accept(((JobHandler.WrapperJob)r).job);
    }

    @Override
    protected void afterExecute(Runnable r, Throwable t) {
        super.afterExecute(r, t);
        if (t != null) {
            ((JobHandler.WrapperJob)r).job.done();
        }
        this.afterExecute.accept(((JobHandler.WrapperJob)r).job);
    }

    public void pause(String msg) {
        this.pauseLock.lock();
        try {
            if (!this.isPaused) {
                LOGGER.debug("paused process executor: {}", (Object)msg);
            }
            this.isPaused = true;
        }
        finally {
            this.pauseLock.unlock();
        }
    }

    public void resume(String msg) {
        this.pauseLock.lock();
        try {
            if (this.isPaused) {
                LOGGER.debug("resumed process executor: {}", (Object)msg);
            }
            this.isPaused = false;
            this.unpaused.signalAll();
        }
        finally {
            this.pauseLock.unlock();
        }
    }
}

