/*
 * Decompiled with CFR 0.152.
 */
package net.querz.mcaselector.io.job;

import java.io.File;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import javafx.scene.image.Image;
import net.querz.mcaselector.io.ImageHelper;
import net.querz.mcaselector.io.JobHandler;
import net.querz.mcaselector.io.RegionDirectories;
import net.querz.mcaselector.io.job.ProcessDataJob;
import net.querz.mcaselector.tile.Tile;
import net.querz.mcaselector.util.point.Point2i;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CachedImageLoadJob
extends ProcessDataJob {
    private static final Logger LOGGER = LogManager.getLogger(CachedImageLoadJob.class);
    private static final Set<Point2i> loading = ConcurrentHashMap.newKeySet();
    private final Tile tile;
    private final File cachedImageFile;
    private final int loadZoomLevel;
    private final int targetZoomLevel;
    private final Consumer<Image> callback;

    public static void load(Tile tile, File cachedImageFile, int loadZoomLevel, int targetZoomLevel, Consumer<Image> callback) {
        JobHandler.addJob(new CachedImageLoadJob(tile, cachedImageFile, loadZoomLevel, targetZoomLevel, callback));
    }

    public static boolean isLoading(Tile tile) {
        return loading.contains(tile.getLocation());
    }

    public static void setLoading(Tile tile, boolean loading) {
        LOGGER.debug("set loading from cache for {} to {}, image:{}, loaded:{}", (Object)tile.getLocation(), (Object)loading, tile.getImage() == null ? "null" : tile.getImage().getHeight() + "x" + tile.getImage().getWidth(), (Object)tile.isLoaded());
        if (loading) {
            CachedImageLoadJob.loading.add(tile.getLocation());
        } else {
            CachedImageLoadJob.loading.remove(tile.getLocation());
        }
    }

    public CachedImageLoadJob(Tile tile, File cachedImageFile, int loadZoomLevel, int targetZoomLevel, Consumer<Image> callback) {
        super(new RegionDirectories(tile.getLocation(), null, null, null), 10000000);
        this.tile = tile;
        this.cachedImageFile = cachedImageFile;
        this.loadZoomLevel = loadZoomLevel;
        this.targetZoomLevel = targetZoomLevel;
        this.callback = callback;
    }

    @Override
    public boolean execute() {
        Image cachedImg = this.loadImageFromDiskCache(this.cachedImageFile);
        if (cachedImg != null) {
            this.tile.setImage(cachedImg);
        }
        this.tile.setLoaded(true);
        this.callback.accept(cachedImg);
        return true;
    }

    @Override
    public void cancel() {
        CachedImageLoadJob.setLoading(this.tile, false);
    }

    private Image loadImageFromDiskCache(File cachedImgFile) {
        Image cachedImg = new Image(cachedImgFile.toURI().toString(), false);
        if (cachedImg.isError()) {
            LOGGER.warn("failed to load image from cache: {}", (Object)cachedImgFile.getAbsolutePath());
            return null;
        }
        LOGGER.debug("image loaded: {}", (Object)cachedImgFile.getAbsolutePath());
        if (this.loadZoomLevel != this.targetZoomLevel) {
            cachedImg = ImageHelper.scaleDownFXImage(cachedImg, 512 / this.targetZoomLevel);
        }
        return cachedImg;
    }
}

