/*
 * Decompiled with CFR 0.152.
 */
package net.querz.mcaselector.io.job;

import java.util.function.Consumer;
import net.querz.mcaselector.config.ConfigProvider;
import net.querz.mcaselector.filter.filters.GroupFilter;
import net.querz.mcaselector.io.JobHandler;
import net.querz.mcaselector.io.RegionDirectories;
import net.querz.mcaselector.io.WorldDirectories;
import net.querz.mcaselector.io.job.ProcessDataJob;
import net.querz.mcaselector.io.mca.Region;
import net.querz.mcaselector.selection.ChunkSet;
import net.querz.mcaselector.selection.Selection;
import net.querz.mcaselector.text.Translation;
import net.querz.mcaselector.util.point.Point2i;
import net.querz.mcaselector.util.progress.Progress;
import net.querz.mcaselector.util.progress.Timer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class ChunkFilterSelector {
    private static final Logger LOGGER = LogManager.getLogger(ChunkFilterSelector.class);

    private ChunkFilterSelector() {
    }

    public static void selectFilter(GroupFilter filter, Selection selection, int radius, Consumer<Selection> callback, Progress progressChannel, boolean cli) {
        WorldDirectories wd = ConfigProvider.WORLD.getWorldDirs();
        RegionDirectories[] rd = wd.listRegions(selection);
        if (rd == null || rd.length == 0) {
            if (cli) {
                progressChannel.done("no files");
            } else {
                progressChannel.done(Translation.DIALOG_PROGRESS_NO_FILES.toString());
            }
            return;
        }
        JobHandler.clearQueues();
        progressChannel.setMax(rd.length);
        progressChannel.updateProgress(rd[0].getLocationAsFileName(), 0);
        Consumer<Throwable> errorHandler = t -> progressChannel.incrementProgress("error");
        for (RegionDirectories r : rd) {
            MCASelectFilterProcessJob job = new MCASelectFilterProcessJob(r, filter, selection, callback, radius, progressChannel);
            job.errorHandler = errorHandler;
            JobHandler.addJob(job);
        }
    }

    private static class MCASelectFilterProcessJob
    extends ProcessDataJob {
        private final Progress progressChannel;
        private final GroupFilter filter;
        private final Selection selection;
        private final Consumer<Selection> callback;
        private final int radius;

        private MCASelectFilterProcessJob(RegionDirectories dirs, GroupFilter filter, Selection selection, Consumer<Selection> callback, int radius, Progress progressChannel) {
            super(dirs, 20000000);
            this.filter = filter;
            this.selection = selection;
            this.callback = callback;
            this.progressChannel = progressChannel;
            this.radius = radius;
        }

        @Override
        public boolean execute() {
            Point2i location = this.getRegionDirectories().getLocation();
            if (!this.filter.appliesToRegion(location)) {
                LOGGER.debug("filter does not apply to region {}", (Object)this.getRegionDirectories().getLocation());
                this.progressChannel.incrementProgress(this.getRegionDirectories().getLocationAsFileName());
                return true;
            }
            Timer t = new Timer();
            try {
                Region region = Region.loadRegion(this.getRegionDirectories());
                ChunkSet chunks = region.getFilteredChunks(this.filter, this.selection);
                if (!chunks.isEmpty()) {
                    if (chunks.size() == 1024) {
                        chunks = null;
                    }
                    Selection selection = new Selection();
                    selection.addAll(location, chunks);
                    selection.addRadius(this.radius, this.selection);
                    this.callback.accept(selection);
                }
                LOGGER.debug("took {} to select chunks in {}", (Object)t, (Object)this.getRegionDirectories().getLocationAsFileName());
            }
            catch (Exception ex) {
                LOGGER.warn("error selecting chunks in {}", (Object)this.getRegionDirectories().getLocationAsFileName(), (Object)ex);
            }
            this.progressChannel.incrementProgress(this.getRegionDirectories().getLocationAsFileName());
            return true;
        }
    }
}

