/*
 * Decompiled with CFR 0.152.
 */
package net.querz.mcaselector.io.job;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.querz.mcaselector.config.ConfigProvider;
import net.querz.mcaselector.io.FileHelper;
import net.querz.mcaselector.io.JobHandler;
import net.querz.mcaselector.io.RegionDirectories;
import net.querz.mcaselector.io.WorldDirectories;
import net.querz.mcaselector.io.job.ProcessDataJob;
import net.querz.mcaselector.io.job.SaveDataJob;
import net.querz.mcaselector.io.mca.EntitiesMCAFile;
import net.querz.mcaselector.io.mca.MCAFile;
import net.querz.mcaselector.io.mca.PoiMCAFile;
import net.querz.mcaselector.io.mca.Region;
import net.querz.mcaselector.io.mca.RegionMCAFile;
import net.querz.mcaselector.selection.ChunkSet;
import net.querz.mcaselector.selection.Selection;
import net.querz.mcaselector.text.Translation;
import net.querz.mcaselector.util.point.Point2i;
import net.querz.mcaselector.util.point.Point3i;
import net.querz.mcaselector.util.progress.Progress;
import net.querz.mcaselector.util.progress.Timer;
import net.querz.mcaselector.util.property.DataProperty;
import net.querz.mcaselector.util.range.Range;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class ChunkImporter {
    private static final Logger LOGGER = LogManager.getLogger(ChunkImporter.class);

    private ChunkImporter() {
    }

    public static void importChunks(WorldDirectories source, Progress progressChannel, boolean cli, boolean overwrite, Selection sourceSelection, Selection targetSelection, List<Range> ranges, Point3i offset, DataProperty<Map<Point2i, RegionDirectories>> tempFiles) {
        try {
            WorldDirectories wd = ConfigProvider.WORLD.getWorldDirs();
            RegionDirectories[] rd = wd.listRegions(targetSelection);
            if (rd == null || rd.length == 0) {
                if (cli) {
                    progressChannel.done("no files");
                } else {
                    progressChannel.done(Translation.DIALOG_PROGRESS_NO_FILES.toString());
                }
                return;
            }
            JobHandler.clearQueues();
            if (cli) {
                progressChannel.setMessage("collecting data...");
            } else {
                progressChannel.setMessage(Translation.DIALOG_PROGRESS_COLLECTING_DATA.toString());
            }
            HashMap<Point2i, RegionDirectories> tempFilesMap = null;
            if (source.sharesDirectories(ConfigProvider.WORLD.getWorldDirs())) {
                tempFilesMap = new HashMap<Point2i, RegionDirectories>();
            }
            tempFiles.set(tempFilesMap);
            Long2ObjectOpenHashMap<LongSet> targetMapping = ChunkImporter.createTargetSourceMapping(source.getRegion(), sourceSelection, targetSelection, offset.toPoint2i());
            progressChannel.setMax(targetMapping.size());
            progressChannel.updateProgress(rd[0].getLocationAsFileName(), 0);
            Consumer<Throwable> errorHandler = t -> progressChannel.incrementProgress("error");
            for (Long2ObjectMap.Entry entry : targetMapping.long2ObjectEntrySet()) {
                Point2i target = new Point2i(entry.getLongKey());
                RegionDirectories targetDirs = FileHelper.createRegionDirectories(target);
                MCAChunkImporterProcessJob job = new MCAChunkImporterProcessJob(targetDirs, source, target, (LongSet)entry.getValue(), offset, progressChannel, overwrite, sourceSelection, targetSelection, ranges, tempFilesMap);
                job.errorHandler = errorHandler;
                JobHandler.addJob(job);
            }
        }
        catch (Exception ex) {
            LOGGER.warn("failed creating jobs to import chunks", (Throwable)ex);
        }
    }

    private static Long2ObjectOpenHashMap<LongSet> createTargetSourceMapping(File sourceDirectory, Selection sourceSelection, Selection targetSelection, Point2i offset) {
        Long2ObjectOpenHashMap<LongSet> sourceTargetMapping = new Long2ObjectOpenHashMap<LongSet>();
        LongOpenHashSet sourceRegions = FileHelper.parseAllMCAFileNames(sourceDirectory);
        if (sourceSelection != null) {
            sourceRegions.removeIf(s -> !sourceSelection.isAnyChunkInRegionSelected(s));
        }
        LongIterator longIterator = sourceRegions.iterator();
        while (longIterator.hasNext()) {
            long sourceRegion = (Long)longIterator.next();
            LongSet targetRegions = ChunkImporter.getTargetRegions(new Point2i(sourceRegion), offset, targetSelection);
            if (targetRegions.isEmpty()) continue;
            sourceTargetMapping.put(sourceRegion, targetRegions);
        }
        Long2ObjectOpenHashMap<LongSet> targetSourceMapping = new Long2ObjectOpenHashMap<LongSet>();
        int initSize = Math.min((offset.getX() % 32 != 0 ? 2 : 0) + (offset.getZ() % 32 != 0 ? 2 : 0), 1);
        for (Long2ObjectMap.Entry entry : sourceTargetMapping.long2ObjectEntrySet()) {
            LongIterator longIterator2 = ((LongSet)entry.getValue()).iterator();
            while (longIterator2.hasNext()) {
                long target = (Long)longIterator2.next();
                if (targetSourceMapping.containsKey(target)) {
                    targetSourceMapping.get(target).add(entry.getLongKey());
                    continue;
                }
                targetSourceMapping.compute(target, (k, o) -> {
                    LongOpenHashSet sources = new LongOpenHashSet(initSize);
                    sources.add(entry.getLongKey());
                    return sources;
                });
            }
        }
        return targetSourceMapping;
    }

    private static LongSet getTargetRegions(Point2i source, Point2i offset, Selection selection) {
        LongOpenHashSet result = new LongOpenHashSet(5, 0.9f);
        Point2i sourceChunk = source.regionToChunk().add(offset);
        ChunkImporter.addIfInSelection(result, sourceChunk.chunkToRegion(), selection);
        ChunkImporter.addIfInSelection(result, sourceChunk.add(31, 0).chunkToRegion(), selection);
        ChunkImporter.addIfInSelection(result, sourceChunk.add(0, 31).chunkToRegion(), selection);
        ChunkImporter.addIfInSelection(result, sourceChunk.add(31, 31).chunkToRegion(), selection);
        return result;
    }

    private static void addIfInSelection(LongOpenHashSet set, Point2i p, Selection selection) {
        if (selection == null || selection.isAnyChunkInRegionSelected(p)) {
            set.add(p.asLong());
        }
    }

    private static class MCAChunkImporterProcessJob
    extends ProcessDataJob {
        private final WorldDirectories sourceDirs;
        private final LongSet sourceRegions;
        private final Point2i target;
        private final Point3i offset;
        private final Progress progressChannel;
        private final boolean overwrite;
        private final Selection sourceSelection;
        private final Selection targetSelection;
        private final List<Range> ranges;
        private final Map<Point2i, RegionDirectories> tempFilesMap;

        private MCAChunkImporterProcessJob(RegionDirectories targetDirs, WorldDirectories sourceDirs, Point2i target, LongSet sourceRegions, Point3i offset, Progress progressChannel, boolean overwrite, Selection sourceSelection, Selection targetSelection, List<Range> ranges, Map<Point2i, RegionDirectories> tempFilesMap) {
            super(targetDirs, 20000000);
            this.sourceDirs = sourceDirs;
            this.sourceRegions = sourceRegions;
            this.target = target;
            this.offset = offset;
            this.progressChannel = progressChannel;
            this.overwrite = overwrite;
            this.sourceSelection = sourceSelection;
            this.targetSelection = targetSelection;
            this.ranges = ranges;
            this.tempFilesMap = tempFilesMap;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean execute() {
            if (this.offset.getX() == 0 && this.offset.getY() == 0 && this.offset.getZ() == 0 && this.targetSelection == null && this.sourceSelection == null && !this.getRegionDirectories().exists()) {
                File source;
                boolean allCopied = true;
                if (!this.getRegionDirectories().getRegion().exists()) {
                    source = new File(this.sourceDirs.getRegion(), this.getRegionDirectories().getLocationAsFileName());
                    if (source.exists()) {
                        try {
                            Files.copy(source.toPath(), this.getRegionDirectories().getRegion().toPath(), new CopyOption[0]);
                        }
                        catch (IOException ex) {
                            LOGGER.warn("failed to copy file {} to {}", (Object)source, (Object)this.getRegionDirectories().getRegion(), (Object)ex);
                        }
                    }
                } else {
                    allCopied = false;
                }
                if (!this.getRegionDirectories().getPoi().exists() && this.sourceDirs.getPoi() != null) {
                    source = new File(this.sourceDirs.getPoi(), this.getRegionDirectories().getLocationAsFileName());
                    if (source.exists()) {
                        try {
                            Files.copy(source.toPath(), this.getRegionDirectories().getPoi().toPath(), new CopyOption[0]);
                        }
                        catch (IOException ex) {
                            LOGGER.warn("failed to copy file {} to {}", (Object)source, (Object)this.getRegionDirectories().getPoi(), (Object)ex);
                        }
                    }
                } else {
                    allCopied = false;
                }
                if (!this.getRegionDirectories().getEntities().exists() && this.sourceDirs.getEntities() != null) {
                    source = new File(this.sourceDirs.getEntities(), this.getRegionDirectories().getLocationAsFileName());
                    if (source.exists()) {
                        try {
                            Files.copy(source.toPath(), this.getRegionDirectories().getEntities().toPath(), new CopyOption[0]);
                        }
                        catch (IOException ex) {
                            LOGGER.warn("failed to copy file {} to {}", (Object)source, (Object)this.getRegionDirectories().getEntities(), (Object)ex);
                        }
                    }
                } else {
                    allCopied = false;
                }
                if (allCopied) {
                    this.progressChannel.incrementProgress(this.getRegionDirectories().getLocationAsFileName());
                    return true;
                }
            }
            HashSet sourceDataMappingRegion = new HashSet();
            HashSet sourceDataMappingPoi = new HashSet();
            HashSet sourceDataMappingEntities = new HashSet();
            LongIterator longIterator = this.sourceRegions.iterator();
            while (longIterator.hasNext()) {
                void var8_13;
                long source = (Long)longIterator.next();
                Iterator s = new Point2i(source);
                if (this.tempFilesMap != null && this.tempFilesMap.containsKey(s)) {
                    RegionDirectories regionDirectories = this.tempFilesMap.get(s);
                } else {
                    RegionDirectories regionDirectories = new RegionDirectories();
                }
                File sourceFile = var8_13.getRegion() != null ? var8_13.getRegion() : new File(this.sourceDirs.getRegion(), FileHelper.createMCAFileName(s));
                if (sourceFile.exists()) {
                    sourceDataMappingRegion.add(s);
                }
                if ((sourceFile = var8_13.getPoi() != null ? var8_13.getPoi() : new File(this.sourceDirs.getPoi(), FileHelper.createMCAFileName(s))).exists()) {
                    sourceDataMappingPoi.add(s);
                }
                if (!(sourceFile = var8_13.getEntities() != null ? var8_13.getEntities() : new File(this.sourceDirs.getEntities(), FileHelper.createMCAFileName(s))).exists()) continue;
                sourceDataMappingEntities.add(s);
            }
            if (sourceDataMappingRegion.isEmpty() && sourceDataMappingPoi.isEmpty() && sourceDataMappingEntities.isEmpty()) {
                LOGGER.warn("no source mca files to merge into {}", (Object)this.getRegionDirectories().getLocationAsFileName());
                this.progressChannel.incrementProgress(this.getRegionDirectories().getLocationAsFileName());
                return true;
            }
            Timer t = new Timer();
            try {
                ChunkSet sourceChunks;
                MCAFile source;
                Region targetRegion = Region.loadOrCreateEmptyRegion(this.getRegionDirectories());
                ChunkSet targetChunks = null;
                if (this.targetSelection != null) {
                    targetChunks = this.targetSelection.getSelectedChunks(this.target);
                }
                for (Point2i point2i : sourceDataMappingRegion) {
                    source = new RegionMCAFile(new File(this.sourceDirs.getRegion(), FileHelper.createMCAFileName(point2i)));
                    source.load(false);
                    LOGGER.debug("merging region chunks from {} into {}", (Object)point2i, (Object)this.target);
                    if (targetRegion.getRegion() == null) {
                        targetRegion.setRegion(new RegionMCAFile(this.getRegionDirectories().getRegion()));
                    }
                    sourceChunks = null;
                    if (this.sourceSelection != null) {
                        sourceChunks = this.sourceSelection.getSelectedChunks(point2i);
                    }
                    ((RegionMCAFile)source).mergeChunksInto(targetRegion.getRegion(), this.offset, this.overwrite, sourceChunks, targetChunks, this.ranges);
                }
                for (Point2i point2i : sourceDataMappingPoi) {
                    source = new PoiMCAFile(new File(this.sourceDirs.getPoi(), FileHelper.createMCAFileName(point2i)));
                    source.load(false);
                    LOGGER.debug("merging poi chunks from {} into {}", (Object)point2i, (Object)this.target);
                    if (targetRegion.getPoi() == null) {
                        targetRegion.setPoi(new PoiMCAFile(this.getRegionDirectories().getPoi()));
                    }
                    sourceChunks = null;
                    if (this.sourceSelection != null) {
                        sourceChunks = this.sourceSelection.getSelectedChunks(point2i);
                    }
                    ((PoiMCAFile)source).mergeChunksInto(targetRegion.getPoi(), this.offset, this.overwrite, sourceChunks, targetChunks, this.ranges);
                }
                for (Point2i point2i : sourceDataMappingEntities) {
                    source = new EntitiesMCAFile(new File(this.sourceDirs.getEntities(), FileHelper.createMCAFileName(point2i)));
                    source.load(false);
                    LOGGER.debug("merging entities chunks from {} into {}", (Object)point2i, (Object)this.target);
                    if (targetRegion.getEntities() == null) {
                        targetRegion.setEntities(new EntitiesMCAFile(this.getRegionDirectories().getEntities()));
                    }
                    sourceChunks = null;
                    if (this.sourceSelection != null) {
                        sourceChunks = this.sourceSelection.getSelectedChunks(point2i);
                    }
                    ((EntitiesMCAFile)source).mergeChunksInto(targetRegion.getEntities(), this.offset, this.overwrite, sourceChunks, targetChunks, this.ranges);
                }
                MCAChunkImporterSaveJob job = new MCAChunkImporterSaveJob(this.getRegionDirectories(), targetRegion, this.progressChannel);
                job.errorHandler = this.errorHandler;
                JobHandler.executeSaveData(job);
                LOGGER.debug("took {} to merge chunks into {} with offset {}", (Object)t, (Object)this.getRegionDirectories().getLocation(), (Object)this.offset);
                return false;
            }
            catch (Exception ex) {
                LOGGER.warn("failed to process chunk import for {}", (Object)this.getRegionDirectories().getLocationAsFileName(), (Object)ex);
                this.progressChannel.incrementProgress(this.getRegionDirectories().getLocationAsFileName());
                return true;
            }
        }
    }

    private static class MCAChunkImporterSaveJob
    extends SaveDataJob<Region> {
        private final Progress progressChannel;

        private MCAChunkImporterSaveJob(RegionDirectories targetDirs, Region data, Progress progressChannel) {
            super(targetDirs, data);
            this.progressChannel = progressChannel;
        }

        @Override
        public void execute() {
            Timer t = new Timer();
            try {
                ((Region)this.getData()).saveWithTempFiles();
            }
            catch (Exception ex) {
                LOGGER.warn("failed to save imported chunks to {}", (Object)this.getRegionDirectories().getLocationAsFileName(), (Object)ex);
            }
            this.progressChannel.incrementProgress(this.getRegionDirectories().getLocationAsFileName());
            LOGGER.debug("took {} to save data for {}", (Object)t, (Object)this.getRegionDirectories().getLocationAsFileName());
        }
    }
}

