/*
 * Decompiled with CFR 0.152.
 */
package net.querz.mcaselector.io.job;

import java.util.List;
import java.util.function.Consumer;
import net.querz.mcaselector.changer.Field;
import net.querz.mcaselector.config.ConfigProvider;
import net.querz.mcaselector.io.JobHandler;
import net.querz.mcaselector.io.RegionDirectories;
import net.querz.mcaselector.io.WorldDirectories;
import net.querz.mcaselector.io.job.ProcessDataJob;
import net.querz.mcaselector.io.job.SaveDataJob;
import net.querz.mcaselector.io.mca.Region;
import net.querz.mcaselector.selection.Selection;
import net.querz.mcaselector.text.Translation;
import net.querz.mcaselector.util.point.Point2i;
import net.querz.mcaselector.util.progress.Progress;
import net.querz.mcaselector.util.progress.Timer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class FieldChanger {
    private static final Logger LOGGER = LogManager.getLogger(FieldChanger.class);

    private FieldChanger() {
    }

    public static void changeNBTFields(List<Field<?>> fields, boolean force, Selection selection, Progress progressChannel, boolean headless) {
        WorldDirectories wd = ConfigProvider.WORLD.getWorldDirs();
        RegionDirectories[] rd = wd.listRegions(selection);
        if (rd == null || rd.length == 0) {
            if (headless) {
                progressChannel.done("no files");
            } else {
                progressChannel.done(Translation.DIALOG_PROGRESS_NO_FILES.toString());
            }
            return;
        }
        JobHandler.clearQueues();
        progressChannel.setMax(rd.length);
        progressChannel.updateProgress(rd[0].getLocationAsFileName(), 0);
        Consumer<Throwable> errorHandler = t -> progressChannel.incrementProgress("error");
        for (RegionDirectories r : rd) {
            MCAFieldChangeProcessJob job = new MCAFieldChangeProcessJob(r, fields, force, selection, progressChannel);
            job.errorHandler = errorHandler;
            JobHandler.addJob(job);
        }
    }

    public static class MCAFieldChangeProcessJob
    extends ProcessDataJob {
        private final Progress progressChannel;
        private final List<Field<?>> fields;
        private final boolean force;
        private final Selection selection;

        private MCAFieldChangeProcessJob(RegionDirectories dirs, List<Field<?>> fields, boolean force, Selection selection, Progress progressChannel) {
            super(dirs, 20000000);
            this.fields = fields;
            this.force = force;
            this.selection = selection;
            this.progressChannel = progressChannel;
        }

        @Override
        public boolean execute() {
            Point2i location;
            if (this.selection != null && !this.selection.isAnyChunkInRegionSelected(location = this.getRegionDirectories().getLocation())) {
                LOGGER.debug("will not apply nbt changes to {}", (Object)this.getRegionDirectories().getLocationAsFileName());
                this.progressChannel.incrementProgress(this.getRegionDirectories().getLocationAsFileName());
                return true;
            }
            try {
                Region region = Region.loadRegion(this.getRegionDirectories());
                region.applyFieldChanges(this.fields, this.force, this.selection);
                MCAFieldChangeSaveJob job = new MCAFieldChangeSaveJob(this.getRegionDirectories(), region, this.progressChannel);
                job.errorHandler = this.errorHandler;
                JobHandler.executeSaveData(job);
                return false;
            }
            catch (Exception ex) {
                this.progressChannel.incrementProgress(this.getRegionDirectories().getLocationAsFileName());
                LOGGER.warn("error changing fields in {}", (Object)this.getRegionDirectories().getLocationAsFileName(), (Object)ex);
                return true;
            }
        }
    }

    public static class MCAFieldChangeSaveJob
    extends SaveDataJob<Region> {
        private final Progress progressChannel;

        private MCAFieldChangeSaveJob(RegionDirectories file, Region region, Progress progressChannel) {
            super(file, region);
            this.progressChannel = progressChannel;
        }

        @Override
        public void execute() {
            Timer t = new Timer();
            try {
                ((Region)this.getData()).saveWithTempFiles();
            }
            catch (Exception ex) {
                LOGGER.warn("failed to save changed fields for {}", (Object)this.getRegionDirectories().getLocationAsFileName(), (Object)ex);
            }
            this.progressChannel.incrementProgress(this.getRegionDirectories().getLocationAsFileName());
            LOGGER.debug("took {} to save data for {}", (Object)t, (Object)this.getRegionDirectories().getLocationAsFileName());
        }
    }
}

