/*
 * Decompiled with CFR 0.152.
 */
package net.querz.mcaselector.io.job;

import java.io.IOException;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.querz.mcaselector.io.RegionDirectories;
import net.querz.mcaselector.io.job.ProcessDataJob;
import net.querz.mcaselector.io.mca.ChunkData;
import net.querz.mcaselector.io.mca.EntitiesChunk;
import net.querz.mcaselector.io.mca.EntitiesMCAFile;
import net.querz.mcaselector.io.mca.PoiChunk;
import net.querz.mcaselector.io.mca.PoiMCAFile;
import net.querz.mcaselector.io.mca.RegionChunk;
import net.querz.mcaselector.io.mca.RegionMCAFile;
import net.querz.mcaselector.overlay.Overlay;
import net.querz.mcaselector.tile.Tile;
import net.querz.mcaselector.util.point.Point2i;
import net.querz.mcaselector.util.progress.Timer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ParseDataJob
extends ProcessDataJob {
    private static final Logger LOGGER = LogManager.getLogger(ParseDataJob.class);
    private static final Set<Point2i> loading = ConcurrentHashMap.newKeySet();
    private final BiConsumer<int[], UUID> dataCallback;
    private final UUID world;
    private final RegionMCAFile region;
    private final PoiMCAFile poi;
    private final EntitiesMCAFile entities;
    private final Overlay parser;
    private final Tile tile;
    private final Supplier<Integer> prioritySupplier;

    public ParseDataJob(Tile tile, RegionDirectories dirs, UUID world, RegionMCAFile region, PoiMCAFile poi, EntitiesMCAFile entities, BiConsumer<int[], UUID> dataCallback, Overlay parser, Supplier<Integer> prioritySupplier) {
        super(dirs, 20000000);
        this.tile = tile;
        this.dataCallback = dataCallback;
        this.world = world;
        this.region = region;
        this.poi = poi;
        this.entities = entities;
        this.parser = parser;
        this.prioritySupplier = prioritySupplier;
        ParseDataJob.setLoading(tile, true);
    }

    public ParseDataJob(Tile tile, RegionDirectories dirs, UUID world, BiConsumer<int[], UUID> dataCallback, Overlay parser, Supplier<Integer> prioritySupplier) {
        super(dirs, 20000000);
        this.tile = tile;
        this.dataCallback = dataCallback;
        this.world = world;
        this.region = null;
        this.poi = null;
        this.entities = null;
        this.parser = parser;
        this.prioritySupplier = prioritySupplier;
        ParseDataJob.setLoading(tile, true);
    }

    public static boolean isLoading(Tile tile) {
        return loading.contains(tile.getLocation());
    }

    public static synchronized void setLoading(Tile tile, boolean loading) {
        if (loading) {
            ParseDataJob.loading.add(tile.getLocation());
        } else {
            ParseDataJob.loading.remove(tile.getLocation());
        }
    }

    public Tile getTile() {
        return this.tile;
    }

    @Override
    public void run() {
        this.execute();
    }

    @Override
    public boolean execute() {
        Timer t = new Timer();
        RegionMCAFile regionMCAFile = null;
        if (this.region != null) {
            regionMCAFile = this.region;
        } else if (this.getRegionDirectories().getRegion() != null && this.getRegionDirectories().getRegion().exists() && this.getRegionDirectories().getRegion().length() > 0L) {
            regionMCAFile = new RegionMCAFile(this.getRegionDirectories().getRegion());
            try {
                regionMCAFile.load(false);
            }
            catch (IOException ex) {
                LOGGER.warn("failed to read mca file header from {}", (Object)this.getRegionDirectories().getRegion());
            }
        }
        EntitiesMCAFile entitiesMCAFile = null;
        if (this.entities != null) {
            entitiesMCAFile = this.entities;
        } else if (this.getRegionDirectories().getEntities() != null && this.getRegionDirectories().getEntities().exists() && this.getRegionDirectories().getEntities().length() > 0L) {
            entitiesMCAFile = new EntitiesMCAFile(this.getRegionDirectories().getEntities());
            try {
                entitiesMCAFile.load(false);
            }
            catch (IOException ex) {
                LOGGER.warn("failed to read mca file header from {}", (Object)this.getRegionDirectories().getEntities());
            }
        }
        PoiMCAFile poiMCAFile = null;
        if (this.poi != null) {
            poiMCAFile = this.poi;
        } else if (this.getRegionDirectories().getPoi() != null && this.getRegionDirectories().getPoi().exists() && this.getRegionDirectories().getPoi().length() > 0L) {
            poiMCAFile = new PoiMCAFile(this.getRegionDirectories().getPoi());
            try {
                poiMCAFile.load(false);
            }
            catch (IOException ex) {
                LOGGER.warn("failed to read mca file header from {}", (Object)this.getRegionDirectories().getPoi());
            }
        }
        if (regionMCAFile == null && poiMCAFile == null && entitiesMCAFile == null) {
            this.dataCallback.accept(null, this.world);
            LOGGER.warn("no data to load and parse for region {}", (Object)this.getRegionDirectories().getLocation());
            ParseDataJob.setLoading(this.tile, false);
            return true;
        }
        int[] data = new int[1024];
        for (int i = 0; i < 1024; ++i) {
            ChunkData chunkData = new ChunkData(regionMCAFile == null ? null : (RegionChunk)regionMCAFile.getChunk(i), poiMCAFile == null ? null : (PoiChunk)poiMCAFile.getChunk(i), entitiesMCAFile == null ? null : (EntitiesChunk)entitiesMCAFile.getChunk(i), false);
            try {
                data[i] = chunkData.parseData(this.parser);
                continue;
            }
            catch (Exception ex) {
                LOGGER.warn("failed to parse chunk data at index {}", (Object)i, (Object)ex);
            }
        }
        this.dataCallback.accept(data, this.world);
        ParseDataJob.setLoading(this.tile, false);
        LOGGER.debug("took {} to load and parse data for region {}", (Object)t, (Object)this.getRegionDirectories().getLocation());
        return true;
    }

    @Override
    public void cancel() {
        ParseDataJob.setLoading(this.tile, false);
    }

    @Override
    public int getPriority() {
        if (this.prioritySupplier == null) {
            return super.getPriority();
        }
        return super.getBasePriority() + this.prioritySupplier.get();
    }
}

